/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.render;

import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.util.math.ProjectionUtil;
import dev.nymnux.rhizome.util.math.Vec2d;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2d;

public class HudRenderUtil {
    private static final int MARGIN = 16;
    private static final int MARGIN_BOTTOM = 48;

    public static void drawTexture(ClientContext ctx, class_332 drawContext, class_2960 texture, Vector2d posPercent, int u, int v, int commonWidth, int commonHeight, int textureWidth, int textureHeight, double scale, boolean centeredX, boolean centeredY, boolean mirrorX, boolean mirrorY, int color2) {
        double screenWidth = ctx.client.method_22683().method_4489();
        double screenHeight = ctx.client.method_22683().method_4506();
        HudRenderUtil.drawTexture(ctx, drawContext, texture, screenWidth * posPercent.x, screenHeight * posPercent.y, u, v, commonWidth, commonHeight, textureWidth, textureHeight, scale, centeredX, centeredY, mirrorX, mirrorY, color2);
    }

    public static void drawTexture(ClientContext ctx, class_332 drawContext, class_2960 texture, double x, double y, int u, int v, int commonWidth, int commonHeight, int textureWidth, int textureHeight, double scale, boolean centeredX, boolean centeredY, boolean mirrorX, boolean mirrorY, int color2) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float resizedGuiScale = 1.0f / ClientContext.getScaleFactor(ctx);
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale);
        matrixStack.translate((float)x, (float)y);
        if (centeredX) {
            matrixStack.translate((float)(-scale * (double)commonWidth / 2.0), 0.0f);
        }
        if (centeredY) {
            matrixStack.translate(0.0f, (float)(-scale * (double)commonHeight / 2.0));
        }
        matrixStack.scale((float)scale);
        int regionWidth = commonWidth;
        int regionHeight = commonHeight;
        if (mirrorX) {
            u += regionWidth;
            regionWidth *= -1;
        }
        if (mirrorY) {
            v += regionHeight;
            regionHeight *= -1;
        }
        drawContext.method_25293(class_10799.field_56883, texture, 0, 0, (float)u, (float)v, commonWidth, commonHeight, regionWidth, regionHeight, textureWidth, textureHeight, color2);
        matrixStack.popMatrix();
    }

    public static void drawText(ClientContext ctx, class_332 drawContext, class_2561 text, Vector2d posPercent, double scale, int color2, boolean shadow, boolean centeredX, boolean centeredY) {
        double screenWidth = ctx.client.method_22683().method_4489();
        double screenHeight = ctx.client.method_22683().method_4506();
        HudRenderUtil.drawText(ctx, drawContext, text, screenWidth * posPercent.x, screenHeight * posPercent.y, scale, color2, shadow, centeredX, centeredY);
    }

    public static void drawText(ClientContext ctx, class_332 drawContext, class_2561 text, double x, double y, double scale, int color2, boolean shadow, boolean centeredX, boolean centeredY) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float resizedGuiScale = 1.0f / ClientContext.getScaleFactor(ctx);
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale, resizedGuiScale);
        matrixStack.translate((float)x, (float)y);
        if (centeredX) {
            matrixStack.translate((float)(-scale * (double)ctx.client.field_1772.method_27525((class_5348)text) / 2.0), 0.0f);
        }
        if (centeredY) {
            double d = -scale;
            Objects.requireNonNull(ctx.client.field_1772);
            matrixStack.translate(0.0f, (float)(d * 9.0 / 2.0));
        }
        matrixStack.scale((float)scale);
        drawContext.method_51439(ctx.client.field_1772, text, 0, 0, color2, shadow);
        matrixStack.popMatrix();
    }

    public static void drawOutlineQuad(class_332 context, int x, int y, int width, int height, int color2) {
        HudRenderUtil.fill(context, x, y, width, 1, color2);
        HudRenderUtil.fill(context, x + width - 1, y, 1, height, color2);
        HudRenderUtil.fill(context, x, y + height - 1, width, 1, color2);
        HudRenderUtil.fill(context, x, y, 1, height, color2);
    }

    public static void drawLine(class_332 context, Vec2d from, Vec2d to, int color2) {
        HudRenderUtil.drawLine(context, new class_241((float)from.m, (float)from.n), new class_241((float)to.m, (float)to.n), color2, color2, 1.0f);
    }

    public static void drawLine(class_332 context, class_241 from, class_241 to, int colorFrom, int colorTo, float lineWidth) {
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate(from.field_1343, from.field_1342);
        matrices.rotate((float)Math.atan2(to.field_1342 - from.field_1342, to.field_1343 - from.field_1343));
        float d = (float)Math.sqrt((to.field_1343 - from.field_1343) * (to.field_1343 - from.field_1343) + (to.field_1342 - from.field_1342) * (to.field_1342 - from.field_1342));
        context.method_25296(0, 0, (int)d, (int)lineWidth, colorFrom, colorTo);
        matrices.popMatrix();
    }

    public static void fill(class_332 context, int x, int y, int width, int height, int color2) {
        context.method_25294(x, y, x + width, y + height, color2);
    }

    public static boolean canSeeOnScreen(ClientContext ctx, class_243 targetPos, float tickDelta) {
        class_243 ndcPos = ProjectionUtil.projectToNDC(ctx, targetPos, tickDelta);
        return ndcPos.field_1350 < 1.0 && ndcPos.field_1352 > -1.0 && ndcPos.field_1352 < 1.0 && ndcPos.field_1351 > -1.0 && ndcPos.field_1351 < 1.0;
    }

    public static Vector2d getAlwaysOnScreenPos(ClientContext ctx, class_243 targetPos, float tickDelta) {
        float scaleFactor = ClientContext.getScaleFactor(ctx);
        int margin = (int)(16.0f * scaleFactor);
        int marginBottom = (int)(48.0f * scaleFactor);
        return HudRenderUtil.getAlwaysOnScreenPos(ctx, targetPos, tickDelta, margin, marginBottom);
    }

    public static Vector2d getAlwaysOnScreenPos(ClientContext ctx, class_243 targetPos, float tickDelta, int margin, int marginBottom) {
        double scaleX;
        double distance;
        boolean inside;
        class_243 ndcPos = ProjectionUtil.projectToNDC(ctx, targetPos, tickDelta);
        double halfScreenWidth = (double)ctx.client.method_22683().method_4489() / 2.0;
        double halfScreenHeight = (double)ctx.client.method_22683().method_4506() / 2.0;
        double coordX = ndcPos.field_1352 * halfScreenWidth;
        double coordY = ndcPos.field_1351 * halfScreenHeight;
        double coordMinX = -halfScreenWidth + (double)margin;
        double coordMinY = -halfScreenHeight + (double)marginBottom;
        double coordMaxX = halfScreenWidth - (double)margin;
        double coordMaxY = halfScreenHeight - (double)margin;
        boolean bl = inside = ndcPos.field_1350 < 1.0 && coordX >= coordMinX && coordX <= coordMaxX && coordY >= coordMinY && coordY <= coordMaxY;
        if (inside) {
            return new Vector2d(coordX + halfScreenWidth, halfScreenHeight - coordY);
        }
        double dirX = coordX;
        double dirY = coordY;
        if (ndcPos.field_1350 >= 1.0) {
            dirX *= -1.0;
            dirY *= -1.0;
        }
        if ((distance = Math.hypot(dirX, dirY)) < 1.0E-9) {
            return new Vector2d(halfScreenWidth, halfScreenHeight);
        }
        double d = dirX != 0.0 ? (dirX > 0.0 ? coordMaxX / dirX : coordMinX / dirX) : (scaleX = Double.POSITIVE_INFINITY);
        double scaleY = dirY != 0.0 ? (dirY > 0.0 ? coordMaxY / dirY : coordMinY / dirY) : Double.POSITIVE_INFINITY;
        double scale = Math.min(scaleX, scaleY);
        double clampedX = dirX * scale;
        double clampedY = dirY * scale;
        return new Vector2d(clampedX + halfScreenWidth, halfScreenHeight - clampedY);
    }
}

