/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.container.group;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.config.color.CfgColorGui;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.ModText;
import dev.nymnux.rhizome.util.string.StringUtil;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModIntegerFieldWidget
extends class_342 {
    private static final int BUTTON_SIZE = 6;
    private static final int BUTTON_GAP = 3;
    private int extendedWidth;
    private Predicate<Integer> range;
    private int smallStep;
    private int bigStep;
    private int defaultValue;

    public static ModIntegerFieldWidget of(ClientContext ctx, int width, int value, Consumer<Integer> apply, int smallStep, int bigStep, Predicate<Integer> range, int defaultValue) {
        return ModIntegerFieldWidget.of(ctx, width, (class_2561)null, null, value, apply, smallStep, bigStep, range, defaultValue);
    }

    public static ModIntegerFieldWidget of(ClientContext ctx, int width, @NotNull class_2561 placeHolder, int value, Consumer<Integer> apply, int smallStep, int bigStep, Predicate<Integer> range, int defaultValue) {
        return ModIntegerFieldWidget.of(ctx, width, placeHolder, null, value, apply, smallStep, bigStep, range, defaultValue);
    }

    public static ModIntegerFieldWidget of(ClientContext ctx, int width, @NotNull ModText placeHolder, int value, Consumer<Integer> apply, int smallStep, int bigStep, Predicate<Integer> range, int defaultValue) {
        return ModIntegerFieldWidget.of(ctx, width, placeHolder.getText(), null, value, apply, smallStep, bigStep, range, defaultValue);
    }

    public static ModIntegerFieldWidget of(ClientContext ctx, int width, @NotNull ModText placeHolder, @NotNull ModText toolTip, int value, Consumer<Integer> apply, int smallStep, int bigStep, Predicate<Integer> range, int defaultValue) {
        return ModIntegerFieldWidget.of(ctx, width, placeHolder.getText(), toolTip.getText(), value, apply, smallStep, bigStep, range, defaultValue);
    }

    public static ModIntegerFieldWidget of(ClientContext ctx, int width, @Nullable class_2561 placeHolder, @Nullable class_2561 toolTip, int value, Consumer<Integer> apply, int smallStep, int bigStep, Predicate<Integer> range, int defaultValue) {
        if (width < 9) {
            width = 9;
        }
        ModIntegerFieldWidget txt = new ModIntegerFieldWidget(ctx.client.field_1772, width - 9);
        if (placeHolder != null) {
            txt.method_47404((class_2561)class_2561.method_43470((String)placeHolder.getString()));
        }
        if (toolTip != null) {
            txt.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)toolTip.getString())));
        }
        txt.method_1852(String.valueOf(value));
        txt.extendedWidth = width;
        txt.range = range;
        txt.smallStep = smallStep;
        txt.bigStep = bigStep;
        txt.defaultValue = defaultValue;
        txt.method_1863(s -> {
            int applyValue = txt.getValidValue();
            apply.accept(applyValue);
        });
        return txt;
    }

    private ModIntegerFieldWidget(class_327 textRenderer, int width) {
        super(textRenderer, 0, 0, width, 15, (class_2561)class_2561.method_43473());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isValidClick(button) || !this.isBtnHovered(mouseX, mouseY)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        ModScreen.playModButtonDownSound();
        if (button == 2) {
            this.method_1852(String.valueOf(this.defaultValue));
            return super.method_25402(mouseX, mouseY, button);
        }
        int step = button == 0 ? this.smallStep : this.bigStep;
        int modifier = this.isBtnAddHovered(mouseX, mouseY) ? step : -step;
        int newValue = this.getValidValue() + modifier;
        if (this.range.test(newValue)) {
            this.method_1852(String.valueOf(newValue));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);
        CfgColorGui config2 = ModConfig.getInstance().cfgColorGui;
        context.method_25294(this.method_46426() + this.extendedWidth - 6, this.method_46427(), this.method_46426() + this.extendedWidth, this.method_46427() + 6, this.isBtnAddHovered(mouseX, mouseY) ? config2.buttonColorHovered : config2.buttonColor);
        context.method_25294(this.method_46426() + this.extendedWidth - 6, this.method_46427() + 6 + 3, this.method_46426() + this.extendedWidth, this.method_46427() + 12 + 3, this.isBtnSubHovered(mouseX, mouseY) ? config2.buttonColorHovered : config2.buttonColor);
    }

    public int method_25368() {
        return this.extendedWidth;
    }

    private boolean isBtnAddHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + this.extendedWidth - 6) && mouseX < (double)(this.method_46426() + this.extendedWidth) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + 6);
    }

    private boolean isBtnSubHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + this.extendedWidth - 6) && mouseX < (double)(this.method_46426() + this.extendedWidth) && mouseY >= (double)(this.method_46427() + 6 + 3) && mouseY < (double)(this.method_46427() + 12 + 3);
    }

    private boolean isBtnHovered(double mouseX, double mouseY) {
        return this.isBtnAddHovered(mouseX, mouseY) || this.isBtnSubHovered(mouseX, mouseY);
    }

    private int getValidValue() {
        return StringUtil.getIntWithLimit(this.method_1882(), this.range, this.defaultValue);
    }

    private boolean isValidClick(int mouseButton) {
        return mouseButton == 0 || mouseButton == 1 || mouseButton == 2;
    }
}

