/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.screens;

import dev.nymnux.rhizome.config.CfgChatMacro;
import dev.nymnux.rhizome.config.CfgPartyWaypointShare;
import dev.nymnux.rhizome.config.CfgQuickDungeonCommand;
import dev.nymnux.rhizome.config.HintRecord;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.config.screen.ModConfigScreen;
import dev.nymnux.rhizome.config.string.StringHolder;
import dev.nymnux.rhizome.gui.module.ModuleButton;
import dev.nymnux.rhizome.gui.module.ModuleButtons;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.screen.container.list.ScreenEntryList;
import dev.nymnux.rhizome.gui.screen.screens.ScreenCoordInput;
import dev.nymnux.rhizome.gui.screen.screens.ScreenModDirectionButtonUsage;
import dev.nymnux.rhizome.gui.screen.screens.ScreenPartyManager;
import dev.nymnux.rhizome.gui.screen.screens.ScreenSimpleCalculator;
import dev.nymnux.rhizome.gui.screen.screens.ScreenSimpleWarpMenu;
import dev.nymnux.rhizome.gui.screen.screens.ScreenWaypointShare;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.gui.widget.ModColorSlider;
import dev.nymnux.rhizome.gui.widget.ModDoubleSlider;
import dev.nymnux.rhizome.gui.widget.ModIntegerSlider;
import dev.nymnux.rhizome.gui.widget.ModSwitchButton;
import dev.nymnux.rhizome.keybind.RhiKeyBinds;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.modules.event.function.FunctionKeyDispatcher;
import dev.nymnux.rhizome.module.modules.event.function.FunctionMode;
import dev.nymnux.rhizome.module.modules.gadget.PartyWaypointShare;
import dev.nymnux.rhizome.module.modules.waypoint.QuickWaypointManager;
import dev.nymnux.rhizome.text.ModText;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.ChatUtil;
import dev.nymnux.rhizome.util.ListUtil;
import dev.nymnux.rhizome.util.io.KeyBindUtil;
import dev.nymnux.rhizome.util.math.Vec2i;
import dev.nymnux.rhizome.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class ScreenIndex
extends ModScreen {
    private final List<ModButton> modButtons = new ArrayList<ModButton>();
    private boolean closed = false;
    private boolean mouseClicked = false;

    public ScreenIndex(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void method_25426() {
        this.modButtons.clear();
        HintRecord hintRecord = ModConfig.getInstance().hintRecord;
        int screenIndexModuleButtonRowSize = ModConfig.getInstance().screenIndexModuleButtonRowSize;
        ModPanel panelModuleButtons = this.createPanel(ModScreen.InnerPosition.RIGHT_TOP, ScreenIndex.calcWidth(screenIndexModuleButtonRowSize), ScreenIndex.calcHeight((int)Math.ceil((double)ModuleButtons.ALL_MODULES.size() / (double)screenIndexModuleButtonRowSize)));
        List<List<ModuleButton>> dividedModuleButtons = ListUtil.divideList(ModuleButtons.ALL_MODULES, screenIndexModuleButtonRowSize);
        for (int i = 0; i < dividedModuleButtons.size(); ++i) {
            List<ModuleButton> row = dividedModuleButtons.get(i);
            for (int j = 0; j < row.size(); ++j) {
                ModuleButton moduleButton = row.get(j);
                ModButton moduleButtonWidget = moduleButton.getButtonWidget(this.ctx);
                this.addModButton(panelModuleButtons, moduleButtonWidget, j * 18, i * 18);
            }
        }
        this.addPanel(panelModuleButtons);
        Vec2i panelChatMacroSize = this.calcPanelChatMacroSize();
        ModPanel panelChatMacro = this.createPanel(ModScreen.InnerPosition.LEFT_TOP, panelChatMacroSize.m, panelChatMacroSize.n);
        for (CfgChatMacro chatMacro : ModConfig.getInstance().cfgChatMacroList) {
            ModButton btnChatMacro = new ModButton(15 + 18 * (chatMacro.widthCount - 1), (class_2561)class_2561.method_43470((String)chatMacro.displayName), button -> {
                if (chatMacro.openChatScreen) {
                    ChatUtil.openChatScreen(this.ctx, chatMacro.message, chatMacro.chatScreenIndex);
                } else {
                    ChatUtil.sendChatMessage(this.ctx, chatMacro.message);
                }
            });
            this.addModButton(panelChatMacro, btnChatMacro, 18 * chatMacro.gridPos.m, 18 * chatMacro.gridPos.n);
        }
        this.addPanel(panelChatMacro);
        ModPanel panelChatMacroConfig = this.createPanel(ModScreen.InnerPosition.LEFT_BOTTOM, ScreenIndex.calcWidth(1), ScreenIndex.calcHeight(1));
        this.addModButton(panelChatMacroConfig, new ModButton(15, RhiTexts.common.icon.config.getText(), button -> {
            if (ModConfig.getInstance().hintRecord.modDirectionButtonUsage) {
                ScreenIndex.openScreen(new ScreenModDirectionButtonUsage(this.ctx));
                ModConfig.getInstance().hintRecord.modDirectionButtonUsage = false;
            } else {
                ScreenIndex.openScreen(ScreenEntryList.chatMacroConfigScreen(this.ctx));
            }
        }));
        this.addPanel(panelChatMacroConfig);
        ModPanel panelModConfig = this.createPanel(ModScreen.InnerPosition.RIGHT_BOTTOM, ScreenIndex.calcWidth(1), ScreenIndex.calcHeight(1));
        this.addModButton(panelModConfig, new ModButton(15, RhiTexts.common.icon.config.getText(), button -> this.ctx.client.method_1507(ModConfigScreen.create(null))));
        this.addPanel(panelModConfig);
        FunctionMode mode = FunctionKeyDispatcher.getMode();
        if (mode != null) {
            class_2561 name = mode.getDisplayName();
            int panelFunctionKeyWidth = StringUtil.getExtendedTextWidth(this.ctx, name.getString());
            ModPanel panelFunctionKey = this.createPanel(ModScreen.InnerPosition.TOP_MIDDLE, panelFunctionKeyWidth, ScreenIndex.calcHeight(1));
            ModButton btnCurrFunctionKey = new ModButton(panelFunctionKeyWidth, name, button -> {}, button -> {
                FunctionKeyDispatcher.setMode(null);
                ScreenIndex.closeScreen();
            }, button -> {
                hintRecord.functionKey = false;
            });
            class_5250 tooltip = mode.getTooltip();
            if (hintRecord.functionKey) {
                ScreenIndex.appendHintTooltip(tooltip, RhiTexts.function_key.hint.getHints());
            }
            btnCurrFunctionKey.method_47400(class_7919.method_47407((class_2561)tooltip));
            this.addModButton(panelFunctionKey, btnCurrFunctionKey);
            this.addPanel(panelFunctionKey);
        }
        int hubBtnLength = 30;
        int hubBtnGap = 5;
        int hubSize = 3;
        int hubLength = hubBtnLength * hubSize + hubBtnGap * (hubSize - 1);
        int hubGridLength = hubBtnLength + hubBtnGap;
        ModPanel panelHub = this.createPanel(ModScreen.InnerPosition.CENTER, hubLength, hubLength);
        ModButton btnSkyblockMap = new ModButton(hubBtnLength, RhiTexts.screen.hub.skyblock_map, button -> {
            if (ModConfig.getInstance().useDefaultWarpMenu) {
                ChatUtil.sendChatMessage(this.ctx, "/warp");
            } else {
                ScreenIndex.openScreen(new ScreenSimpleWarpMenu(this.ctx));
            }
        });
        btnSkyblockMap.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnSkyblockMap, hubGridLength, 0);
        ModButton btnSkyblockBazaar = new ModButton(hubBtnLength, RhiTexts.screen.hub.skyblock_bazaar, button -> ChatUtil.sendChatMessage(this.ctx, "/bz"));
        btnSkyblockBazaar.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnSkyblockBazaar, 0, hubGridLength);
        ModButton btnSkyblockAuctionHouse = new ModButton(hubBtnLength, RhiTexts.screen.hub.skyblock_auction_house, button -> ChatUtil.sendChatMessage(this.ctx, "/ah"));
        btnSkyblockAuctionHouse.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnSkyblockAuctionHouse, hubGridLength * 2, hubGridLength);
        ModButton btnScreenQuickWaypoint = new ModButton(hubBtnLength, RhiTexts.common.icon.waypoint, button -> QuickWaypointManager.setWaypoint(this.ctx.player.method_24515()), button -> QuickWaypointManager.clearWaypoint(), button -> {
            ScreenIndex.openScreen(new ScreenCoordInput(this.ctx, QuickWaypointManager::setWaypoint));
            hintRecord.quickWaypoint = false;
        });
        btnScreenQuickWaypoint.method_53533(hubBtnLength);
        if (hintRecord.quickWaypoint) {
            btnScreenQuickWaypoint.method_47400(ScreenIndex.buildHintTooltip(RhiTexts.screen.hub.quick_waypoint$hint.getHints()));
        }
        this.addModButton(panelHub, btnScreenQuickWaypoint, 0, hubGridLength * 2);
        ModButton btnSimpleCalculator = new ModButton(hubBtnLength, RhiTexts.screen.hub.simple_calculator, button -> ScreenIndex.openScreen(new ScreenSimpleCalculator(this.ctx)));
        btnSimpleCalculator.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnSimpleCalculator, hubGridLength * 2, hubGridLength * 2);
        ModButton btnQuickDungeon = new ModButton(hubBtnLength, RhiTexts.screen.hub.quick_dungeon, button -> ScreenIndex.openScreen(this.ctx, scn -> {
            CfgQuickDungeonCommand config2 = ModConfig.getInstance().cfgQuickDungeonCommand;
            ModPanel panelMain = scn.createPanel(ModScreen.InnerPosition.CENTER, ScreenIndex.calcWidth(7), ScreenIndex.calcHeight(2));
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F1", config2.catacombFloor1).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 0, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F2", config2.catacombFloor2).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 18, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F3", config2.catacombFloor3).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 36, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F4", config2.catacombFloor4).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 54, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F5", config2.catacombFloor5).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 72, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F6", config2.catacombFloor6).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 90, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F7", config2.catacombFloor7).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291), 108, 0);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M1", config2.masterModeCatacombFloor1).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 0, 18);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M2", config2.masterModeCatacombFloor2).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 18, 18);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M3", config2.masterModeCatacombFloor3).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 36, 18);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M4", config2.masterModeCatacombFloor4).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 54, 18);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M5", config2.masterModeCatacombFloor5).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 72, 18);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M6", config2.masterModeCatacombFloor6).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 90, 18);
            panelMain.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "M7", config2.masterModeCatacombFloor7).setCustomMessageColor(-43691).setCustomMessageColorHovered(-43691), 108, 18);
            scn.addPanel(panelMain);
            ModPanel panelFloor0 = scn.appendPanel(panelMain, ModScreen.OuterPosition.LEFT_TOP, ScreenIndex.calcWidth(1), ScreenIndex.calcHeight(1), false);
            panelFloor0.addDrawableChild((class_339)this.getQuickDungeonButton(this.ctx, "F0", config2.catacombFloor0).setCustomMessageColor(-11141291).setCustomMessageColorHovered(-11141291));
            scn.addPanel(panelFloor0);
        }));
        btnQuickDungeon.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnQuickDungeon, 0, 0);
        ModButton btnPartyManager = new ModButton(hubBtnLength, RhiTexts.screen.hub.party_manager, button -> ScreenIndex.openScreen(new ScreenPartyManager(this.ctx)));
        btnPartyManager.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnPartyManager, hubGridLength * 2, 0);
        ModButton btnLocationShare = new ModButton(hubBtnLength, RhiTexts.screen.hub.location_share, button -> ScreenIndex.openScreen(new ScreenWaypointShare(this.ctx)), button -> PartyWaypointShare.clear(), button -> ScreenIndex.openScreen(this.ctx, scn -> {
            int panelWidth = 200;
            ModPanel panel = scn.createPanel(ModScreen.InnerPosition.CENTER, panelWidth, ScreenIndex.calcHeight(9));
            CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
            panel.addDrawableChild((class_339)new ModSwitchButton(RhiTexts.screen.party_waypoint_share_config.show_player_head, config2.showPlayerHead, btn -> {
                config2.showPlayerHead = btn.isChecked();
            }));
            panel.addDrawableChild((class_339)new ModIntegerSlider(panelWidth, RhiTexts.screen.party_waypoint_share_config.min_scale_distance, config2.minScaleDistance, 1, 48, mappedValue -> {
                config2.minScaleDistance = mappedValue;
            }));
            panel.addDrawableChild((class_339)new ModIntegerSlider(panelWidth, RhiTexts.screen.party_waypoint_share_config.interact_radius, config2.interactRadius, 1, 15, mappedValue -> {
                config2.interactRadius = mappedValue;
            }));
            panel.addDrawableChild((class_339)new ModDoubleSlider(panelWidth, RhiTexts.screen.party_waypoint_share_config.scale, config2.scale, 1.0, 128.0, mappedValue -> {
                config2.scale = mappedValue;
            }));
            panel.addDrawableChild((class_339)new ModIntegerSlider(panelWidth, RhiTexts.screen.party_waypoint_share_config.rare_event_duration, config2.rareEventDuration, 1, 200, mappedValue -> {
                config2.rareEventDuration = mappedValue;
            }));
            panel.addDrawableChild((class_339)ScreenIndex.buildTextField(this.ctx, panelWidth, RhiTexts.screen.party_waypoint_share_config.sound_effect, RhiTexts.screen.party_waypoint_share_config.sound_effect, config2.soundEffect, (String s) -> {
                config2.soundEffect = s;
            }));
            panel.addDrawableChild((class_339)new ModButton(panelWidth, RhiTexts.screen.party_waypoint_share_config.rare_event_config, button1 -> ScreenIndex.openScreen(ScreenEntryList.rareEventConfigScreen(this.ctx))));
            panel.addDrawableChild(new ModColorSlider(panelWidth, config2.messageColor, integer -> {
                config2.messageColor = integer;
            }, -32944, RhiTexts.screen.party_waypoint_share_config.message_color));
            scn.addPanel(panel);
        }));
        btnLocationShare.method_53533(hubBtnLength);
        this.addModButton(panelHub, btnLocationShare, hubGridLength, hubGridLength * 2);
        this.addPanel(panelHub);
        super.method_25426();
    }

    private ModButton getQuickDungeonButton(ClientContext ctx, String floorName, StringHolder config2) {
        return new ModButton(15, ModText.of(floorName), button -> {
            this.method_25419();
            ChatUtil.sendChatMessage(ctx, config2.str);
        }, button -> {}, button -> ScreenIndex.openScreen(ctx, scn -> {
            int panelWidth = 300;
            ModPanel panel = this.createPanel(ModScreen.InnerPosition.CENTER, panelWidth, ScreenIndex.calcHeight(1));
            class_342 txtCommand = ScreenIndex.buildTextField(ctx, panelWidth, (class_2561)class_2561.method_43470((String)floorName), config2.str, (String s) -> {
                config2.str = s;
            });
            panel.addDrawableChild((class_339)txtCommand);
            scn.addPanel(panel);
        }));
    }

    private Vec2i calcPanelChatMacroSize() {
        Vec2i size = new Vec2i();
        int maxX = 0;
        int maxY = 0;
        for (CfgChatMacro chatMacro : ModConfig.getInstance().cfgChatMacroList) {
            int endX = (chatMacro.gridPos.m + chatMacro.widthCount - 1) * 18 + 15;
            int endY = chatMacro.gridPos.n * 18 + 15;
            if (endX > maxX) {
                maxX = endX;
            }
            if (endY <= maxY) continue;
            maxY = endY;
        }
        size.m = maxX;
        size.n = maxY;
        return size;
    }

    public void method_25393() {
        if (!this.mouseClicked && (KeyBindUtil.isMouseDown(0) || KeyBindUtil.isMouseDown(1) || KeyBindUtil.isMouseDown(2))) {
            this.mouseClicked = true;
        }
        if (!this.closed && !KeyBindUtil.isKeyOrMouseDown(RhiKeyBinds.keyIndex)) {
            ScreenIndex.clearScreen();
            if (!this.mouseClicked) {
                for (ModButton modButton : this.modButtons) {
                    if (!modButton.method_49606()) continue;
                    ScreenIndex.playModButtonDownSound();
                    modButton.onLeftClick();
                    break;
                }
            }
            this.closed = true;
        }
        super.method_25393();
    }

    private void addModButton(ModPanel panel, ModButton button) {
        this.modButtons.add(button);
        panel.addDrawableChild((class_339)button);
    }

    private void addModButton(ModPanel panel, ModButton button, int x, int y) {
        this.modButtons.add(button);
        panel.addDrawableChild((class_339)button, x, y);
    }
}

