/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.screens;

import dev.nymnux.rhizome.config.CfgQuickItemSwap;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.ModText;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.math.Vec2d;
import dev.nymnux.rhizome.util.render.RenderUtil;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class ScreenQuickItemSwapConfig
extends ModScreen {
    private ModButton[] btnHotBar;
    private ModButton[] btnInventoryInside;
    private int selectedBtnSlotId = -1;

    public ScreenQuickItemSwapConfig(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void method_25426() {
        int slotId;
        this.btnHotBar = new ModButton[8];
        this.btnInventoryInside = new ModButton[27];
        this.selectedBtnSlotId = -1;
        int panelWidth = 168;
        int panelHotBarHeight = 16;
        int panelInventoryInsideHeight = 54;
        ModPanel panelInventoryInside = this.createPanel(ModScreen.InnerPosition.CENTER, panelWidth, panelInventoryInsideHeight);
        panelInventoryInside.move(0, -panelHotBarHeight / 2);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                slotId = (i + 1) * 9 + j;
                int index = i * 9 + j;
                this.btnInventoryInside[index] = new ModButton(16, (class_2561)class_2561.method_43473(), button -> this.onButtonLeftClick(slotId), button -> this.onButtonRightClick(slotId));
                this.btnInventoryInside[index].method_53533(16);
                panelInventoryInside.addDrawableChild((class_339)this.btnInventoryInside[index], j * 19, i * 19);
            }
        }
        this.addPanel(panelInventoryInside);
        ModPanel panelHotBar = this.appendPanel(panelInventoryInside, ModScreen.OuterPosition.BOTTOM_MIDDLE, panelWidth, panelHotBarHeight, true);
        for (int i = 0; i < 8; ++i) {
            slotId = i;
            this.btnHotBar[i] = new ModButton(16, (class_2561)class_2561.method_43473(), button -> this.onButtonLeftClick(slotId));
            this.btnHotBar[i].method_53533(16);
            panelHotBar.addDrawableChild((class_339)this.btnHotBar[i], i * 19, 0);
        }
        ModButton btnMenu = new ModButton(16, ModText.of("\u00b7\u00b7\u00b7"));
        btnMenu.method_53533(16);
        panelHotBar.addDrawableChild((class_339)btnMenu, 152, 0);
        this.addPanel(panelHotBar);
        if (ModConfig.getInstance().hintRecord.quickItemSwap) {
            ModPanel panelHint = this.appendPanel(panelInventoryInside, ModScreen.OuterPosition.RIGHT_TOP, 16, 16, true);
            ModButton btnHint = new ModButton(16, RhiTexts.common.icon.question_mark, button -> {
                ModConfig.getInstance().hintRecord.quickItemSwap = false;
                this.method_41843();
            });
            btnHint.method_53533(16);
            btnHint.method_47400(ScreenQuickItemSwapConfig.buildHintTooltip(RhiTexts.screen.quick_item_swap_config.hint.getHints(), false));
            panelHint.addDrawableChild((class_339)btnHint);
            this.addPanel(panelHint);
        }
        super.method_25426();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i;
        super.method_25394(context, mouseX, mouseY, delta);
        class_1661 inventory = this.ctx.player.method_31548();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotId = (i + 1) * 9 + j;
                int index = i * 9 + j;
                ModButton btnI = this.btnInventoryInside[index];
                context.method_51427(inventory.method_5438(slotId), btnI.method_46426(), btnI.method_46427());
            }
        }
        for (i = 0; i < 8; ++i) {
            ModButton btnI = this.btnHotBar[i];
            context.method_51427(inventory.method_5438(i), btnI.method_46426(), btnI.method_46427());
        }
        CfgQuickItemSwap config2 = ModConfig.getInstance().cfgQuickItemSwap;
        config2.swapMap.forEach((slotInventoryInside, slotHotBar) -> {
            if (slotInventoryInside < 9 || slotInventoryInside >= 36 || slotHotBar < 0 || slotHotBar >= 8) {
                return;
            }
            ModButton btn1 = this.btnInventoryInside[slotInventoryInside - 9];
            ModButton btn2 = this.btnHotBar[slotHotBar];
            int color2 = config2.hotBarSlotColor.get((int)slotHotBar);
            int offset = -1;
            ScreenQuickItemSwapConfig.drawStyledItemBorder(context, btn1.method_46426() + offset, btn1.method_46427() + offset, color2);
            ScreenQuickItemSwapConfig.drawStyledItemBorder(context, btn2.method_46426() + offset, btn2.method_46427() + offset, color2);
            RenderUtil.drawLine(context, new Vec2d((double)btn1.method_46426() + 8.5, (double)btn1.method_46427() + 8.5), new Vec2d((double)btn2.method_46426() + 8.5, (double)btn2.method_46427() + 8.5), color2);
        });
    }

    private void onButtonLeftClick(int slotId) {
        if (this.selectedBtnSlotId == -1) {
            if (slotId >= 9 && slotId < 36) {
                this.selectedBtnSlotId = slotId;
            }
        } else if (slotId >= 0 && slotId < 8) {
            ModConfig.getInstance().cfgQuickItemSwap.swapMap.put(this.selectedBtnSlotId, slotId);
            this.selectedBtnSlotId = -1;
        } else if (slotId >= 9 && slotId < 36) {
            this.selectedBtnSlotId = slotId;
        }
    }

    private void onButtonRightClick(int slotId) {
        this.selectedBtnSlotId = -1;
        ModConfig.getInstance().cfgQuickItemSwap.swapMap.remove(slotId);
    }

    private static void drawStyledItemBorder(class_332 context, int x, int y, int color2) {
        int sectionWidth = 4;
        int width = 17;
        context.method_51738(x, x + sectionWidth, y, color2);
        context.method_51738(x + width - sectionWidth, x + width, y, color2);
        context.method_51738(x, x + sectionWidth, y + width, color2);
        context.method_51738(x + width - sectionWidth, x + width, y + width, color2);
        context.method_51742(x, y, y + sectionWidth, color2);
        context.method_51742(x, y + width - sectionWidth, y + width, color2);
        context.method_51742(x + width, y, y + sectionWidth, color2);
        context.method_51742(x + width, y + width - sectionWidth, y + width, color2);
    }
}

