/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.screens.fishingtimer;

import dev.nymnux.rhizome.config.CfgFishingTimer;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.screen.screens.fishingtimer.ScreenFishingTimerConfigSoundEffect;
import dev.nymnux.rhizome.gui.screen.screens.fishingtimer.ScreenFishingTimerConfigTimerBar;
import dev.nymnux.rhizome.gui.screen.screens.fishingtimer.ScreenFishingTimerPreset;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.gui.widget.ModDoubleSlider;
import dev.nymnux.rhizome.gui.widget.ModIntegerSlider;
import dev.nymnux.rhizome.gui.widget.ModSwitchButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.modules.render.label.LabelManager;
import dev.nymnux.rhizome.module.modules.render.label.SimpleLabel;
import dev.nymnux.rhizome.profile.PrfFishingTimerLoader;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.ToastUtil;
import dev.nymnux.rhizome.util.color.ColorUtil;
import java.io.File;
import net.minecraft.class_156;
import net.minecraft.class_2428;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class ScreenFishingTimerConfig
extends ModScreen {
    private int timer = 40;
    private int prevTimer = 40;

    public ScreenFishingTimerConfig(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void method_25426() {
        this.timer = 40;
        this.prevTimer = 40;
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        int panelLeftWidth = 160;
        ModPanel panelLeft = this.createPanel(ModScreen.InnerPosition.LEFT_MIDDLE, panelLeftWidth, ScreenFishingTimerConfig.calcHeight(8));
        panelLeft.addDrawableChild((class_339)new ModSwitchButton(RhiTexts.screen.fishing_timer_config.show_timer_bar, config2.showTimerBar, btn -> {
            config2.showTimerBar = btn.isChecked();
        }));
        panelLeft.addDrawableChild((class_339)new ModSwitchButton(RhiTexts.screen.fishing_timer_config.enable_sound_effect, config2.enableSoundEffect, btn -> {
            config2.enableSoundEffect = btn.isChecked();
        }));
        panelLeft.addDrawableChild((class_339)new ModIntegerSlider(panelLeftWidth, RhiTexts.screen.fishing_timer_config.timer_threshold, config2.timerThreshold, 0, 40, mappedValue -> {
            config2.timerThreshold = mappedValue;
        }));
        panelLeft.addDrawableChild((class_339)new ModDoubleSlider(panelLeftWidth, RhiTexts.screen.fishing_timer_config.armor_stand_offset_y, config2.armorStandOffsetY, -2.0, 2.0, mappedValue -> {
            config2.armorStandOffsetY = mappedValue;
        }));
        panelLeft.addDrawableChild((class_339)new ModDoubleSlider(panelLeftWidth, RhiTexts.common.config.x_percent, config2.xPercent, mappedValue -> {
            config2.xPercent = mappedValue;
        }));
        panelLeft.addDrawableChild((class_339)new ModDoubleSlider(panelLeftWidth, RhiTexts.common.config.y_percent, config2.yPercent, mappedValue -> {
            config2.yPercent = mappedValue;
        }));
        panelLeft.addDrawableChild((class_339)new ModDoubleSlider(panelLeftWidth, RhiTexts.common.config.scale, config2.scale, 0.0, 32.0, mappedValue -> {
            config2.scale = mappedValue;
        }));
        panelLeft.addDrawableChild((class_339)new ModDoubleSlider(panelLeftWidth, RhiTexts.common.config.volume, config2.volume, 0.0, 4.0, mappedValue -> {
            config2.volume = mappedValue;
        }));
        this.addPanel(panelLeft);
        int panelRightWidth = 80;
        ModPanel panelRight = this.createPanel(ModScreen.InnerPosition.RIGHT_MIDDLE, panelRightWidth, ScreenFishingTimerConfig.calcHeight(2));
        panelRight.addDrawableChild((class_339)new ModButton(panelRightWidth, RhiTexts.screen.fishing_timer_config.timer_bar, button -> ScreenFishingTimerConfig.openScreen(new ScreenFishingTimerConfigTimerBar(this.ctx))));
        panelRight.addDrawableChild((class_339)new ModButton(panelRightWidth, RhiTexts.screen.fishing_timer_config.sound_effect, button -> ScreenFishingTimerConfig.openScreen(new ScreenFishingTimerConfigSoundEffect(this.ctx))));
        this.addPanel(panelRight);
        int panelBottomWidth = this.ctx.client.method_22683().method_4486() - 6;
        ModPanel panelBottom = this.createPanel(ModScreen.InnerPosition.BOTTOM_MIDDLE, panelBottomWidth, ScreenFishingTimerConfig.calcHeight(1));
        panelBottom.addDrawableChild((class_339)new ModIntegerSlider(panelBottomWidth, RhiTexts.common.config.preview, 40, 0, 40, mappedValue -> {
            this.timer = mappedValue;
        }));
        this.addPanel(panelBottom);
        ModPanel panelPrf = this.createPanel(ModScreen.InnerPosition.RIGHT_TOP, ScreenFishingTimerConfig.calcWidth(3), ScreenFishingTimerConfig.calcHeight(1));
        panelPrf.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.preset, button -> ScreenFishingTimerConfig.openScreen(new ScreenFishingTimerPreset(this.ctx))));
        panelPrf.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.the_import, button -> {
            PrfFishingTimerLoader.importProfile(this.ctx);
            ScreenFishingTimerConfig.clearScreen();
            ScreenFishingTimerConfig.openScreen(new ScreenFishingTimerConfig(this.ctx));
        }), 18, 0);
        panelPrf.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.the_export, button -> {
            if (!PrfFishingTimerLoader.exportProfile(this.ctx)) {
                ToastUtil.addToast(RhiTexts.toast.fishing_timer.failed_to_export_profile, "");
                return;
            }
            String path = this.ctx.client.field_1697.getPath() + "/config/rhizome/profile/fishing_timer/timer.csv";
            File file = new File(path);
            if (file.exists()) {
                class_156.method_668().method_672(file.getParentFile());
            } else {
                ToastUtil.addToast(RhiTexts.toast.fishing_timer.failed_to_open_profile, "");
            }
        }), 36, 0);
        this.addPanel(panelPrf);
        super.method_25426();
    }

    public void method_25393() {
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        if (this.timer > config2.timerThreshold) {
            return;
        }
        double x = (double)this.ctx.client.method_22683().method_4489() * config2.xPercent;
        double y = (double)this.ctx.client.method_22683().method_4506() * config2.yPercent;
        LabelManager.addLabel(new SimpleLabel(x, y, (float)config2.scale, -1, 1, true, ColorUtil.parseFormat(config2.timerBar[this.timer])));
        if (this.prevTimer == this.timer) {
            return;
        }
        CfgFishingTimer.CfgSound soundEffect = config2.soundEffects[this.timer];
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_63535(class_2960.method_60656((String)soundEffect.id));
        if (soundEvent != null) {
            this.ctx.world.method_67392(soundEvent, class_3419.field_15250, (float)(config2.volume * soundEffect.volume), class_2428.method_49818((int)soundEffect.pitch));
        }
        this.prevTimer = this.timer;
    }
}

