/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.gadget;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.mixin.accessor.OrderedTextTooltipComponentAccessor;
import dev.nymnux.rhizome.module.AModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.util.io.KeyBindUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public class TooltipScroll
extends AModModule {
    private static final int QUEUE_SIZE = 5;
    private static final int SMOOTH_COUNT = 2;
    private static List<String> prevTooltip = null;
    private static boolean hasTooltip = false;
    private static final List<Integer> offsetYQueue = new LinkedList<Integer>(List.of(Integer.valueOf(0)));
    private static float tickDelta = 0.0f;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (offsetYQueue.size() > 1) {
            offsetYQueue.removeFirst();
        }
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        TooltipScroll.tickDelta = tickDelta;
        if (!hasTooltip) {
            TooltipScroll.reset();
        }
        hasTooltip = false;
    }

    public static void tick(List<class_5684> components) {
        hasTooltip = true;
        List<String> currTooltip = TooltipScroll.getTooltip(components);
        if (currTooltip == null) {
            TooltipScroll.reset();
            prevTooltip = null;
            return;
        }
        if (prevTooltip == null) {
            TooltipScroll.reset();
            prevTooltip = currTooltip;
            return;
        }
        if (!prevTooltip.equals(currTooltip) && !KeyBindUtil.isAltDown()) {
            TooltipScroll.reset();
            prevTooltip = currTooltip;
        }
    }

    private static List<String> getTooltip(List<class_5684> components) {
        if (components.isEmpty()) {
            return null;
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        for (class_5684 component : components) {
            if (!(component instanceof class_5683)) continue;
            class_5683 orderedTextTooltipComponent = (class_5683)component;
            StringBuilder sb = new StringBuilder();
            ((OrderedTextTooltipComponentAccessor)orderedTextTooltipComponent).rhizome$getText().accept((index, style, codePoint) -> {
                sb.appendCodePoint(codePoint);
                return true;
            });
            tooltip.add(sb.toString());
        }
        if (tooltip.isEmpty()) {
            return null;
        }
        return tooltip;
    }

    public static void onMouseScroll(double verticalAmount) {
        if (verticalAmount == 0.0 || ModConfig.getInstance().tooltipScrollSpeed == 0) {
            return;
        }
        if (offsetYQueue.size() >= 5) {
            return;
        }
        int step = (verticalAmount > 0.0 ? 1 : -1) * ModConfig.getInstance().tooltipScrollSpeed;
        for (int i = 0; i < Math.min(5 - offsetYQueue.size(), 2); ++i) {
            offsetYQueue.add(offsetYQueue.getLast() + step);
        }
    }

    public static int getLerpedOffsetY() {
        if (offsetYQueue.size() > 1) {
            int y1 = offsetYQueue.getFirst();
            int y2 = offsetYQueue.get(1);
            return y1 + Math.round((float)(y2 - y1) * tickDelta);
        }
        return offsetYQueue.getFirst();
    }

    private static void reset() {
        offsetYQueue.clear();
        offsetYQueue.add(0);
    }

    public static void mixinMouse$onMouseScroll() {
    }

    public static void mixinDrawContext$drawTooltip() {
    }

    public static void mixinHoveredTooltipPositioner$preventOverflow() {
    }
}

