/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.fishing;

import dev.nymnux.rhizome.config.CfgFishingTimer;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.AModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.EventClock;
import dev.nymnux.rhizome.module.modules.render.label.LabelManager;
import dev.nymnux.rhizome.module.modules.render.label.SimpleLabel;
import dev.nymnux.rhizome.util.color.ColorUtil;
import dev.nymnux.rhizome.util.math.ProjectionUtil;
import dev.nymnux.rhizome.util.render.RenderUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2428;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class FishingTimer
extends AModModule {
    private static final EventClock ALARM = new EventClock(4, 4, ctx -> ctx.player.method_43077((class_3414)class_3417.field_14622.comp_349()));
    private static final Pattern TIMER_PATTERN = Pattern.compile("^[0-9]\\.[0-9]$");
    private static int currTimer = -1;
    private static int prevTimer = -1;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        if (!config2.showTimerBar && !config2.enableSoundEffect) {
            this.reset();
            return;
        }
        class_1799 itemStack = ctx.player.method_6047();
        if (itemStack.method_7960() || !itemStack.method_31574(class_1802.field_8378)) {
            this.reset();
            return;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (class_1297 entity : ctx.world.method_18112()) {
            class_243 pos;
            class_243 labelPos;
            ProjectionUtil.ProjectResult project;
            class_1531 armorStand;
            if (!(entity instanceof class_1531) || (armorStand = (class_1531)entity).method_5797() == null || !armorStand.method_5807() || !RenderUtil.checkOnFullScreen(ctx, (project = ProjectionUtil.project(ctx, labelPos = new class_243((pos = armorStand.method_19538()).method_10216(), pos.method_10214() + config2.armorStandOffsetY, pos.method_10215()), 0.0f)).screenPos())) continue;
            if (TIMER_PATTERN.matcher(armorStand.method_5797().getString()).matches()) {
                int timer = (int)(Double.parseDouble(armorStand.method_5797().getString()) * 10.0);
                if (timer < 1 || timer > 40) continue;
                results.add(timer);
                continue;
            }
            if (!armorStand.method_5797().getString().equals("!!!")) continue;
            results.add(0);
        }
        if (results.size() > 1) {
            this.addEventClockStart(ALARM, true);
            this.reset();
        } else if (results.size() == 1) {
            int timer;
            currTimer = timer = ((Integer)results.getFirst()).intValue();
            if (config2.showTimerBar) {
                this.onTimerBar(ctx, timer);
            }
            if (config2.enableSoundEffect) {
                this.onSoundEffect(ctx, timer);
            }
        } else {
            this.reset();
        }
    }

    private void onTimerBar(ClientContext ctx, int timer) {
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        if (timer > config2.timerThreshold) {
            return;
        }
        double x = (double)ctx.client.method_22683().method_4489() * config2.xPercent;
        double y = (double)ctx.client.method_22683().method_4506() * config2.yPercent;
        LabelManager.addLabel(new SimpleLabel(x, y, (float)config2.scale, -1, 1, true, ColorUtil.parseFormat(config2.timerBar[timer])));
    }

    private void onSoundEffect(ClientContext ctx, int timer) {
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        if (timer > config2.timerThreshold) {
            return;
        }
        if (prevTimer == timer) {
            return;
        }
        CfgFishingTimer.CfgSound soundEffect = config2.soundEffects[timer];
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_63535(class_2960.method_60656((String)soundEffect.id));
        if (soundEvent == null) {
            return;
        }
        ctx.world.method_67392(soundEvent, class_3419.field_15250, (float)(config2.volume * soundEffect.volume), class_2428.method_49818((int)soundEffect.pitch));
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        if (currTimer != -1) {
            prevTimer = currTimer;
        }
    }

    private void reset() {
        currTimer = -1;
        prevTimer = -1;
    }
}

