/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.waypoint;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.AModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.math.ProjectionUtil;
import dev.nymnux.rhizome.util.math.Vec2d;
import dev.nymnux.rhizome.util.render.RenderUtil;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class QuickWaypointManager
extends AModModule {
    private static final int MIN_SCALE_DISTANCE = 16;
    private static final double TEXT_SCALE_FACTOR = 128.0;
    private static final double SCALE_FACTOR = 0.5;
    @Nullable
    private static class_2338 waypoint = null;

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        double scale;
        if (waypoint == null) {
            return;
        }
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float guiScale = ClientContext.getScaleFactor(ctx);
        float resizedGuiScale = 1.0f / guiScale;
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale, resizedGuiScale);
        class_243 pos = waypoint.method_46558();
        ProjectionUtil.ProjectResult result = ProjectionUtil.project(ctx, pos, tickDelta);
        Vec2d screenPos = result.screenPos();
        boolean onScreen = RenderUtil.checkAndLockOnScreen(ctx, screenPos);
        double dist = pos.method_1022(ctx.client.field_1773.method_19418().method_19326());
        if (dist > 16.0) {
            dist = 16.0;
        }
        double d = scale = Double.isNaN(scale = 64.0 / dist) ? Double.MAX_VALUE : scale;
        if (onScreen) {
            scale /= result.rawFov() / 70.0;
        }
        matrixStack.translate((float)screenPos.m, (float)(screenPos.n - scale * 4.0));
        matrixStack.scale((float)scale, (float)scale);
        drawContext.method_27534(ctx.client.field_1772, RhiTexts.common.icon.waypoint.getText(), 0, 0, ModConfig.getInstance().cfgPartyWaypointShare.messageColor);
        matrixStack.popMatrix();
    }

    public static void clearWaypoint() {
        waypoint = null;
    }

    public static void setWaypoint(@Nullable class_2338 pos) {
        waypoint = pos;
    }
}

