/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.io;

import dev.nymnux.rhizome.mixin.accessor.KeyBindingAccessor;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.util.mixin.IMixinKeyBinding;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class KeyBindUtil {
    private static final long WINDOW = class_310.method_1551().method_22683().method_4490();

    public static List<class_304> getDirectionKeyBinds(ClientContext ctx) {
        class_315 options = ctx.client.field_1690;
        return List.of(options.field_1894, options.field_1913, options.field_1881, options.field_1849);
    }

    public static List<class_304> getMoveControlKeyBinds(ClientContext ctx) {
        class_315 options = ctx.client.field_1690;
        return List.of(options.field_1894, options.field_1913, options.field_1881, options.field_1849, options.field_1903, options.field_1832, options.field_1867);
    }

    public static List<class_304> getClientPlayKeyBinds(ClientContext ctx) {
        class_315 options = ctx.client.field_1690;
        return List.of(options.field_1894, options.field_1913, options.field_1881, options.field_1849, options.field_1903, options.field_1832, options.field_1867, options.field_1886, options.field_1904, options.field_1871);
    }

    public static void resetKeyBind(class_304 keyBind) {
        ((KeyBindingAccessor)keyBind).rhizome$reset();
    }

    public static boolean isCopyDown() {
        return KeyBindUtil.isKeyDown(67) && KeyBindUtil.isCtrlDown() && !KeyBindUtil.isShiftDown() && !KeyBindUtil.isAltDown();
    }

    public static boolean isPasteDown() {
        return KeyBindUtil.isKeyDown(86) && KeyBindUtil.isCtrlDown() && !KeyBindUtil.isShiftDown() && !KeyBindUtil.isAltDown();
    }

    public static class_2561 getKeyboardKeyName(int glfwCode) {
        class_3675.class_306 key = class_3675.method_15985((int)glfwCode, (int)0);
        class_5250 text = class_2561.method_43471((String)key.method_1441());
        if (text.getString().contains(".")) {
            String name = GLFW.glfwGetKeyName((int)glfwCode, (int)0);
            if (name != null) {
                return class_2561.method_43470((String)name.toUpperCase());
            }
            return class_2561.method_43470((String)"-");
        }
        return text;
    }

    public static State getState(class_304 keyBind) {
        boolean isDown = keyBind.method_1434();
        boolean isDownPre = ((IMixinKeyBinding)keyBind).rhizome$isKeyPressedPre();
        boolean onPress = isDown && !isDownPre;
        boolean onRelease = !isDown && isDownPre;
        return new State(onPress, isDown, onRelease, KeyBindUtil.getMod());
    }

    public static boolean isKeyDown(int glfwCode) {
        return GLFW.glfwGetKey((long)WINDOW, (int)glfwCode) == 1;
    }

    public static boolean isMouseDown(int glfwCode) {
        return GLFW.glfwGetMouseButton((long)WINDOW, (int)glfwCode) == 1;
    }

    public static boolean isKeyOrMouseDown(class_304 keyBind) {
        class_3675.class_306 key = ((IMixinKeyBinding)keyBind).rhizome$getKey();
        if (key.method_1442() == class_3675.class_307.field_1668) {
            if (key.method_1444() == class_3675.field_16237.method_1444()) {
                return false;
            }
            return GLFW.glfwGetKey((long)WINDOW, (int)key.method_1444()) == 1;
        }
        if (key.method_1442() == class_3675.class_307.field_1672) {
            return GLFW.glfwGetMouseButton((long)WINDOW, (int)key.method_1444()) == 1;
        }
        return false;
    }

    private static State.Mod getMod() {
        if (KeyBindUtil.isRightButtonDown()) {
            return State.Mod.WITH_RIGHT_BUTTON;
        }
        if (KeyBindUtil.isLeftButtonDown()) {
            return State.Mod.WITH_LEFT_BUTTON;
        }
        if (KeyBindUtil.isShiftDown()) {
            return State.Mod.WITH_SHIFT;
        }
        if (KeyBindUtil.isCtrlDown()) {
            return State.Mod.WITH_CTRL;
        }
        if (KeyBindUtil.isAltDown()) {
            return State.Mod.WITH_ALT;
        }
        if (KeyBindUtil.isTabDown()) {
            return State.Mod.WITH_TAB;
        }
        return State.Mod.NORMAL;
    }

    public static boolean isShiftDown() {
        return GLFW.glfwGetKey((long)WINDOW, (int)340) == 1 || GLFW.glfwGetKey((long)WINDOW, (int)344) == 1;
    }

    public static boolean isCtrlDown() {
        return GLFW.glfwGetKey((long)WINDOW, (int)341) == 1 || GLFW.glfwGetKey((long)WINDOW, (int)345) == 1;
    }

    public static boolean isAltDown() {
        return GLFW.glfwGetKey((long)WINDOW, (int)342) == 1 || GLFW.glfwGetKey((long)WINDOW, (int)346) == 1;
    }

    public static boolean isTabDown() {
        return GLFW.glfwGetKey((long)WINDOW, (int)258) == 1;
    }

    public static boolean isLeftButtonDown() {
        return GLFW.glfwGetMouseButton((long)WINDOW, (int)0) == 1;
    }

    public static boolean isRightButtonDown() {
        return GLFW.glfwGetMouseButton((long)WINDOW, (int)1) == 1;
    }

    public record State(boolean onPress, boolean isDown, boolean onRelease, @NotNull Mod mod) {

        public static enum Mod {
            NORMAL,
            WITH_SHIFT,
            WITH_CTRL,
            WITH_ALT,
            WITH_TAB,
            WITH_LEFT_BUTTON,
            WITH_RIGHT_BUTTON;

        }
    }
}

