/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.math;

import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.util.math.Vec2d;
import net.minecraft.class_243;

public class RotationUtil {
    public static class_243 getRotationVec(double yaw, double pitch) {
        double pitchRad = Math.toRadians(pitch);
        double yawRadNeg = -Math.toRadians(yaw);
        double h = Math.cos(yawRadNeg);
        double i = Math.sin(yawRadNeg);
        double j = Math.cos(pitchRad);
        double k = Math.sin(pitchRad);
        return new class_243(i * j, -k, h * j);
    }

    public static double getYawDisplay(ClientContext ctx, float tickDelta) {
        return RotationUtil.getYawDisplay(ctx.player.method_5705(tickDelta));
    }

    public static double getYawDisplay(double yaw) {
        return (yaw = RotationUtil.clampYaw(yaw)) > 180.0 ? yaw - 360.0 : yaw;
    }

    public static Facing getFacing(ClientContext ctx, float tickDelta) {
        return RotationUtil.getFacing(ctx.player.method_5705(tickDelta));
    }

    public static Facing getFacing(double yaw) {
        if ((yaw = RotationUtil.clampYaw(yaw)) >= 0.0 && yaw < 45.0 || yaw >= 315.0 && yaw < 360.0) {
            return Facing.Z_POS;
        }
        if (yaw >= 45.0 && yaw < 135.0) {
            return Facing.X_NEG;
        }
        if (yaw >= 135.0 && yaw < 225.0) {
            return Facing.Z_NEG;
        }
        return Facing.X_POS;
    }

    public static Vec2d getAttitudeAngles(class_243 o, class_243 v) {
        double dx = v.field_1352 - o.field_1352;
        double dy = v.field_1351 - o.field_1351;
        double dz = v.field_1350 - o.field_1350;
        double yaw = Math.toDegrees(-Math.atan2(dx, dz));
        double pitch = Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)));
        return new Vec2d(yaw, pitch);
    }

    public static double clampYaw(double yaw) {
        if ((yaw %= 360.0) < 0.0) {
            yaw += 360.0;
        }
        return yaw;
    }

    public static double clampPitch(double pitch) {
        pitch = Math.max(-90.0, Math.min(90.0, pitch));
        return pitch;
    }

    public static double includedAngleVecRad(class_243 v1, class_243 v2) {
        double dotProduct = v1.field_1352 * v2.field_1352 + v1.field_1351 * v2.field_1351 + v1.field_1350 * v2.field_1350;
        double magnitude1 = Math.sqrt(v1.field_1352 * v1.field_1352 + v1.field_1351 * v1.field_1351 + v1.field_1350 * v1.field_1350);
        double magnitude2 = Math.sqrt(v2.field_1352 * v2.field_1352 + v2.field_1351 * v2.field_1351 + v2.field_1350 * v2.field_1350);
        return Math.acos(dotProduct / (magnitude1 * magnitude2));
    }

    public static double includedAngleAttitudeRad(Vec2d a1, Vec2d a2) {
        double r1 = Math.cos(Math.toRadians(a1.n));
        double r2 = Math.cos(Math.toRadians(a2.n));
        class_243 v1 = new class_243(r1 * Math.cos(Math.toRadians(a1.m)), r1 * Math.sin(Math.toRadians(a1.m)), Math.sin(Math.toRadians(a1.n)));
        class_243 v2 = new class_243(r2 * Math.cos(Math.toRadians(a2.m)), r2 * Math.sin(Math.toRadians(a2.m)), Math.sin(Math.toRadians(a2.n)));
        return RotationUtil.includedAngleVecRad(v1, v2);
    }

    public static double includedAngleYawDeg(double yaw1, double yaw2) {
        return Math.abs(RotationUtil.relativeAngleDiffDeg(yaw1, yaw2));
    }

    public static double includedAnglePitchDeg(double pitch1, double pitch2) {
        return Math.abs(RotationUtil.clampPitch(pitch1) - RotationUtil.clampPitch(pitch2));
    }

    public static double relativeAngleDiffDeg(double degTo, double degFrom) {
        return ((degTo - degFrom) % 360.0 + 540.0) % 360.0 - 180.0;
    }

    public static int getRotationDir(double yawTo, double yawFrom) {
        double delta = RotationUtil.relativeAngleDiffDeg(yawTo, yawFrom);
        if (delta > 0.0) {
            return 1;
        }
        if (delta < 0.0) {
            return -1;
        }
        return 0;
    }

    public static enum Facing {
        X_POS,
        Z_POS,
        X_NEG,
        Z_NEG;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> "X";
                case 1, 3 -> "Z";
            };
        }

        public String getSign() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> "+";
                case 2, 3 -> "-";
            };
        }
    }
}

