/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.render;

import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.util.color.ModColor;
import dev.nymnux.rhizome.util.math.Vec2d;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class RenderUtil {
    private static final int SCREEN_PADDING = 100;
    private static final double SCREEN_MAP_RATIO_X = 1.0;
    private static final double SCREEN_MAP_RATIO_Y = 0.85;
    private static final double BRIGHTNESS_MULTIPLIER = 0.25;

    public static void drawOutlineQuad(class_332 context, int x, int y, int width, int height, int color2) {
        RenderUtil.fill(context, x, y, width, 1, color2);
        RenderUtil.fill(context, x + width - 1, y, 1, height, color2);
        RenderUtil.fill(context, x, y + height - 1, width, 1, color2);
        RenderUtil.fill(context, x, y, 1, height, color2);
    }

    public static void drawLine(class_332 context, Vec2d from, Vec2d to, int color2) {
        RenderUtil.drawLine(context, new class_241((float)from.m, (float)from.n), new class_241((float)to.m, (float)to.n), color2, color2, 3.0f);
    }

    public static void drawLine(class_332 context, class_241 from, class_241 to, int colorFrom, int colorTo, float lineWidth) {
    }

    public static void fill(class_332 context, int x, int y, int width, int height, int color2) {
        context.method_25294(x, y, x + width, y + height, color2);
    }

    public static boolean checkOnFullScreen(ClientContext ctx, Vec2d v) {
        int w = ctx.client.method_22683().method_4489();
        int h = ctx.client.method_22683().method_4506();
        return v.m >= 0.0 && v.m <= (double)w && v.n >= 0.0 && v.n <= (double)h;
    }

    public static boolean checkAndLockOnScreen(ClientContext ctx, Vec2d v) {
        boolean onScreen = true;
        int mappedScreenWidth = (int)((double)ctx.client.method_22683().method_4489() * 1.0);
        int mappedScreenHeight = (int)((double)ctx.client.method_22683().method_4506() * 0.85);
        if (v.m < 100.0) {
            v.m = 100.0;
            onScreen = false;
        }
        if (v.m > (double)(mappedScreenWidth - 100)) {
            v.m = mappedScreenWidth - 100;
            onScreen = false;
        }
        if (v.n < 100.0) {
            v.n = 100.0;
            onScreen = false;
        }
        if (v.n > (double)(mappedScreenHeight - 100)) {
            v.n = mappedScreenHeight - 100;
            onScreen = false;
        }
        return onScreen;
    }

    public static int getVanillaShadowColor(int raw) {
        ModColor color2 = new ModColor(raw);
        int r = (int)((double)color2.getR() * 0.25);
        int g = (int)((double)color2.getG() * 0.25);
        int b = (int)((double)color2.getB() * 0.25);
        return new ModColor(r, g, b, color2.getA()).getValue();
    }

    public static void drawCenteredTextWithShadow(class_332 drawContext, class_2561 text, double centerX, double centerY, int color2, int shadowColor) {
        RenderUtil.drawCenteredText(drawContext, text, centerX + 1.0, centerY + 1.0, shadowColor);
        RenderUtil.drawCenteredText(drawContext, text, centerX, centerY, color2);
    }

    public static void drawCenteredTextWithShadow(class_332 drawContext, class_2561 text, double centerX, double centerY, int color2) {
        RenderUtil.drawCenteredTextWithShadow(drawContext, text, centerX, centerY, color2, RenderUtil.getVanillaShadowColor(color2));
    }

    public static void drawCenteredText(class_332 drawContext, class_2561 text, double centerX, double centerY, int color2) {
    }
}

