/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.hunger;

import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.UnruffledModClient;
import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.interfaces.ExtendedHungerManager;
import io.github.orlouge.unruffled.interfaces.HasFireImmunitySetting;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    private float attackExhaustion;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract void method_7322(float var1);

    @Shadow
    public abstract class_1702 method_7344();

    @Shadow
    public abstract float method_7261(float var1);

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void onAttackHead(class_1297 target, CallbackInfo ci) {
        this.attackExhaustion = 0.1f;
        class_1702 class_17022 = this.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager extendedHungerManager = (ExtendedHungerManager)class_17022;
            this.attackExhaustion = PlayerEntityMixin.getAttackExhaustion((class_1657)this);
            float stamina = this.method_37908().field_9236 ? UnruffledModClient.stamina : extendedHungerManager.getStamina();
            if (this.method_7261(0.5f) < 1.0f && stamina < this.attackExhaustion * extendedHungerManager.getStaminaDepletionRate()) {
                ci.cancel();
            }
        }
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;addExhaustion(F)V"))
    public void onAttackExhaustion(class_1657 instance, float exhaustion) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof class_3222) {
            ExtendedHungerManager extendedHungerManager;
            float stamina;
            class_3222 serverPlayer = (class_3222)playerEntityMixin;
            playerEntityMixin = this.method_7344();
            if (playerEntityMixin instanceof ExtendedHungerManager && (stamina = (extendedHungerManager = (ExtendedHungerManager)((Object)playerEntityMixin)).getStamina()) > 0.4f && stamina - this.attackExhaustion * extendedHungerManager.getStaminaDepletionRate() < 0.1f) {
                UnruffledMod.FAST_ATTACK_CRITERION.trigger(serverPlayer);
            }
        }
        instance.method_7322(this.attackExhaustion);
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttributeValue(Lnet/minecraft/registry/entry/RegistryEntry;)D", ordinal=1))
    public double increaseSweepingRatio(class_1657 playerEntity, class_6880<class_1320> registryEntry) {
        double normal = playerEntity.method_45325(registryEntry);
        int mouseSweepLevel = Math.min(3, (2 + (int)Math.abs(playerEntity.field_6241 - playerEntity.field_6259)) / 10);
        return Math.max(normal, (double)mouseSweepLevel / (double)(mouseSweepLevel + 1));
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"))
    public float onAttackCooldownPenalty(class_1657 instance, float baseTime) {
        return 1.0f;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;takeKnockback(DDD)V", ordinal=0), index=0)
    public double increaseKnockbackIfSprintJumping(double strength) {
        if (this.method_5624() && this.field_6017 <= 1.0f && !this.method_24828() && !this.method_6101() && !this.method_5799() && !this.method_5765()) {
            PlayerEntityMixin playerEntityMixin = this;
            if (playerEntityMixin instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)playerEntityMixin;
                UnruffledMod.KNOCKBACK_CRITERION.trigger(serverPlayer);
            }
            return strength + 0.5;
        }
        return strength;
    }

    private static float getAttackExhaustion(class_1657 player) {
        class_1702 class_17022 = player.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager extendedHungerManager = (ExtendedHungerManager)class_17022;
            return extendedHungerManager.getAttackExhaustion(player, player.method_7261(0.5f));
        }
        return 0.05f;
    }

    @Inject(method={"addExperience"}, at={@At(value="HEAD")})
    public void experienceToStamina(int experience, CallbackInfo ci) {
        class_1702 class_17022 = this.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager extendedHungerManager = (ExtendedHungerManager)class_17022;
            extendedHungerManager.addStamina((float)experience / 20.0f);
        }
    }

    @ModifyConstant(method={"updateTurtleHelmet"}, constant={@Constant(intValue=200)})
    public int increaseTurtleHelmetEffectTime(int time) {
        return time * 6;
    }

    @Redirect(method={"getBlockBreakingSpeed"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/EntityAttributeInstance;getValue()D"))
    public double waterBreathingIsAquaAffinity(class_1324 instance) {
        double normal = instance.method_6194();
        if (normal >= 1.0) {
            return normal;
        }
        if (class_1292.method_5574((class_1309)this)) {
            PlayerEntityMixin playerEntityMixin = this;
            if (playerEntityMixin instanceof class_3222) {
                class_3222 player = (class_3222)playerEntityMixin;
                UnruffledMod.AQUA_AFFINITY_CRITERION.trigger(player);
            }
            return Math.max(normal, 1.0);
        }
        return normal;
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    public void resetWearinessOnWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (skipSleepTimer || updateSleepingPlayers || !this.method_6113()) {
            return;
        }
        class_1702 class_17022 = this.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager extendedHungerManager = (ExtendedHungerManager)class_17022;
            extendedHungerManager.resetWeariness();
        }
    }

    @Inject(method={"damageShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;)V")})
    public void consumeStaminaOnShieldHit(float amount, CallbackInfo ci) {
        class_1702 class_17022 = this.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager extendedHungerManager = (ExtendedHungerManager)class_17022;
            extendedHungerManager.addStamina(Math.min(0.33f, -amount / 30.0f));
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setHealth(F)V")})
    public void addWearinessOnDamage(class_1282 source, float amount, CallbackInfo ci) {
        class_1702 class_17022 = this.method_7344();
        if (class_17022 instanceof ExtendedHungerManager) {
            ExtendedHungerManager extendedHungerManager = (ExtendedHungerManager)class_17022;
            extendedHungerManager.addWeariness(amount / 2000.0f);
        }
    }

    @ModifyConstant(method={"Lnet/minecraft/entity/player/PlayerEntity;dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, constant={@Constant(floatValue=0.5f, ordinal=0)})
    public float modifyDropSpread(float velocity) {
        return velocity * ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.dropSpreadFactor();
    }

    @ModifyVariable(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="STORE"))
    public class_1542 makeDeathDropsFireImmune(class_1542 drop, class_1799 stack, boolean throwRandomly, boolean retainOwnership) {
        if (throwRandomly && !retainOwnership && this.method_6059(class_1294.field_5918) && drop instanceof HasFireImmunitySetting) {
            HasFireImmunitySetting immuneDrop = (HasFireImmunitySetting)drop;
            immuneDrop.setFireImmune(true);
        }
        return drop;
    }
}

