/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.sleeping;

import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.interfaces.HasBackupSpawnPoints;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Shadow
    @Final
    private MinecraftServer field_14360;
    private class_3545<HasBackupSpawnPoints.SpawnPoint, Optional<class_243>> foundSpawnPoint = null;

    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;removePlayer(Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/entity/Entity$RemovalReason;)V", shift=At.Shift.AFTER)})
    public void findBackupSpawnIfNeeded(class_3222 player, boolean alive, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> cir) {
        HasBackupSpawnPoints.SpawnPoint originalPoint;
        this.foundSpawnPoint = null;
        if (!(player instanceof HasBackupSpawnPoints)) {
            return;
        }
        HasBackupSpawnPoints backupSpawnPoints = (HasBackupSpawnPoints)player;
        HasBackupSpawnPoints.SpawnPoint point = originalPoint = new HasBackupSpawnPoints.SpawnPoint(player.method_26280(), (class_5321<class_1937>)player.method_26281(), player.method_30631(), player.method_26282());
        while (point != null) {
            Optional respawnPos;
            class_3218 backupWorld = this.field_14360.method_3847(point.dimension());
            if (point.pos() != null && point.dimension() != null && backupWorld != null && (respawnPos = class_3222.method_60588((class_3218)backupWorld, (class_2338)point.pos(), (float)point.angle(), (boolean)point.forced(), (boolean)alive)).isPresent()) {
                this.foundSpawnPoint = new class_3545((Object)point, Optional.of(((class_3222.class_9773)respawnPos.get()).comp_2811));
                return;
            }
            backupSpawnPoints.deleteBackupSpawnPoint(point);
            point = backupSpawnPoints.getTopBackupSpawnPoint();
        }
        this.foundSpawnPoint = originalPoint.pos() == null ? null : new class_3545((Object)originalPoint, Optional.empty());
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getRespawnTarget(ZLnet/minecraft/world/TeleportTarget$PostDimensionTransition;)Lnet/minecraft/world/TeleportTarget;"))
    public class_5454 replaceTeleportPos(class_3222 instance, boolean alive, class_5454.class_9823 postDimensionTransition) {
        if (this.foundSpawnPoint == null) {
            return instance.method_60590(alive, postDimensionTransition);
        }
        return new class_5454(instance.field_13995.method_3847(((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).dimension()), ((Optional)this.foundSpawnPoint.method_15441()).orElse(class_243.method_24953((class_2382)((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).pos())), class_243.field_1353, ((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).angle(), 0.0f, postDimensionTransition);
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="RETURN")})
    public void clearSpawnPoint(class_3222 player, boolean alive, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> cir) {
        this.foundSpawnPoint = null;
        UnruffledMod.sendLockedDeathPosition(player);
    }

    @Inject(method={"sendPlayerStatus"}, at={@At(value="TAIL")})
    public void updateLockedDeathPosOnPlayerStatus(class_3222 player, CallbackInfo ci) {
        UnruffledMod.sendLockedDeathPosition(player);
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;sendStatusEffects(Lnet/minecraft/server/network/ServerPlayerEntity;)V")})
    public void updateLockedDeathPosOnConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        UnruffledMod.sendLockedDeathPosition(player);
    }
}

