/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.utils;

import io.github.orlouge.unruffled.config.Config;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;

public class PeacefulChunks
extends class_18 {
    public static final int PEACEFUL_RANGE = 7;
    private final Map<class_1923, Set<UUID>> chunkPlayerMap = new HashMap<class_1923, Set<UUID>>();
    private final Map<UUID, class_1923> playerCenterMap = new HashMap<UUID, class_1923>();
    private static final class_18.class_8645<PeacefulChunks> TYPE = new class_18.class_8645(PeacefulChunks::new, PeacefulChunks::new, null);

    public PeacefulChunks() {
    }

    public PeacefulChunks(class_2487 nbt, class_7225.class_7874 lookup) {
        class_1923 pos;
        for (class_2520 chunkElement : nbt.method_10554("chunks", 10)) {
            class_2487 chunkEntry = (class_2487)chunkElement;
            pos = new class_1923(chunkEntry.method_10550("x"), chunkEntry.method_10550("z"));
            HashSet<UUID> uuids = new HashSet<UUID>();
            for (class_2520 uuidElement : chunkEntry.method_10554("uuids", 11)) {
                uuids.add(class_2512.method_25930((class_2520)uuidElement));
            }
            this.chunkPlayerMap.put(pos, uuids);
        }
        for (class_2520 centerElement : nbt.method_10554("centers", 10)) {
            class_2487 centerEntry = (class_2487)centerElement;
            pos = new class_1923(centerEntry.method_10550("x"), centerEntry.method_10550("z"));
            this.playerCenterMap.put(centerEntry.method_25926("uuid"), pos);
        }
    }

    public void add(UUID uuid, class_1923 pos, int range) {
        class_1923 prevPos = this.playerCenterMap.get(uuid);
        if (prevPos != null) {
            if (prevPos.equals((Object)pos)) {
                return;
            }
            this.removeFromChunkMap(uuid, pos, range);
        }
        for (int x = pos.field_9181 - ++range; x <= pos.field_9181 + range; ++x) {
            for (int z = pos.field_9180 - range; z <= pos.field_9180 + range; ++z) {
                if ((x - pos.field_9181) * (x - pos.field_9181) + (z - pos.field_9180) * (z - pos.field_9180) > range * range) continue;
                this.chunkPlayerMap.computeIfAbsent(new class_1923(x, z), ignored -> new HashSet()).add(uuid);
            }
        }
        this.playerCenterMap.put(uuid, pos);
        this.method_80();
    }

    public void remove(UUID uuid, class_1923 pos, int range) {
        this.removeFromChunkMap(uuid, pos, range);
        class_1923 prevPos = this.playerCenterMap.get(uuid);
        if (prevPos != null && !prevPos.equals((Object)pos)) {
            this.removeFromChunkMap(uuid, prevPos, range);
        }
        this.playerCenterMap.remove(uuid);
        this.method_80();
    }

    public class_1923 getCenterPos(UUID uuid) {
        return this.playerCenterMap.get(uuid);
    }

    private void removeFromChunkMap(UUID uuid, class_1923 pos, int range) {
        for (int x = pos.field_9181 - ++range; x <= pos.field_9181 + range; ++x) {
            for (int z = pos.field_9180 - range; z <= pos.field_9180 + range; ++z) {
                if ((x - pos.field_9181) * (x - pos.field_9181) + (z - pos.field_9180) * (z - pos.field_9180) > range * range) continue;
                this.chunkPlayerMap.computeIfPresent(new class_1923(x, z), (ignored, set) -> {
                    set.remove(uuid);
                    return set;
                });
            }
        }
    }

    public boolean isPeaceful(class_1923 pos) {
        return ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.peacefulChunks() && !this.chunkPlayerMap.getOrDefault(pos, Collections.emptySet()).isEmpty();
    }

    public Set<UUID> peacefulChunkBedOwners(class_1923 pos) {
        return ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.peacefulChunks() ? this.chunkPlayerMap.getOrDefault(pos, Collections.emptySet()) : Collections.emptySet();
    }

    public static PeacefulChunks get(class_26 persistentStateManager) {
        return (PeacefulChunks)persistentStateManager.method_17924(TYPE, "unruffled_peaceful_chunks");
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2499 chunkList = new class_2499();
        for (Map.Entry<class_1923, Set<UUID>> entry : this.chunkPlayerMap.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            class_2487 chunkEntry = new class_2487();
            chunkEntry.method_10569("x", entry.getKey().field_9181);
            chunkEntry.method_10569("z", entry.getKey().field_9180);
            class_2499 uuidList = new class_2499();
            for (UUID uuid : entry.getValue()) {
                uuidList.add((Object)class_2512.method_25929((UUID)uuid));
            }
            chunkEntry.method_10566("uuids", (class_2520)uuidList);
            chunkList.add((Object)chunkEntry);
        }
        nbt.method_10566("chunks", (class_2520)chunkList);
        class_2499 centerList = new class_2499();
        for (Map.Entry<UUID, class_1923> entry : this.playerCenterMap.entrySet()) {
            class_2487 centerEntry = new class_2487();
            centerEntry.method_25927("uuid", entry.getKey());
            centerEntry.method_10569("x", entry.getValue().field_9181);
            centerEntry.method_10569("z", entry.getValue().field_9180);
            centerList.add((Object)centerEntry);
        }
        nbt.method_10566("centers", (class_2520)centerList);
        return nbt;
    }
}

