/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.interfaces.NearbyPlayersTracker;
import io.github.orlouge.unruffled.items.AncientCodexItem;
import io.github.orlouge.unruffled.items.CustomItems;
import io.github.orlouge.unruffled.items.ItemEnchantmentsHelper;
import io.github.orlouge.unruffled.utils.TradedCompasses;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3851;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7045;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Trades {
    private static final ConfiguredTrade[] WANDERING_TRADER_BUY = new ConfiguredTrade[]{Trades.buyItemForOneEmerald(class_1802.field_8477, 1, 128, 12), Trades.buyItem(class_1802.field_8477, 1, 3, 42, 12), Trades.buyItem(class_1802.field_8477, 1, 4, 32, 12), Trades.buyWithItemEnchantments(CustomItems.EVIL_TOTEM, 1, 64, 12, 12)};
    private static final ConfiguredTrade[] WANDERING_TRADER_CODEX = (ConfiguredTrade[])IntStream.rangeClosed(1, 50).mapToObj(number -> Trades.buyAncientCodex(number, 32, 12, 12)).toArray(ConfiguredTrade[]::new);
    private static final ConfiguredTrade[] WANDERING_TRADER_DECORATION = new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8260, 1, 16, 64, 1), Trades.sellItem(class_1802.field_37539, 1, 8, 64, 1), Trades.sellItem(class_1802.field_37540, 1, 8, 64, 1), Trades.sellItem(class_1802.field_37541, 1, 8, 64, 1), Trades.sellItem(class_1802.field_20402, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8434, 1, 8, 64, 1), Trades.sellItem(class_1802.field_27024, 1, 16, 64, 1)};
    private static final ConfiguredTrade[] WANDERING_TRADER_GLAZED_TERRACOTTA = new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8870, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8139, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8889, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8649, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8244, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8257, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8484, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8640, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8177, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8277, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8318, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8562, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8394, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8096, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8885, 1, 12, 64, 1), Trades.sellItem(class_1802.field_8172, 1, 12, 64, 1)};
    private static final ConfiguredTrade[] WANDERING_TRADER_ASSORTED = new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8209, 1, 12, 12, 1), Trades.sellItem(class_1802.field_8153, 1, 16, 12, 1), Trades.sellItem(class_1802.field_8711, 1, 4, 12, 1), Trades.sellItem(class_1802.field_27023, 1, 1, 12, 1), Trades.sellItem(class_1802.field_8815, 8, 1, 2, 1), Trades.sellItem(class_1802.field_8281, 1, 5, 12, 1), Trades.sellItem(class_1802.field_8535, 1, 8, 6, 1), Trades.sellItem(class_1802.field_27063, 1, 5, 12, 1), Trades.sellItem(class_1802.field_8614, 4, 1, 4, 1), Trades.sellItem(class_1802.field_38747, 16, 1, 1, 1), Trades.sellItem(class_1802.field_8449, 1, 1, 12, 1), Trades.sellWithItemEnchantments(CustomItems.SACRED_SWORD, 48, 1, 1, 12), Trades.sellItem(class_1802.field_23256, 24, 1, 1, 12, 0.2f)};
    private static final ConfiguredTrade[] WANDERING_TRADER_POTIONS = new ConfiguredTrade[]{Trades.sellWithPotion(class_1802.field_8436, class_1847.field_8980, 1, 1, 16, 1), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8980, 1, 3, 16, 1), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8986, 1, 3, 16, 1), Trades.sellWithPotion(class_1802.field_8574, UnruffledMod.TELEPORTATION_POTION, 24, 1, 12, 1), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8992, 2, 3, 16, 2), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_9003, 1, 3, 16, 1)};
    private static final Map<class_3852, List<ConfiguredTrade[]>> VILLAGER_TRADES = Map.ofEntries(Map.entry(class_3852.field_17052, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8743, 1, 1, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8660, 1, 1, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8523, 2, 1, 12, 2, 0.2f), Trades.sellItem(class_1802.field_8396, 2, 1, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8283, 1, 1, 12, 3, 0.2f), Trades.sellItem(class_1802.field_8313, 1, 1, 12, 3, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8873, 2, 1, 12, 4, 0.2f), Trades.sellItem(class_1802.field_8218, 2, 1, 12, 4, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8578, 2, 1, 12, 5, 0.2f), Trades.sellItem(class_1802.field_8560, 4, 1, 12, 5, 0.2f)})), Map.entry(class_3852.field_17053, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8153, 1, 24, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8726, 1, 16, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8046, 2, 16, 12, 2, 0.2f), Trades.sellItem(class_1802.field_8745, 1, 8, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8389, 1, 12, 12, 2, 0.2f), Trades.sellItem(class_1802.field_8606, 1, 16, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8504, 1, 8, 12, 3, 0.2f), Trades.sellItem(class_1802.field_8245, 1, 8, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8748, 1, 16, 12, 3, 0.2f), Trades.sellItem(class_1802.field_8073, 1, 8, 12, 4, 0.2f)})), Map.entry(class_3852.field_17054, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8251, 1, 4, 12, 1, 0.2f), Trades.buyAncientCodex(10, 64, 1, 10)}, new ConfiguredTrade[]{Trades.sellMap((class_6862<class_3195>)class_7045.field_37043, "filled_map.monument", class_20.class_21.field_98, 6, 12, 5), Trades.buyAncientCodex(20, 64, 1, 10)}, new ConfiguredTrade[]{Trades.sellMap((class_6862<class_3195>)class_7045.field_37042, "filled_map.mansion", class_20.class_21.field_88, 8, 12, 10), Trades.buyAncientCodex(30, 64, 1, 10)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_23256, 32, 1, 2, 10, 0.2f), Trades.buyAncientCodex(40, 64, 1, 10)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_38747, 16, 1, 12, 1, 0.2f), Trades.buyAncientCodex(50, 64, 1, 10)})), Map.entry(class_3852.field_17055, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8801, 1, 16, 12, 1, 0.2f), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8980, 1, 3, 12, 2)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8790, 4, 16, 12, 2, 0.2f), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8969, 1, 3, 12, 5)}, new ConfiguredTrade[]{Trades.sellWithPotion(class_1802.field_8574, class_1847.field_9003, 1, 3, 12, 10), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_9001, 1, 3, 12, 10)}, new ConfiguredTrade[]{Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8992, 2, 3, 12, 10), Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8981, 1, 3, 12, 10)}, new ConfiguredTrade[]{Trades.sellWithPotion(class_1802.field_8574, class_1847.field_8964, 1, 3, 12, 10), Trades.buyWithItemEnchantments(CustomItems.EVIL_TOTEM, 1, 32, 12, 10)})), Map.entry(class_3852.field_17056, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8317, 1, 24, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8861, 1, 16, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8567, 1, 16, 12, 2, 0.2f), Trades.sellItem(class_1802.field_17531, 1, 16, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8179, 1, 16, 12, 3, 0.2f), Trades.sellItem(class_1802.field_8324, 1, 8, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8186, 1, 8, 12, 4, 0.2f), Trades.sellItem(class_1802.field_8309, 1, 16, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8116, 1, 8, 12, 5, 0.2f), Trades.sellItem(class_1802.field_8803, 1, 8, 12, 5, 0.2f)})), Map.entry(class_3852.field_17057, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8429, 1, 8, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8794, 1, 8, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8209, 2, 12, 12, 2, 0.2f), Trades.sellItem(class_1802.field_8323, 2, 8, 12, 3, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8846, 2, 8, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8666, 1, 1, 12, 10, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8714, 1, 1, 12, 10, 0.2f), Trades.sellItem(class_1802.field_8108, 1, 1, 12, 10, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_28410, 2, 8, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8864, 1, 3, 12, 1, 0.2f)})), Map.entry(class_3852.field_17058, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8107, 1, 16, 12, 1, 0.2f), Trades.sellWithPotion(class_1802.field_8087, class_1847.field_8976, 1, 12, 12, 2)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8236, 1, 12, 12, 2, 0.2f), Trades.sellWithPotion(class_1802.field_8087, class_1847.field_8973, 1, 8, 12, 3)}, new ConfiguredTrade[]{Trades.sellItem(CustomItems.PIERCING_ARROW, 1, 12, 12, 3, 0.2f), Trades.sellWithPotion(class_1802.field_8087, class_1847.field_8970, 1, 12, 12, 3)}, new ConfiguredTrade[]{Trades.sellItem(CustomItems.IGNITING_ARROW, 1, 12, 12, 4, 0.2f), Trades.sellWithPotion(class_1802.field_8087, class_1847.field_8972, 1, 12, 12, 4)}, new ConfiguredTrade[]{Trades.sellWithPotion(class_1802.field_8087, class_1847.field_8977, 1, 8, 12, 5), Trades.sellWithPotion(class_1802.field_8087, class_1847.field_8980, 1, 12, 12, 5)})), Map.entry(class_3852.field_17059, List.of(new ConfiguredTrade[]{Trades.sellDyedArmor(class_1802.field_8267, 1, 12, 1), Trades.sellDyedArmor(class_1802.field_8370, 1, 12, 1)}, new ConfiguredTrade[]{Trades.sellDyedArmor(class_1802.field_8577, 1, 12, 2), Trades.sellDyedArmor(class_1802.field_8570, 1, 12, 2)}, new ConfiguredTrade[]{Trades.sellDyedArmor(class_1802.field_18138, 1, 12, 5), Trades.sellItem(class_1802.field_8175, 1, 1, 12, 3, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8143, 1, 32, 12, 2, 0.2f), Trades.sellItem(class_1802.field_28408, 1, 16, 12, 3, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_27023, 2, 1, 12, 5, 0.2f), Trades.buyItemForOneEmerald(class_1802.field_8614, 1, 12, 10)})), Map.entry(class_3852.field_17060, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8529, 1, 4, 12, 1), Trades.buyBiomeBasedAncientCodex(1, 64, 1, 10)}, new ConfiguredTrade[]{Trades.buyBiomeBasedAncientCodex(2, 64, 1, 30), Trades.buyBiomeBasedAncientCodex(3, 64, 1, 30)}, new ConfiguredTrade[]{Trades.buyBiomeBasedAncientCodex(4, 64, 1, 40), Trades.buyBiomeBasedAncientCodex(5, 64, 1, 40)}, new ConfiguredTrade[]{Trades.buyBiomeBasedAncientCodex(6, 64, 1, 50), Trades.buyBiomeBasedAncientCodex(7, 64, 1, 50)}, new ConfiguredTrade[]{Trades.buyBiomeBasedAncientCodex(8, 64, 1, 125), Trades.buyBiomeBasedAncientCodex(9, 64, 1, 125)})), Map.entry(class_3852.field_17061, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_20390, 1, 16, 12, 1, 0.2f), Trades.sellItem(class_1802.field_20395, 1, 16, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_20411, 1, 16, 12, 2, 0.2f), Trades.sellItem(class_1802.field_20403, 1, 16, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_20397, 1, 16, 12, 3, 0.2f), Trades.sellItem(class_1802.field_20385, 1, 16, 12, 3, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_28859, 1, 16, 12, 5, 0.2f), Trades.sellItem(class_1802.field_28871, 1, 16, 12, 5, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_23830, 1, 12, 16, 10, 0.2f), Trades.sellItem(class_1802.field_28860, 1, 16, 16, 5, 0.2f)})), Map.entry(class_3852.field_17063, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8276, 1, 16, 12, 1, 0.2f), Trades.sellItem(class_1802.field_19044, 1, 16, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_19056, 1, 16, 12, 2, 0.2f), Trades.sellItem(class_1802.field_19059, 1, 16, 12, 2, 0.2f), Trades.sellItem(class_1802.field_19051, 1, 16, 12, 2, 0.2f), Trades.sellItem(class_1802.field_19052, 1, 16, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_19058, 1, 12, 12, 3, 0.2f), Trades.sellItem(class_1802.field_19050, 1, 12, 12, 3, 0.2f), Trades.sellItem(class_1802.field_19054, 1, 12, 12, 3, 0.2f), Trades.sellItem(class_1802.field_19046, 1, 12, 12, 3, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_19055, 1, 12, 12, 4, 0.2f), Trades.sellItem(class_1802.field_19047, 1, 12, 12, 4, 0.2f), Trades.sellItem(class_1802.field_19053, 1, 12, 12, 4, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_19057, 1, 12, 12, 5, 0.2f), Trades.sellItem(class_1802.field_19049, 1, 12, 12, 5, 0.2f), Trades.sellItem(class_1802.field_19048, 1, 12, 12, 5, 0.2f), Trades.sellItem(class_1802.field_19045, 1, 12, 12, 5, 0.2f)})), Map.entry(class_3852.field_17064, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8403, 1, 1, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8699, 1, 1, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8475, 1, 1, 12, 2, 0.2f), Trades.sellItem(class_1802.field_8609, 1, 1, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellWithItemEnchantments(CustomItems.IRON_BOLSTER, 1, 1, 12, 2), Trades.sellItem(class_1802.field_8335, 2, 1, 12, 5, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8825, 2, 1, 12, 5, 0.2f), Trades.buyItemForOneEmerald(class_1802.field_8477, 1, 12, 10)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8782, 5, 1, 12, 10, 0.2f), Trades.sellItem(class_1802.field_8377, 16, 1, 12, 10, 0.2f)})), Map.entry(class_3852.field_17065, List.of(new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8528, 1, 1, 12, 1, 0.2f), Trades.sellItem(class_1802.field_8062, 1, 1, 12, 1, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8371, 1, 1, 12, 2, 0.2f), Trades.sellItem(class_1802.field_8475, 1, 1, 12, 2, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8845, 1, 1, 12, 4, 0.2f), Trades.sellItem(class_1802.field_8825, 2, 1, 12, 4, 0.2f)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8255, 1, 1, 12, 2, 0.2f), Trades.buyItemForOneEmerald(class_1802.field_8477, 1, 12, 10)}, new ConfiguredTrade[]{Trades.sellItem(class_1802.field_8802, 16, 1, 12, 10, 0.2f), Trades.sellItem(class_1802.field_8556, 16, 1, 12, 10, 0.2f)})));
    public static final TradesConfig DEFAULT_CONFIG = new TradesConfig(Optional.of(VILLAGER_TRADES.entrySet().stream().map(entry -> Map.entry((class_3852)entry.getKey(), new ConfiguredVillagerTrades(Optional.of(true), (ConfiguredVillagerPool[])((List)entry.getValue()).stream().map(pool -> new ConfiguredVillagerPool(2, (ConfiguredTrade[])pool)).toArray(ConfiguredVillagerPool[]::new)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), Optional.of(new ConfiguredWanderingTraderTrades(Optional.of(true), Optional.of(true), new ConfiguredWanderingTraderPool[]{new ConfiguredWanderingTraderPool(1, WANDERING_TRADER_BUY), new ConfiguredWanderingTraderPool(1, WANDERING_TRADER_GLAZED_TERRACOTTA), new ConfiguredWanderingTraderPool(2, WANDERING_TRADER_DECORATION), new ConfiguredWanderingTraderPool(5, WANDERING_TRADER_ASSORTED), new ConfiguredWanderingTraderPool(1, WANDERING_TRADER_POTIONS), new ConfiguredWanderingTraderPool(1, WANDERING_TRADER_CODEX), new ConfiguredWanderingTraderPool(1, new ConfiguredTrade[]{Trades.buyLodestoneCompass(0, 1, 1, 1)}), new ConfiguredWanderingTraderPool(1, new ConfiguredTrade[]{Trades.buyLodestoneCompass(1, 1, 1, 1)}), new ConfiguredWanderingTraderPool(1, new ConfiguredTrade[]{Trades.buyLodestoneCompass(2, 1, 1, 1)}), new ConfiguredWanderingTraderPool(1, new ConfiguredTrade[]{Trades.buyLodestoneCompass(3, 1, 1, 1)}), new ConfiguredWanderingTraderPool(1, new ConfiguredTrade[]{Trades.buyLodestoneCompass(4, 1, 1, 1)}), new ConfiguredWanderingTraderPool(1, new ConfiguredTrade[]{Trades.sellLodestoneCompass(3, 12, 10)})})));

    private static ConfiguredTrade sellItem(class_1792 item, int price, int count, int maxUses, int experience) {
        return Trades.sellItem(item, price, count, maxUses, experience, 0.05f);
    }

    private static ConfiguredTrade sellItem(class_1792 item, int price, int count, int maxUses, int experience, float multiplier) {
        return new ConfiguredTrade(Optional.of(item), false, price, count, maxUses, experience, multiplier, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade sellMap(class_6862<class_3195> structureTag, String nameKey, class_20.class_21 icon, int price, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.empty(), false, price, 1, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.of(structureTag), Optional.of(nameKey), Optional.of(icon), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade sellWithPotion(class_1792 item, class_1842 potion, int price, int count, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.of(item), false, price, count, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(potion), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade sellWithItemEnchantments(class_1792 item, int price, int count, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.of(item), false, price, count, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(true), Optional.empty());
    }

    private static ConfiguredTrade sellDyedArmor(class_1792 item, int price, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.of(item), false, price, 1, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(true), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade buyItemForOneEmerald(class_1792 item, int count, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.of(item), true, 1, count, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade buyItem(class_1792 item, int count, int payment, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.of(item), true, payment, count, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade buyWithItemEnchantments(class_1792 item, int count, int payment, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.of(item), true, payment, count, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(true), Optional.empty());
    }

    private static ConfiguredTrade buyAncientCodex(int number, int payment, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.empty(), true, payment, 1, maxUses, experience, 0.05f, Optional.of(number), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ConfiguredTrade buyBiomeBasedAncientCodex(int number, int payment, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.empty(), true, payment, 1, maxUses, experience, 0.05f, Optional.empty(), Optional.of(number), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static ConfiguredTrade buyLodestoneCompass(int index, int payment, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.empty(), true, payment, 1, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(index));
    }

    public static ConfiguredTrade sellLodestoneCompass(int payment, int maxUses, int experience) {
        return new ConfiguredTrade(Optional.empty(), false, payment, 1, maxUses, experience, 0.05f, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(0));
    }

    private static class_1799 process(class_1935 item, Function<class_1799, class_1799> processor) {
        class_1799 stack = new class_1799(item);
        stack.method_7980(new class_2487());
        stack = processor.apply(stack);
        return stack;
    }

    private static BiFunction<class_3854, class_1799, class_1799> setCodexBasedOnBiome(int add) {
        return (type, stack) -> {
            int base = 10;
            if (type == class_3854.field_17071) {
                base = 0;
            }
            if (type == class_3854.field_17074 || type == class_3854.field_17072) {
                base = 20;
            }
            if (type == class_3854.field_17075) {
                base = 30;
            }
            if (type == class_3854.field_17077) {
                base = 40;
            }
            return AncientCodexItem.setNumber(stack, base + add);
        };
    }

    public record ConfiguredTrade(Optional<class_1792> item, boolean buy, int payment, int count, int maxUses, int experience, float multiplier, Optional<Integer> codexNumber, Optional<Integer> biomeBasedCodexNumber, Optional<class_6862<class_3195>> mapStructureTag, Optional<String> mapNameKey, Optional<class_20.class_21> mapIcon, Optional<class_1842> potion, Optional<Boolean> randomDyed, Optional<Boolean> applyItemEnchantments, Optional<Integer> lodestoneCompass) {
        public static final Codec<ConfiguredTrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().optionalFieldOf("item").forGetter(ConfiguredTrade::item), (App)Codec.BOOL.optionalFieldOf("buy", (Object)false).forGetter(ConfiguredTrade::buy), (App)Codec.INT.optionalFieldOf("payment", (Object)1).forGetter(ConfiguredTrade::payment), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ConfiguredTrade::count), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(ConfiguredTrade::maxUses), (App)Codec.INT.optionalFieldOf("experience", (Object)1).forGetter(ConfiguredTrade::experience), (App)Codec.FLOAT.optionalFieldOf("multiplier", (Object)Float.valueOf(0.05f)).forGetter(ConfiguredTrade::multiplier), (App)Codec.INT.optionalFieldOf("codex_number").forGetter(ConfiguredTrade::codexNumber), (App)Codec.INT.optionalFieldOf("biome_based_codex_number").forGetter(ConfiguredTrade::biomeBasedCodexNumber), (App)class_2960.field_25139.optionalFieldOf("map_structure_tag").xmap(o -> o.map(identifier -> class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)identifier)), o -> o.map(class_6862::comp_327)).forGetter(ConfiguredTrade::mapStructureTag), (App)Codec.STRING.optionalFieldOf("map_name_key").forGetter(ConfiguredTrade::mapNameKey), (App)Codec.INT.optionalFieldOf("map_icon").xmap(o -> o.map(id -> class_20.class_21.method_99((byte)((byte)id.intValue()))), o -> o.map(icon -> icon.method_98())).forGetter(ConfiguredTrade::mapIcon), (App)class_7923.field_41179.method_39673().optionalFieldOf("potion").forGetter(ConfiguredTrade::potion), (App)Codec.BOOL.optionalFieldOf("random_dyed").forGetter(ConfiguredTrade::randomDyed), (App)Codec.BOOL.optionalFieldOf("apply_item_enchantments").forGetter(ConfiguredTrade::applyItemEnchantments), (App)Codec.INT.optionalFieldOf("lodestone_compass").forGetter(ConfiguredTrade::lodestoneCompass)).apply((Applicative)instance, ConfiguredTrade::new));

        public class_3853.class_1652 toFactory() {
            if (this.lodestoneCompass.isPresent()) {
                if (this.buy) {
                    return new BuyLodestoneCompassFactory(this.lodestoneCompass.get(), this.count, this.payment, this.maxUses, this.experience, this.multiplier);
                }
                return new SellLodestoneCompassFactory(this.payment, this.maxUses, this.experience, this.multiplier);
            }
            if (this.mapStructureTag.isPresent()) {
                return new class_3853.class_1654(this.payment, this.mapStructureTag.get(), this.mapNameKey.orElse(""), this.mapIcon.orElse(class_20.class_21.field_110), this.maxUses, this.experience);
            }
            if (this.randomDyed().orElse(false).booleanValue() && this.item.isPresent()) {
                return new class_3853.class_4160(this.item.get(), this.payment, this.maxUses, this.experience);
            }
            if (this.biomeBasedCodexNumber.isPresent()) {
                return new TypeAwareBuyNbtItemFactory((class_1935)CustomItems.ANCIENT_CODEX, Trades.setCodexBasedOnBiome(this.biomeBasedCodexNumber.get()), this.count, this.payment, this.maxUses, this.experience);
            }
            class_1792 tradeItem = null;
            Function<class_1799, class_1799> itemFunction = null;
            if (this.codexNumber.isPresent()) {
                tradeItem = CustomItems.ANCIENT_CODEX;
                itemFunction = stack -> AncientCodexItem.setNumber(stack, this.codexNumber.get());
            } else if (this.item.isPresent()) {
                tradeItem = this.item.get();
                if (this.potion.isPresent()) {
                    itemFunction = stack -> class_1844.method_8061((class_1799)stack, (class_1842)this.potion.get());
                } else if (this.applyItemEnchantments.orElse(false).booleanValue()) {
                    itemFunction = ItemEnchantmentsHelper::setItemEnchantments;
                }
            }
            if (tradeItem != null) {
                if (this.buy) {
                    if (itemFunction == null) {
                        if (this.payment == 1) {
                            return new class_3853.class_4161((class_1935)tradeItem, this.count, this.maxUses, this.experience);
                        }
                        return new BuyNbtItemFactory((class_1935)tradeItem, this.count, this.payment, this.maxUses, this.experience);
                    }
                    return new BuyNbtItemFactory((class_1935)tradeItem, itemFunction, this.count, this.payment, this.maxUses, this.experience);
                }
                if (itemFunction == null) {
                    return new class_3853.class_4165(tradeItem, this.payment, this.count, this.maxUses, this.experience);
                }
                return new SellNbtItemFactory((class_1935)tradeItem, itemFunction, this.payment, this.count, this.maxUses, this.experience);
            }
            return null;
        }
    }

    public record ConfiguredVillagerTrades(Optional<Boolean> enabled, ConfiguredVillagerPool[] pools) {
        public static final Codec<ConfiguredVillagerTrades> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace_with_pools").forGetter(ConfiguredVillagerTrades::enabled), (App)Codec.list(ConfiguredVillagerPool.CODEC).xmap(list -> (ConfiguredVillagerPool[])list.toArray(ConfiguredVillagerPool[]::new), array -> Arrays.stream(array).toList()).fieldOf("pools").forGetter(ConfiguredVillagerTrades::pools)).apply((Applicative)instance, ConfiguredVillagerTrades::new));
    }

    public record ConfiguredVillagerPool(int count, ConfiguredTrade[] trades) {
        public static final Codec<ConfiguredVillagerPool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ConfiguredVillagerPool::count), (App)Codec.list(ConfiguredTrade.CODEC).xmap(list -> (ConfiguredTrade[])list.toArray(ConfiguredTrade[]::new), array -> Arrays.stream(array).toList()).fieldOf("trades").forGetter(ConfiguredVillagerPool::trades)).apply((Applicative)instance, ConfiguredVillagerPool::new));
    }

    public record TradesConfig(Optional<Map<class_3852, ConfiguredVillagerTrades>> villagerTrades, Optional<ConfiguredWanderingTraderTrades> wanderingTraderTrades) {
        public static final Codec<TradesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_7923.field_41195.method_39673(), ConfiguredVillagerTrades.CODEC).optionalFieldOf("villagers").forGetter(TradesConfig::villagerTrades), (App)ConfiguredWanderingTraderTrades.CODEC.optionalFieldOf("wandering_trader").forGetter(TradesConfig::wanderingTraderTrades)).apply((Applicative)instance, TradesConfig::new));
    }

    public record ConfiguredWanderingTraderTrades(Optional<Boolean> enabled, Optional<Boolean> addVanilla, ConfiguredWanderingTraderPool[] pools) {
        public static final Codec<ConfiguredWanderingTraderTrades> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("add_extra_pools").forGetter(ConfiguredWanderingTraderTrades::enabled), (App)Codec.BOOL.optionalFieldOf("add_vanilla_trades").forGetter(ConfiguredWanderingTraderTrades::addVanilla), (App)Codec.list(ConfiguredWanderingTraderPool.CODEC).xmap(list -> (ConfiguredWanderingTraderPool[])list.toArray(ConfiguredWanderingTraderPool[]::new), array -> Arrays.stream(array).toList()).fieldOf("pools").forGetter(ConfiguredWanderingTraderTrades::pools)).apply((Applicative)instance, ConfiguredWanderingTraderTrades::new));
    }

    public record ConfiguredWanderingTraderPool(int count, ConfiguredTrade[] trades) {
        public static final Codec<ConfiguredWanderingTraderPool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("count", (Object)2).forGetter(ConfiguredWanderingTraderPool::count), (App)Codec.list(ConfiguredTrade.CODEC).xmap(list -> (ConfiguredTrade[])list.toArray(ConfiguredTrade[]::new), array -> Arrays.stream(array).toList()).fieldOf("trades").forGetter(ConfiguredWanderingTraderPool::trades)).apply((Applicative)instance, ConfiguredWanderingTraderPool::new));
    }

    public static class TypeAwareBuyNbtItemFactory
    implements class_3853.class_1652 {
        private final Map<class_3854, class_1799> buy;
        private final int count;
        private final int payment;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public TypeAwareBuyNbtItemFactory(class_1935 item, BiFunction<class_3854, class_1799, class_1799> processor, int count, int payment, int maxUses, int experience) {
            this(class_7923.field_41194.method_10220().map(type -> Map.entry(type, Trades.process(item, stack -> (class_1799)processor.apply((class_3854)type, (class_1799)stack)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), count, payment, maxUses, experience);
        }

        public TypeAwareBuyNbtItemFactory(Map<class_3854, class_1799> item, int count, int payment, int maxUses, int experience) {
            this.buy = item;
            this.count = count;
            this.payment = payment;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 buyStack;
            if (entity instanceof class_3851) {
                class_3851 villager = (class_3851)entity;
                buyStack = this.buy.get(villager.method_7231().method_16919()).method_7972();
            } else {
                buyStack = this.buy.values().stream().findFirst().get().method_7972();
            }
            buyStack.method_7939(this.count);
            return new class_1914(buyStack, new class_1799((class_1935)class_1802.field_8687, this.payment), this.maxUses, this.experience, this.multiplier);
        }
    }

    public static class BuyNbtItemFactory
    implements class_3853.class_1652 {
        private final class_1799 buy;
        private final int count;
        private final int payment;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public BuyNbtItemFactory(class_1935 item, Function<class_1799, class_1799> processor, int count, int payment, int maxUses, int experience) {
            this(Trades.process(item, processor), count, payment, maxUses, experience);
        }

        public BuyNbtItemFactory(class_1935 item, int count, int payment, int maxUses, int experience) {
            this(new class_1799(item), count, payment, maxUses, experience);
        }

        public BuyNbtItemFactory(class_1799 item, int count, int payment, int maxUses, int experience) {
            this.buy = item;
            this.count = count;
            this.payment = payment;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 buyStack = new class_1799((class_1935)this.buy.method_7909());
            buyStack.method_7980(this.buy.method_7969());
            buyStack.method_7939(this.count);
            return new class_1914(buyStack, new class_1799((class_1935)class_1802.field_8687, this.payment), this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellNbtItemFactory
    implements class_3853.class_1652 {
        private final class_1799 sell;
        private final int price;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellNbtItemFactory(class_1935 item, Function<class_1799, class_1799> processor, int price, int count, int maxUses, int experience) {
            this(Trades.process(item, processor), price, count, maxUses, experience, 0.05f);
        }

        public SellNbtItemFactory(class_1799 stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.sell = stack;
            this.price = price;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 sellStack = new class_1799((class_1935)this.sell.method_7909());
            sellStack.method_7980(this.sell.method_7969());
            sellStack.method_7939(this.count);
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price), sellStack, this.maxUses, this.experience, this.multiplier);
        }
    }

    static class BuyLodestoneCompassFactory
    implements class_3853.class_1652 {
        private final int index;
        private final int count;
        private final int payment;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public BuyLodestoneCompassFactory(int index, int count, int payment, int maxUses, int experience, float multiplier) {
            this.index = index;
            this.count = count;
            this.payment = payment;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1937 class_19372 = entity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                if (entity instanceof NearbyPlayersTracker) {
                    NearbyPlayersTracker nearbyPlayersTracker = (NearbyPlayersTracker)entity;
                    TradedCompasses compasses = TradedCompasses.get(world.method_17983());
                    class_1657 player = nearbyPlayersTracker.getNearbyPlayer(this.index);
                    if (player != null) {
                        for (int i = 0; i < 5; ++i) {
                            class_1799 compass = compasses.getBuy(world, player);
                            if (compass == null) continue;
                            compass = compass.method_7972();
                            compass.method_7939(this.count);
                            return new class_1914(compass, new class_1799((class_1935)class_1802.field_8687, this.payment), this.maxUses, this.experience, this.multiplier);
                        }
                    }
                }
            }
            return null;
        }
    }

    static class SellLodestoneCompassFactory
    implements class_3853.class_1652 {
        private final int price;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellLodestoneCompassFactory(int price, int maxUses, int experience, float multiplier) {
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1937 class_19372 = entity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                TradedCompasses compasses = TradedCompasses.get(world.method_17983());
                class_1799 compass = compasses.getRandomSell(5, world, random, entity.method_19538());
                if (compass == null) {
                    return null;
                }
                compass.method_7939(1);
                return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price), compass, this.maxUses, this.experience, this.multiplier);
            }
            return null;
        }
    }
}

