/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.items;

import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.items.CustomItems;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7871;

public class ItemEnchantmentsHelper {
    public static class_1799 createWithItemEnchantments(class_1792 item) {
        return ItemEnchantmentsHelper.setItemEnchantments(new class_1799((class_1935)item));
    }

    public static boolean hasItemEnchantments(class_1799 stack) {
        return ((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.itemEnchantments().containsKey(stack.method_7909());
    }

    public static class_1799 setItemEnchantments(class_1799 stack) {
        Map<class_1887, Integer> enchantments = ((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.itemEnchantments().get(stack.method_7909());
        boolean hide = true;
        if (stack.method_31574(CustomItems.EVIL_TOTEM) && ((Config)Config.INSTANCE.method_15332()).mechanicsConfig.evokerDropsEvilTotem()) {
            if (enchantments == null) {
                enchantments = new HashMap<class_1887, Integer>();
            }
            enchantments.put(class_1893.field_9113, 1);
            hide = false;
        }
        if (enchantments == null) {
            return stack;
        }
        for (Map.Entry<class_1887, Integer> entry : enchantments.entrySet()) {
            stack.method_7978(entry.getKey(), entry.getValue().intValue());
        }
        if (hide) {
            stack.method_30268(class_1799.class_5422.field_25768);
        }
        return stack;
    }

    public static boolean isDisabled(class_1887 enchantment, class_1799 stack) {
        return Config.isLoaded() && ((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.disabledEnchantments().contains(enchantment) && !((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.itemEnchantments().getOrDefault(stack.method_7909(), Collections.emptyMap()).containsKey(enchantment);
    }

    private static boolean isUnselectable(class_1887 enchantment, class_1799 stack) {
        return Config.isLoaded() && ((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.unobtainableEnchantments().contains(enchantment);
    }

    public static class_1799 processItem(class_1799 stack, class_7871.class_7872 lookup, boolean allowNonRandomLootEnchantments) {
        boolean hasStoredEnchantments;
        stack = stack.method_7972();
        boolean hasEnchantments = stack.method_7942();
        boolean bl = hasStoredEnchantments = stack.method_7985() && stack.method_7948().method_10545("StoredEnchantments");
        while (hasEnchantments || hasStoredEnchantments) {
            Map enchantments = class_1890.method_8222((class_1799)stack);
            LinkedHashMap<class_1887, Integer> out = new LinkedHashMap<class_1887, Integer>();
            for (Map.Entry entry : enchantments.entrySet()) {
                if (ItemEnchantmentsHelper.isDisabled((class_1887)entry.getKey(), stack) || !allowNonRandomLootEnchantments && ItemEnchantmentsHelper.isUnselectable((class_1887)entry.getKey(), stack)) continue;
                out.put((class_1887)entry.getKey(), (Integer)entry.getValue());
            }
            class_1890.method_8214((Map)enchantments, (class_1799)stack);
            if (hasEnchantments) {
                hasEnchantments = false;
                continue;
            }
            hasStoredEnchantments = false;
        }
        if (stack.method_31574(class_1802.field_8598) && class_1890.method_8222((class_1799)stack).isEmpty()) {
            stack = new class_1799((class_1935)class_1802.field_8529, stack.method_7947());
        }
        if (stack.method_7985() && stack.method_7948().method_10545("Items")) {
            class_2499 itemList = stack.method_7948().method_10554("Items", 10);
            class_2499 outList = new class_2499();
            for (class_2520 el : itemList) {
                if (el.method_10711() != 10) continue;
                class_1799 itemStack = class_1799.method_7915((class_2487)((class_2487)el));
                class_2487 out = new class_2487();
                ItemEnchantmentsHelper.processItem(itemStack.method_7972(), lookup, allowNonRandomLootEnchantments).method_7953(out);
                outList.add((Object)out);
            }
            stack.method_7948().method_10566("Items", (class_2520)outList);
        }
        return stack;
    }
}

