/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.enchanting;

import io.github.orlouge.unruffled.config.Config;
import io.github.orlouge.unruffled.items.ItemEnchantmentsHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1903;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public class EnchantmentHelperMixin {
    @ModifyVariable(method={"set"}, at=@At(value="LOAD"), argsOnly=true)
    private static Map<class_1887, Integer> removeDisabledEnchantments(Map<class_1887, Integer> enchantments, Map<class_1887, Integer> enchantments2, class_1799 stack) {
        LinkedHashMap<class_1887, Integer> newEnchantments = new LinkedHashMap<class_1887, Integer>();
        for (Map.Entry<class_1887, Integer> entry : enchantments.entrySet()) {
            if (ItemEnchantmentsHelper.isDisabled(entry.getKey(), stack)) continue;
            newEnchantments.put(entry.getKey(), entry.getValue());
        }
        return newEnchantments;
    }

    @Inject(method={"getLure"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setLureIfDisabled(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.disabledEnchantments().contains(class_1893.field_9100)) {
            if (class_1893.field_9100.method_8192(stack)) {
                cir.setReturnValue((Object)3);
            }
            cir.cancel();
        }
    }

    @Inject(method={"getSweepingMultiplier"}, at={@At(value="RETURN")}, cancellable=true)
    private static void sweepingEdgeIfMovingHead(class_1309 entity, CallbackInfoReturnable<Float> cir) {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            float originalMultiplier = cir.getReturnValueF();
            float newMultiplier = class_1903.method_8241((int)Math.min(3, (2 + (int)Math.abs(playerEntity.field_6241 - playerEntity.field_6259)) / 10));
            cir.setReturnValue((Object)Float.valueOf(Math.max(originalMultiplier, newMultiplier)));
        }
    }

    @ModifyVariable(method={"getProtectionAmount"}, at=@At(value="STORE"))
    private static MutableInt replaceProtectionEnchantments(MutableInt protection, Iterable<class_1799> equipment, class_1282 source) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!source.method_48789(class_8103.field_42246)) break block9;
                        if (!((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.disabledEnchantments().contains(class_1893.field_9095)) break block10;
                        for (class_1799 item : equipment) {
                            class_1792 class_17922 = item.method_7909();
                            if (!(class_17922 instanceof class_1738)) continue;
                            class_1738 armor = (class_1738)class_17922;
                            if (armor.method_7686() == class_1740.field_7889) {
                                protection.add(4);
                                continue;
                            }
                            if (armor.method_7686() != class_1740.field_21977) continue;
                            protection.add(8);
                        }
                        break block10;
                    }
                    if (!source.method_48789(class_8103.field_42249)) break block11;
                    if (!((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.disabledEnchantments().contains(class_1893.field_9107)) break block10;
                    for (class_1799 item : equipment) {
                        class_1792 class_17923 = item.method_7909();
                        if (!(class_17923 instanceof class_1738)) continue;
                        class_1738 armor = (class_1738)class_17923;
                        if (armor.method_7686() == class_1740.field_7889) {
                            protection.add(4);
                            continue;
                        }
                        if (armor.method_7686() != class_1740.field_21977) continue;
                        protection.add(6);
                    }
                    break block10;
                }
                if (!source.method_48789(class_8103.field_42250)) break block12;
                if (!((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.disabledEnchantments().contains(class_1893.field_9129)) break block10;
                for (class_1799 item : equipment) {
                    class_1738 armor;
                    class_1792 class_17924 = item.method_7909();
                    if (!(class_17924 instanceof class_1738) || (armor = (class_1738)class_17924).method_7685() != class_1304.field_6166) continue;
                    if (armor.method_7686() == class_1740.field_7897) {
                        protection.add(16);
                        continue;
                    }
                    protection.add(10);
                }
                break block10;
            }
            if (!source.method_48789(class_8103.field_42242) && ((Config)Config.INSTANCE.method_15332()).enchantmentsConfig.disabledEnchantments().contains(class_1893.field_9111)) {
                for (class_1799 item : equipment) {
                    class_1738 armor;
                    class_1792 class_17925;
                    if (!item.method_7909().method_7846() || !item.method_7909().method_7846()) continue;
                    if (source.method_49708(class_8111.field_42350) && (class_17925 = item.method_7909()) instanceof class_1738 && (armor = (class_1738)class_17925).method_7686() == class_1740.field_21977) {
                        protection.add(6);
                        continue;
                    }
                    protection.add(2);
                }
            }
        }
        return protection;
    }
}

