/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.sleeping;

import io.github.orlouge.unruffled.UnruffledMod;
import io.github.orlouge.unruffled.interfaces.HasBackupSpawnPoints;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Shadow
    @Final
    private MinecraftServer field_14360;
    private class_3545<HasBackupSpawnPoints.SpawnPoint, Optional<class_243>> foundSpawnPoint = null;

    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;removePlayer(Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/entity/Entity$RemovalReason;)V", shift=At.Shift.AFTER)})
    public void findBackupSpawnIfNeeded(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir) {
        HasBackupSpawnPoints.SpawnPoint originalPoint;
        this.foundSpawnPoint = null;
        if (!(player instanceof HasBackupSpawnPoints)) {
            return;
        }
        HasBackupSpawnPoints backupSpawnPoints = (HasBackupSpawnPoints)player;
        HasBackupSpawnPoints.SpawnPoint point = originalPoint = new HasBackupSpawnPoints.SpawnPoint(player.method_26280(), (class_5321<class_1937>)player.method_26281(), player.method_30631(), player.method_26282());
        while (point != null) {
            Optional respawnPos;
            class_3218 backupWorld = this.field_14360.method_3847(point.dimension());
            if (point.pos() != null && point.dimension() != null && backupWorld != null && (respawnPos = class_1657.method_26091((class_3218)backupWorld, (class_2338)point.pos(), (float)point.angle(), (boolean)point.forced(), (boolean)alive)).isPresent()) {
                this.foundSpawnPoint = new class_3545((Object)point, (Object)respawnPos);
                return;
            }
            backupSpawnPoints.deleteBackupSpawnPoint(point);
            point = backupSpawnPoints.getTopBackupSpawnPoint();
        }
        this.foundSpawnPoint = new class_3545((Object)originalPoint, Optional.empty());
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getSpawnPointPosition()Lnet/minecraft/util/math/BlockPos;"))
    public class_2338 replaceSpawnPointPos(class_3222 instance) {
        return this.foundSpawnPoint != null ? ((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).pos() : instance.method_26280();
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getSpawnPointDimension()Lnet/minecraft/registry/RegistryKey;"))
    public class_5321<class_1937> replaceSpawnPointDimension(class_3222 instance) {
        return this.foundSpawnPoint != null ? ((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).dimension() : instance.method_26281();
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getSpawnAngle()F"))
    public float replaceSpawnAngle(class_3222 instance) {
        return this.foundSpawnPoint != null ? ((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).angle() : instance.method_30631();
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;isSpawnForced()Z"))
    public boolean replaceSpawnForced(class_3222 instance) {
        return this.foundSpawnPoint != null ? ((HasBackupSpawnPoints.SpawnPoint)this.foundSpawnPoint.method_15442()).forced() : instance.method_26282();
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="RETURN")})
    public void clearSpawnPoint(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir) {
        this.foundSpawnPoint = null;
        UnruffledMod.sendLockedDeathPosition(player);
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;findRespawnPosition(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;FZZ)Ljava/util/Optional;"))
    public Optional<class_243> findSpawnOrBackupSpawn(class_3218 world, class_2338 pos, float angle, boolean forced, boolean alive, class_3222 player, boolean alive2) {
        return this.foundSpawnPoint != null ? (Optional)this.foundSpawnPoint.method_15441() : class_1657.method_26091((class_3218)world, (class_2338)pos, (float)angle, (boolean)forced, (boolean)alive);
    }

    @Inject(method={"sendPlayerStatus"}, at={@At(value="TAIL")})
    public void updateLockedDeathPosOnPlayerStatus(class_3222 player, CallbackInfo ci) {
        UnruffledMod.sendLockedDeathPosition(player);
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getResourcePackProperties()Ljava/util/Optional;")})
    public void updateLockedDeathPosOnConnect(class_2535 connection, class_3222 player, CallbackInfo ci) {
        UnruffledMod.sendLockedDeathPosition(player);
    }
}

