/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.mixin.worldgen;

import io.github.orlouge.unruffled.interfaces.StructurePlacementWithSpreadFactor;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_6872.class})
public abstract class RandomSpreadStructurePlacementMixin
extends class_6874
implements StructurePlacementWithSpreadFactor {
    @Shadow
    @Final
    private int field_37772;
    @Shadow
    @Final
    private int field_37773;
    @Shadow
    @Final
    private class_6873 field_37774;
    protected float spreadFactor = -1.0f;
    protected float correctionFactor = -1.0f;

    protected RandomSpreadStructurePlacementMixin(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, float frequency, int salt, Optional<class_6874.class_7152> exclusionZone) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone);
    }

    @Override
    public void setSpreadFactor(float spreadFactor, float correctionFactor) {
        this.spreadFactor = spreadFactor;
        this.correctionFactor = correctionFactor;
    }

    @Inject(method={"getStartChunk"}, at={@At(value="HEAD")}, cancellable=true)
    public void applySpreadFactor(long seed, int chunkX, int chunkZ, CallbackInfoReturnable<class_1923> cir) {
        if (this.spreadFactor > 0.0f && this.field_37773 > 0) {
            float rarity = this.field_37772 + this.field_37773 * 2;
            float correctedSpreadFactor = Math.max(1.0f, this.spreadFactor / (1.0f + rarity / this.correctionFactor));
            int spacing = (int)((float)this.field_37772 * correctedSpreadFactor);
            int separation = (int)((float)this.field_37773 * correctedSpreadFactor);
            int i = Math.floorDiv(chunkX, spacing);
            int j = Math.floorDiv(chunkZ, spacing);
            class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
            chunkRandom.method_12665(seed, i, j, this.method_41645());
            int k = spacing - separation;
            int l = this.field_37774.method_40173((class_5819)chunkRandom, k);
            int m = this.field_37774.method_40173((class_5819)chunkRandom, k);
            cir.setReturnValue((Object)new class_1923(i * spacing + l, j * spacing + m));
            cir.cancel();
        }
    }
}

