/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.orlouge.unruffled.interfaces.HasAttachedLodestone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7477;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;

public class TradedCompasses
extends class_18 {
    public final Map<UUID, LinkedHashMap<class_4208, class_1799>> availableForBuy = new HashMap<UUID, LinkedHashMap<class_4208, class_1799>>();
    public final Map<UUID, List<Compass>> availableForSell = new HashMap<UUID, List<Compass>>();
    public final Map<class_2561, Integer> usedNames = new HashMap<class_2561, Integer>();
    public final Map<class_2561, Integer> usedLores = new HashMap<class_2561, Integer>();
    private final Map<class_4208, Lodestone> lodestoneStatus = new HashMap<class_4208, Lodestone>();
    public static final int MAX_BUY_PER_PLAYER = 10;
    public static final int MAX_SELL_PER_PLAYER = 30;

    public TradedCompasses() {
    }

    public static TradedCompasses get(class_26 persistentStateManager) {
        return (TradedCompasses)persistentStateManager.method_17924(TradedCompasses::new, TradedCompasses::new, "unruffled_traded_compasses");
    }

    public void addBuy(class_1657 player, class_1799 compass) {
        compass = compass.method_7972();
        compass.method_7939(1);
        LinkedHashMap buy = this.availableForBuy.computeIfAbsent(player.method_5667(), k -> new LinkedHashMap());
        Optional<Compass> compassData = TradedCompasses.getCompass(compass);
        if (compassData.isEmpty()) {
            return;
        }
        class_4208 pos = class_4208.method_19443(compassData.get().dimension, (class_2338)compassData.get().lodestonePos());
        Lodestone status = this.lodestoneStatus.get(pos);
        if (status != null && status.sellTrades > 0 && !buy.containsKey(pos)) {
            return;
        }
        buy.remove(pos);
        while (buy.size() >= 10) {
            buy.remove(buy.keySet().iterator().next());
        }
        buy.put(pos, compass);
        this.method_80();
    }

    public void addSell(class_1799 compassStack, class_1657 customer, List<? extends class_1657> possibleSellers) {
        if (customer == null) {
            return;
        }
        Optional<Compass> soldCompass = TradedCompasses.getCompass(compassStack);
        if (soldCompass.isPresent()) {
            class_4208 pos = class_4208.method_19443(soldCompass.get().dimension, (class_2338)soldCompass.get().lodestonePos);
            Lodestone lodestone = this.lodestoneStatus.get(pos);
            Compass compass = soldCompass.get().lore.isPresent() && lodestone.name().equals(soldCompass.get().lore()) ? new Compass(soldCompass.get().name, Optional.empty(), soldCompass.get().lodestonePos, soldCompass.get().dimension) : soldCompass.get();
            Set<UUID> keys = possibleSellers == null ? this.availableForBuy.keySet() : Stream.concat(Stream.of(customer), possibleSellers.stream()).map(class_1297::method_5667).toList();
            for (UUID uuid : keys) {
                LinkedHashMap buy = this.availableForBuy.getOrDefault(uuid, new LinkedHashMap());
                if (buy.isEmpty()) continue;
                buy.remove(pos);
            }
            List sell = this.availableForSell.computeIfAbsent(customer.method_5667(), k -> new LinkedList());
            while (sell.size() >= 30) {
                Compass removedCompass = (Compass)sell.remove(0);
                class_4208 removedCompassPos = class_4208.method_19443(removedCompass.dimension, (class_2338)removedCompass.lodestonePos);
                Lodestone removedCompassLodestone = this.lodestoneStatus.get(removedCompassPos);
                if (removedCompassLodestone == null) continue;
                this.lodestoneStatus.put(removedCompassPos, new Lodestone(removedCompassLodestone.name, removedCompassLodestone.sellTrades - 1, removedCompassLodestone.displayEntityUUID));
            }
            sell.add(compass);
            this.lodestoneStatus.put(pos, lodestone == null ? new Lodestone(Optional.empty(), 1, Optional.empty()) : new Lodestone(lodestone.name, lodestone.sellTrades + 1, lodestone.displayEntityUUID));
            compass.name.ifPresent(text -> this.usedNames.merge((class_2561)text, 1, (k, v) -> v + 1));
            compass.lore.ifPresent(text -> this.usedLores.merge((class_2561)text, 1, (k, v) -> v + 1));
            this.method_80();
        }
    }

    public class_1799 getBuy(class_3218 world, class_1657 player) {
        LinkedHashMap buyMap = this.availableForBuy.getOrDefault(player.method_5667(), new LinkedHashMap());
        List buy = buyMap.entrySet().stream().toList();
        for (int attempts = 0; !buy.isEmpty() && attempts < buy.size(); ++attempts) {
            Map.Entry entry = (Map.Entry)buy.get(buy.size() - 1 - attempts);
            class_1799 stack = (class_1799)entry.getValue();
            Optional<Compass> topCompass = TradedCompasses.getCompass(stack);
            if (topCompass.isPresent() && topCompass.get().isValid(world.method_8503())) {
                List sell = this.availableForSell.getOrDefault(player.method_5667(), Collections.emptyList());
                for (Compass soldCompass : sell) {
                    if (!soldCompass.isClone(topCompass.get())) continue;
                    stack = null;
                    break;
                }
                if (stack != null) {
                    return stack;
                }
            }
            buyMap.remove(entry.getKey());
            this.method_80();
        }
        return null;
    }

    public class_1799 getRandomSell(int attempts, class_3218 world, class_5819 random, class_243 posToAvoid) {
        ArrayList<UUID> players = new ArrayList<UUID>(this.availableForSell.keySet());
        int maxAttempts = attempts;
        for (int i = 0; i < maxAttempts; ++i) {
            Optional profile;
            Compass compass;
            if (players.isEmpty()) {
                return null;
            }
            int index = players.size() == 1 ? 0 : random.method_43051(0, players.size());
            UUID uuid = (UUID)players.get(index);
            List sell = this.availableForSell.getOrDefault(uuid, Collections.emptyList());
            if (sell.isEmpty()) {
                players.remove(index);
                if (i >= 100) continue;
                ++maxAttempts;
                continue;
            }
            if (sell.size() == 1) {
                compass = (Compass)sell.get(0);
            } else {
                sell = new ArrayList(sell);
                Compass last = (Compass)sell.get(sell.size() - 1);
                for (int j = 0; j < sell.size() / 4; ++j) {
                    sell.add(last);
                }
                compass = (Compass)sell.get(random.method_43051(0, sell.size()));
            }
            if (i < maxAttempts - 2 && posToAvoid.method_1022(compass.lodestonePos.method_46558()) * 0.003 + (double)random.method_43057() < 1.0) {
                if (i >= attempts) continue;
                ++maxAttempts;
                continue;
            }
            if (!compass.isValid(world.method_8503())) {
                this.invalidateCompass(uuid, compass);
                continue;
            }
            class_1792 j = class_1802.field_8251;
            if (!(j instanceof class_1759)) continue;
            class_1759 compassItem = (class_1759)j;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8251);
            class_2487 nbt = stack.method_7948();
            compassItem.method_27315(compass.dimension, compass.lodestonePos, nbt);
            class_4208 pos = class_4208.method_19443(compass.dimension, (class_2338)compass.lodestonePos);
            class_2561 name = null;
            ArrayList<Object> lore = null;
            boolean duplicateName = true;
            boolean duplicateLore = true;
            if (compass.name.isPresent()) {
                name = compass.name.get();
                duplicateName = this.usedNames.getOrDefault(name, 0) > 1;
            }
            class_2561 compassLore = null;
            if (compass.lore.isPresent()) {
                compassLore = compass.lore.get();
            } else {
                Lodestone lodestone = this.lodestoneStatus.get(pos);
                if (lodestone != null && lodestone.name.isPresent()) {
                    compassLore = lodestone.name.get();
                }
            }
            if (compassLore != null) {
                lore = new ArrayList<class_2561>(List.of(compassLore));
                boolean bl = duplicateLore = this.usedLores.getOrDefault(compassLore, 0) > 1;
            }
            if (duplicateName && duplicateLore && (profile = Optional.ofNullable(world.method_8503().method_3793()).flatMap(cache -> cache.method_14512(uuid))).isPresent()) {
                if (lore == null) {
                    lore = new ArrayList();
                }
                lore.addAll(class_2561.method_30163((String)String.format("%s / %04d", ((GameProfile)profile.get()).getName(), Math.abs(pos.hashCode()) % 10000)).method_36136(class_2583.field_24360.method_10977(class_124.field_1080)));
            }
            if (lore != null) {
                class_2487 displayNbt = new class_2487();
                class_2499 loreNbt = new class_2499();
                lore.forEach(t -> loreNbt.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)t))));
                displayNbt.method_10566("Lore", (class_2520)loreNbt);
                stack.method_7959("display", (class_2520)displayNbt);
            }
            if (name != null) {
                stack.method_7977(name);
            }
            return stack;
        }
        return null;
    }

    private void invalidateCompass(UUID uuid, Compass compass) {
        List sell = this.availableForSell.getOrDefault(uuid, Collections.emptyList());
        class_4208 pos = class_4208.method_19443(compass.dimension, (class_2338)compass.lodestonePos);
        Lodestone lodestoneStatus = this.lodestoneStatus.get(pos);
        if (lodestoneStatus != null) {
            this.lodestoneStatus.put(pos, new Lodestone(lodestoneStatus.name, lodestoneStatus.sellTrades - 1, lodestoneStatus.displayEntityUUID));
        }
        if ((sell = new ArrayList<Compass>(sell.stream().filter(other -> !other.isClone(compass)).toList())).isEmpty()) {
            this.availableForSell.remove(uuid);
        } else {
            this.availableForSell.put(uuid, sell);
        }
        if (compass.name.isPresent()) {
            class_2561 name = compass.name.get();
            Integer used = this.usedNames.getOrDefault(name, 0);
            if (used > 1) {
                this.usedNames.put(name, used - 1);
            } else if (used == 1) {
                this.usedNames.remove(name);
            }
        }
        this.method_80();
    }

    public void storeLodestoneName(class_4208 blockPos, class_2561 name, class_3218 world) {
        int sellTrades = 0;
        Lodestone oldStatus = this.lodestoneStatus.get(blockPos);
        if (oldStatus != null) {
            sellTrades = oldStatus.sellTrades;
            if (oldStatus.name.isPresent()) {
                Integer used = this.usedLores.getOrDefault(oldStatus.name.get(), 0);
                if (used > 1) {
                    this.usedLores.put(oldStatus.name.get(), used - 1);
                } else if (used == 1) {
                    this.usedLores.remove(oldStatus.name.get());
                }
            }
            oldStatus.displayEntityUUID.flatMap(uuid -> Optional.ofNullable(world.method_14190(uuid))).ifPresent(class_1297::method_31472);
        }
        Optional<UUID> displayUuid = Optional.empty();
        if (name != null) {
            this.usedLores.compute(name, (k, cnt) -> cnt == null ? 1 : cnt + 1);
            class_8113.class_8123 display = (class_8113.class_8123)class_1299.field_42457.method_5883((class_1937)world);
            if (display instanceof HasAttachedLodestone) {
                HasAttachedLodestone attachedLodestone = (HasAttachedLodestone)display;
                attachedLodestone.setAttachedLodestone(blockPos.method_19446(), name);
                world.method_8649((class_1297)display);
                displayUuid = Optional.of(display.method_5667());
            }
        }
        this.lodestoneStatus.put(blockPos, new Lodestone(Optional.ofNullable(name), sellTrades, displayUuid));
        this.method_80();
    }

    public void deleteLodestoneName(class_4208 blockPos, class_3218 world) {
        this.storeLodestoneName(blockPos, null, world);
        this.method_80();
    }

    public class_2561 getLodestoneName(class_4208 blockPos) {
        return Optional.ofNullable(this.lodestoneStatus.get(blockPos)).flatMap(Lodestone::name).orElse(null);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 buyList = new class_2499();
        for (Map.Entry<UUID, LinkedHashMap<class_4208, class_1799>> entry : this.availableForBuy.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            class_2487 class_24872 = new class_2487();
            class_24872.method_25927("uuid", (UUID)entry.getKey());
            class_2499 class_24992 = new class_2499();
            for (Map.Entry entry2 : ((LinkedHashMap)entry.getValue()).entrySet()) {
                class_24992.add((Object)((class_1799)entry2.getValue()).method_7969());
            }
            class_24872.method_10566("compasses", (class_2520)class_24992);
            buyList.add((Object)class_24872);
        }
        nbt.method_10566("buy", (class_2520)buyList);
        class_2499 sellList = new class_2499();
        for (Map.Entry entry : this.availableForSell.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            class_2487 class_24873 = new class_2487();
            class_24873.method_25927("uuid", (UUID)entry.getKey());
            class_2499 class_24993 = new class_2499();
            for (Compass compass : (List)entry.getValue()) {
                class_2487 compassNbt = compass.toNbt();
                if (compassNbt == null) continue;
                class_24993.add((Object)compassNbt);
            }
            class_24873.method_10566("compasses", (class_2520)class_24993);
            sellList.add((Object)class_24873);
        }
        nbt.method_10566("sell", (class_2520)sellList);
        class_2499 nameList = new class_2499();
        for (Map.Entry<class_2561, Integer> entry : this.usedNames.entrySet()) {
            if (entry.getValue() == 0) continue;
            class_2487 class_24874 = new class_2487();
            class_24874.method_10582("name", class_2561.class_2562.method_10867((class_2561)entry.getKey()));
            class_24874.method_10569("count", entry.getValue().intValue());
            nameList.add((Object)class_24874);
        }
        nbt.method_10566("names", (class_2520)nameList);
        class_2499 class_24994 = new class_2499();
        for (Map.Entry<class_2561, Integer> entry : this.usedLores.entrySet()) {
            if (entry.getValue() == 0) continue;
            class_2487 class_24875 = new class_2487();
            class_24875.method_10582("lore", class_2561.class_2562.method_10867((class_2561)entry.getKey()));
            class_24875.method_10569("count", entry.getValue().intValue());
            class_24994.add((Object)class_24875);
        }
        nbt.method_10566("lores", (class_2520)class_24994);
        class_2499 class_24995 = new class_2499();
        for (Map.Entry<class_4208, Lodestone> entry : this.lodestoneStatus.entrySet()) {
            if (entry.getValue() == null) continue;
            class_2487 lodestoneEntry = new class_2487();
            lodestoneEntry.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)entry.getKey().method_19446()));
            lodestoneEntry.method_10566("dimension", (class_2520)class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, (Object)entry.getKey().method_19442()).result().get());
            lodestoneEntry.method_10566("status", (class_2520)entry.getValue().toNbt());
            class_24995.add((Object)lodestoneEntry);
        }
        nbt.method_10566("lodestones", (class_2520)class_24995);
        return nbt;
    }

    public TradedCompasses(class_2487 nbt) {
        class_5250 name;
        class_2487 nameEntry;
        Cloneable compasses;
        UUID player;
        class_2487 playerEntry;
        for (class_2520 playerElement : nbt.method_10554("buy", 10)) {
            playerEntry = (class_2487)playerElement;
            player = playerEntry.method_25926("uuid");
            compasses = new LinkedHashMap();
            for (class_2520 compassEntry : playerEntry.method_10554("compasses", 10)) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8251);
                stack.method_7980((class_2487)compassEntry);
                Optional<Compass> compassData = TradedCompasses.getCompass(stack);
                if (compassData.isEmpty()) continue;
                class_4208 pos = class_4208.method_19443(compassData.get().dimension, (class_2338)compassData.get().lodestonePos);
                ((HashMap)compasses).put(pos, stack);
            }
            this.availableForBuy.put(player, (LinkedHashMap<class_4208, class_1799>)compasses);
        }
        for (class_2520 playerElement : nbt.method_10554("sell", 10)) {
            playerEntry = (class_2487)playerElement;
            player = playerEntry.method_25926("uuid");
            compasses = new LinkedList();
            for (class_2520 compassEntry : playerEntry.method_10554("compasses", 10)) {
                Compass compass = Compass.fromNbt((class_2487)compassEntry);
                if (compass == null) continue;
                ((LinkedList)compasses).add(compass);
            }
            this.availableForSell.put(player, (List<Compass>)((Object)compasses));
        }
        for (class_2520 nameElement : nbt.method_10554("names", 10)) {
            nameEntry = (class_2487)nameElement;
            name = class_2561.class_2562.method_10877((String)nameEntry.method_10558("name"));
            if (name == null) continue;
            this.usedNames.put((class_2561)name, nameEntry.method_10550("count"));
        }
        for (class_2520 loreElement : nbt.method_10554("lores", 10)) {
            nameEntry = (class_2487)loreElement;
            name = class_2561.class_2562.method_10877((String)nameEntry.method_10558("lore"));
            if (name == null) continue;
            this.usedLores.put((class_2561)name, nameEntry.method_10550("count"));
        }
        if (nbt.method_10573("lodestones", 9)) {
            for (class_2520 lodestoneElement : nbt.method_10554("lodestones", 10)) {
                class_2487 lodestoneEntry = (class_2487)lodestoneElement;
                Optional dimension = class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)lodestoneEntry.method_10580("dimension")).result();
                dimension.ifPresent(worldRegistryKey -> Optional.ofNullable(class_2512.method_10691((class_2487)lodestoneEntry.method_10562("pos"))).ifPresent(pos -> this.lodestoneStatus.put(class_4208.method_19443((class_5321)worldRegistryKey, (class_2338)pos), Lodestone.fromNbt(lodestoneEntry.method_10562("status")))));
            }
        }
    }

    public static Optional<Compass> getCompass(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8251) && class_1759.method_26365((class_1799)stack)) {
            class_2487 compassNbt = stack.method_7948();
            if (!(compassNbt.method_10545("LodestonePos") && compassNbt.method_10545("LodestoneTracked") && compassNbt.method_10577("LodestoneTracked"))) {
                return Optional.empty();
            }
            Optional lodestoneDimension = class_1759.method_26364((class_2487)compassNbt);
            if (lodestoneDimension.isPresent()) {
                class_2338 lodestonePos = class_2512.method_10691((class_2487)compassNbt.method_10562("LodestonePos"));
                return Optional.of(new Compass(stack.method_7938() ? Optional.of(stack.method_7964()) : Optional.empty(), Optional.ofNullable(stack.method_7969()).filter(nbt -> nbt.method_10573("display", 10)).map(nbt -> nbt.method_10562("display")).filter(nbt -> nbt.method_10573("Lore", 9)).flatMap(nbt -> nbt.method_10554("Lore", 8).stream().findFirst()).map(l -> class_2561.class_2562.method_10877((String)l.method_10714())), lodestonePos, (class_5321<class_1937>)((class_5321)lodestoneDimension.get())));
            }
        }
        return Optional.empty();
    }

    public record Compass(Optional<class_2561> name, Optional<class_2561> lore, class_2338 lodestonePos, class_5321<class_1937> dimension) {
        public boolean isValid(MinecraftServer server) {
            class_3218 targetWorld = server.method_3847(this.dimension);
            if (targetWorld == null) {
                return false;
            }
            return targetWorld.method_24794(this.lodestonePos) && targetWorld.method_19494().method_26339(class_7477.field_39296, this.lodestonePos);
        }

        public boolean isClone(Compass other) {
            return this.lodestonePos.equals((Object)other.lodestonePos) && this.dimension.equals(other.dimension);
        }

        public static Compass fromNbt(class_2487 nbt) {
            Optional dimension = class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("dimension")).result();
            if (dimension.isPresent()) {
                Optional<class_2561> text = Optional.empty();
                Optional<Object> lore = Optional.empty();
                if (nbt.method_10545("name")) {
                    text = Optional.ofNullable(class_2561.class_2562.method_10877((String)nbt.method_10558("name")));
                }
                if (nbt.method_10545("lore")) {
                    lore = Optional.ofNullable(class_2561.class_2562.method_10877((String)nbt.method_10558("lore")));
                }
                return new Compass(text, lore, class_2512.method_10691((class_2487)nbt.method_10562("pos")), (class_5321<class_1937>)((class_5321)dimension.get()));
            }
            return null;
        }

        public class_2487 toNbt() {
            DataResult encodedDimension = class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, this.dimension);
            Optional dimension = encodedDimension.resultOrPartial(s -> {});
            if (dimension.isPresent()) {
                class_2487 nbt = new class_2487();
                this.name.ifPresent(text -> nbt.method_10582("name", class_2561.class_2562.method_10867((class_2561)text)));
                nbt.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)this.lodestonePos));
                nbt.method_10566("dimension", (class_2520)dimension.get());
                return nbt;
            }
            return null;
        }
    }

    public record Lodestone(Optional<class_2561> name, int sellTrades, Optional<UUID> displayEntityUUID) {
        public static Lodestone fromNbt(class_2487 nbt) {
            Optional<class_2561> name = Optional.empty();
            if (nbt.method_10545("name")) {
                name = Optional.ofNullable(class_2561.class_2562.method_10877((String)nbt.method_10558("name")));
            }
            short hasSellTrade = nbt.method_10568("trades");
            Optional<UUID> displayEntity = nbt.method_10545("display_entity") ? Optional.of(nbt.method_25926("display_entity")) : Optional.empty();
            return new Lodestone(name, hasSellTrade, displayEntity);
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            this.name.ifPresent(text -> nbt.method_10582("name", class_2561.class_2562.method_10867((class_2561)text)));
            nbt.method_10575("trades", (short)this.sellTrades);
            this.displayEntityUUID.ifPresent(uuid -> nbt.method_25927("display_entity", uuid));
            return nbt;
        }
    }
}

