/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.unruffled.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_8174;

public abstract class BlockTemplate {
    public abstract class_2680 getBlockState(class_5819 var1);

    public abstract void process(class_5281 var1, class_5819 var2, class_2338 var3, class_2350 var4);

    public static BlockTemplate empty() {
        return new Simple(null);
    }

    public static BlockTemplate block(class_2680 state) {
        return new Simple(state);
    }

    public static BlockTemplate block(class_2248 block) {
        return BlockTemplate.block(block.method_9564());
    }

    public static BlockTemplate random(class_2680[] states) {
        return new RandomChoice(Arrays.stream(states).map(Simple::new).toList(), 0);
    }

    public static BlockTemplate random(class_2680[] states, int emptyWeight) {
        return new RandomChoice(Arrays.stream(states).map(Simple::new).toList(), emptyWeight);
    }

    public static BlockTemplate lootContainer(class_2680 state, class_5321<class_52> lootTableId) {
        return new ProcessBlockEntity(new Simple(state), (entity, random) -> {
            if (entity instanceof class_2621) {
                ((class_2621)entity).method_54867(lootTableId, random.method_43055());
            }
        });
    }

    public static BlockTemplate lootContainer(class_2248 block, class_5321<class_52> lootTableId) {
        return BlockTemplate.lootContainer(block.method_9564(), lootTableId);
    }

    public static BlockTemplate lootContainer(class_2680 state, class_2960 lootTable) {
        return BlockTemplate.lootContainer(state, (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTable));
    }

    public static BlockTemplate lootBrushable(class_2680 state, class_5321<class_52> lootTableId) {
        return new ProcessBlockEntity(new Simple(state), (entity, random) -> {
            if (entity instanceof class_8174) {
                ((class_8174)entity).method_49216(lootTableId, random.method_43055());
            }
        });
    }

    public static BlockTemplate lootBrushable(class_2248 block, class_2960 lootTableId) {
        return BlockTemplate.lootBrushable(block, (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableId));
    }

    public static BlockTemplate lootBrushable(class_2248 block, class_5321<class_52> lootTableId) {
        return BlockTemplate.lootBrushable(block.method_9564(), lootTableId);
    }

    public static BlockTemplate blockEntity(BlockTemplate template, BiConsumer<class_2586, class_5819> blockEntityFunction) {
        return new ProcessBlockEntity(template, blockEntityFunction);
    }

    public static BlockTemplate blockEntity(class_2680 state, BiConsumer<class_2586, class_5819> blockEntityFunction) {
        return BlockTemplate.blockEntity(new Simple(state), blockEntityFunction);
    }

    public static BlockTemplate blockEntity(class_2248 block, BiConsumer<class_2586, class_5819> blockEntityFunction) {
        return BlockTemplate.blockEntity(block.method_9564(), blockEntityFunction);
    }

    public static BlockTemplate sideEffect(BlockTemplate template, Consumer<ProcessContext> processor) {
        return new ProcessWorld(template, processor);
    }

    public static BlockTemplate sideEffect(BlockTemplate template, BiConsumer<class_5281, class_2338> processor) {
        return new ProcessWorld(template, ctx -> processor.accept(ctx.world, ctx.pos));
    }

    public static BlockTemplate sideEffect(class_2680 state, BiConsumer<class_5281, class_2338> processor) {
        return BlockTemplate.sideEffect((BlockTemplate)new Simple(state), processor);
    }

    private static class Simple
    extends BlockTemplate {
        private final class_2680 state;

        public Simple(class_2680 state) {
            this.state = state;
        }

        @Override
        public class_2680 getBlockState(class_5819 random) {
            return this.state;
        }

        @Override
        public void process(class_5281 world, class_5819 random, class_2338 pos, class_2350 direction) {
        }
    }

    private static class RandomChoice
    extends BlockTemplate {
        private final List<? extends BlockTemplate> choices;
        private final int emptyWeight;

        public RandomChoice(List<? extends BlockTemplate> choices, int emptyWeight) {
            this.choices = choices;
            this.emptyWeight = emptyWeight;
        }

        @Override
        public class_2680 getBlockState(class_5819 random) {
            int choice = random.method_43048(this.choices.size() + this.emptyWeight);
            return choice < this.choices.size() ? this.choices.get(choice).getBlockState(random) : null;
        }

        @Override
        public void process(class_5281 world, class_5819 random, class_2338 pos, class_2350 direction) {
        }
    }

    private static class ProcessBlockEntity
    extends BlockTemplate {
        private final BlockTemplate baseTemplate;
        private final BiConsumer<class_2586, class_5819> blockEntityFunction;

        private ProcessBlockEntity(BlockTemplate baseTemplate, BiConsumer<class_2586, class_5819> blockEntityFunction) {
            this.baseTemplate = baseTemplate;
            this.blockEntityFunction = blockEntityFunction;
        }

        @Override
        public class_2680 getBlockState(class_5819 random) {
            return this.baseTemplate.getBlockState(random);
        }

        @Override
        public void process(class_5281 world, class_5819 random, class_2338 pos, class_2350 direction) {
            class_2586 entity = world.method_8321(pos);
            if (entity != null) {
                this.blockEntityFunction.accept(entity, random);
            }
        }
    }

    private static class ProcessWorld
    extends BlockTemplate {
        private final BlockTemplate template;
        private final Consumer<ProcessContext> worldFunction;

        private ProcessWorld(BlockTemplate template, Consumer<ProcessContext> worldFunction) {
            this.template = template;
            this.worldFunction = worldFunction;
        }

        @Override
        public class_2680 getBlockState(class_5819 random) {
            return this.template.getBlockState(random);
        }

        @Override
        public void process(class_5281 world, class_5819 random, class_2338 pos, class_2350 direction) {
            this.worldFunction.accept(new ProcessContext(world, random, pos, direction));
        }
    }

    public record ProcessContext(class_5281 world, class_5819 random, class_2338 pos, class_2350 direction) {
    }
}

