/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.SoundOverride;
import com.example.soundattract.util.ThreadingChecks;
import com.example.soundattract.util.WorkerScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_7923;

public class SoundTracker {
    public static final List<SoundRecord> RECENT_SOUNDS = Collections.synchronizedList(new ArrayList());
    private static final Map<String, Map<Long, List<SoundRecord>>> SPATIAL_SOUNDS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, CachedBest> ASYNC_BEST_BY_MOB = new ConcurrentHashMap<UUID, CachedBest>();
    private static final WeakHashMap<RaycastCacheKey, double[]> RAYCAST_CACHE = new WeakHashMap();
    private static int pruneIndex = 0;
    private static final int SOUNDS_PRUNED_PER_TICK = 1;
    private static final Map<UUID, Long> LAST_SUBMIT_TICK = new ConcurrentHashMap<UUID, Long>();

    private static int getGridRadiusForRange(double range, int partitionSize) {
        if (range < 8.0) {
            return 1;
        }
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        for (int i = 1; i <= 20; ++i) {
            if (!(range < 8.0 + (double)partitionSize * (double)i)) continue;
            return i + 1;
        }
        return 21;
    }

    public static Set<Long> getCoveredCells(class_2338 pos, double range, int partitionSize) {
        HashSet<Long> cells = new HashSet<Long>();
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        int gridRadius = SoundTracker.getGridRadiusForRange(range, partitionSize);
        int baseX = pos.method_10263() / partitionSize;
        int baseZ = pos.method_10260() / partitionSize;
        for (int dx = -gridRadius; dx <= gridRadius; ++dx) {
            for (int dz = -gridRadius; dz <= gridRadius; ++dz) {
                int cellX = baseX + dx;
                int cellZ = baseZ + dz;
                long key = (long)cellX << 32 | (long)cellZ & 0xFFFFFFFFL;
                cells.add(key);
            }
        }
        return cells;
    }

    private static long getAsyncResultTtlNanos() {
        long ms = 2500L;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.asyncResultTtlMs > 0L) {
            ms = SoundAttractMod.CONFIG.asyncResultTtlMs;
        }
        return TimeUnit.MILLISECONDS.toNanos(ms);
    }

    public static void applySoundScoreResult(WorkerScheduler.SoundScoreResult result) {
        if (result == null || result.mobUuid == null) {
            return;
        }
        CachedBest cb = new CachedBest(result.best, result.createdAtNanos, result.dimensionKey);
        ASYNC_BEST_BY_MOB.put(result.mobUuid, cb);
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.debug("[SoundTracker] Applied async best for mob {} in dim {}", (Object)result.mobUuid, (Object)result.dimensionKey);
        }
    }

    public static SoundRecord getCachedBestFor(class_1308 mob, String dimensionKey) {
        if (mob == null) {
            return null;
        }
        CachedBest cb = ASYNC_BEST_BY_MOB.get(mob.method_5667());
        if (cb == null) {
            return null;
        }
        if (dimensionKey != null && cb.dimensionKey != null && !dimensionKey.equals(cb.dimensionKey)) {
            return null;
        }
        long ttl = SoundTracker.getAsyncResultTtlNanos();
        long age = System.nanoTime() - cb.createdAtNanos;
        if (age > ttl) {
            ASYNC_BEST_BY_MOB.remove(mob.method_5667());
            return null;
        }
        return cb.best;
    }

    public static void clearCachedBest(UUID mobUuid) {
        if (mobUuid != null) {
            ASYNC_BEST_BY_MOB.remove(mobUuid);
        }
    }

    private static synchronized void updateSpatialSounds() {
        SPATIAL_SOUNDS.clear();
        if (SoundAttractMod.CONFIG == null) {
            return;
        }
        int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        ArrayList<SoundRecord> currentSounds = new ArrayList<SoundRecord>(RECENT_SOUNDS);
        for (SoundRecord r : currentSounds) {
            r.coveredCells.clear();
            Set<Long> cells = SoundTracker.getCoveredCells(r.pos, r.range, partitionSize);
            r.coveredCells.addAll(cells);
            Map dimMap = SPATIAL_SOUNDS.computeIfAbsent(r.dimensionKey, d -> Collections.synchronizedMap(new HashMap()));
            for (Long key : cells) {
                dimMap.computeIfAbsent(key, k -> Collections.synchronizedList(new ArrayList())).add(r);
            }
        }
    }

    public static synchronized void addSound(class_3414 se, class_2338 pos, String dimensionKey, double range, double weight, int lifetime, String explicitSoundId) {
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot add sound.");
            return;
        }
        Object soundIdToUse = explicitSoundId;
        if (soundIdToUse == null && se != null && se.method_14833() != null) {
            soundIdToUse = se.method_14833().toString();
        }
        if (soundIdToUse == null) {
            soundIdToUse = "unknown_sound_id_at_" + pos.method_23854();
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.warn("[SoundTracker] SoundEvent or explicitSoundId resulted in null soundId. Using placeholder: {}", soundIdToUse);
            }
        }
        String finalSoundId = soundIdToUse;
        if (!(SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || SoundAttractMod.CONFIG.soundIdWhitelist.contains(finalSoundId) || finalSoundId.equals(SoundMessage.VOICE_CHAT_SOUND_ID.toString()))) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Skipped non-whitelist sound: {} at {} (dim: {}), range={}, weight={}", new Object[]{finalSoundId, pos, dimensionKey, range, weight});
            }
            return;
        }
        if (range < 0.0) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.warn("[SoundTracker] Attempted to register sound {} at {} (dim: {}) with negative range={}, skipping.", new Object[]{finalSoundId, pos, dimensionKey, range});
            }
            return;
        }
        boolean removed = RECENT_SOUNDS.removeIf(r -> r.pos.equals((Object)pos) && Objects.equals(r.soundId, finalSoundId) && Objects.equals(r.dimensionKey, dimensionKey));
        if (removed && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Refreshed sound (removed old instance): {} at {} (dim: {})", new Object[]{finalSoundId, pos, dimensionKey});
        }
        RECENT_SOUNDS.add(new SoundRecord(se, finalSoundId, pos, lifetime, dimensionKey, range, weight));
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Registered sound {} at {} (dim: {}), range={}, weight={}, lifetime={}", new Object[]{finalSoundId, pos, dimensionKey, String.format("%.2f", range), String.format("%.2f", weight), lifetime});
        }
        SoundTracker.updateSpatialSounds();
    }

    public static synchronized void addSound(class_3414 se, class_2338 pos, String dimensionKey, double range, double weight, int lifetime) {
        SoundTracker.addSound(se, pos, dimensionKey, range, weight, lifetime, null);
    }

    public static synchronized void addSound(class_3414 se, class_2338 pos, String dimensionKey) {
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded for default lifetime sound.");
            return;
        }
        int lifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
        SoundTracker.addSound(se, pos, dimensionKey, 16.0, 1.0, lifetime);
    }

    public static synchronized void addVirtualSound(class_2338 pos, String dimensionKey, double range, double weight, int lifetime, UUID sourcePlayer, String animationClass) {
        String finalVirtualSoundId;
        boolean removed;
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot add virtual sound.");
            return;
        }
        String constructedVirtualSoundId = "virtual_sound:" + (animationClass != null ? animationClass : "player_action");
        if (sourcePlayer != null) {
            String playerPart = sourcePlayer.toString();
            constructedVirtualSoundId = constructedVirtualSoundId + ":" + (playerPart.length() > 8 ? playerPart.substring(0, 8) : playerPart);
        }
        if ((removed = RECENT_SOUNDS.removeIf(arg_0 -> SoundTracker.lambda$addVirtualSound$3(pos, finalVirtualSoundId = constructedVirtualSoundId, dimensionKey, arg_0))) && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Refreshed virtual sound (removed old instance): {} at {} (dim: {})", new Object[]{finalVirtualSoundId, pos, dimensionKey});
        }
        RECENT_SOUNDS.add(new VirtualSoundRecord(pos, lifetime, dimensionKey, range, weight, sourcePlayer, animationClass));
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Registered virtual sound (intended ID for refresh check: {}) at {} (dim: {}), range={}, weight={}, lifetime={}", new Object[]{finalVirtualSoundId, pos, dimensionKey, String.format("%.2f", range), String.format("%.2f", weight), lifetime});
        }
        SoundTracker.updateSpatialSounds();
    }

    public static synchronized void tick() {
        boolean soundsChanged = false;
        Iterator<SoundRecord> iter = RECENT_SOUNDS.iterator();
        while (iter.hasNext()) {
            SoundRecord r = iter.next();
            --r.ticksRemaining;
            if (r.ticksRemaining > 0) continue;
            iter.remove();
            soundsChanged = true;
        }
        if (soundsChanged) {
            SoundTracker.updateSpatialSounds();
        }
    }

    public static synchronized void removeSoundAt(class_2338 pos, String dimensionKey) {
        boolean removed = RECENT_SOUNDS.removeIf(r -> r.pos.equals((Object)pos) && Objects.equals(r.dimensionKey, dimensionKey));
        if (removed) {
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Removed sound(s) at pos {} in dim {}", (Object)pos, (Object)dimensionKey);
            }
            SoundTracker.updateSpatialSounds();
        }
    }

    private static boolean isCustomWool(class_2680 state, class_2248 block) {
        try {
            if (state.method_26164(class_3481.field_15481)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String id = class_7923.field_41175.method_10221((Object)block).toString();
        return id.contains("wool") || id.contains("carpet");
    }

    private static boolean isCustomThin(class_2680 state, class_2248 block) {
        String id = class_7923.field_41175.method_10221((Object)block).toString();
        return id.contains("pane") || id.contains("bars") || id.contains("trapdoor") || id.contains("carpet") || id.contains("fence") || id.contains("wall") || id.contains("slab") || id.contains("door");
    }

    private static boolean isCustomNonSolid(class_2680 state, class_2248 block) {
        if (state.method_26215()) {
            return true;
        }
        String id = class_7923.field_41175.method_10221((Object)block).toString();
        return id.contains("leaves") || id.contains("flower") || id.contains("plant") || id.contains("torch") || id.contains("vine") || id.contains("grass") || id.contains("mushroom") || id.contains("kelp") || id.contains("coral") || id.contains("cactus") || id.contains("sugar_cane") || id.contains("ladder");
    }

    private static boolean isCustomSolid(class_2680 state, class_2248 block) {
        return !SoundTracker.isCustomThin(state, block) && !SoundTracker.isCustomNonSolid(state, block);
    }

    private static boolean isCustomLiquid(class_2248 block) {
        if (block instanceof class_2404) {
            return true;
        }
        String id = class_7923.field_41175.method_10221((Object)block).toString();
        return id.contains("water") || id.contains("lava");
    }

    public static double[] applyBlockMuffling(class_1937 level, class_2338 src, class_2338 dst, double origRange, double origWeight, String soundId) {
        RaycastCacheKey key;
        double[] cached;
        String currentSoundId;
        ThreadingChecks.warnIfOffServerThread(level, "SoundTracker.applyBlockMuffling");
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot apply muffling.");
            return new double[]{origRange, origWeight};
        }
        String string = currentSoundId = soundId != null ? soundId : "unknown_muffling_sound";
        if (!(SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || SoundAttractMod.CONFIG.soundIdWhitelist.contains(currentSoundId) || currentSoundId.startsWith("virtual_sound:") || currentSoundId.equals(SoundMessage.VOICE_CHAT_SOUND_ID.toString()) || !SoundAttractMod.CONFIG.debugLogging)) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Skipped muffling for sound {} at {} -> {} due to whitelist", new Object[]{currentSoundId, src, dst});
        }
        if ((cached = RAYCAST_CACHE.get(key = new RaycastCacheKey(dst, src, currentSoundId))) != null) {
            return cached;
        }
        double range = origRange;
        double weight = origWeight;
        int x0 = src.method_10263();
        int y0 = src.method_10264();
        int z0 = src.method_10260();
        int x1 = dst.method_10263();
        int y1 = dst.method_10264();
        int z1 = dst.method_10260();
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int sx = Integer.compare(x1, x0);
        int sy = Integer.compare(y1, y0);
        int sz = Integer.compare(z1, z0);
        int nMaxSteps = dx + dy + dz + 1;
        int x = x0;
        int y = y0;
        int z = z0;
        int err_xy = dx - dy;
        int err_xz = dx - dz;
        int blocksMuffled = 0;
        int areaRadius = SoundAttractMod.CONFIG.mufflingAreaRadius;
        class_243 startVec = class_243.method_24953((class_2382)src);
        class_243 endVec = class_243.method_24953((class_2382)dst);
        class_243 direction = endVec.method_1020(startVec).method_1029();
        double totalDistance = startVec.method_1022(endVec);
        double step = 0.5;
        for (double d = 0.0; d <= totalDistance && range > 0.0 && weight > 0.0; d += step) {
            class_243 currentPoint = startVec.method_1019(direction.method_1021(d));
            class_2338 currentBlockPos = class_2338.method_49638((class_2374)currentPoint);
            boolean muffledThisStep = false;
            for (int dxr = -areaRadius; dxr <= areaRadius && !muffledThisStep; ++dxr) {
                for (int dyr = -areaRadius; dyr <= areaRadius && !muffledThisStep; ++dyr) {
                    for (int dzr = -areaRadius; dzr <= areaRadius && !muffledThisStep; ++dzr) {
                        class_2680 state;
                        class_2248 block;
                        class_2338 posToCheck = currentBlockPos.method_10069(dxr, dyr, dzr);
                        if (d > step && posToCheck.equals((Object)src) || d < totalDistance - step && posToCheck.equals((Object)dst) || !level.method_22340(posToCheck) || (block = (state = level.method_8320(posToCheck)).method_26204()) == class_2246.field_10124 || state.method_26215()) continue;
                        if (SoundTracker.isCustomWool(state, block) && SoundAttractMod.CONFIG.woolMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.woolBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.woolBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if (SoundTracker.isCustomThin(state, block) && SoundAttractMod.CONFIG.thinMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.thinBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.thinBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if (SoundTracker.isCustomNonSolid(state, block) && SoundAttractMod.CONFIG.nonSolidMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.nonSolidBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.nonSolidBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if (SoundTracker.isCustomSolid(state, block) && SoundAttractMod.CONFIG.solidMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.solidBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.solidBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if ((state.method_26227() == null || state.method_26227().method_15769()) && !SoundTracker.isCustomLiquid(block) || !SoundAttractMod.CONFIG.liquidMufflingEnabled) continue;
                        range -= (double)SoundAttractMod.CONFIG.liquidBlockRangeReduction;
                        weight -= SoundAttractMod.CONFIG.liquidBlockWeightReduction;
                        ++blocksMuffled;
                        muffledThisStep = true;
                    }
                }
            }
        }
        if (range < 0.0) {
            range = 0.0;
        }
        if (weight < 0.0) {
            weight = 0.0;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[BlockMuffling] soundId={}, src={}, dst={}, origRange={}, origWeight={}, muffledRange={}, muffledWeight={}, blocksMuffled={}", new Object[]{currentSoundId, src, dst, String.format("%.2f", origRange), String.format("%.2f", origWeight), String.format("%.2f", range), String.format("%.2f", weight), blocksMuffled});
        }
        double[] result = new double[]{range, weight};
        if (blocksMuffled > 0 || origRange == 0.0) {
            RAYCAST_CACHE.put(key, result);
        }
        return result;
    }

    public static synchronized void pruneIrrelevantSounds(class_1937 level) {
        ThreadingChecks.warnIfOffServerThread(level, "SoundTracker.pruneIrrelevantSounds");
        if (RECENT_SOUNDS.isEmpty() || SoundAttractMod.CONFIG == null) {
            return;
        }
        int total = RECENT_SOUNDS.size();
        if (pruneIndex >= total) {
            pruneIndex = 0;
        }
        int prunedThisTick = 0;
        int checkedThisTick = 0;
        ArrayList<SoundRecord> soundsToPrune = new ArrayList<SoundRecord>();
        for (int i = 0; i < total && checkedThisTick < total && prunedThisTick < 1; ++i) {
            int currentIndex = (pruneIndex + i) % total;
            if (currentIndex >= RECENT_SOUNDS.size()) continue;
            SoundRecord sound = RECENT_SOUNDS.get(currentIndex);
            ++checkedThisTick;
            if (sound.ticksRemaining > SoundAttractMod.CONFIG.scanCooldownTicks) continue;
            boolean isRelevantToAnyMob = false;
            for (Long cellKey : sound.coveredCells) {
                int cellX = (int)(cellKey >> 32);
                int cellZ = (int)(cellKey & 0xFFFFFFFFL);
                int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
                if (partitionSize <= 0) {
                    partitionSize = 16;
                }
                class_238 checkBox = new class_238((double)(cellX * partitionSize), (double)level.method_31607(), (double)(cellZ * partitionSize), (double)((cellX + 1) * partitionSize), (double)level.method_31600(), (double)((cellZ + 1) * partitionSize));
                List mobsInCell = level.method_8390(class_1308.class, checkBox, m -> m.method_5805());
                for (class_1308 mob : mobsInCell) {
                    Optional<SoundOverride> ov;
                    class_2960 rl;
                    if (!SoundAttractMod.CONFIG.attractedEntities.contains(class_7923.field_41177.method_10221((Object)mob.method_5864()).toString())) continue;
                    MobProfile profile = SoundAttractMod.CONFIG.getMatchingProfile(mob);
                    double effectiveRange = sound.range;
                    double effectiveWeight = sound.weight;
                    if (profile != null && sound.soundId != null && (rl = class_2960.method_12829((String)sound.soundId)) != null && (ov = profile.getSoundOverride(rl)).isPresent()) {
                        effectiveRange = ov.get().getRange();
                        effectiveWeight = ov.get().getWeight();
                    }
                    double[] muffled = SoundTracker.applyBlockMuffling(level, sound.pos, mob.method_24515(), effectiveRange, effectiveWeight, sound.soundId);
                    double finalRange = muffled[0];
                    if (!(mob.method_24515().method_10262((class_2382)sound.pos) <= finalRange * finalRange)) continue;
                    isRelevantToAnyMob = true;
                    break;
                }
                if (!isRelevantToAnyMob) continue;
                break;
            }
            if (isRelevantToAnyMob) continue;
            soundsToPrune.add(sound);
            ++prunedThisTick;
        }
        if (!soundsToPrune.isEmpty()) {
            RECENT_SOUNDS.removeAll(soundsToPrune);
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Pruned {} irrelevant sounds.", (Object)soundsToPrune.size());
            }
            SoundTracker.updateSpatialSounds();
        }
        pruneIndex = (pruneIndex + checkedThisTick) % Math.max(1, RECENT_SOUNDS.size());
    }

    public static synchronized SoundRecord findNearestSound(class_1937 level, class_1308 mob, class_2338 mobPos, class_243 mobEyePos) {
        ThreadingChecks.warnIfOffServerThread(level, "SoundTracker.findNearestSound");
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot find nearest sound.");
            return null;
        }
        String dimensionKey = level.method_27983().method_29177().toString();
        ArrayList<SoundRecord> currentSoundsSnapshot = new ArrayList<SoundRecord>(RECENT_SOUNDS);
        if (currentSoundsSnapshot.isEmpty()) {
            return null;
        }
        MobProfile profile = SoundAttractMod.CONFIG.getMatchingProfile(mob);
        SoundRecord bestSound = null;
        double highestComparisonWeight = -1.0;
        double closestDistSqrForBest = Double.MAX_VALUE;
        double noveltyBonusValue = SoundAttractMod.CONFIG.soundNoveltyBonusWeight;
        int noveltyTicks = SoundAttractMod.CONFIG.soundNoveltyTimeTicks;
        int maxLifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
        for (SoundRecord r : currentSoundsSnapshot) {
            double finalComparisonWeight;
            Optional<SoundOverride> ov;
            class_2960 rl;
            String soundId;
            if (r == null || r.pos == null || !Objects.equals(r.dimensionKey, dimensionKey)) continue;
            String string = soundId = r.soundId != null ? r.soundId : "unknown_sound_in_recent_list";
            if (!SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() && !SoundAttractMod.CONFIG.soundIdWhitelist.contains(soundId) && !soundId.startsWith("virtual_sound:") && !soundId.equals(SoundMessage.VOICE_CHAT_SOUND_ID.toString())) continue;
            double effectiveInitialRange = r.range;
            double effectiveInitialWeight = r.weight;
            if (profile != null && (rl = class_2960.method_12829((String)soundId)) != null && (ov = profile.getSoundOverride(rl)).isPresent()) {
                effectiveInitialRange = ov.get().getRange();
                effectiveInitialWeight = ov.get().getWeight();
            }
            double[] muffled = SoundTracker.applyBlockMuffling(level, r.pos, mobPos, effectiveInitialRange, effectiveInitialWeight, soundId);
            double muffledRange = muffled[0];
            double muffledWeight = muffled[1];
            double distSqr = mobPos.method_10262((class_2382)r.pos);
            if (muffledWeight <= 0.0 || muffledRange <= 0.0 || distSqr > muffledRange * muffledRange) continue;
            double noveltyBonus = 0.0;
            if (noveltyBonusValue > 0.0 && r.ticksRemaining > maxLifetime - noveltyTicks) {
                noveltyBonus = noveltyBonusValue;
            }
            if (!((finalComparisonWeight = muffledWeight + noveltyBonus) > highestComparisonWeight) && (!(Math.abs(finalComparisonWeight - highestComparisonWeight) < 0.001) || !(distSqr < closestDistSqrForBest))) continue;
            highestComparisonWeight = finalComparisonWeight;
            closestDistSqrForBest = distSqr;
            bestSound = new SoundRecord(r.sound, soundId, r.pos, r.ticksRemaining, r.dimensionKey, muffledRange, muffledWeight);
        }
        return bestSound;
    }

    private static int getSubmitCooldownTicks() {
        int ticks = 10;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.asyncSubmitCooldownTicks > 0) {
            ticks = SoundAttractMod.CONFIG.asyncSubmitCooldownTicks;
        }
        return ticks;
    }

    public static void submitAsyncSoundScore(class_1937 level, class_1308 mob, class_2338 mobPos) {
        ThreadingChecks.warnIfOffServerThread(level, "SoundTracker.submitAsyncSoundScore");
        if (level == null || mob == null || SoundAttractMod.CONFIG == null) {
            return;
        }
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)level;
        long nowTick = serverWorld.method_8510();
        Long last = LAST_SUBMIT_TICK.get(mob.method_5667());
        int cooldown = SoundTracker.getSubmitCooldownTicks();
        if (last != null && nowTick - last < (long)cooldown) {
            return;
        }
        LAST_SUBMIT_TICK.put(mob.method_5667(), nowTick);
        String dimensionKey = level.method_27983().method_29177().toString();
        ArrayList<SoundRecord> current = new ArrayList<SoundRecord>(RECENT_SOUNDS);
        if (current.isEmpty()) {
            return;
        }
        MobProfile profile = SoundAttractMod.CONFIG.getMatchingProfile(mob);
        ArrayList<CandidateSnapshot> cands = new ArrayList<CandidateSnapshot>(current.size());
        for (SoundRecord r : current) {
            double distSqr;
            Optional<SoundOverride> ov;
            class_2960 rl;
            String soundId;
            if (r == null || r.pos == null || !Objects.equals(r.dimensionKey, dimensionKey)) continue;
            String string = soundId = r.soundId != null ? r.soundId : "unknown_sound_in_recent_list";
            if (!SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() && !SoundAttractMod.CONFIG.soundIdWhitelist.contains(soundId) && !soundId.startsWith("virtual_sound:") && !soundId.equals(SoundMessage.VOICE_CHAT_SOUND_ID.toString())) continue;
            double effRange = r.range;
            double effWeight = r.weight;
            if (profile != null && (rl = class_2960.method_12829((String)soundId)) != null && (ov = profile.getSoundOverride(rl)).isPresent()) {
                effRange = ov.get().getRange();
                effWeight = ov.get().getWeight();
            }
            double[] muffled = SoundTracker.applyBlockMuffling(level, r.pos, mobPos, effRange, effWeight, soundId);
            double mr = muffled[0];
            double mw = muffled[1];
            if (mw <= 0.0 || mr <= 0.0 || (distSqr = mobPos.method_10262((class_2382)r.pos)) > mr * mr) continue;
            cands.add(new CandidateSnapshot(r.pos, soundId, mr, mw, distSqr, r.ticksRemaining));
        }
        if (cands.isEmpty()) {
            return;
        }
        int noveltyTicks = SoundAttractMod.CONFIG.soundNoveltyTimeTicks;
        double noveltyBonus = SoundAttractMod.CONFIG.soundNoveltyBonusWeight;
        int maxLifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
        SoundScoreRequestSnapshot req = new SoundScoreRequestSnapshot(mob.method_5667(), dimensionKey, mobPos, noveltyTicks, noveltyBonus, maxLifetime, Collections.unmodifiableList(cands));
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.debug("[SoundTracker] Submitting async sound score for mob {} in dim {} with {} candidates", new Object[]{mob.method_5667(), dimensionKey, cands.size()});
        }
        WorkerScheduler.submitSoundTask(() -> {
            CandidateSnapshot best = null;
            double bestWeight = -1.0;
            double bestDist = Double.MAX_VALUE;
            for (CandidateSnapshot c : req.candidates) {
                double bonus = req.noveltyBonusValue > 0.0 && c.ticksRemaining > req.maxLifetime - req.noveltyTicks ? req.noveltyBonusValue : 0.0;
                double w = c.muffledWeight + bonus;
                if (!(w > bestWeight) && (!(Math.abs(w - bestWeight) < 0.001) || !(c.distSqr < bestDist))) continue;
                bestWeight = w;
                bestDist = c.distSqr;
                best = c;
            }
            SoundRecord bestRecord = null;
            if (best != null) {
                bestRecord = new SoundRecord(null, best.soundId, best.pos, Math.min(req.maxLifetime, Math.max(1, best.ticksRemaining)), req.dimensionKey, best.muffledRange, best.muffledWeight);
            }
            return new WorkerScheduler.SoundScoreResult(req.mobUuid, req.dimensionKey, bestRecord);
        });
    }

    public static List<class_1308> getMobsForSound(class_1937 world, SoundRecord sound, Predicate<class_1308> filter) {
        ThreadingChecks.warnIfOffServerThread(world, "SoundTracker.getMobsForSound");
        ArrayList<class_1308> result = new ArrayList<class_1308>();
        if (sound == null || world == null || SoundAttractMod.CONFIG == null) {
            return result;
        }
        double queryRange = sound.range;
        int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        int cellSearchRadius = (int)Math.ceil(queryRange / (double)partitionSize);
        int centerCellX = sound.pos.method_10263() / partitionSize;
        int centerCellZ = sound.pos.method_10260() / partitionSize;
        int minY = world.method_31607();
        int maxY = world.method_31600();
        for (int dx = -cellSearchRadius; dx <= cellSearchRadius; ++dx) {
            for (int dz = -cellSearchRadius; dz <= cellSearchRadius; ++dz) {
                int currentCellX = centerCellX + dx;
                int currentCellZ = centerCellZ + dz;
                class_238 cellBox = new class_238((double)(currentCellX * partitionSize), (double)minY, (double)(currentCellZ * partitionSize), (double)((currentCellX + 1) * partitionSize), (double)maxY, (double)((currentCellZ + 1) * partitionSize));
                List mobsInCell = world.method_8390(class_1308.class, cellBox, filter);
                for (class_1308 mob : mobsInCell) {
                    if (!(mob.method_24515().method_10262((class_2382)sound.pos) <= queryRange * queryRange)) continue;
                    result.add(mob);
                }
            }
        }
        return result;
    }

    public static synchronized List<SoundRecord> getRecentSounds() {
        return new ArrayList<SoundRecord>(RECENT_SOUNDS);
    }

    private static /* synthetic */ boolean lambda$addVirtualSound$3(class_2338 pos, String finalVirtualSoundId, String dimensionKey, SoundRecord r) {
        return r.pos.equals((Object)pos) && Objects.equals(r.soundId, finalVirtualSoundId) && Objects.equals(r.dimensionKey, dimensionKey);
    }

    private static final class CachedBest {
        final SoundRecord best;
        final long createdAtNanos;
        final String dimensionKey;

        CachedBest(SoundRecord best, long createdAtNanos, String dimensionKey) {
            this.best = best;
            this.createdAtNanos = createdAtNanos;
            this.dimensionKey = dimensionKey;
        }
    }

    public static class SoundRecord {
        public final class_3414 sound;
        public final String soundId;
        public final class_2338 pos;
        public int ticksRemaining;
        public final String dimensionKey;
        public final double range;
        public final double weight;
        public final Set<Long> coveredCells = new HashSet<Long>();
        public static final int DEFAULT_TICKS_REMAINING = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.soundLifetimeTicks : 200;

        public SoundRecord(class_3414 sound, String soundId, class_2338 pos, int lifetime, String dimensionKey, double range, double weight) {
            this.sound = sound;
            this.soundId = soundId;
            this.pos = pos;
            this.ticksRemaining = lifetime;
            this.dimensionKey = dimensionKey;
            this.range = range;
            this.weight = weight;
        }

        public SoundRecord(class_3414 sound, class_2338 pos, int lifetime, String dimensionKey, double range, double weight) {
            this(sound, sound != null && sound.method_14833() != null ? sound.method_14833().toString() : "unknown_sound_event_id", pos, lifetime, dimensionKey, range, weight);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SoundRecord)) {
                return false;
            }
            SoundRecord other = (SoundRecord)obj;
            return Objects.equals(this.soundId, other.soundId) && Objects.equals(this.pos, other.pos) && Objects.equals(this.dimensionKey, other.dimensionKey) && Double.compare(this.weight, other.weight) == 0 && Double.compare(this.range, other.range) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.soundId, this.pos, this.dimensionKey, this.range, this.weight);
        }
    }

    public static class VirtualSoundRecord
    extends SoundRecord {
        public final UUID sourcePlayer;
        public final String animationClass;

        public VirtualSoundRecord(class_2338 pos, int lifetime, String dimensionKey, double range, double weight, UUID sourcePlayer, String animationClass) {
            super(null, "virtual_sound:" + (animationClass != null ? animationClass : "unknown"), pos, lifetime, dimensionKey, range, weight);
            this.sourcePlayer = sourcePlayer;
            this.animationClass = animationClass;
        }
    }

    private static class RaycastCacheKey {
        public final class_2338 mobPos;
        public final class_2338 soundPos;
        public final String soundId;

        public RaycastCacheKey(class_2338 mobPos, class_2338 soundPos, String soundId) {
            this.mobPos = mobPos;
            this.soundPos = soundPos;
            this.soundId = Objects.requireNonNull(soundId, "soundId cannot be null for RaycastCacheKey");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RaycastCacheKey)) {
                return false;
            }
            RaycastCacheKey other = (RaycastCacheKey)o;
            return this.mobPos.equals((Object)other.mobPos) && this.soundPos.equals((Object)other.soundPos) && this.soundId.equals(other.soundId);
        }

        public int hashCode() {
            return Objects.hash(this.mobPos, this.soundPos, this.soundId);
        }
    }

    private static final class CandidateSnapshot {
        final class_2338 pos;
        final String soundId;
        final double muffledRange;
        final double muffledWeight;
        final double distSqr;
        final int ticksRemaining;

        CandidateSnapshot(class_2338 pos, String soundId, double muffledRange, double muffledWeight, double distSqr, int ticksRemaining) {
            this.pos = pos;
            this.soundId = soundId;
            this.muffledRange = muffledRange;
            this.muffledWeight = muffledWeight;
            this.distSqr = distSqr;
            this.ticksRemaining = ticksRemaining;
        }
    }

    private static final class SoundScoreRequestSnapshot {
        final UUID mobUuid;
        final String dimensionKey;
        final class_2338 mobPos;
        final int noveltyTicks;
        final double noveltyBonusValue;
        final int maxLifetime;
        final List<CandidateSnapshot> candidates;

        SoundScoreRequestSnapshot(UUID mobUuid, String dimensionKey, class_2338 mobPos, int noveltyTicks, double noveltyBonusValue, int maxLifetime, List<CandidateSnapshot> candidates) {
            this.mobUuid = mobUuid;
            this.dimensionKey = dimensionKey;
            this.mobPos = mobPos;
            this.noveltyTicks = noveltyTicks;
            this.noveltyBonusValue = noveltyBonusValue;
            this.maxLifetime = maxLifetime;
            this.candidates = candidates;
        }
    }
}

