/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.mixin.MobEntityAccessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1308;
import net.minecraft.class_1352;

public final class BlockBreakerManager {
    private static final Map<class_1308, GoalAction> PENDING = new ConcurrentHashMap<class_1308, GoalAction>();

    private BlockBreakerManager() {
    }

    public static void scheduleAdd(class_1308 mob, class_1352 goal, int priority) {
        if (mob == null || goal == null) {
            return;
        }
        PENDING.put(mob, new GoalAction(ActionType.ADD, goal, priority));
    }

    public static void scheduleRemove(class_1308 mob, class_1352 goal) {
        if (mob == null || goal == null) {
            return;
        }
        PENDING.put(mob, new GoalAction(ActionType.REMOVE, goal, 2));
    }

    public static void processPendingActions() {
        if (PENDING.isEmpty()) {
            return;
        }
        for (class_1308 mob : PENDING.keySet()) {
            GoalAction action = PENDING.remove(mob);
            if (action == null || !mob.method_5805() || mob.method_31481()) continue;
            switch (action.type.ordinal()) {
                case 0: {
                    ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().filter(w -> w.method_19058().getClass().equals(action.goal.getClass())).findFirst().ifPresent(w -> ((MobEntityAccessor)mob).getGoalSelector().method_6280(w.method_19058()));
                    ((MobEntityAccessor)mob).getGoalSelector().method_6277(action.priority, action.goal);
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) break;
                    SoundAttractMod.LOGGER.info("[BlockBreakerManager] Added goal {} for {} at priority {}", new Object[]{action.goal.getClass().getSimpleName(), mob.method_5477().getString(), action.priority});
                    break;
                }
                case 1: {
                    ((MobEntityAccessor)mob).getGoalSelector().method_6280(action.goal);
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) break;
                    SoundAttractMod.LOGGER.info("[BlockBreakerManager] Removed goal {} for {}", (Object)action.goal.getClass().getSimpleName(), (Object)mob.method_5477().getString());
                }
            }
        }
    }

    private record GoalAction(ActionType type, class_1352 goal, int priority) {
    }

    private static enum ActionType {
        ADD,
        REMOVE;

    }
}

