/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class LeaderAttractionGoal
extends class_1352 {
    private final class_1308 mob;
    private final double moveSpeed;
    private class_2338 targetPos;
    private class_243 chosenDest = null;
    private boolean hasPicked = false;
    private class_243 lastPosVec = null;
    private int stuckTicks = 0;
    private BlockBreakerPosGoal blockBreakerGoal = null;

    public LeaderAttractionGoal(class_1308 mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.mob.method_5765() || this.mob.method_6113() || this.mob.method_5968() != null) {
            return false;
        }
        if (MobGroupManager.getLeader(this.mob) != this.mob) {
            return false;
        }
        return RaidManager.isRaidAdvancing(this.mob);
    }

    public boolean method_6266() {
        if (MobGroupManager.getLeader(this.mob) != this.mob) {
            return false;
        }
        return RaidManager.isRaidAdvancing(this.mob);
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
    }

    public void method_6268() {
        double arrivalDist;
        if (!RaidManager.isRaidAdvancing(this.mob)) {
            this.mob.method_5942().method_6340();
            return;
        }
        class_2338 raidTarget = RaidManager.getRaidTarget(this.mob);
        if (raidTarget == null) {
            this.mob.method_5942().method_6340();
            return;
        }
        this.targetPos = raidTarget;
        class_243 cur = this.mob.method_19538();
        if (this.lastPosVec != null && cur.method_1025(this.lastPosVec) < 0.01) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            this.lastPosVec = cur;
            if (this.blockBreakerGoal != null) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
            }
        }
        if (this.stuckTicks >= 40 && SoundAttractMod.CONFIG.enableBlockBreaking && this.blockBreakerGoal == null) {
            BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, this.targetPos, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, SoundAttractMod.CONFIG.blockBreakToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolRequired);
            BlockBreakerManager.scheduleAdd(this.mob, breaker, 2);
            this.blockBreakerGoal = breaker;
        }
        double d = arrivalDist = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.arrivalDistance : 6.0;
        if (!this.hasPicked) {
            long seed = this.mob.method_5667().getMostSignificantBits() ^ this.mob.method_5667().getLeastSignificantBits() ^ this.targetPos.method_10063();
            Random rand = new Random(seed);
            double angle = rand.nextDouble() * (Math.PI * 2);
            double radius = arrivalDist * Math.sqrt(rand.nextDouble());
            double offX = Math.cos(angle) * radius;
            double offZ = Math.sin(angle) * radius;
            double fx = (double)this.targetPos.method_10263() + 0.5 + offX;
            double fz = (double)this.targetPos.method_10260() + 0.5 + offZ;
            double fy = this.targetPos.method_10264();
            this.chosenDest = new class_243(fx, fy, fz);
            this.hasPicked = true;
        }
        if (this.chosenDest != null) {
            class_243 curPos = this.mob.method_19538();
            if (curPos.method_1025(this.chosenDest) > 2.25) {
                this.mob.method_5942().method_6337(this.chosenDest.field_1352, this.chosenDest.field_1351, this.chosenDest.field_1350, this.moveSpeed);
            }
            if (this.mob.method_5942().method_6357()) {
                this.hasPicked = false;
                this.chosenDest = null;
            }
        }
    }

    private void navigateTo(class_2338 pos, double speed) {
        if (pos == null) {
            if (!this.mob.method_5942().method_6357()) {
                this.mob.method_5942().method_6340();
            }
            return;
        }
        this.mob.method_5942().method_6337((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, speed);
    }
}

