/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.ai.SpatialPartitionModule;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2338;

public class MobCellAssignmentHooks {
    private static final WeakHashMap<class_1308, Long> lastCellKey = new WeakHashMap();

    public static void register() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!(entity instanceof class_1308)) {
                return;
            }
            class_1308 mob = (class_1308)entity;
            UUID uuid = mob.method_5667();
            class_2338 pos = mob.method_24515();
            SpatialPartitionModule.addMobToCell(uuid, pos);
            SpatialPartitionModule.addMobToCache(uuid, mob);
            lastCellKey.put(mob, SpatialPartitionModule.cellKey(pos));
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (!(entity instanceof class_1308)) {
                return;
            }
            class_1308 mob = (class_1308)entity;
            UUID uuid = mob.method_5667();
            SpatialPartitionModule.enqueueDeadUuid(uuid);
            SpatialPartitionModule.removeMobFromCache(uuid);
            lastCellKey.remove(mob);
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            for (class_1297 entity : world.method_27909()) {
                if (!(entity instanceof class_1308)) continue;
                class_1308 mob = (class_1308)entity;
                UUID uuid = mob.method_5667();
                class_2338 pos = mob.method_24515();
                long newKey = SpatialPartitionModule.cellKey(pos);
                Long lastKey = lastCellKey.get(mob);
                if (lastKey == null) {
                    lastCellKey.put(mob, newKey);
                    SpatialPartitionModule.addMobToCell(uuid, pos);
                    continue;
                }
                if (lastKey == newKey) continue;
                SpatialPartitionModule.removeMobFromCell(uuid);
                SpatialPartitionModule.addMobToCell(uuid, pos);
                lastCellKey.put(mob, newKey);
            }
        });
    }
}

