/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.SpatialPartitionModule;
import com.example.soundattract.ai.SpatialPartitioner;
import com.example.soundattract.util.ThreadingChecks;
import com.example.soundattract.util.WorkerScheduler;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class MobGroupManager {
    private static List<Long> cellsToProcess = new ArrayList<Long>();
    private static int nextCellIndex = 0;
    public static int CELLS_PER_TICK = 20;
    public static int MOBS_PER_CELL_PER_TICK = 10;
    public static int MIN_CELLS_PER_TICK = 5;
    public static int MAX_CELLS_PER_TICK = 40;
    public static int MIN_MOBS_PER_CELL_PER_TICK = 3;
    public static int MAX_MOBS_PER_CELL_PER_TICK = 30;
    private static final Map<Long, Deque<class_1308>> cellEdgeMobs = new HashMap<Long, Deque<class_1308>>();
    private static final double EDGE_MARGIN = 2.0;
    private static final int EDGE_MOBS_PER_TICK = 4;
    private static final Map<UUID, class_1308> uuidToLeader = Collections.synchronizedMap(new HashMap());
    private static final List<WeakReference<class_1308>> leaders = Collections.synchronizedList(new ArrayList());
    private static final Map<class_1308, List<SoundRelay>> mobToRelayedSounds = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<class_1308, Long> mobLastRelayTime = Collections.synchronizedMap(new WeakHashMap());
    private static final Set<UUID> deserterUuids = Collections.synchronizedSet(new HashSet());
    private static long lastGroupUpdateTime = -1L;
    private static final int RELAY_SOUND_TTL = 40;
    private static final int RELAY_SOUND_RATE_LIMIT = 20;
    private static final double STICKY_RADIUS_MARGIN = 2.0;
    private static long lastCleanupTime = -1L;
    private static final Object cleanupLock = new Object();
    private static Map<class_1308, Set<class_1308>> lastEdgeMobEntityMap = new HashMap<class_1308, Set<class_1308>>();

    private static boolean isAttractedType(class_1308 mob) {
        String id = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        return SoundAttractMod.CONFIG.attractedEntities.contains(id);
    }

    private static boolean isEligibleLeader(class_1308 mob) {
        if (mob == null) {
            return false;
        }
        if (SoundAttractMod.CONFIG == null) {
            return false;
        }
        if (MobGroupManager.isAttractedType(mob)) {
            return true;
        }
        try {
            return SoundAttractMod.CONFIG.getMatchingProfile(mob) != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static boolean isEdgeMobEntity(class_1308 mob) {
        boolean isEdge;
        class_1308 leader;
        if (mob != null) {
            ThreadingChecks.warnIfOffServerThread(mob.method_37908(), "MobGroupManager.isEdgeMobEntity");
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[isEdgeMobEntity] Checking mob {} (pos: {}, {})", new Object[]{mob.method_5477().getString(), mob.method_23317(), mob.method_23321()});
        }
        if ((leader = MobGroupManager.getLeader(mob)) == mob) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[isEdgeMobEntity] MobEntity {} is its own leader (not edge)", (Object)mob.method_5477().getString());
            }
            return false;
        }
        Set<class_1308> edgeSet = lastEdgeMobEntityMap.get(leader);
        boolean bl = isEdge = edgeSet != null && edgeSet.contains(mob);
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[isEdgeMobEntity] MobEntity {} edge result: {} (from cache)", (Object)mob.method_5477().getString(), (Object)isEdge);
        }
        return isEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupStaleEntries(class_3218 level) {
        Object object = cleanupLock;
        synchronized (object) {
            Object object2 = leaders;
            synchronized (object2) {
                leaders.removeIf(ref -> {
                    class_1308 mob = (class_1308)ref.get();
                    return mob == null || mob.method_31481();
                });
            }
            object2 = uuidToLeader;
            synchronized (object2) {
                uuidToLeader.keySet().removeIf(uuid -> {
                    class_1308 mob = uuidToLeader.get(uuid);
                    return mob == null || mob.method_31481();
                });
            }
            object2 = mobToRelayedSounds;
            synchronized (object2) {
                mobToRelayedSounds.keySet().removeIf(mob -> mob == null || mob.method_31481());
            }
            object2 = mobLastRelayTime;
            synchronized (object2) {
                mobLastRelayTime.keySet().removeIf(mob -> mob == null || mob.method_31481());
            }
            object2 = deserterUuids;
            synchronized (object2) {
                deserterUuids.removeIf(uuid -> {
                    class_1308 mob = uuidToLeader.get(uuid);
                    return mob == null || mob.method_31481();
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public static void updateGroups(class_3218 level) {
        List group;
        class_2960 id;
        int cellsProcessed;
        ThreadingChecks.warnIfOffServerThread((class_1937)level, "MobGroupManager.updateGroups");
        double tps = 20.0;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.serverTpsSupplier != null) {
            tps = SoundAttractMod.CONFIG.serverTpsSupplier.get();
        } else if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.lastKnownTps > 0.0) {
            tps = SoundAttractMod.CONFIG.lastKnownTps;
        }
        if (SoundAttractMod.CONFIG != null) {
            MIN_CELLS_PER_TICK = SoundAttractMod.CONFIG.minCellsPerTick;
            MAX_CELLS_PER_TICK = SoundAttractMod.CONFIG.maxCellsPerTick;
            MIN_MOBS_PER_CELL_PER_TICK = SoundAttractMod.CONFIG.minMobsPerCellPerTick;
            MAX_MOBS_PER_CELL_PER_TICK = SoundAttractMod.CONFIG.maxMobsPerCellPerTick;
        }
        double clampedTps = Math.max(10.0, Math.min(20.0, tps));
        double tpsFrac = (clampedTps - 10.0) / 10.0;
        CELLS_PER_TICK = (int)Math.round((double)MIN_CELLS_PER_TICK + (double)(MAX_CELLS_PER_TICK - MIN_CELLS_PER_TICK) * tpsFrac);
        MOBS_PER_CELL_PER_TICK = (int)Math.round((double)MIN_MOBS_PER_CELL_PER_TICK + (double)(MAX_MOBS_PER_CELL_PER_TICK - MIN_MOBS_PER_CELL_PER_TICK) * tpsFrac);
        if (MIN_CELLS_PER_TICK == MAX_CELLS_PER_TICK) {
            CELLS_PER_TICK = MIN_CELLS_PER_TICK;
        }
        if (MIN_MOBS_PER_CELL_PER_TICK == MAX_MOBS_PER_CELL_PER_TICK) {
            MOBS_PER_CELL_PER_TICK = MIN_MOBS_PER_CELL_PER_TICK;
        }
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] TPS: {} | CELLS_PER_TICK: {} | MOBS_PER_CELL_PER_TICK: {}", new Object[]{tps, CELLS_PER_TICK, MOBS_PER_CELL_PER_TICK});
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] updateGroups called at game time {}", (Object)level.method_8510());
        }
        long time = level.method_8510();
        int scanCooldown = DynamicScanCooldownManager.currentScanCooldownTicks;
        int groupAssignInterval = DynamicScanCooldownManager.getGroupAssignmentInterval();
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.groupUpdateInterval > 0) {
            groupAssignInterval = SoundAttractMod.CONFIG.groupUpdateInterval;
        }
        if (lastGroupUpdateTime >= 0L && time - lastGroupUpdateTime < (long)groupAssignInterval) {
            return;
        }
        lastGroupUpdateTime = time;
        if (scanCooldown > 0 && (lastCleanupTime == -1L || time - lastCleanupTime > 10L * (long)scanCooldown)) {
            MobGroupManager.cleanupStaleEntries(level);
            lastCleanupTime = time;
        }
        List<String> attracted = SoundAttractMod.CONFIG.attractedEntities.stream().map(Object::toString).toList();
        HashMap<class_1308, class_2960> mobIdMap = new HashMap<class_1308, class_2960>();
        if (cellsToProcess.isEmpty()) {
            cellsToProcess.addAll((Collection<Long>)SpatialPartitionModule.cellToMobUuids.keySet());
            nextCellIndex = 0;
        }
        ArrayList<class_1308> mobs = new ArrayList<class_1308>();
        block3: for (cellsProcessed = 0; nextCellIndex < cellsToProcess.size() && cellsProcessed < CELLS_PER_TICK; ++nextCellIndex, ++cellsProcessed) {
            Long cellKey = cellsToProcess.get(nextCellIndex);
            LongOpenHashSet uuidSet = (LongOpenHashSet)SpatialPartitionModule.cellToMobUuids.get((Object)cellKey);
            if (uuidSet == null) continue;
            int mobsProcessed = 0;
            LongIterator longIterator = uuidSet.iterator();
            block4: while (longIterator.hasNext()) {
                long uuidLsb = (Long)longIterator.next();
                if (mobsProcessed >= MOBS_PER_CELL_PER_TICK) continue block3;
                for (UUID uuid : SpatialPartitionModule.uuidToMobCache.keySet()) {
                    if (uuid.getLeastSignificantBits() != uuidLsb) continue;
                    class_1308 mob = SpatialPartitionModule.getMobFromCache(uuid);
                    if (mob != null && mob.method_5805()) {
                        if (!MobGroupManager.isAttractedType(mob)) continue;
                        class_2960 id2 = class_7923.field_41177.method_10221((Object)mob.method_5864());
                        mobIdMap.put(mob, id2);
                        if (attracted.contains(id2.toString())) {
                            mobs.add(mob);
                        }
                    }
                    ++mobsProcessed;
                    continue block4;
                }
            }
        }
        if (nextCellIndex >= cellsToProcess.size()) {
            cellsToProcess.clear();
            nextCellIndex = 0;
        }
        if (cellsProcessed == 0) {
            return;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            StringBuilder allMobEntityTypesLog = new StringBuilder();
            for (class_1308 mob : mobs) {
                id = (class_2960)mobIdMap.get(mob);
                allMobEntityTypesLog.append(String.format("%s at (%.1f, %.1f, %.1f); ", id.toString(), mob.method_23317(), mob.method_23318(), mob.method_23321()));
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] All mobs present ({}): {}", (Object)mobs.size(), (Object)allMobEntityTypesLog.toString());
        }
        ArrayList<class_1308> attractedMobEntities = new ArrayList<class_1308>();
        for (class_1308 mob : mobs) {
            id = (class_2960)mobIdMap.get(mob);
            if (!attracted.contains(id.toString())) continue;
            attractedMobEntities.add(mob);
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            StringBuilder mobPosLog = new StringBuilder();
            for (class_1308 mob : attractedMobEntities) {
                mobPosLog.append(String.format("%s at (%.1f, %.1f, %.1f); ", mob.method_5477().getString(), mob.method_23317(), mob.method_23318(), mob.method_23321()));
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] Attracted mobs ({}): {}", (Object)attractedMobEntities.size(), (Object)mobPosLog.toString());
        }
        uuidToLeader.clear();
        leaders.clear();
        for (class_1308 m2 : attractedMobEntities) {
            if (SoundAttractMod.CONFIG.getMatchingProfile(m2) == null) continue;
            leaders.add(new WeakReference<class_1308>(m2));
            uuidToLeader.put(m2.method_5667(), m2);
            if (!SoundAttractMod.CONFIG.debugLogging) continue;
            SoundAttractMod.LOGGER.info("[MobGroupManager] Profiled mob {} forced to leader", (Object)class_7923.field_41177.method_10221((Object)m2.method_5864()));
        }
        if (attractedMobEntities.isEmpty()) {
            return;
        }
        double groupRadius = SoundAttractMod.CONFIG.groupDistance;
        int maxGroupSize = SoundAttractMod.CONFIG.maxGroupSize;
        double cellSize = groupRadius;
        int maxLeadersCfg = SoundAttractMod.CONFIG.maxLeaders;
        double leaderSpacingMult = SoundAttractMod.CONFIG.leaderSpacingMultiplier;
        double leaderSpacingDist = groupRadius * Math.max(0.0, leaderSpacingMult);
        HashMap<Long, List> cellToMobs = new HashMap<Long, List>();
        for (class_1308 mob : attractedMobEntities) {
            long cellKey = SpatialPartitioner.getKey(new class_2338((int)mob.method_23317(), 0, (int)mob.method_23321()), SoundAttractMod.CONFIG.spatialPartitionSize);
            cellToMobs.computeIfAbsent(cellKey, k -> new ArrayList()).add(mob);
        }
        int leaderCount = 0;
        int totalGroupSize = 0;
        HashMap<class_1308, List<class_1308>> leaderToGroup = new HashMap<class_1308, List<class_1308>>();
        ArrayList<class_1308> assignedLeaders = new ArrayList<class_1308>();
        for (Map.Entry entry : cellToMobs.entrySet()) {
            group = (List)entry.getValue();
            if (group.isEmpty()) continue;
            for (class_1308 mob : group) {
                class_1308 currentLeader = uuidToLeader.get(mob.method_5667());
                class_1308 nearestLeader = currentLeader != null && currentLeader.method_5805() ? currentLeader : null;
                double nearestDistSq = Double.MAX_VALUE;
                if (nearestLeader == null) {
                    for (class_1308 leader : assignedLeaders) {
                        double distSq;
                        int size;
                        if (maxGroupSize > 0 && (size = leaderToGroup.getOrDefault(leader, Collections.emptyList()).size()) >= maxGroupSize || !((distSq = mob.method_5858((class_1297)leader)) <= groupRadius * groupRadius) || !(distSq < nearestDistSq)) continue;
                        nearestLeader = leader;
                        nearestDistSq = distSq;
                    }
                    if (nearestLeader == null) {
                        for (WeakReference ref : leaders) {
                            double distSq;
                            int size;
                            class_1308 existing = (class_1308)ref.get();
                            if (existing == null || existing.method_31481() || maxGroupSize > 0 && (size = leaderToGroup.getOrDefault(existing, Collections.emptyList()).size()) >= maxGroupSize || !((distSq = mob.method_5858((class_1297)existing)) <= groupRadius * groupRadius) || !(distSq < nearestDistSq)) continue;
                            nearestLeader = existing;
                            nearestDistSq = distSq;
                        }
                    }
                    if (nearestLeader == null) {
                        boolean underMax = maxLeadersCfg <= 0 || leaders.size() < maxLeadersCfg;
                        boolean respectsSpacing = true;
                        if (leaderSpacingDist > 0.0) {
                            for (WeakReference<class_1308> ref : leaders) {
                                class_1308 existing = (class_1308)ref.get();
                                if (existing == null || existing.method_31481() || !(mob.method_5858((class_1297)existing) < leaderSpacingDist * leaderSpacingDist)) continue;
                                respectsSpacing = false;
                                break;
                            }
                        }
                        if (underMax && respectsSpacing) {
                            assignedLeaders.add(mob);
                            leaders.add(new WeakReference<class_1308>(mob));
                            ++leaderCount;
                            nearestLeader = mob;
                        }
                    }
                }
                if (nearestLeader == null) continue;
                if (maxGroupSize > 0) {
                    List curGroup = leaderToGroup.computeIfAbsent(nearestLeader, k -> new ArrayList());
                    if (curGroup.size() >= maxGroupSize) continue;
                    uuidToLeader.put(mob.method_5667(), nearestLeader);
                    curGroup.add(mob);
                    ++totalGroupSize;
                    continue;
                }
                uuidToLeader.put(mob.method_5667(), nearestLeader);
                leaderToGroup.computeIfAbsent(nearestLeader, k -> new ArrayList()).add(mob);
                ++totalGroupSize;
            }
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            double avgGroupSize = leaderCount > 0 ? (double)totalGroupSize / (double)leaderCount : 0.0;
            SoundAttractMod.LOGGER.info("[MobGroupManager] Grouped {} mobs into {} groups (avg group size: {:.2f})", new Object[]{attractedMobEntities.size(), leaderCount, avgGroupSize});
        }
        MobGroupManager.submitEdgeSelectionAsync(leaderToGroup);
        for (class_1308 mob : attractedMobEntities) {
            if (!uuidToLeader.containsKey(mob.method_5667())) {
                deserterUuids.add(mob.method_5667());
                if (!SoundAttractMod.CONFIG.debugLogging) continue;
                SoundAttractMod.LOGGER.info("[MobGroupManager] MobEntity {} marked as DESERTER (not in any group)", (Object)mob.method_5477().getString());
                continue;
            }
            deserterUuids.remove(mob.method_5667());
        }
        lastEdgeMobEntityMap.clear();
        for (class_1308 leader : leaderToGroup.keySet()) {
            Object m32;
            group = (List)leaderToGroup.get(leader);
            if (group == null) continue;
            int sectors = SoundAttractMod.CONFIG.numEdgeSectors;
            int edgePerSector = Math.max(0, SoundAttractMod.CONFIG.edgeMobsPerSector);
            HashMap<Integer, List> sectorToFarthestList = new HashMap<Integer, List>();
            double leaderX = leader.method_23317();
            double leaderZ = leader.method_23321();
            for (Object m32 : group) {
                if (m32 == leader) continue;
                double dx2 = m32.method_23317() - leaderX;
                double dz2 = m32.method_23321() - leaderZ;
                double angle = Math.atan2(dz2, dx2);
                int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                sectorToFarthestList.computeIfAbsent(sector, k -> new ArrayList()).add(m32);
            }
            HashSet<class_1308> edgeMobEntities = new HashSet<class_1308>();
            m32 = sectorToFarthestList.entrySet().iterator();
            while (m32.hasNext()) {
                Map.Entry entry2 = (Map.Entry)m32.next();
                List mobsInSector = (List)entry2.getValue();
                mobsInSector.sort((a, b) -> Double.compare(b.method_5739((class_1297)leader), a.method_5739((class_1297)leader)));
                int edgeCount = Math.min(edgePerSector, mobsInSector.size());
                if (edgeCount == 0 && !mobsInSector.isEmpty()) {
                    edgeCount = 1;
                }
                for (int i = 0; i < edgeCount; ++i) {
                    edgeMobEntities.add((class_1308)mobsInSector.get(i));
                }
            }
            if (edgeMobEntities.isEmpty() && group.size() > 1) {
                class_1308 farthest = null;
                double maxDist = -1.0;
                for (class_1308 m4 : group) {
                    double dist;
                    if (m4 == leader || !((dist = (double)m4.method_5739((class_1297)leader)) > maxDist)) continue;
                    maxDist = dist;
                    farthest = m4;
                }
                if (farthest != null) {
                    edgeMobEntities.add(farthest);
                }
            }
            lastEdgeMobEntityMap.put(leader, edgeMobEntities);
            if (!SoundAttractMod.CONFIG.debugLogging) continue;
            StringBuilder sb = new StringBuilder();
            for (class_1308 edge : edgeMobEntities) {
                sb.append(edge.method_5477().getString()).append(", ");
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] Edge mobs for leader {} (sync): {}", (Object)leader.method_5477().getString(), (Object)sb.toString());
        }
        mobToRelayedSounds.entrySet().removeIf(e -> ((class_1308)e.getKey()).method_31481());
        for (List relays : mobToRelayedSounds.values()) {
            relays.removeIf(r -> time - r.timestamp > 40L);
        }
        mobLastRelayTime.entrySet().removeIf(e -> ((class_1308)e.getKey()).method_31481());
        ArrayList<class_1308> allAttractedMobEntities = new ArrayList<class_1308>();
        class_238 worldBox = new class_238(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (class_1308 mob : level.method_8390(class_1308.class, worldBox, m -> true)) {
            if (!MobGroupManager.isAttractedType(mob)) continue;
            allAttractedMobEntities.add(mob);
        }
        Set<UUID> set = deserterUuids;
        synchronized (set) {
            for (class_1308 mob : allAttractedMobEntities) {
                boolean isGrouped;
                class_1308 leader = uuidToLeader.get(mob.method_5667());
                boolean bl = isGrouped = leader != null && leader != mob;
                if (!isGrouped) {
                    deserterUuids.add(mob.method_5667());
                    if (!SoundAttractMod.CONFIG.debugLogging) continue;
                    SoundAttractMod.LOGGER.info("[MobGroupManager] MobEntity {} marked as DESERTER", (Object)mob.method_5477().getString());
                    continue;
                }
                deserterUuids.remove(mob.method_5667());
            }
        }
    }

    private static long offsetCellKey(long baseKey, int dx, int dz, double cellSize) {
        long cellX = baseKey >> 32;
        long cellZ = baseKey & 0xFFFFFFFFL;
        return cellX + (long)dx << 32 | cellZ + (long)dz & 0xFFFFFFFFL;
    }

    public static void relaySoundToLeader(class_1308 mob, double x, double y, double z, double range, double weight, long timestamp) {
        class_1308 leader;
        if (mob != null) {
            ThreadingChecks.warnIfOffServerThread(mob.method_37908(), "MobGroupManager.relaySoundToLeader");
        }
        if ((leader = MobGroupManager.getLeader(mob)) == mob) {
            return;
        }
        Long lastRelay = mobLastRelayTime.get(mob);
        if (lastRelay != null && timestamp - lastRelay < 20L) {
            return;
        }
        mobLastRelayTime.put(mob, timestamp);
        SoundRelay relay = new SoundRelay(x, y, z, range, weight, timestamp);
        List relays = mobToRelayedSounds.computeIfAbsent(leader, k -> new ArrayList());
        if (!relays.contains(relay)) {
            relays.add(relay);
        }
    }

    public static List<SoundRelay> consumeRelayedSounds(class_1308 leader) {
        List<SoundRelay> relays;
        if (leader != null) {
            ThreadingChecks.warnIfOffServerThread(leader.method_37908(), "MobGroupManager.consumeRelayedSounds");
        }
        if ((relays = mobToRelayedSounds.remove(leader)) == null) {
            return Collections.emptyList();
        }
        long now = leader.method_37908().method_8510();
        HashSet<SoundRelay> deduped = new HashSet<SoundRelay>();
        for (SoundRelay r : relays) {
            if (now - r.timestamp > 40L) continue;
            deduped.add(r);
        }
        return new ArrayList<SoundRelay>(deduped);
    }

    public static class_1308 getLeader(class_1308 mob) {
        return uuidToLeader.getOrDefault(mob.method_5667(), mob);
    }

    public static void promoteToDeserter(class_1308 mob) {
        deserterUuids.add(mob.method_5667());
    }

    public static boolean isDeserter(class_1308 mob) {
        return deserterUuids.contains(mob.method_5667());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCellGroup(long cellKey, class_3218 level) {
        int i;
        Object candidate2;
        ThreadingChecks.warnIfOffServerThread((class_1937)level, "MobGroupManager.updateCellGroup");
        List<String> attracted = SoundAttractMod.CONFIG.attractedEntities.stream().map(Object::toString).toList();
        ArrayList<class_1308> mobsInCell = new ArrayList<class_1308>();
        LongOpenHashSet uuidSet = (LongOpenHashSet)SpatialPartitionModule.cellToMobUuids.get(cellKey);
        if (uuidSet == null || uuidSet.isEmpty()) {
            return;
        }
        for (UUID uuid : SpatialPartitionModule.uuidToMobCache.keySet()) {
            class_1308 mob;
            if (!uuidSet.contains(uuid.getLeastSignificantBits()) || (mob = SpatialPartitionModule.getMobFromCache(uuid)) == null || !mob.method_5805() || !MobGroupManager.isAttractedType(mob)) continue;
            mobsInCell.add(mob);
        }
        if (mobsInCell.isEmpty()) {
            return;
        }
        int maxLeadersCfg = SoundAttractMod.CONFIG.maxLeaders;
        int maxGroupSize = SoundAttractMod.CONFIG.maxGroupSize;
        double groupRadius = SoundAttractMod.CONFIG.groupDistance;
        double spacingMult = SoundAttractMod.CONFIG.leaderSpacingMultiplier;
        double spacingDist = groupRadius * Math.max(0.0, spacingMult);
        Object leader = null;
        Deque edgeBuffer = cellEdgeMobs.computeIfAbsent(cellKey, k -> new LinkedList());
        edgeBuffer.clear();
        double cellSize = SpatialPartitionModule.cellSize;
        long cellX = cellKey >> 32;
        long cellZ = cellKey & 0xFFFFFFFFL;
        double minX = (double)cellX * cellSize;
        double minZ = (double)cellZ * cellSize;
        double maxX = minX + cellSize;
        double maxZ = minZ + cellSize;
        for (Object candidate2 : mobsInCell) {
            if (!MobGroupManager.isEligibleLeader(candidate2)) continue;
            boolean alreadyLeader = false;
            for (WeakReference<class_1308> ref : leaders) {
                if (ref.get() != candidate2) continue;
                alreadyLeader = true;
                break;
            }
            if (!alreadyLeader) {
                if (maxLeadersCfg > 0 && leaders.size() >= maxLeadersCfg) {
                    class_1308 nearestExisting = null;
                    double best = Double.MAX_VALUE;
                    for (WeakReference<class_1308> ref : leaders) {
                        double d2;
                        class_1308 ex = (class_1308)ref.get();
                        if (ex == null || ex.method_31481() || !((d2 = candidate2.method_5858((class_1297)ex)) <= groupRadius * groupRadius) || !(d2 < best)) continue;
                        best = d2;
                        nearestExisting = ex;
                    }
                    if (nearestExisting == null) continue;
                    leader = nearestExisting;
                    break;
                }
                if (spacingDist > 0.0) {
                    boolean tooClose = false;
                    for (WeakReference<class_1308> ref : leaders) {
                        class_1308 ex = (class_1308)ref.get();
                        if (ex == null || ex.method_31481() || !(candidate2.method_5858((class_1297)ex) < spacingDist * spacingDist)) continue;
                        tooClose = true;
                        break;
                    }
                    if (tooClose) {
                        WeakReference<class_1308> ref;
                        class_1308 nearestExisting = null;
                        double best = Double.MAX_VALUE;
                        ref = leaders.iterator();
                        while (ref.hasNext()) {
                            double d2;
                            WeakReference ref2 = (WeakReference)ref.next();
                            class_1308 ex = (class_1308)ref2.get();
                            if (ex == null || ex.method_31481() || !((d2 = candidate2.method_5858((class_1297)ex)) < best)) continue;
                            best = d2;
                            nearestExisting = ex;
                        }
                        if (nearestExisting == null) continue;
                        leader = nearestExisting;
                        break;
                    }
                }
            }
            leader = candidate2;
            break;
        }
        if (leader == null) {
            return;
        }
        int currentGroupSize = 0;
        candidate2 = uuidToLeader;
        synchronized (candidate2) {
            for (class_1308 mappedLeader : uuidToLeader.values()) {
                if (mappedLeader != leader) continue;
                ++currentGroupSize;
            }
        }
        int assignedThisCall = 0;
        for (i = 0; i < mobsInCell.size(); ++i) {
            class_1308 mob = (class_1308)mobsInCell.get(i);
            if (mob == leader) {
                if (maxGroupSize <= 0 || currentGroupSize < maxGroupSize) {
                    uuidToLeader.put(mob.method_5667(), mob);
                    leaders.add(new WeakReference<class_1308>(mob));
                    ++currentGroupSize;
                    ++assignedThisCall;
                } else {
                    deserterUuids.add(mob.method_5667());
                }
            } else if (maxGroupSize <= 0 || currentGroupSize < maxGroupSize) {
                uuidToLeader.put(mob.method_5667(), (class_1308)leader);
                ++currentGroupSize;
                ++assignedThisCall;
            } else {
                deserterUuids.add(mob.method_5667());
            }
            double x = mob.method_23317();
            double z = mob.method_23321();
            if (!(x - minX < 2.0 || maxX - x < 2.0 || z - minZ < 2.0) && !(maxZ - z < 2.0)) continue;
            edgeBuffer.add(mob);
        }
        for (i = 0; i < 4 && !edgeBuffer.isEmpty(); ++i) {
            class_1308 edgeMob = (class_1308)edgeBuffer.poll();
            if (edgeMob == null || edgeMob.method_31481() || !edgeMob.method_5805()) continue;
            Object bestLeader = leader;
            double bestDist = edgeMob.method_5858((class_1297)leader);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dz == 0) continue;
                    long neighborCell = cellX + (long)dx << 32 | cellZ + (long)dz & 0xFFFFFFFFL;
                    ArrayList<class_1308> neighborMobs = new ArrayList<class_1308>();
                    LongOpenHashSet neighborUuids = (LongOpenHashSet)SpatialPartitionModule.cellToMobUuids.get(neighborCell);
                    if (neighborUuids != null) {
                        for (UUID uuid : SpatialPartitionModule.uuidToMobCache.keySet()) {
                            class_1308 nm;
                            if (!neighborUuids.contains(uuid.getLeastSignificantBits()) || (nm = SpatialPartitionModule.getMobFromCache(uuid)) == null || !nm.method_5805()) continue;
                            neighborMobs.add(nm);
                        }
                    }
                    for (class_1308 nm : neighborMobs) {
                        double d;
                        class_1308 nLeader = uuidToLeader.getOrDefault(nm.method_5667(), nm);
                        if (!MobGroupManager.isEligibleLeader(nLeader) || !((d = edgeMob.method_5858((class_1297)nLeader)) < bestDist)) continue;
                        bestLeader = nLeader;
                        bestDist = d;
                    }
                }
            }
            if (bestLeader != leader) {
                uuidToLeader.put(edgeMob.method_5667(), (class_1308)bestLeader);
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[EdgeMobOptimizer] Mob {} reassigned to closer leader {} (dist={})", new Object[]{edgeMob.method_5477().getString(), bestLeader.method_5477().getString(), Math.sqrt(bestDist)});
                }
            }
            if (!edgeMob.method_5805()) continue;
            edgeBuffer.add(edgeMob);
        }
        if (SoundAttractMod.CONFIG.debugLogging && leader != null) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] updateCellGroup: cellKey={} leader={} assigned={} (existingGroupSize now ~{})", new Object[]{cellKey, leader.method_5477().getString(), assignedThisCall, currentGroupSize});
        }
    }

    public static void scheduleCellsForSound(class_2338 soundPos, double range, class_3218 level, long currentTick) {
        ThreadingChecks.warnIfOffServerThread((class_1937)level, "MobGroupManager.scheduleCellsForSound");
        int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
        int gridRadius = (int)Math.ceil(range / (double)partitionSize);
        int baseX = soundPos.method_10263() / partitionSize;
        int baseZ = soundPos.method_10260() / partitionSize;
        for (int layer = 0; layer <= gridRadius; ++layer) {
            int tickDelay = layer;
            for (int dx = -layer; dx <= layer; ++dx) {
                for (int dz = -layer; dz <= layer; ++dz) {
                    if (Math.abs(dx) != layer && Math.abs(dz) != layer) continue;
                    int cellX = baseX + dx;
                    int cellZ = baseZ + dz;
                    long cellKey = (long)cellX << 32 | (long)cellZ & 0xFFFFFFFFL;
                    long scheduledTick = currentTick + (long)tickDelay;
                    DynamicScanCooldownManager.scheduler.scheduleCell(cellKey, 0, scheduledTick);
                }
            }
        }
    }

    public static void scheduleNearbyCellsForPlayers(class_3218 level, long currentTick) {
        ThreadingChecks.warnIfOffServerThread((class_1937)level, "MobGroupManager.scheduleNearbyCellsForPlayers");
        int[] tierRadii = new int[]{3, 5, 8, 12};
        for (class_3222 player : level.method_18456()) {
            class_2338 pos = player.method_24515();
            for (int tier = 0; tier < tierRadii.length; ++tier) {
                int radius = tierRadii[tier];
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        long cellKey = SpatialPartitionModule.cellKey(pos.method_10069(dx * SpatialPartitionModule.cellSize, 0, dz * SpatialPartitionModule.cellSize));
                        DynamicScanCooldownManager.scheduler.scheduleCell(cellKey, tier, currentTick);
                    }
                }
            }
        }
    }

    public static void applyGroupResult(WorkerScheduler.GroupComputeResult result) {
        if (result == null || result.data == null) {
            return;
        }
        class_1937 guardWorld = null;
        Iterator<UUID> iterator = result.data;
        if (iterator instanceof GroupEdgeComputeOutput) {
            GroupEdgeComputeOutput edgeOut = (GroupEdgeComputeOutput)((Object)iterator);
            iterator = edgeOut.leaderToEdgeUuids.keySet().iterator();
            while (iterator.hasNext()) {
                UUID leaderId = iterator.next();
                class_1308 leaderRef = SpatialPartitionModule.getMobFromCache(leaderId);
                if (leaderRef == null) continue;
                guardWorld = leaderRef.method_37908();
                break;
            }
        }
        if (guardWorld != null) {
            ThreadingChecks.warnIfOffServerThread(guardWorld, "MobGroupManager.applyGroupResult");
        }
        if ((iterator = result.data) instanceof GroupEdgeComputeOutput) {
            GroupEdgeComputeOutput out = (GroupEdgeComputeOutput)((Object)iterator);
            HashMap newMap = new HashMap();
            for (Map.Entry<UUID, Set<UUID>> e : out.leaderToEdgeUuids.entrySet()) {
                class_1308 leader = SpatialPartitionModule.getMobFromCache(e.getKey());
                if (leader == null || leader.method_31481()) continue;
                HashSet<class_1308> edges = new HashSet<class_1308>();
                for (UUID edgeUuid : e.getValue()) {
                    class_1308 mob = SpatialPartitionModule.getMobFromCache(edgeUuid);
                    if (mob == null || !mob.method_5805()) continue;
                    edges.add(mob);
                }
                if (edges.isEmpty()) continue;
                newMap.put(leader, edges);
            }
            if (!newMap.isEmpty()) {
                lastEdgeMobEntityMap.clear();
                lastEdgeMobEntityMap.putAll(newMap);
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.debug("[MobGroupManager] Applied async edge selection for {} groups.", (Object)newMap.size());
                }
            }
        } else if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.debug("[MobGroupManager] Ignoring unknown group result type: {}", (Object)result.data.getClass().getName());
        }
    }

    private static void submitEdgeSelectionAsync(Map<class_1308, List<class_1308>> leaderToGroup) {
        if (leaderToGroup == null || leaderToGroup.isEmpty()) {
            return;
        }
        ArrayList<LeaderGroupSnapshot> groupSnaps = new ArrayList<LeaderGroupSnapshot>();
        for (Map.Entry<class_1308, List<class_1308>> e : leaderToGroup.entrySet()) {
            class_1308 leader = e.getKey();
            if (leader == null || leader.method_31481()) continue;
            ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
            for (class_1308 m : e.getValue()) {
                if (m == null || m.method_31481()) continue;
                members.add(new MemberInfo(m.method_5667(), m.method_23317(), m.method_23321()));
            }
            groupSnaps.add(new LeaderGroupSnapshot(leader.method_5667(), leader.method_23317(), leader.method_23321(), members));
        }
        GroupEdgeSnapshot snapshot = new GroupEdgeSnapshot(groupSnaps);
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.debug("[MobGroupManager] Submitting async group edge compute for {} groups", (Object)groupSnaps.size());
        }
        WorkerScheduler.submitGroupTask(() -> {
            int sectors = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.numEdgeSectors : 8;
            int edgePerSector = 4;
            HashMap<UUID, Set<UUID>> out = new HashMap<UUID, Set<UUID>>();
            for (LeaderGroupSnapshot g : snapshot.groups) {
                if (g == null || g.members == null || g.members.isEmpty()) continue;
                HashMap<Integer, List> sectorMap = new HashMap<Integer, List>();
                for (MemberInfo memberInfo : g.members) {
                    if (memberInfo.uuid.equals(g.leaderUuid)) continue;
                    double dx = memberInfo.x - g.leaderX;
                    double dz = memberInfo.z - g.leaderZ;
                    double angle = Math.atan2(dz, dx);
                    int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                    sectorMap.computeIfAbsent(sector, k -> new ArrayList()).add(memberInfo);
                }
                HashSet<UUID> edges = new HashSet<UUID>();
                for (List list : sectorMap.values()) {
                    list.sort((a, b) -> {
                        double da = (a.x - g.leaderX) * (a.x - g.leaderX) + (a.z - g.leaderZ) * (a.z - g.leaderZ);
                        double db = (b.x - g.leaderX) * (b.x - g.leaderX) + (b.z - g.leaderZ) * (b.z - g.leaderZ);
                        return Double.compare(db, da);
                    });
                    int edgeCount = Math.min(edgePerSector, list.size());
                    if (edgeCount == 0 && !list.isEmpty()) {
                        edgeCount = 1;
                    }
                    for (int i = 0; i < edgeCount; ++i) {
                        edges.add(((MemberInfo)list.get((int)i)).uuid);
                    }
                }
                if (edges.isEmpty() && g.members.size() > 1) {
                    void var8_13;
                    Object var8_12 = null;
                    double max = -1.0;
                    for (MemberInfo mi3 : g.members) {
                        double d;
                        if (mi3.uuid.equals(g.leaderUuid) || !((d = (mi3.x - g.leaderX) * (mi3.x - g.leaderX) + (mi3.z - g.leaderZ) * (mi3.z - g.leaderZ)) > max)) continue;
                        max = d;
                        MemberInfo memberInfo = mi3;
                    }
                    if (var8_13 != null) {
                        edges.add(var8_13.uuid);
                    }
                }
                if (edges.isEmpty()) continue;
                out.put(g.leaderUuid, edges);
            }
            return new WorkerScheduler.GroupComputeResult(new GroupEdgeComputeOutput(out));
        });
    }

    public static class SoundRelay {
        public final double x;
        public final double y;
        public final double z;
        public final double range;
        public final double weight;
        public final long timestamp;
        public final int hash;

        public SoundRelay(double x, double y, double z, double range, double weight, long timestamp) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.range = range;
            this.weight = weight;
            this.timestamp = timestamp;
            this.hash = Objects.hash((int)x, (int)y, (int)z, (int)range, (int)(weight * 100.0));
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoundRelay)) {
                return false;
            }
            SoundRelay other = (SoundRelay)o;
            return this.hash == other.hash && Math.abs(this.timestamp - other.timestamp) < 40L;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static final class GroupEdgeComputeOutput {
        final Map<UUID, Set<UUID>> leaderToEdgeUuids;

        GroupEdgeComputeOutput(Map<UUID, Set<UUID>> leaderToEdgeUuids) {
            this.leaderToEdgeUuids = leaderToEdgeUuids;
        }

        public String toString() {
            return "GroupEdgeComputeOutput{" + this.leaderToEdgeUuids.size() + " groups}";
        }
    }

    static final class MemberInfo {
        final UUID uuid;
        final double x;
        final double z;

        MemberInfo(UUID uuid, double x, double z) {
            this.uuid = uuid;
            this.x = x;
            this.z = z;
        }
    }

    static final class LeaderGroupSnapshot {
        final UUID leaderUuid;
        final double leaderX;
        final double leaderZ;
        final List<MemberInfo> members;

        LeaderGroupSnapshot(UUID leaderUuid, double leaderX, double leaderZ, List<MemberInfo> members) {
            this.leaderUuid = leaderUuid;
            this.leaderX = leaderX;
            this.leaderZ = leaderZ;
            this.members = members;
        }
    }

    static final class GroupEdgeSnapshot {
        final List<LeaderGroupSnapshot> groups;

        GroupEdgeSnapshot(List<LeaderGroupSnapshot> groups) {
            this.groups = groups;
        }
    }
}

