/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.PlayerStance;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class PlayerProfile {
    private final String profileName;
    @Nullable
    private final class_2487 nbtMatcher;
    private final Map<PlayerStance, Double> detectionOverrides;

    public PlayerProfile(String profileName, @Nullable class_2487 nbtMatcher, Map<PlayerStance, Double> detectionOverrides) {
        this.profileName = Objects.requireNonNull(profileName, "profileName");
        this.nbtMatcher = nbtMatcher;
        this.detectionOverrides = Map.copyOf(Objects.requireNonNull(detectionOverrides));
    }

    public Optional<Double> getDetectionOverride(PlayerStance stance) {
        return Optional.ofNullable(this.detectionOverrides.get((Object)stance));
    }

    public boolean matches(class_1657 player) {
        try {
            boolean isDebugging;
            if (player == null) {
                return false;
            }
            boolean bl = isDebugging = SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging;
            if (isDebugging) {
                SoundAttractMod.LOGGER.info("[PlayerProfile] Checking profile '{}' for player '{}'", (Object)this.profileName, (Object)player.method_5477().getString());
            }
            if (this.nbtMatcher == null || this.nbtMatcher.method_33133()) {
                if (isDebugging) {
                    SoundAttractMod.LOGGER.info("[PlayerProfile] SUCCESS: Profile matched (no NBT matcher).");
                }
                return true;
            }
            class_2487 playerNbt = new class_2487();
            player.method_5647(playerNbt);
            if (isDebugging) {
                SoundAttractMod.LOGGER.info("[PlayerProfile] Player NBT to be checked: {}", (Object)playerNbt.method_10714());
                SoundAttractMod.LOGGER.info("[PlayerProfile] Matcher NBT to be used: {}", (Object)this.nbtMatcher.method_10714());
            }
            boolean result = this.checkNbt(playerNbt, this.nbtMatcher);
            if (isDebugging) {
                if (result) {
                    SoundAttractMod.LOGGER.info("[PlayerProfile] SUCCESS: Profile '{}' matched player '{}'.", (Object)this.profileName, (Object)player.method_5477().getString());
                } else {
                    SoundAttractMod.LOGGER.info("[PlayerProfile] FAILED: Profile '{}' did not match player '{}'.", (Object)this.profileName, (Object)player.method_5477().getString());
                }
            }
            return result;
        }
        catch (Throwable t) {
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.warn("[PlayerProfile] Match check failed for profile '{}': {}", (Object)this.profileName, (Object)t.getMessage());
            }
            return false;
        }
    }

    private boolean checkNbt(class_2487 playerNbt, class_2487 matcherNbt) {
        boolean isDebugging = SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging;
        for (String key : matcherNbt.method_10541()) {
            byte matcherType;
            if (!playerNbt.method_10573(key, (int)(matcherType = matcherNbt.method_10540(key)))) {
                if (isDebugging) {
                    SoundAttractMod.LOGGER.info("[PlayerProfile] Check failed: Player NBT does not contain key '{}' with matching type.", (Object)key);
                }
                return false;
            }
            if (matcherType == 10) {
                if (this.checkNbt(playerNbt.method_10562(key), matcherNbt.method_10562(key))) continue;
                return false;
            }
            if (matcherType == 9) {
                class_2499 matcherList = (class_2499)matcherNbt.method_10580(key);
                class_2520 rawPlayerTag = playerNbt.method_10580(key);
                if (!(rawPlayerTag instanceof class_2499)) {
                    if (isDebugging) {
                        SoundAttractMod.LOGGER.info("[PlayerProfile] Check failed: Player NBT for key '{}' is not a List.", (Object)key);
                    }
                    return false;
                }
                class_2499 playerList = (class_2499)rawPlayerTag;
                if (playerList.containsAll((Collection)matcherList)) continue;
                if (isDebugging) {
                    SoundAttractMod.LOGGER.info("[PlayerProfile] Check failed: Player list for key '{}' does not contain all matcher elements.", (Object)key);
                    SoundAttractMod.LOGGER.info("[PlayerProfile] -> Player List: {}", (Object)playerList.method_10714());
                    SoundAttractMod.LOGGER.info("[PlayerProfile] -> Matcher List: {}", (Object)matcherList.method_10714());
                }
                return false;
            }
            if (playerNbt.method_10580(key).equals((Object)matcherNbt.method_10580(key))) continue;
            if (isDebugging) {
                SoundAttractMod.LOGGER.info("[PlayerProfile] Check failed: Values for key '{}' do not match.", (Object)key);
                SoundAttractMod.LOGGER.info("[PlayerProfile] -> Player Value: {}", (Object)playerNbt.method_10580(key).method_10714());
                SoundAttractMod.LOGGER.info("[PlayerProfile] -> Matcher Value: {}", (Object)matcherNbt.method_10580(key).method_10714());
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "PlayerProfile{profileName='" + this.profileName + "'" + (String)(this.nbtMatcher != null ? ", nbtMatcher=" + this.nbtMatcher.method_10714() : "") + ", detectionOverrides=" + String.valueOf(this.detectionOverrides) + "}";
    }
}

