/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundOverride;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2522;

public class SoundAttractConfigData {
    private List<MobProfile> cachedMobProfiles = null;
    private List<PlayerProfile> cachedPlayerProfiles = null;
    private transient Map<String, Double> pointBlankGunShootRangesMap;
    private transient Map<String, Double> pointBlankAttachmentSoundReductionsMap;
    private transient Map<String, Double> pointBlankMuzzleFlashReductionsMap = null;
    public boolean debugLogging = false;
    private static final int CURRENT_SCHEMA_VERSION = 3;
    public int configSchemaVersion = 3;
    public int workerThreads = 0;
    public int workerQueueCapacity = 1024;
    public long workerTaskBudgetMs = 2L;
    public int asyncSubmitCooldownTicks = 10;
    public long asyncResultTtlMs = 2500L;
    public int soundLifetimeTicks = 200;
    public int scanCooldownTicks = 25;
    public double minTpsForScanCooldown = 10.0;
    public double maxTpsForScanCooldown = 20.0;
    public int cellsPerTick = 50;
    public int minCellsPerTick = 25;
    public int maxCellsPerTick = 100;
    public int mobsPerCellPerTick = 55;
    public int minMobsPerCellPerTick = 25;
    public int maxMobsPerCellPerTick = 100;
    public double lastKnownTps = 20.0;
    public Supplier<Double> serverTpsSupplier = null;
    public boolean useRangeInSoundSwitch = true;
    public double soundSwitchRatio = 0.7;
    public double soundNoveltyBonusWeight = 0.5;
    public int soundNoveltyTimeTicks = 100;
    public double arrivalDistance = 6.0;
    public double mobMoveSpeed = 1.15;
    public List<String> attractedEntities = new ArrayList<String>(List.of("minecraft:cave_spider", "minecraft:creeper", "minecraft:drowned", "minecraft:endermite", "minecraft:evoker", "minecraft:guardian", "minecraft:hoglin", "minecraft:husk", "minecraft:magma_cube", "minecraft:phantom", "minecraft:piglin", "minecraft:piglin_brute", "minecraft:pillager", "minecraft:ravager", "minecraft:shulker", "minecraft:silverfish", "minecraft:skeleton", "minecraft:slime", "minecraft:spider", "minecraft:stray", "minecraft:vex", "minecraft:vindicator", "minecraft:witch", "minecraft:wither_skeleton", "minecraft:zoglin", "minecraft:zombie", "minecraft:zombie_villager"));
    public boolean edgeMobSmartBehavior = false;
    public int edgeInvestigateWaitTicks = 15;
    public int spatialPartitionSize = 24;
    public double groupDistance = 128.0;
    public int maxGroupSize = 128;
    public int maxLeaders = 16;
    public double leaderSpacingMultiplier = 1.0;
    public int edgeMobsPerSector = 4;
    public double groupSprintMultiplier = 1.1;
    public double leaderReturnArrivalDistance = 2.0;
    public int groupUpdateInterval = 200;
    public int raidCountdownTicks = 200;
    public int numEdgeSectors = 6;
    public List<String> nonPlayerSoundIdList = new ArrayList<String>(List.of("minecraft:item.crossbow.shoot;16;4", "minecraft:item.crossbow.loading_start;6;2", "minecraft:item.crossbow.loading_middle;6;2", "minecraft:item.crossbow.loading_end;6;2", "minecraft:item.crossbow.quick_charge_1;6;2", "minecraft:item.crossbow.quick_charge_2;6;2", "minecraft:item.crossbow.quick_charge_3;6;2", "minecraft:entity.arrow.shoot;14;4", "minecraft:item.shield.block;12;3", "minecraft:block.lever.click;5;3", "minecraft:block.wooden_trapdoor.open;8;3", "minecraft:block.wooden_trapdoor.close;8;3", "minecraft:block.bamboo_wood_trapdoor.open;10;3", "minecraft:block.bamboo_wood_trapdoor.close;10;3", "minecraft:block.cherry_wood_trapdoor.open;10;3", "minecraft:block.cherry_wood_trapdoor.close;10;3", "minecraft:block.iron_trapdoor.open;15;4", "minecraft:block.iron_trapdoor.close;15;4", "minecraft:block.wooden_door.open;12;4", "minecraft:block.wooden_door.close;12;4", "minecraft:block.bamboo_wood_door.open;15;4", "minecraft:block.bamboo_wood_door.close;15;4", "minecraft:block.cherry_wood_door.open;15;4", "minecraft:block.cherry_wood_door.close;15;4", "minecraft:block.iron_door.open;20;5", "minecraft:block.iron_door.close;20;5", "minecraft:block.fence_gate.open;10;3", "minecraft:block.fence_gate.close;10;3", "minecraft:block.piston.extend;25;4", "minecraft:block.piston.contract;25;4", "minecraft:block.dispenser.dispense;12;4", "minecraft:block.dispenser.launch;12;4", "minecraft:block.anvil.land;45;5", "minecraft:block.anvil.use;35;5", "minecraft:block.anvil.destroy;30;5", "minecraft:block.sand.fall;6;3", "minecraft:block.gravel.fall;6;3", "minecraft:block.grass.break;3;2", "minecraft:block.scaffolding.break;3;2", "minecraft:entity.boat.paddle_water;8;3", "minecraft:ambient.underwater.enter;4;2", "minecraft:ambient.underwater.exit;4;2", "minecraft:block.chest.open;5;2", "minecraft:block.chest.close;5;2", "minecraft:block.barrel.open;5;2", "minecraft:block.barrel.close;5;2", "minecraft:block.ender_chest.open;6;2", "minecraft:block.ender_chest.close;6;2", "minecraft:block.shulker_box.open;6;2", "minecraft:block.shulker_box.close;6;2", "minecraft:block.bell.use;40;5", "minecraft:block.bell.resonate;25;4", "minecraft:block.furnace.fire_crackle;8;3", "minecraft:entity.generic.explode;50;7", "minecraft:entity.firework_rocket.launch;10;3", "minecraft:entity.firework_rocket.blast;20;5", "minecraft:entity.firework_rocket.large_blast;30;6", "musketmod:musket_fire;155;8", "musketmod:blunderbuss_fire;154;7", "musketmod:pistol_fire;164;5", "cgm:item.shotgun.fire;156;15", "cgm:item.shotgun.silenced_fire;131;13", "cgm:item.shotgun.enchanted_fire;156;15", "cgm:item.shotgun.cock;90;6", "cgm:item.rifle.fire;162;16", "cgm:item.rifle.silenced_fire;137;13", "cgm:item.rifle.enchanted_fire;162;16", "cgm:item.rifle.cock;90;6", "cgm:item.pistol.fire;164;16", "cgm:item.pistol.silenced_fire;139;13", "cgm:item.pistol.enchanted_fire;164;16", "cgm:item.pistol.reload;85;7", "cgm:item.pistol.cock;90;6", "cgm:item.assault_rifle.fire;159;16", "cgm:item.assault_rifle.silenced_fire;134;13", "cgm:item.assault_rifle.enchanted_fire;159;16", "cgm:item.assault_rifle.cock;90;6", "cgm:item.grenade_launcher.fire;172;17", "cgm:item.bazooka.fire;184;17", "cgm:item.mini_gun.fire;180;17", "cgm:item.mini_gun.enchanted_fire;180;17", "cgm:item.machine_pistol.fire;160;16", "cgm:item.machine_pistol.silenced_fire;135;13", "cgm:item.machine_pistol.enchanted_fire;160;16", "cgm:item.heavy_rifle.fire;165;16", "cgm:item.heavy_rifle.silenced_fire;140;13", "cgm:item.heavy_rifle.enchanted_fire;165;16", "cgm:item.heavy_rifle.cock;90;6", "cgm:item.grenade.pin;72;6", "cgm:entity.stun_grenade.explosion;175;18", "cgm:entity.stun_grenade.ring;104;10"));
    public List<String> soundIdWhitelist = new ArrayList<String>(List.of("minecraft:item.crossbow.shoot", "minecraft:item.crossbow.loading_start", "minecraft:item.crossbow.loading_middle", "minecraft:item.crossbow.loading_end", "minecraft:item.crossbow.quick_charge_1", "minecraft:item.crossbow.quick_charge_2", "minecraft:item.crossbow.quick_charge_3", "minecraft:entity.arrow.shoot", "minecraft:item.shield.block", "minecraft:block.lever.click", "minecraft:block.wooden_trapdoor.open", "minecraft:block.wooden_trapdoor.close", "minecraft:block.bamboo_wood_trapdoor.open", "minecraft:block.bamboo_wood_trapdoor.close", "minecraft:block.cherry_wood_trapdoor.open", "minecraft:block.cherry_wood_trapdoor.close", "minecraft:block.iron_trapdoor.open", "minecraft:block.iron_trapdoor.close", "minecraft:block.wooden_door.open", "minecraft:block.wooden_door.close", "minecraft:block.bamboo_wood_door.open", "minecraft:block.bamboo_wood_door.close", "minecraft:block.cherry_wood_door.open", "minecraft:block.cherry_wood_door.close", "minecraft:block.iron_door.open", "minecraft:block.iron_door.close", "minecraft:block.fence_gate.open", "minecraft:block.fence_gate.close", "minecraft:block.piston.extend", "minecraft:block.piston.contract", "minecraft:block.dispenser.dispense", "minecraft:block.dispenser.launch", "minecraft:block.anvil.land", "minecraft:block.anvil.use", "minecraft:block.anvil.destroy", "minecraft:block.sand.fall", "minecraft:block.gravel.fall", "minecraft:block.grass.break", "minecraft:block.scaffolding.break", "minecraft:entity.boat.paddle_water", "minecraft:ambient.underwater.enter", "minecraft:ambient.underwater.exit", "minecraft:block.chest.open", "minecraft:block.chest.close", "minecraft:block.barrel.open", "minecraft:block.barrel.close", "minecraft:block.ender_chest.open", "minecraft:block.ender_chest.close", "minecraft:block.shulker_box.open", "minecraft:block.shulker_box.close", "minecraft:block.bell.use", "minecraft:block.furnace.fire_crackle", "minecraft:entity.generic.explode", "minecraft:entity.firework_rocket.launch", "minecraft:entity.firework_rocket.blast", "minecraft:entity.firework_rocket.large_blast", "minecraft:random/anvil_land", "entity/leashknot/place1", "minecraft:entity.player.sprint", "minecraft:entity.player.jump", "minecraft:entity.player.sneak", "soundattract:voice_chat", "musketmod:musket_fire", "musketmod:blunderbuss_fire", "musketmod:pistol_fire", "cgm:item.shotgun.fire", "cgm:item.shotgun.silenced_fire", "cgm:item.shotgun.enchanted_fire", "cgm:item.shotgun.cock", "cgm:item.rifle.fire", "cgm:item.rifle.silenced_fire", "cgm:item.rifle.enchanted_fire", "cgm:item.rifle.cock", "cgm:item.pistol.fire", "cgm:item.pistol.silenced_fire", "cgm:item.pistol.enchanted_fire", "cgm:item.pistol.reload", "cgm:item.pistol.cock", "cgm:item.assault_rifle.fire", "cgm:item.assault_rifle.silenced_fire", "cgm:item.assault_rifle.enchanted_fire", "cgm:item.assault_rifle.cock", "cgm:item.grenade_launcher.fire", "cgm:item.bazooka.fire", "cgm:item.mini_gun.fire", "cgm:item.mini_gun.enchanted_fire", "cgm:item.machine_pistol.fire", "cgm:item.machine_pistol.silenced_fire", "cgm:item.machine_pistol.enchanted_fire", "cgm:item.heavy_rifle.fire", "cgm:item.heavy_rifle.silenced_fire", "cgm:item.heavy_rifle.enchanted_fire", "cgm:item.heavy_rifle.cock", "cgm:item.grenade.pin", "cgm:entity.stun_grenade.explosion", "cgm:entity.stun_grenade.ring", "pointblank:gun_action"));
    public int mufflingAreaRadius = 0;
    public boolean woolMufflingEnabled = true;
    public List<String> customWoolBlocks = new ArrayList<String>();
    public int woolBlockRangeReduction = 6;
    public double woolBlockWeightReduction = 0.6;
    public boolean solidMufflingEnabled = true;
    public List<String> customSolidBlocks = new ArrayList<String>();
    public int solidBlockRangeReduction = 4;
    public double solidBlockWeightReduction = 0.4;
    public boolean nonSolidMufflingEnabled = true;
    public List<String> customNonSolidBlocks = new ArrayList<String>();
    public int nonSolidBlockRangeReduction = 3;
    public double nonSolidBlockWeightReduction = 0.3;
    public boolean thinMufflingEnabled = true;
    public List<String> customThinBlocks = new ArrayList<String>();
    public int thinBlockRangeReduction = 2;
    public double thinBlockWeightReduction = 0.2;
    public boolean liquidMufflingEnabled = true;
    public List<String> customLiquidBlocks = new ArrayList<String>();
    public int liquidBlockRangeReduction = 1;
    public double liquidBlockWeightReduction = 0.1;
    public List<String> fovOverrides = new ArrayList<String>(List.of("minecraft:spider, 360.0, 360.0", "minecraft:cave_spider, 360.0, 360.0", "minecraft:phantom, 200.0, 280.0", "minecraft:vex, 200.0, 280.0", "minecraft:allay, 200.0, 280.0", "minecraft:bat, 20.0, 20.0", "minecraft:parrot, 200.0, 280.0", "minecraft:ghast, 200.0, 280.0", "minecraft:blaze, 200.0, 280.0", "minecraft:axolotl, 270.0, 90.0", "minecraft:camel, 270.0, 90.0", "minecraft:chicken, 270.0, 90.0", "minecraft:cow, 270.0, 90.0", "minecraft:donkey, 270.0, 90.0", "minecraft:goat, 270.0, 90.0", "minecraft:horse, 270.0, 90.0", "minecraft:mule, 270.0, 90.0", "minecraft:mooshroom, 270.0, 90.0", "minecraft:panda, 270.0, 90.0", "minecraft:pig, 270.0, 90.0", "minecraft:rabbit, 270.0, 90.0", "minecraft:sheep, 270.0, 90.0", "minecraft:sniffer, 270.0, 90.0", "minecraft:strider, 270.0, 90.0", "minecraft:turtle, 270.0, 90.0", "minecraft:villager, 270.0, 90.0", "minecraft:wandering_trader, 270.0, 90.0", "minecraft:slime, 270.0, 120.0", "minecraft:magma_cube, 270.0, 120.0", "minecraft:cod, 300.0, 100.0", "minecraft:pufferfish, 300.0, 100.0", "minecraft:salmon, 300.0, 100.0", "minecraft:squid, 300.0, 100.0", "minecraft:glow_squid, 300.0, 100.0", "minecraft:tadpole, 300.0, 100.0", "minecraft:tropical_fish, 300.0, 100.0", "minecraft:cat, 140.0, 140.0", "minecraft:ocelot, 140.0, 140.0", "minecraft:wolf, 140.0, 140.0", "minecraft:polar_bear, 140.0, 140.0", "minecraft:fox, 140.0, 140.0", "minecraft:frog, 140.0, 140.0", "minecraft:zombie, 200.0, 135.0", "minecraft:husk, 200.0, 135.0", "minecraft:drowned, 200.0, 135.0", "minecraft:skeleton, 200.0, 135.0", "minecraft:stray, 200.0, 135.0", "minecraft:pillager, 200.0, 135.0", "minecraft:vindicator, 200.0, 135.0", "minecraft:evoker, 200.0, 135.0", "minecraft:witch, 200.0, 135.0", "minecraft:piglin, 200.0, 135.0", "minecraft:piglin_brute, 200.0, 135.0", "minecraft:iron_golem, 200.0, 135.0", "minecraft:creeper, 90.0, 90.0", "minecraft:enderman, 180.0, 240.0", "minecraft:guardian, 320.0, 180.0", "minecraft:elder_guardian, 320.0, 180.0", "minecraft:ravager, 160.0, 100.0", "minecraft:hoglin, 160.0, 100.0", "minecraft:zoglin, 160.0, 100.0", "minecraft:shulker, 270.0, 45.0"));
    public List<String> fovExclusionList = new ArrayList<String>(List.of());
    public int stealthCheckInterval = 30;
    public int targetLossGracePeriodTicks = 60;
    public double standingDetectionRange = 32.0;
    public double standingDetectionRangeCamouflage = 1.0;
    public double sneakDetectionRange = 12.0;
    public double sneakDetectionRangeCamouflage = 1.0;
    public double crawlDetectionRange = 4.0;
    public double crawlDetectionRangeCamouflage = 1.0;
    public double invisibilityStealthFactor = 0.1;
    public double neutralLightLevel = 7.0;
    public double lightLevelSensitivity = 0.8;
    public double minLightFactor = 0.2;
    public double maxLightFactor = 3.0;
    public boolean enableHeldItemPenalty = true;
    public double heldItemPenaltyFactor = 1.1;
    public boolean enableEnchantmentPenalty = true;
    public double armorEnchantmentPenaltyFactor = 1.15;
    public double heldItemEnchantmentPenaltyFactor = 1.15;
    public double rainStealthFactor = 0.8;
    public double thunderStealthFactor = 0.6;
    public double movementThreshold = 0.003;
    public double movementStealthPenalty = 1.2;
    public double stationaryStealthBonusFactor = 0.8;
    public boolean camouflageDistanceScaling = true;
    public double camouflageDistanceMax = 16.0;
    public double camouflageDistanceMinEffectiveness = 0.3;
    public boolean camouflageMovementPenalty = true;
    public double camouflageSprintingPenalty = 0.4;
    public double camouflageWalkingPenalty = 0.15;
    public int camouflageColorSimilarityThreshold = 70;
    public List<String> camouflageSets = new ArrayList<String>(List.of("F9FFFE;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "F9801D;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "C74EBD;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "3AB3DA;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "FED83D;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "80C71F;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "F38BAA;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "474F52;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "9D9D97;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "169C9C;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "8932B8;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "3C44AA;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "835432;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "5E7C16;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "B02E26;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots", "1D1D21;minecraft:leather_helmet;minecraft:leather_chestplate;minecraft:leather_leggings;minecraft:leather_boots"));
    public boolean enableVoiceChatIntegration = true;
    public int voiceChatWhisperRange = 8;
    public int voiceChatNormalRange = 32;
    public double voiceChatWeight = 50.0;
    public List<String> voiceChatDbThresholdMap = new ArrayList<String>(List.of("110:2.0", "90:1.8", "75:1.5", "50:1.0", "30:0.7", "10:0.3", "0:0.05"));
    public boolean enablePointBlankIntegration = true;
    public double pointblankReloadRange = 9.0;
    public int pointblankReloadWeight = 9;
    public double pointblankShootRange = 128.0;
    public double pointblankBaseAttachmentReduction = 0.0;
    public int pointblankShootWeight = 10;
    public double gunshotBaseDetectionRange = 128.0;
    public int gunshotDetectionDurationTicks = 60;
    public List<String> pointblankGunShootRanges = new ArrayList<String>(List.of("pointblank:glock17;128.0", "pointblank:glock18;128.0", "pointblank:m9;128.0", "pointblank:m1911a1;128.0", "pointblank:tti_viper;128.0", "pointblank:p30l;128.0", "pointblank:mk23;128.0", "pointblank:deserteagle;140.0", "pointblank:rhino;138.0", "pointblank:m4a1;118.0", "pointblank:m4a1mod1;118.0", "pointblank:star15;90.0", "pointblank:m4sopmodii;118.0", "pointblank:m16a1;90.0", "pointblank:hk416;118.0", "pointblank:scarl;72.0", "pointblank:xm7;118.0", "pointblank:g36c;132.0", "pointblank:g36k;132.0", "pointblank:aug;118.0", "pointblank:g41;118.0", "pointblank:ak74;128.0", "pointblank:ak12;128.0", "pointblank:an94;128.0", "pointblank:ar57;128.0", "pointblank:xm29;128.0", "pointblank:mp5;128.0", "pointblank:mp7;128.0", "pointblank:ro635;119.0", "pointblank:ump45;128.0", "pointblank:vector;90.0", "pointblank:p90;128.0", "pointblank:m950;128.0", "pointblank:tmp;128.0", "pointblank:sl8;128.0", "pointblank:mk14ebr;128.0", "pointblank:uar10;156.0", "pointblank:g3;128.0", "pointblank:wa2000;128.0", "pointblank:xm3;128.0", "pointblank:c14;128.0", "pointblank:l96a1;128.0", "pointblank:ballista;128.0", "pointblank:gm6lynx;128.0", "pointblank:m590;128.0", "pointblank:m870;128.0", "pointblank:spas12;128.0", "pointblank:m1014;128.0", "pointblank:citoricxs;128.0", "pointblank:hs12;128.0", "pointblank:lamg;128.0", "pointblank:mk48;128.0", "pointblank:m249;128.0", "pointblank:m32mgl;128.0", "pointblank:smaw;128.0", "pointblank:at4;128.0", "pointblank:javelin;200.0", "pointblank:m134minigun;156.0", "pointblank:aughbar;128.0", "pointblank:aa12;128.0", "pointblank:ak47;128.0"));
    public List<String> pointblankAttachmentSoundReductions = new ArrayList<String>(List.of("pointblank:ar_suppressor;40.0", "pointblank:ar_suppressor_tan;40.0", "pointblank:xm7_suppressor;40.0", "pointblank:ak_suppressor;40.0", "pointblank:smg_suppressor;40.0", "pointblank:rf_suppressor;40.0", "pointblank:hp_suppressor;40.0", "pointblank:sg_suppressor;40.0"));
    public List<String> pointblankMuzzleFlashReductions = new ArrayList<String>(List.of("pointblank:ar_suppressor;90.0", "pointblank:ar_suppressor_tan;90.0", "pointblank:xm7_suppressor;90.0", "pointblank:ak_suppressor;90.0", "pointblank:smg_suppressor;90.0", "pointblank:rf_suppressor;90.0", "pointblank:hp_suppressor;90.0", "pointblank:sg_suppressor;90.0"));
    public List<String> specialMobProfilesRaw = new ArrayList<String>(List.of("GreedyGoblin;minecraft:piglin;;minecraft:block.chest.open:30.0:2.5,minecraft:entity.player.death:50.0:3.0;standing:40.0,sneaking:20.0,crawling:10.0", "FastZombie;minecraft:zombie;{IsAlpha:1b};minecraft:entity.player.hurt:25.0:2.0;standing:60.0,sneaking:30.0,crawling:10.0"));
    public List<String> specialPlayerProfilesRaw = new ArrayList<String>(List.of("FelineOrigin;{cardinal_components:{\"origins:origin\":{OriginLayers:[{Layer:\"origins:origin\",Origin:\"origins:feline\"}]}}};standing:24.0,sneaking:10.0,crawling:3.0"));
    public boolean enableBlockBreaking = false;
    public double blockBreakTimeMultiplier = 1.0;
    public boolean blockBreakToolOnly = false;
    public boolean blockBreakProperToolOnly = false;
    public boolean blockBreakProperToolRequired = false;
    public int blockBreakMaxY = 255;
    public boolean blockBreakBlacklistTileEntities = true;
    public boolean blockBreakListAsWhitelist = false;
    public List<String> blockBreakBlockList = new ArrayList<String>();
    public List<String> nonBlockingVisionAllowList = new ArrayList<String>();

    public void buildCaches() {
        this.migrateLegacyPlayerProfiles();
        this.cachedMobProfiles = this.parseMobProfiles();
        this.cachedPlayerProfiles = this.parsePlayerProfiles();
        this.pointBlankGunShootRangesMap = this.parseConfigList(this.pointblankGunShootRanges);
        this.pointBlankAttachmentSoundReductionsMap = this.parseConfigList(this.pointblankAttachmentSoundReductions);
        this.pointBlankMuzzleFlashReductionsMap = this.parseConfigList(this.pointblankMuzzleFlashReductions);
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[Config] Caches have been built.");
        }
    }

    public void invalidateCaches() {
        this.cachedMobProfiles = null;
        this.cachedPlayerProfiles = null;
        this.pointBlankGunShootRangesMap = null;
        this.pointBlankAttachmentSoundReductionsMap = null;
        this.pointBlankMuzzleFlashReductionsMap = null;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[Config] All caches have been invalidated.");
        }
    }

    private void migrateLegacyPlayerProfiles() {
        if (this.specialPlayerProfilesRaw == null) {
            return;
        }
        boolean changed = false;
        ArrayList<String> migrated = new ArrayList<String>(this.specialPlayerProfilesRaw.size());
        for (String raw : this.specialPlayerProfilesRaw) {
            if (raw == null) {
                migrated.add(null);
                continue;
            }
            String trimmed = raw.trim();
            if (trimmed.isEmpty()) {
                migrated.add(trimmed);
                continue;
            }
            String[] parts = trimmed.split(";", -1);
            if (parts.length == 6) {
                String profileName = parts[0].trim();
                String detectionOverrides = parts[5].trim();
                String newEntry = profileName + ";;" + detectionOverrides;
                migrated.add(newEntry);
                changed = true;
                SoundAttractMod.LOGGER.warn("[Config] Migrated legacy 6-part player profile '{}' to 3-part format. Name/UUID/held/armor matchers are no longer supported; only detectionOverrides were kept.", (Object)profileName);
                continue;
            }
            migrated.add(trimmed);
        }
        if (changed) {
            this.specialPlayerProfilesRaw = migrated;
            if (this.configSchemaVersion < 3) {
                this.configSchemaVersion = 3;
            }
        } else if (this.configSchemaVersion < 3) {
            this.configSchemaVersion = 3;
        }
    }

    public Map<String, Double> getPointBlankGunShootRanges() {
        if (this.pointBlankGunShootRangesMap == null) {
            this.buildCaches();
        }
        return this.pointBlankGunShootRangesMap;
    }

    public Map<String, Double> getPointBlankAttachmentSoundReductions() {
        if (this.pointBlankAttachmentSoundReductionsMap == null) {
            this.buildCaches();
        }
        return this.pointBlankAttachmentSoundReductionsMap;
    }

    public Map<String, Double> getPointBlankMuzzleFlashReductions() {
        if (this.pointBlankMuzzleFlashReductionsMap == null) {
            this.buildCaches();
        }
        return this.pointBlankMuzzleFlashReductionsMap;
    }

    public List<MobProfile> parseMobProfiles() {
        ArrayList<MobProfile> list = new ArrayList<MobProfile>();
        for (String rawEntry : this.specialMobProfilesRaw) {
            if (rawEntry == null || rawEntry.trim().isEmpty()) continue;
            String[] parts = rawEntry.trim().split(";", -1);
            if (parts.length != 5) {
                SoundAttractMod.LOGGER.warn("Skipping malformed mob profile entry: '{}'. Expected 5 semicolon-separated parts.", (Object)rawEntry);
                continue;
            }
            String profileName = parts[0].trim();
            String mobIdString = parts[1].trim();
            String nbtMatcherString = parts[2].trim();
            String soundOverridesString = parts[3].trim();
            String detectionString = parts[4].trim();
            class_2487 parsedNbt = null;
            if (!nbtMatcherString.isEmpty()) {
                try {
                    parsedNbt = class_2522.method_10718((String)nbtMatcherString);
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("Failed to parse NBT matcher for mob profile '{}': {}. Error: {}", new Object[]{profileName, nbtMatcherString, e.getMessage()});
                    parsedNbt = null;
                }
            }
            ArrayList<SoundOverride> soundOverrides = new ArrayList<SoundOverride>();
            if (!soundOverridesString.isEmpty()) {
                String[] overrideEntries;
                for (String entry : overrideEntries = soundOverridesString.split(",")) {
                    String trimmed = entry.trim();
                    if (trimmed.isEmpty()) continue;
                    try {
                        SoundOverride so = SoundOverride.parse(trimmed);
                        soundOverrides.add(so);
                    }
                    catch (IllegalArgumentException e) {
                        SoundAttractMod.LOGGER.warn("Failed to parse SoundOverride '{}' for profile '{}': {}", new Object[]{trimmed, profileName, e.getMessage()});
                    }
                }
            }
            HashMap<PlayerStance, Double> detectionOverrides = new HashMap<PlayerStance, Double>();
            if (!detectionString.isEmpty()) {
                String[] stancePairs;
                for (String pair : stancePairs = detectionString.split(",")) {
                    double val;
                    String trimmedPair = pair.trim();
                    if (trimmedPair.isEmpty()) continue;
                    String[] kv = trimmedPair.split(":", 2);
                    if (kv.length != 2) {
                        SoundAttractMod.LOGGER.warn("Skipping malformed detection override '{}' in profile '{}'. Expected 'stance:value'.", (Object)trimmedPair, (Object)profileName);
                        continue;
                    }
                    String stanceName = kv[0].trim().toLowerCase(Locale.ROOT);
                    String valueStr = kv[1].trim();
                    Optional<PlayerStance> stanceOpt = PlayerStance.fromString(stanceName);
                    if (stanceOpt.isEmpty()) {
                        SoundAttractMod.LOGGER.warn("Unknown PlayerStance '{}' in profile '{}'. Skipping.", (Object)stanceName, (Object)profileName);
                        continue;
                    }
                    try {
                        val = Double.parseDouble(valueStr);
                    }
                    catch (NumberFormatException e) {
                        SoundAttractMod.LOGGER.warn("Invalid detection override value '{}' for stance '{}' in profile '{}'. Skipping.", new Object[]{valueStr, stanceName, profileName});
                        continue;
                    }
                    detectionOverrides.put(stanceOpt.get(), val);
                }
            }
            try {
                MobProfile mp = new MobProfile(profileName, mobIdString.isEmpty() ? "*" : mobIdString, nbtMatcherString.isEmpty() ? null : nbtMatcherString, soundOverrides, detectionOverrides);
                list.add(mp);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Failed to construct MobProfile for entry '{}': {}", (Object)rawEntry, (Object)e.getMessage());
            }
        }
        this.cachedMobProfiles = Collections.unmodifiableList(list);
        return this.cachedMobProfiles;
    }

    public List<PlayerProfile> parsePlayerProfiles() {
        ArrayList<PlayerProfile> list = new ArrayList<PlayerProfile>();
        if (this.specialPlayerProfilesRaw == null) {
            this.cachedPlayerProfiles = Collections.unmodifiableList(list);
            return this.cachedPlayerProfiles;
        }
        for (String raw : this.specialPlayerProfilesRaw) {
            if (raw == null || raw.trim().isEmpty()) continue;
            String[] parts = raw.trim().split(";", -1);
            if (parts.length != 3) {
                SoundAttractMod.LOGGER.warn("Skipping malformed player profile: '{}' (expected 3 parts)", (Object)raw);
                continue;
            }
            String profileName = parts[0].trim();
            String nbtMatcherString = parts[1].trim();
            String detectionStr = parts[2].trim();
            class_2487 parsedNbt = null;
            if (!nbtMatcherString.isEmpty()) {
                try {
                    parsedNbt = class_2522.method_10718((String)nbtMatcherString);
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("Failed to parse NBT matcher for player profile '{}': {}. Error: {}", new Object[]{profileName, nbtMatcherString, e.getMessage()});
                    parsedNbt = null;
                }
            }
            HashMap<PlayerStance, Double> detectionOverrides = new HashMap<PlayerStance, Double>();
            if (!detectionStr.isEmpty()) {
                String[] pairs;
                for (String pair : pairs = detectionStr.split(",")) {
                    String tp = pair.trim();
                    if (tp.isEmpty()) continue;
                    String[] kv = tp.split(":", 2);
                    if (kv.length != 2) {
                        SoundAttractMod.LOGGER.warn("Malformed stance override '{}' in player profile '{}'", (Object)tp, (Object)profileName);
                        continue;
                    }
                    Optional<PlayerStance> stanceOpt = PlayerStance.fromString(kv[0].trim());
                    if (stanceOpt.isEmpty()) {
                        SoundAttractMod.LOGGER.warn("Unknown stance '{}' in player profile '{}'", (Object)kv[0], (Object)profileName);
                        continue;
                    }
                    try {
                        double val = Double.parseDouble(kv[1].trim());
                        detectionOverrides.put(stanceOpt.get(), val);
                    }
                    catch (NumberFormatException nfe) {
                        SoundAttractMod.LOGGER.warn("Invalid value '{}' for stance '{}' in player profile '{}'", new Object[]{kv[1], kv[0], profileName});
                    }
                }
            }
            try {
                PlayerProfile pp = new PlayerProfile(profileName, parsedNbt, detectionOverrides);
                list.add(pp);
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.warn("Failed to construct PlayerProfile for entry '{}': {}", (Object)raw, (Object)t.getMessage());
            }
        }
        this.cachedPlayerProfiles = Collections.unmodifiableList(list);
        return this.cachedPlayerProfiles;
    }

    public MobProfile getMatchingProfile(class_1308 mob) {
        for (MobProfile profile : this.getMobProfiles()) {
            if (!profile.matches(mob)) continue;
            return profile;
        }
        return null;
    }

    public PlayerProfile getMatchingPlayerProfile(class_1657 player) {
        for (PlayerProfile pp : this.getPlayerProfiles()) {
            if (!pp.matches(player)) continue;
            return pp;
        }
        return null;
    }

    public List<MobProfile> getMobProfiles() {
        if (this.cachedMobProfiles == null) {
            this.buildCaches();
        }
        return this.cachedMobProfiles;
    }

    public List<PlayerProfile> getPlayerProfiles() {
        if (this.cachedPlayerProfiles == null) {
            this.buildCaches();
        }
        return this.cachedPlayerProfiles;
    }

    public SoundConfig getSoundConfigForId(String id) {
        if (id == null || this.nonPlayerSoundIdList == null) {
            return null;
        }
        for (String entry : this.nonPlayerSoundIdList) {
            String[] parts = entry.split(";");
            if (parts.length < 3 || !id.equals(parts[0])) continue;
            try {
                double range = Double.parseDouble(parts[1]);
                double weight = Double.parseDouble(parts[2]);
                return new SoundConfig(id, range, weight);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }

    private Map<String, Double> parseConfigList(List<String> list) {
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String entry : list) {
            if (entry == null || entry.trim().isEmpty()) continue;
            try {
                String[] parts = entry.split(";", 2);
                if (parts.length == 2) {
                    map.put(parts[0].trim(), Double.parseDouble(parts[1].trim()));
                    continue;
                }
                SoundAttractMod.LOGGER.warn("Skipping malformed config entry: '{}'. Expected 'id;value'.", (Object)entry);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Failed to parse config entry: '{}'. Error: {}", (Object)entry, (Object)e.getMessage());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static class SoundConfig {
        public final String soundId;
        public final double range;
        public final double weight;

        public SoundConfig(String soundId, double range, double weight) {
            this.soundId = soundId;
            this.range = range;
            this.weight = weight;
        }
    }
}

