/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessagePayload;
import com.example.soundattract.logic.SoundMessageHandler;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;

@Addon(id="soundattract", name="Attract to Sound", version="PlasmoVoice", authors={"Paldiu", "Sylsatra"})
public class PlasmoIntegration
implements AddonInitializer {
    @InjectPlasmoVoice
    private PlasmoVoiceServer server;

    public void onAddonInitialize() {
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[PlasmoIntegration] onAddonInitialize: registering voice listener");
        }
        try {
            this.server.getEventBus().register((Object)this, (Object)new VoiceListener());
        }
        catch (Throwable t) {
            SoundAttractMod.LOGGER.warn("[PlasmoIntegration] register(this, listener) failed: {}", (Object)t.toString());
        }
    }

    public void onAddonShutdown() {
        super.onAddonShutdown();
    }

    public static final class VoiceListener {
        @EventSubscribe
        public void voiceActive(PlayerSpeakEvent event) {
            McPlayer mcPlayerObj = event.getPlayer().getInstance();
            if (!(mcPlayerObj instanceof class_3222)) {
                return;
            }
            class_3222 mcPlayer = (class_3222)mcPlayerObj;
            double x = mcPlayer.method_23317();
            double y = mcPlayer.method_23318();
            double z = mcPlayer.method_23321();
            class_2960 dim = mcPlayer.method_37908().method_27983().method_29177();
            int range = SoundAttractMod.CONFIG.voiceChatNormalRange;
            SoundMessagePayload payload = new SoundMessagePayload(SoundMessagePayload.VOICE_CHAT_SOUND_ID, x, y, z, dim, Optional.of(mcPlayer.method_5667()), range, 100.0, null, null);
            mcPlayer.method_5682().execute(() -> SoundMessageHandler.handle(payload, mcPlayer));
        }

        @EventSubscribe
        public void onServerSourceAudio(ServerSourceAudioPacketEvent event) {
            try {
                MinecraftServer server;
                int distance = event.getDistance();
                PlayerActivationInfo activationInfo = event.getActivationInfo();
                if (activationInfo == null) {
                    return;
                }
                VoicePlayer voicePlayer = activationInfo.getPlayer();
                if (voicePlayer == null) {
                    return;
                }
                McPlayer playerObj = voicePlayer.getInstance();
                if (playerObj == null) {
                    return;
                }
                class_3222 mcPlayer = null;
                if (playerObj instanceof class_3222) {
                    class_3222 sp;
                    mcPlayer = sp = (class_3222)playerObj;
                } else {
                    String[] candidateMethods;
                    for (String methodName : candidateMethods = new String[]{"getPlayer", "getMinecraftPlayer", "getHandle", "getInstance"}) {
                        try {
                            Method m = playerObj.getClass().getMethod(methodName, new Class[0]);
                            Object inner = m.invoke((Object)playerObj, new Object[0]);
                            if (!(inner instanceof class_3222)) continue;
                            class_3222 sp2 = (class_3222)inner;
                            mcPlayer = (class_3222)inner;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (mcPlayer == null) {
                        try {
                            UUID uuid = null;
                            try {
                                uuid = (UUID)voicePlayer.getClass().getMethod("getUuid", new Class[0]).invoke((Object)voicePlayer, new Object[0]);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (uuid == null) {
                                try {
                                    uuid = (UUID)voicePlayer.getClass().getMethod("getUUID", new Class[0]).invoke((Object)voicePlayer, new Object[0]);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (uuid == null) {
                                try {
                                    Object id = voicePlayer.getClass().getMethod("getUniqueId", new Class[0]).invoke((Object)voicePlayer, new Object[0]);
                                    if (id instanceof UUID) {
                                        UUID u;
                                        uuid = u = (UUID)id;
                                    }
                                }
                                catch (Throwable id) {
                                    // empty catch block
                                }
                            }
                            if (uuid != null) {
                                ServerAudioSource source = event.getSource();
                                Object var11_23 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (mcPlayer == null) {
                    return;
                }
                int range = distance > 0 ? distance : SoundAttractMod.CONFIG.voiceChatNormalRange;
                double x = mcPlayer.method_23317();
                double y = mcPlayer.method_23318();
                double z = mcPlayer.method_23321();
                class_2960 dim = mcPlayer.method_37908().method_27983().method_29177();
                SoundMessagePayload payload = new SoundMessagePayload(SoundMessagePayload.VOICE_CHAT_SOUND_ID, x, y, z, dim, Optional.of(mcPlayer.method_5667()), range, 100.0, null, null);
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] VOICE_CHAT forwarded via Plasmo: player={} range={} dim={}", new Object[]{mcPlayer.method_7334().getName(), range, dim});
                }
                if ((server = mcPlayer.method_5682()) == null) {
                    return;
                }
                class_3222 mcPlayerFinal = mcPlayer;
                SoundMessagePayload payloadFinal = payload;
                server.execute(() -> SoundMessageHandler.handle(payloadFinal, mcPlayerFinal));
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("[PlasmoIntegration] Exception in onServerSourceAudio", t);
            }
        }
    }
}

