/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.config.SoundAttractConfig;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import org.slf4j.Logger;

public class FovEvents {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final double BACKSTAB_DAMAGE_MULTIPLIER = 1.2;
    private static final FovData DEFAULT_FOV = new FovData(200.0, 135.0);
    private static final Set<EntityType<?>> DEVELOPER_EXCLUSIONS = Set.of(EntityType.WARDEN, EntityType.ENDER_DRAGON, EntityType.WITHER);
    private static Map<ResourceLocation, FovData> CONFIG_FOV_CACHE = null;
    private static Set<ResourceLocation> USER_EXCLUSION_CACHE = null;

    private static void buildCaches() {
        USER_EXCLUSION_CACHE = new HashSet<ResourceLocation>();
        List exclusionList = (List)SoundAttractConfig.COMMON.fovExclusionList.get();
        for (String entry : exclusionList) {
            try {
                ResourceLocation loc = ResourceLocation.tryParse((String)entry.trim());
                if (loc != null) {
                    USER_EXCLUSION_CACHE.add(loc);
                    continue;
                }
                LOGGER.warn("[FOV Config] Malformed exclusion entry, skipping: " + entry);
            }
            catch (Exception e) {
                LOGGER.error("[FOV Config] Failed to parse exclusion entry: " + entry, (Throwable)e);
            }
        }
        LOGGER.info("[FOV Config] Loaded {} user-defined exclusions.", (Object)USER_EXCLUSION_CACHE.size());
        CONFIG_FOV_CACHE = new HashMap<ResourceLocation, FovData>();
        List overrideList = (List)SoundAttractConfig.COMMON.fovOverrides.get();
        for (String entry : overrideList) {
            try {
                String[] parts = entry.split(",");
                if (parts.length != 3) {
                    LOGGER.warn("[FOV Config] Malformed FOV override, skipping: " + entry);
                    continue;
                }
                ResourceLocation mobId = ResourceLocation.tryParse((String)parts[0].trim());
                if (mobId == null) {
                    LOGGER.warn("[FOV Config] Malformed mob identifier in override, skipping: " + entry);
                    continue;
                }
                double h = Double.parseDouble(parts[1].trim());
                double v = Double.parseDouble(parts[2].trim());
                CONFIG_FOV_CACHE.put(mobId, new FovData(h, v));
            }
            catch (Exception e) {
                LOGGER.error("[FOV Config] Failed to parse FOV override entry: " + entry, (Throwable)e);
            }
        }
        LOGGER.info("[FOV Config] Loaded {} custom FOV overrides.", (Object)CONFIG_FOV_CACHE.size());
    }

    @SubscribeEvent
    public void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (event.getVisibilityModifier() <= 0.0) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob looker = (Mob)livingEntity;
        Entity target = event.getLookingEntity();
        if (target == null) {
            return;
        }
        if (!FovEvents.isTargetInFov(looker, target, false)) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public void onMobHurt(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        Entity attacker = event.getSource().getDirectEntity();
        if (attacker == null || attacker == mob) {
            return;
        }
        if (!FovEvents.isTargetInFov(mob, attacker, true)) {
            float originalDamage = event.getOriginalDamage();
            float newDamage = (float)((double)originalDamage * 1.2);
            event.setNewDamage(newDamage);
            if (attacker instanceof Player) {
                mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, mob.getSoundSource(), 1.0f, 1.2f);
            }
        }
    }

    public static boolean isTargetInFov(Mob looker, Entity target, boolean checkObstructions) {
        if (USER_EXCLUSION_CACHE == null) {
            FovEvents.buildCaches();
        }
        ResourceLocation lookerId = EntityType.getKey((EntityType)looker.getType());
        if (DEVELOPER_EXCLUSIONS.contains(looker.getType())) {
            return true;
        }
        if (USER_EXCLUSION_CACHE.contains(lookerId)) {
            return true;
        }
        FovData fov = CONFIG_FOV_CACHE.getOrDefault(lookerId, DEFAULT_FOV);
        if (fov.horizontal() >= 360.0) {
            return true;
        }
        if (checkObstructions && !FovEvents.hasSmartLineOfSight(looker, target)) {
            return false;
        }
        return FovEvents.isWithinFieldOfView(looker, target, fov.horizontal(), fov.vertical());
    }

    public static boolean hasSmartLineOfSight(Mob looker, Entity target) {
        Level level = looker.level();
        Vec3 eyeToEye = target.getEyePosition();
        Vec3 center = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0);
        Vec3 feet = target.position().add(0.0, Math.max(0.1, (double)target.getBbHeight() * 0.15), 0.0);
        Vec3 start = looker.getEyePosition();
        return FovEvents.raycastIgnoringNonBlocking(level, start, eyeToEye, looker) || FovEvents.raycastIgnoringNonBlocking(level, start, center, looker) || FovEvents.raycastIgnoringNonBlocking(level, start, feet, looker);
    }

    private static boolean raycastIgnoringNonBlocking(Level level, Vec3 start, Vec3 end, Mob looker) {
        int maxPassThroughs = 24;
        Vec3 currStart = start;
        Vec3 dir = end.subtract(start);
        double totalDist = dir.length();
        if (totalDist < 1.0E-4) {
            return true;
        }
        dir = dir.normalize();
        for (int i = 0; i < 24; ++i) {
            ClipContext ctx = new ClipContext(currStart, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)looker);
            BlockHitResult hit = level.clip(ctx);
            if (hit.getType() == HitResult.Type.MISS) {
                return true;
            }
            BlockPos pos = hit.getBlockPos();
            BlockState state = level.getBlockState(pos);
            if (!FovEvents.isNonBlockingVision(state, level, pos)) {
                return false;
            }
            Vec3 step = dir.scale(0.6);
            currStart = hit.getLocation().add(step);
        }
        return false;
    }

    private static boolean isNonBlockingVision(BlockState state, Level level, BlockPos pos) {
        ResourceLocation id2;
        Boolean open2;
        if (state == null || level == null || pos == null) {
            return false;
        }
        if (state.isAir()) {
            return true;
        }
        if (state.getBlock() instanceof DoorBlock) {
            try {
                open2 = (Boolean)state.getValue((Property)DoorBlock.OPEN);
                if (open2 != null && open2.booleanValue()) {
                    return true;
                }
            }
            catch (Throwable open2) {
                // empty catch block
            }
        }
        if (state.getBlock() instanceof TrapDoorBlock) {
            try {
                open2 = (Boolean)state.getValue((Property)TrapDoorBlock.OPEN);
                if (open2 != null && open2.booleanValue()) {
                    return true;
                }
            }
            catch (Throwable open3) {
                // empty catch block
            }
        }
        try {
            if (state.is(BlockTags.WALLS)) {
                return false;
            }
        }
        catch (Throwable open3) {
            // empty catch block
        }
        if (state.getBlock() instanceof WallBlock) {
            return false;
        }
        try {
            id2 = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            if (id2 != null) {
                if (SoundAttractConfig.NON_BLOCKING_VISION_ALLOW_CACHE.isEmpty()) {
                    List list;
                    List list2 = list = SoundAttractConfig.COMMON != null ? (List)SoundAttractConfig.COMMON.nonBlockingVisionAllowList.get() : Collections.emptyList();
                    if (list != null && !list.isEmpty()) {
                        SoundAttractConfig.parseAndCacheNonBlockingVisionAllowList();
                    }
                }
                if (SoundAttractConfig.NON_BLOCKING_VISION_ALLOW_CACHE.contains(id2)) {
                    return true;
                }
            }
        }
        catch (Throwable id2) {
            // empty catch block
        }
        try {
            String path;
            id2 = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String string = path = id2 != null ? id2.getPath() : "";
            if (path.contains("glass") && !path.contains("tinted")) {
                return true;
            }
        }
        catch (Throwable id3) {
            // empty catch block
        }
        if (state.getBlock() instanceof IceBlock || state.is(Blocks.PACKED_ICE) || state.is(Blocks.BLUE_ICE)) {
            return true;
        }
        try {
            VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos, CollisionContext.empty());
            if (shape.isEmpty()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!state.isViewBlocking((BlockGetter)level, pos)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isWithinFieldOfView(Mob looker, Entity target, double horizontalFovDegrees, double verticalFovDegrees) {
        Vec3 targetHorizontal;
        Vec3 lookVector = looker.getLookAngle();
        Vec3 toTargetVector = target.position().add(0.0, (double)target.getEyeHeight() / 2.0, 0.0).subtract(looker.getEyePosition()).normalize();
        Vec3 lookHorizontal = new Vec3(lookVector.x, 0.0, lookVector.z).normalize();
        double dotHorizontal = lookHorizontal.dot(targetHorizontal = new Vec3(toTargetVector.x, 0.0, toTargetVector.z).normalize());
        double angleHorizontal = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotHorizontal))));
        if (angleHorizontal > horizontalFovDegrees / 2.0) {
            return false;
        }
        double pitchLook = Math.toDegrees(Math.asin(lookVector.y));
        double pitchTarget = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toTargetVector.y))));
        double angleVertical = Math.abs(pitchTarget - pitchLook);
        return angleVertical <= verticalFovDegrees / 2.0;
    }

    private record FovData(double horizontal, double vertical) {
    }
}

