/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.enchantment.ModEnchantments;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class StealthDetectionEvents {
    private static final Map<Mob, Integer> mobOutOfRangeTicks = new HashMap<Mob, Integer>();
    private static final Map<Player, Vec3> lastPlayerPositions = new HashMap<Player, Vec3>();
    private static long lastStealthCheckTick = -1L;
    private static final Map<UUID, GunshotInfo> playerGunshotInfo = new HashMap<UUID, GunshotInfo>();
    private static final Map<UUID, Double> XRAY_RANGE_CACHE = new HashMap<UUID, Double>();

    private static int getStealthCheckInterval() {
        return (Integer)SoundAttractConfig.COMMON.stealthCheckInterval.get();
    }

    private static boolean hasConcealmentEnchant(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (enchantments == null) {
            return false;
        }
        return enchantments.keySet().stream().anyMatch(holder -> holder.is(ModEnchantments.CONCEAL));
    }

    @SubscribeEvent
    public void onMobAttemptTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return;
        }
        LivingEntity newTarget = event.getNewAboutToBeSetTarget();
        if (newTarget instanceof Player) {
            Player playerTarget = (Player)newTarget;
            if (playerTarget.isCreative() || playerTarget.isSpectator() || !playerTarget.isAlive()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[net.neoforged.neoforge.event.entity.living.LivingSetAttackTargetEvent] Player {} is creative/spectator/dead. Allowing target by {}.", (Object)playerTarget.getName().getString(), (Object)mob.getName().getString());
                }
                return;
            }
            if (!StealthDetectionEvents.canMobDetectPlayer(mob, playerTarget)) {
                event.setCanceled(true);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[net.neoforged.neoforge.event.entity.living.LivingSetAttackTargetEvent] Mob {} targeting of Player {} CANCELED due to stealth rules.", (Object)mob.getName().getString(), (Object)playerTarget.getName().getString());
                }
            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[net.neoforged.neoforge.event.entity.living.LivingSetAttackTargetEvent] Mob {} targeting of Player {} ALLOWED (passes stealth check).", (Object)mob.getName().getString(), (Object)playerTarget.getName().getString());
            }
        }
    }

    public static boolean canMobDetectPlayer(Mob mob, Player player) {
        if (mob == null || player == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[CanDetectPlayer] Called with null mob or player. Defaulting to detectable.");
            }
            return true;
        }
        if (player.isCreative() || player.isSpectator() || !player.isAlive()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CanDetectPlayer] Player {} is creative/spectator/dead. Bypassing stealth. Mob {}.", (Object)player.getName().getString(), (Object)mob.getName().getString());
            }
            return true;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return true;
        }
        Level level = mob.level();
        double detectionRange = StealthDetectionEvents.getRealisticStealthDetectionRange(player, mob, level);
        double distSq = mob.distanceToSqr((Entity)player);
        if (distSq > detectionRange * detectionRange) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[StealthQuery] Player {} is OUT OF RANGE for mob {} (distSq: {}, rangeSq: {}).", new Object[]{player.getName().getString(), mob.getName().getString(), String.format("%.2f", distSq), String.format("%.2f", detectionRange * detectionRange)});
            }
            return false;
        }
        if (!FovEvents.isTargetInFov(mob, (Entity)player, true)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[StealthQuery] Player {} is IN RANGE for mob {} but OUTSIDE FOV. Denying detection.", (Object)player.getName().getString(), (Object)mob.getName().getString());
            }
            return false;
        }
        double xrayRange = StealthDetectionEvents.getEffectiveXrayRange(mob);
        if (xrayRange > 0.0 && distSq <= xrayRange * xrayRange) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[StealthQuery] Player {} detected by mob {} via XRAY range {}.", new Object[]{player.getName().getString(), mob.getName().getString(), String.format("%.2f", xrayRange)});
            }
            return true;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[StealthQuery] Player {} IS DETECTABLE by mob {} (in range and in FOV).", (Object)player.getName().getString(), (Object)mob.getName().getString());
        }
        return true;
    }

    public static void resetXrayCache() {
        XRAY_RANGE_CACHE.clear();
    }

    private static double getEffectiveXrayRange(Mob mob) {
        if (mob == null) {
            return 0.0;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableXrayTargeting.get()).booleanValue()) {
            return 0.0;
        }
        try {
            String applyTagStr = (String)SoundAttractConfig.COMMON.xrayApplyTag.get();
            if (applyTagStr == null || applyTagStr.isBlank()) {
                return 0.0;
            }
            TagKey applyTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)applyTagStr));
            if (!mob.getType().is(applyTag)) {
                return 0.0;
            }
            if (((Boolean)SoundAttractConfig.COMMON.xrayRequireBetterNearby.get()).booleanValue()) {
                String betterTagStr = (String)SoundAttractConfig.COMMON.xrayBetterNearbyTag.get();
                if (betterTagStr == null || betterTagStr.isBlank()) {
                    return 0.0;
                }
                TagKey betterTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)betterTagStr));
                if (!mob.getType().is(betterTag)) {
                    return 0.0;
                }
            }
        }
        catch (Exception e) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[XRAY] Tag check failed for mob {}: {}", (Object)mob.getName().getString(), (Object)e.getMessage());
            }
            return 0.0;
        }
        if (EnhancedAICompat.isEnhancedAiLoaded()) {
            double v = EnhancedAICompat.getXrayAttributeValue(mob);
            return Math.max(0.0, v);
        }
        Double cached = XRAY_RANGE_CACHE.get(mob.getUUID());
        if (cached != null) {
            return cached;
        }
        int max = (Integer)SoundAttractConfig.COMMON.xrayMaxRange.get();
        if (max <= 0) {
            XRAY_RANGE_CACHE.put(mob.getUUID(), 0.0);
            return 0.0;
        }
        int min = (Integer)SoundAttractConfig.COMMON.xrayMinRange.get();
        min = Math.max(0, Math.min(min, max));
        double chance = (Double)SoundAttractConfig.COMMON.xrayChance.get();
        if (mob.getRandom().nextDouble() >= chance) {
            XRAY_RANGE_CACHE.put(mob.getUUID(), 0.0);
            return 0.0;
        }
        int spread = max - min;
        int chosen = spread <= 0 ? max : min + mob.getRandom().nextInt(spread + 1);
        double result = chosen;
        XRAY_RANGE_CACHE.put(mob.getUUID(), result);
        return result;
    }

    public static void recordPlayerGunshot(Player player, double detectionRange) {
        if (player == null || player.level().isClientSide()) {
            return;
        }
        long currentTime = player.level().getGameTime();
        playerGunshotInfo.put(player.getUUID(), new GunshotInfo(currentTime, detectionRange));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[Gunshot] Recorded gunshot for {} with range {}. Effective until tick {}.", new Object[]{player.getName().getString(), String.format("%.2f", detectionRange), currentTime + (long)((Integer)SoundAttractConfig.COMMON.gunshotDetectionDurationTicks.get()).intValue()});
        }
    }

    private static Optional<Double> getActiveGunshotRange(Player player) {
        long duration;
        GunshotInfo info = playerGunshotInfo.get(player.getUUID());
        if (info == null) {
            return Optional.empty();
        }
        long currentTime = player.level().getGameTime();
        if (currentTime - info.timestamp < (duration = (long)((Integer)SoundAttractConfig.COMMON.gunshotDetectionDurationTicks.get()).intValue())) {
            return Optional.of(info.detectionRange);
        }
        playerGunshotInfo.remove(player.getUUID());
        return Optional.empty();
    }

    public static boolean shouldSuppressTargeting(Mob mob) {
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return false;
        }
        LivingEntity target = mob.getTarget();
        if (target == null) {
            return false;
        }
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        return !StealthDetectionEvents.canMobDetectPlayer(mob, player);
    }

    public static boolean shouldSuppressTargeting(Mob mob, Player player) {
        return !StealthDetectionEvents.canMobDetectPlayer(mob, player);
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        int stealthCheckInterval;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return;
        }
        long gameTime = event.getServer().overworld().getGameTime();
        if (gameTime % (long)(stealthCheckInterval = StealthDetectionEvents.getStealthCheckInterval()) != 0L || gameTime == lastStealthCheckTick) {
            return;
        }
        lastStealthCheckTick = gameTime;
        for (ServerLevel level : event.getServer().getAllLevels()) {
            int simDistBlocks = level.getServer().getPlayerList().getViewDistance() * 16;
            HashSet mobsToCheck = new HashSet();
            for (ServerPlayer serverPlayer : level.players()) {
                AABB scanArea = serverPlayer.getBoundingBox().inflate((double)simDistBlocks);
                mobsToCheck.addAll(level.getEntitiesOfClass(Mob.class, scanArea, entity -> entity.isAlive() && entity.getTarget() instanceof Player));
            }
            for (Mob mob : mobsToCheck) {
                Player playerTarget = (Player)mob.getTarget();
                if (playerTarget.isCreative() || playerTarget.isSpectator()) {
                    mobOutOfRangeTicks.remove(mob);
                    continue;
                }
                boolean canCurrentlyDetect = StealthDetectionEvents.canMobDetectPlayer(mob, playerTarget);
                if (canCurrentlyDetect) {
                    if (mobOutOfRangeTicks.remove(mob) == null || !((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                    SoundAttractMod.LOGGER.info("[TickCheck] Mob {} regained direct detection of {}. Grace period reset.", (Object)mob.getName().getString(), (Object)playerTarget.getName().getString());
                    continue;
                }
                int ticks = mobOutOfRangeTicks.getOrDefault(mob, 0) + stealthCheckInterval;
                if (ticks >= (Integer)SoundAttractConfig.COMMON.stealthGracePeriodTicks.get()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[TickCheck] Mob {} lost target {} due to stealth grace period timeout.", (Object)mob.getName().getString(), (Object)playerTarget.getName().getString());
                    }
                    if (mob.getBrain().hasMemoryValue(MemoryModuleType.ANGRY_AT)) {
                        mob.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
                    }
                    mob.setTarget(null);
                    mobOutOfRangeTicks.remove(mob);
                    continue;
                }
                mobOutOfRangeTicks.put(mob, ticks);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[TickCheck] Mob {} cannot detect {}. In grace period ({}/{}).", new Object[]{mob.getName().getString(), playerTarget.getName().getString(), ticks, SoundAttractConfig.COMMON.stealthGracePeriodTicks.get()});
            }
        }
    }

    public static boolean isPlayerMoving(Player player, double threshold) {
        if (player == null) {
            return false;
        }
        Vec3 currentPos = player.position();
        Vec3 lastPos = lastPlayerPositions.get(player);
        boolean moved = false;
        if (lastPos != null) {
            double distSq = currentPos.distanceToSqr(lastPos);
            moved = distSq > threshold * threshold;
        }
        lastPlayerPositions.put(player, currentPos);
        return moved;
    }

    private static PlayerStance determinePlayerStance(Player player) {
        Pose currentPose = player.getPose();
        boolean isVisuallyCrawling = player.isVisuallyCrawling();
        boolean isCrouching = player.isCrouching();
        float playerHeight = player.getBbHeight();
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[DetermineStanceDetails] Player: {}, Pose: {}, isVisuallyCrawling: {}, isCrouching: {}, Height: {}", new Object[]{player.getName().getString(), currentPose, isVisuallyCrawling, isCrouching, String.format("%.2f", Float.valueOf(playerHeight))});
        }
        if (isVisuallyCrawling) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is CRAWLING (VisualCrawl: true, Pose: {}, Height: {})", new Object[]{player.getName().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.CRAWLING;
        }
        if (currentPose == Pose.SWIMMING || currentPose == Pose.SPIN_ATTACK || currentPose == Pose.FALL_FLYING) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is CRAWLING-EQUIVALENT (Pose: {}, Height: {})", new Object[]{player.getName().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.CRAWLING;
        }
        if (isCrouching) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is SNEAKING (Pose: {}, Crouching: {}, Height: {})", new Object[]{player.getName().getString(), currentPose, isCrouching, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.SNEAKING;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is STANDING (Pose: {}, Height: {})", new Object[]{player.getName().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
        }
        return PlayerStance.STANDING;
    }

    private static int colorDifference(int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
    }

    public static double getRealisticStealthDetectionRange(Player player, Mob mob, Level level) {
        ArrayList camoItems;
        double baseRange;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get();
        }
        Optional<Double> gunshotRangeOpt = StealthDetectionEvents.getActiveGunshotRange(player);
        PlayerStance currentStance = StealthDetectionEvents.determinePlayerStance(player);
        if (gunshotRangeOpt.isPresent()) {
            baseRange = gunshotRangeOpt.get();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR] Player has active gunshot flash. Initial range: {}", (Object)String.format("%.2f", baseRange));
            }
            double standingRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
            double poseReduction = Math.max(0.0, standingRange - (switch (currentStance) {
                case PlayerStance.CRAWLING -> (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                case PlayerStance.SNEAKING -> (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                default -> standingRange;
            }));
            baseRange -= poseReduction;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR] Gunshot range adjusted by pose {}. Reduction: {}. New range: {}.", new Object[]{currentStance, String.format("%.2f", poseReduction), String.format("%.2f", baseRange)});
            }
        } else {
            Optional override;
            MobProfile mobProfile = SoundAttractConfig.getMatchingProfile(mob);
            Optional<Object> optional = override = mobProfile != null ? mobProfile.getDetectionOverride(currentStance) : Optional.empty();
            if (override.isPresent()) {
                baseRange = (Double)override.get();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Mob profile '{}' provides override for stance {}: {}", new Object[]{mobProfile.getProfileName(), currentStance, baseRange});
                }
            } else {
                Optional playerOverride;
                PlayerProfile playerProfile = SoundAttractConfig.getMatchingPlayerProfile(player);
                Optional<Object> optional2 = playerOverride = playerProfile != null ? playerProfile.getDetectionOverride(currentStance) : Optional.empty();
                if (playerOverride.isPresent()) {
                    baseRange = (Double)playerOverride.get();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} matched player profile '{}' for stance {}: {}", new Object[]{player.getName().getString(), playerProfile.getProfileName(), currentStance, baseRange});
                    }
                } else {
                    switch (currentStance) {
                        case CRAWLING: {
                            baseRange = (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                            break;
                        }
                        case SNEAKING: {
                            baseRange = (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                            break;
                        }
                        default: {
                            baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
                        }
                    }
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        if (mobProfile != null) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update] Mob {} profile '{}' has no override for stance {}. No matching player profile override. Using default: {}", new Object[]{mob.getName().getString(), mobProfile.getProfileName(), currentStance, baseRange});
                        } else {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update] No mob profile override and no player profile override for Mob {}. Using default for stance {}: {}", new Object[]{mob.getName().getString(), currentStance, baseRange});
                        }
                    }
                }
            }
        }
        if (player.hasEffect(MobEffects.INVISIBILITY)) {
            baseRange *= ((Double)SoundAttractConfig.COMMON.invisibilityStealthFactor.get()).doubleValue();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR] Invisibility applied. Range -> {}", (Object)String.format("%.2f", baseRange));
            }
        }
        int effectiveLight = 0;
        BlockPos playerFeetPos = player.blockPosition();
        BlockPos playerEyesPos = playerFeetPos.above();
        int skyDarkness = level.getSkyDarken();
        if (level.isLoaded(playerFeetPos)) {
            effectiveLight = level.getRawBrightness(playerFeetPos, skyDarkness);
        }
        if (level.isLoaded(playerEyesPos)) {
            effectiveLight = Math.max(effectiveLight, level.getRawBrightness(playerEyesPos, skyDarkness));
        }
        for (ItemStack s : List.of(player.getMainHandItem(), player.getOffhandItem())) {
            Item item = s.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem bi = (BlockItem)item;
            effectiveLight = Math.max(effectiveLight, bi.getBlock().defaultBlockState().getLightEmission());
        }
        double lightFactor = 1.0 + (double)(effectiveLight - (Integer)SoundAttractConfig.COMMON.neutralLightLevel.get()) * ((Double)SoundAttractConfig.COMMON.lightLevelSensitivity.get() / 15.0);
        lightFactor = Math.clamp(lightFactor, (Double)SoundAttractConfig.COMMON.minLightFactor.get(), (Double)SoundAttractConfig.COMMON.maxLightFactor.get());
        baseRange *= lightFactor;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR] Light Level: {}, Factor: {}, Range -> {}", new Object[]{effectiveLight, String.format("%.2f", lightFactor), String.format("%.2f", baseRange)});
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableHeldItemPenalty.get()).booleanValue()) {
            int heldItemCount = 0;
            if (!player.getMainHandItem().isEmpty()) {
                ++heldItemCount;
            }
            if (!player.getOffhandItem().isEmpty()) {
                ++heldItemCount;
            }
            if (heldItemCount > 0) {
                double penaltyPerItem = (Double)SoundAttractConfig.COMMON.heldItemPenaltyFactor.get();
                for (int i = 0; i < heldItemCount; ++i) {
                    baseRange *= penaltyPerItem;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Held Item Penalty: {} items, factor {} (applied {} times) -> {}", new Object[]{heldItemCount, String.format("%.2f", penaltyPerItem), heldItemCount, String.format("%.2f", baseRange)});
                }
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableEnchantmentPenalty.get()).booleanValue()) {
            int enchantedArmorCount = 0;
            for (ItemStack armorStack : player.getArmorSlots()) {
                if (armorStack.isEmpty() || !armorStack.isEnchanted() || StealthDetectionEvents.hasConcealmentEnchant(armorStack)) continue;
                ++enchantedArmorCount;
            }
            if (enchantedArmorCount > 0) {
                baseRange *= Math.pow((Double)SoundAttractConfig.COMMON.armorEnchantmentPenaltyFactor.get(), enchantedArmorCount);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Enchanted Armor Penalty ({} pcs). Range -> {}", (Object)enchantedArmorCount, (Object)String.format("%.2f", baseRange));
                }
            }
            int enchantedHeldCount = 0;
            if (!player.getMainHandItem().isEmpty() && player.getMainHandItem().isEnchanted() && !StealthDetectionEvents.hasConcealmentEnchant(player.getMainHandItem())) {
                ++enchantedHeldCount;
            }
            if (!player.getOffhandItem().isEmpty() && player.getOffhandItem().isEnchanted() && !StealthDetectionEvents.hasConcealmentEnchant(player.getOffhandItem())) {
                ++enchantedHeldCount;
            }
            if (enchantedHeldCount > 0) {
                baseRange *= Math.pow((Double)SoundAttractConfig.COMMON.heldItemEnchantmentPenaltyFactor.get(), enchantedHeldCount);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Enchanted Held Item Penalty ({} pcs). Range -> {}", (Object)enchantedHeldCount, (Object)String.format("%.2f", baseRange));
                }
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalCamouflage.get()).booleanValue()) {
            Optional<Integer> armorColorOpt = StealthDetectionEvents.getEffectiveArmorColor(player);
            Optional<Integer> envColorOpt = StealthDetectionEvents.getAverageEnvironmentalColor(player, level);
            if (armorColorOpt.isPresent() && envColorOpt.isPresent()) {
                int diff = StealthDetectionEvents.colorDifference(armorColorOpt.get(), envColorOpt.get());
                if (diff <= (Integer)SoundAttractConfig.COMMON.environmentalCamouflageColorMatchThreshold.get()) {
                    double ratio = 1.0 - (double)diff / (double)((Integer)SoundAttractConfig.COMMON.environmentalCamouflageColorMatchThreshold.get()).intValue();
                    double effect = (Double)SoundAttractConfig.COMMON.environmentalCamouflageMaxEffectiveness.get() * ratio;
                    baseRange *= 1.0 - effect;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR] EnvCamo BONUS (diff: {}). Range -> {}", (Object)diff, (Object)String.format("%.2f", baseRange));
                    }
                } else if (((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalMismatchPenalty.get()).booleanValue() && diff > (Integer)SoundAttractConfig.COMMON.environmentalMismatchThreshold.get()) {
                    baseRange *= ((Double)SoundAttractConfig.COMMON.environmentalMismatchPenaltyFactor.get()).doubleValue();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR] EnvCamo PENALTY (diff: {}). Range -> {}", (Object)diff, (Object)String.format("%.2f", baseRange));
                    }
                }
            }
        }
        if (level.isRainingAt(player.blockPosition())) {
            baseRange *= ((Double)SoundAttractConfig.COMMON.rainStealthFactor.get()).doubleValue();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR] Rain applied. Range -> {}", (Object)String.format("%.2f", baseRange));
            }
        }
        if (level.isThundering()) {
            baseRange *= ((Double)SoundAttractConfig.COMMON.thunderStealthFactor.get()).doubleValue();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR] Thunder applied. Range -> {}", (Object)String.format("%.2f", baseRange));
            }
        }
        if (currentStance != PlayerStance.SNEAKING && currentStance != PlayerStance.CRAWLING) {
            if (StealthDetectionEvents.isPlayerMoving(player, (Double)SoundAttractConfig.COMMON.movementThreshold.get())) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.movementStealthPenalty.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Movement penalty applied. Range -> {}", (Object)String.format("%.2f", baseRange));
                }
            } else {
                baseRange *= ((Double)SoundAttractConfig.COMMON.stationaryStealthBonusFactor.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Stationary bonus applied. Range -> {}", (Object)String.format("%.2f", baseRange));
                }
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableCamouflage.get()).booleanValue() && !(camoItems = new ArrayList((Collection)SoundAttractConfig.COMMON.camouflageArmorItems.get())).isEmpty()) {
            boolean hasFullSet;
            double totalEffect = 0.0;
            int piecesWorn = 0;
            int camoPiecesWorn = 0;
            ArrayList armorList = new ArrayList();
            player.getArmorSlots().forEach(armorList::add);
            Collections.reverse(armorList);
            block17: for (int i = 0; i < armorList.size(); ++i) {
                ItemStack armorStack = (ItemStack)armorList.get(i);
                if (armorStack.isEmpty()) continue;
                ++piecesWorn;
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)armorStack.getItem());
                if (itemId == null || !camoItems.contains(itemId.toString())) continue;
                ++camoPiecesWorn;
                switch (i) {
                    case 0: {
                        totalEffect += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                        continue block17;
                    }
                    case 1: {
                        totalEffect += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                        continue block17;
                    }
                    case 2: {
                        totalEffect += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                        continue block17;
                    }
                    case 3: {
                        totalEffect += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                    }
                }
            }
            boolean bl = hasFullSet = piecesWorn == 4 && camoPiecesWorn == 4;
            if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                totalEffect = hasFullSet ? (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get() : 0.0;
            } else if (hasFullSet && (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get() > totalEffect) {
                totalEffect = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
            }
            if (totalEffect > 0.0) {
                baseRange *= 1.0 - Math.min(totalEffect, 0.99);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR] Item Camo effect {} applied. Range -> {}", (Object)String.format("%.2f", totalEffect), (Object)String.format("%.2f", baseRange));
                }
            }
        }
        double finalRange = Math.clamp(baseRange, (Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get());
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_End] Final calculated range for {}: {}", (Object)player.getName().getString(), (Object)String.format("%.2f", finalRange));
        }
        return finalRange;
    }

    private static Optional<Integer> getEffectiveArmorColor(Player player) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        boolean onlyDyedLeather = (Boolean)SoundAttractConfig.COMMON.environmentalCamouflageOnlyDyedLeather.get();
        for (ItemStack itemStack : player.getArmorSlots()) {
            ResourceLocation itemIdRL;
            DyedItemColor dyedColor;
            ArmorItem armorItem;
            if (itemStack.isEmpty()) continue;
            Item item = itemStack.getItem();
            boolean colorAdded = false;
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getMaterial().is(ArmorMaterials.LEATHER) && (dyedColor = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR)) != null && dyedColor.showInTooltip()) {
                colors.add(dyedColor.rgb());
                colorAdded = true;
            }
            if (onlyDyedLeather && !colorAdded || colorAdded || (itemIdRL = BuiltInRegistries.ITEM.getKey((Object)item)) == null) continue;
            Integer mappedColorValue = SoundAttractConfig.customArmorColors.get(itemIdRL);
            if (mappedColorValue != null) {
                colors.add(mappedColorValue);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[GetArmorColor] Using MAPPED color for {}: 0x{}", (Object)itemIdRL, (Object)String.format("%06X", mappedColorValue));
                continue;
            }
            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
            SoundAttractMod.LOGGER.info("[GetArmorColor] Item {} not found in custom_armor_color_map.", (Object)itemIdRL);
        }
        if (colors.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GetArmorColor] No determinable armor colors found.");
            }
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int numColors = colors.size();
        if (numColors == 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[GetArmorColor] numColors is 0 after processing, this should not happen if colors list was not empty.");
            }
            return Optional.empty();
        }
        int avgR = (int)(totalR / (long)numColors);
        int avgG = (int)(totalG / (long)numColors);
        int avgB = (int)(totalB / (long)numColors);
        int finalAvgColor = avgR << 16 | avgG << 8 | avgB;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GetArmorColor] Average armor color: 0x{} from {} pieces.", (Object)String.format("%06X", finalAvgColor), (Object)numColors);
        }
        return Optional.of(finalAvgColor);
    }

    private static Optional<Integer> getAverageEnvironmentalColor(Player player, Level level) {
        ArrayList<Integer> blockColors = new ArrayList<Integer>();
        BlockPos playerPos = player.blockPosition();
        for (int yOffset = 0; yOffset >= -1; --yOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    int mapColor;
                    BlockState blockState;
                    BlockPos currentPos = playerPos.offset(xOffset, yOffset, zOffset);
                    if (!level.isLoaded(currentPos) || (blockState = level.getBlockState(currentPos)).isAir() || (mapColor = blockState.getMapColor((BlockGetter)level, (BlockPos)currentPos).col) == 0) continue;
                    blockColors.add(mapColor);
                }
            }
        }
        if (blockColors.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GetEnvColor] No block map colors found in sampling area.");
            }
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator iterator = blockColors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int numColors = blockColors.size();
        if (numColors == 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[GetEnvColor] numColors is 0 after processing, this should not happen if blockColors list was not empty.");
            }
            return Optional.empty();
        }
        int avgR = (int)(totalR / (long)numColors);
        int avgG = (int)(totalG / (long)numColors);
        int avgB = (int)(totalB / (long)numColors);
        int finalAvgColor = avgR << 16 | avgG << 8 | avgB;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GetEnvColor] Average environment color: 0x{} from {} blocks.", (Object)String.format("%06X", finalAvgColor), (Object)numColors);
        }
        return Optional.of(finalAvgColor);
    }

    public static class GunshotInfo {
        public final long timestamp;
        public final double detectionRange;

        public GunshotInfo(long timestamp, double detectionRange) {
            this.timestamp = timestamp;
            this.detectionRange = detectionRange;
        }
    }
}

