/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.StealthDetectionEvents;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FleeFromUnseenAttackerGoal
extends Goal {
    protected final Mob mob;
    private final double speedModifier;
    private double wantedX;
    private double wantedY;
    private double wantedZ;
    private LivingEntity attacker;

    public FleeFromUnseenAttackerGoal(Mob mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        Mob mob = this.mob;
        if (!(mob instanceof PathfinderMob)) {
            return false;
        }
        PathfinderMob pathfinderMob = (PathfinderMob)mob;
        this.attacker = this.mob.getLastHurtByMob();
        if (this.attacker == null) {
            return false;
        }
        LivingEntity livingEntity = this.attacker;
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        if (StealthDetectionEvents.canMobDetectPlayer(this.mob, player)) {
            return false;
        }
        Vec3 fleePos = DefaultRandomPos.getPosAway((PathfinderMob)pathfinderMob, (int)16, (int)7, (Vec3)this.attacker.position());
        if (fleePos == null) {
            return false;
        }
        this.wantedX = fleePos.x;
        this.wantedY = fleePos.y;
        this.wantedZ = fleePos.z;
        return true;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    public void stop() {
        this.attacker = null;
    }
}

