/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class RaidManager {
    private static final int DEFAULT_RAID_COUNTDOWN_TICKS = 200;
    private static final Map<ResourceLocation, PerWorldData> DATA = new ConcurrentHashMap<ResourceLocation, PerWorldData>();

    private static PerWorldData getData(ServerLevel level) {
        return DATA.computeIfAbsent(level.dimension().location(), k -> new PerWorldData());
    }

    public static void scheduleRaid(Mob leader, BlockPos targetPos, long now) {
        Level level = leader.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        PerWorldData d = RaidManager.getData(level2);
        Raid raid = new Raid(leader, targetPos, now);
        d.leaderToRaid.put(leader, raid);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            int countdown = (Integer)SoundAttractConfig.COMMON.raidCountdownTicks.get();
            SoundAttractMod.LOGGER.info("[RaidManager] Scheduled RAID for leader {} at {} (countdown {} ticks)", new Object[]{leader.getName().getString(), targetPos, countdown});
        }
    }

    public static boolean isRaidTicking(Mob leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null && !r.advancing && r.ticksRemaining > 0;
    }

    public static boolean isRaidAdvancing(Mob leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null && r.advancing;
    }

    public static BlockPos getRaidTarget(Mob leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null ? r.target : null;
    }

    public static int getTicksRemaining(Mob leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null ? r.ticksRemaining : -1;
    }

    public static void clearRaid(Mob leader) {
        Level level = leader.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        PerWorldData d = RaidManager.getData(level2);
        d.leaderToRaid.remove(leader);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[RaidManager] Cleared RAID for leader {}", (Object)leader.getName().getString());
        }
    }

    private static Raid getRaid(Mob leader) {
        Level level = leader.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel level2 = (ServerLevel)level;
        PerWorldData d = RaidManager.getData(level2);
        Raid r = d.leaderToRaid.get(leader);
        if (r == null) {
            return null;
        }
        if (!r.isValid()) {
            d.leaderToRaid.remove(leader);
            return null;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(ServerLevel level) {
        PerWorldData d = RaidManager.getData(level);
        long now = level.getGameTime();
        if (d.lastCleanupTime == -1L || now - d.lastCleanupTime > 200L) {
            d.leaderToRaid.entrySet().removeIf(e -> e.getKey() == null || ((Mob)e.getKey()).isRemoved() || !((Mob)e.getKey()).isAlive());
            d.lastCleanupTime = now;
        }
        Map<Mob, Raid> map = d.leaderToRaid;
        synchronized (map) {
            Iterator<Map.Entry<Mob, Raid>> it = d.leaderToRaid.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Mob, Raid> entry = it.next();
                Mob leader = entry.getKey();
                Raid raid = entry.getValue();
                if (leader == null || leader.isRemoved() || !leader.isAlive() || raid == null) {
                    it.remove();
                    continue;
                }
                if (raid.advancing) continue;
                if (raid.ticksRemaining > 0) {
                    --raid.ticksRemaining;
                    if (raid.ticksRemaining % 20 == 0 && ((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[RaidManager] RAID ticking for leader {}: {} ticks remaining", (Object)leader.getName().getString(), (Object)raid.ticksRemaining);
                    }
                }
                if (raid.ticksRemaining > 0) continue;
                raid.ticksRemaining = 0;
                raid.advancing = true;
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[RaidManager] RAID READY: leader {} advancing to {}", (Object)leader.getName().getString(), (Object)raid.target);
            }
        }
    }

    private static class PerWorldData {
        final Map<Mob, Raid> leaderToRaid = Collections.synchronizedMap(new WeakHashMap());
        long lastCleanupTime = -1L;

        private PerWorldData() {
        }
    }

    private static class Raid {
        final WeakReference<Mob> leaderRef;
        final BlockPos target;
        int ticksRemaining;
        boolean advancing;
        final long scheduledAt;

        Raid(Mob leader, BlockPos target, long now) {
            int configured;
            this.leaderRef = new WeakReference<Mob>(leader);
            this.target = target;
            this.ticksRemaining = configured = SoundAttractConfig.COMMON != null && SoundAttractConfig.COMMON.raidCountdownTicks != null ? (Integer)SoundAttractConfig.COMMON.raidCountdownTicks.get() : 200;
            this.advancing = false;
            this.scheduledAt = now;
        }

        boolean isValid() {
            Mob leader = (Mob)this.leaderRef.get();
            return leader != null && leader.isAlive() && !leader.isRemoved();
        }
    }
}

