/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.player.Player;

public class PlayerProfile {
    private final String profileName;
    @Nullable
    private final CompoundTag nbtMatcher;
    private final Map<PlayerStance, Double> detectionOverrides;

    public PlayerProfile(String profileName, @Nullable String nbtMatcherString, Map<PlayerStance, Double> detectionOverrides) {
        this.profileName = Objects.requireNonNull(profileName, "profileName cannot be null");
        CompoundTag parsedNbt = null;
        if (nbtMatcherString != null && !nbtMatcherString.trim().isEmpty()) {
            try {
                parsedNbt = TagParser.parseTag((String)nbtMatcherString);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Failed to parse NBT matcher for player profile '{}': {}", (Object)profileName, (Object)e.getMessage());
            }
        }
        this.nbtMatcher = parsedNbt;
        this.detectionOverrides = Objects.requireNonNull(detectionOverrides, "detectionOverrides cannot be null");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Optional<Double> getDetectionOverride(PlayerStance stance) {
        return Optional.ofNullable(this.detectionOverrides.get((Object)stance));
    }

    public boolean matches(Player player) {
        if (player == null) {
            return false;
        }
        if (this.nbtMatcher == null || this.nbtMatcher.isEmpty()) {
            return true;
        }
        CompoundTag playerNbt = player.saveWithoutId(new CompoundTag());
        return this.checkNbt(playerNbt, this.nbtMatcher);
    }

    private boolean checkNbt(CompoundTag actual, CompoundTag matcher) {
        return this.checkNbtWithPath(actual, matcher, "");
    }

    private boolean checkNbtWithPath(CompoundTag actual, CompoundTag matcher, String path) {
        for (String key : matcher.getAllKeys()) {
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (!actual.contains(key, (int)matcher.getTagType(key))) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.debug("PlayerProfile '{}' NBT mismatch: missing key or type at '{}'", (Object)this.profileName, (Object)fullPath);
                }
                return false;
            }
            if (matcher.getTagType(key) == 10) {
                if (this.checkNbtWithPath(actual.getCompound(key), matcher.getCompound(key), fullPath)) continue;
                return false;
            }
            if (matcher.getTagType(key) == 9) {
                ListTag matcherList = matcher.getList(key, 0);
                if (matcherList.isEmpty()) continue;
                Tag matchElem = matcherList.get(0);
                ListTag actualList = actual.getList(key, (int)matchElem.getId());
                boolean found = false;
                for (int i = 0; i < actualList.size(); ++i) {
                    if (!actualList.get(i).equals((Object)matchElem)) continue;
                    found = true;
                    break;
                }
                if (found || !((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.debug("PlayerProfile '{}' NBT list did not contain matcher element at '{}'", (Object)this.profileName, (Object)fullPath);
                continue;
            }
            if (actual.get(key).equals((Object)matcher.get(key))) continue;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.debug("PlayerProfile '{}' NBT value mismatch at '{}': actual={} expected={}", new Object[]{this.profileName, fullPath, actual.get(key), matcher.get(key)});
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "PlayerProfile{profileName='" + this.profileName + "'" + (String)(this.nbtMatcher != null ? ", nbtMatcher=" + this.nbtMatcher.getAsString() : "") + ", detectionOverrides=" + String.valueOf(this.detectionOverrides) + "}";
    }
}

