/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.config.SoundAttractConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public final class EnhancedAICompat {
    private static final boolean IS_ENHANCED_AI_LOADED = ModList.get().isLoaded("enhancedai");
    private static final int DEFAULT_MAX_Y = 256;
    private static final boolean DEFAULT_BLACKLIST_TILES = true;
    private static final TagKey<Block> EMPTY_BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"soundattract:empty_block_tag"));

    private EnhancedAICompat() {
    }

    public static int getMaxY() {
        return (Integer)SoundAttractConfig.COMMON.blockBreakMaxY.get();
    }

    public static boolean shouldBlacklistTileEntities() {
        return (Boolean)SoundAttractConfig.COMMON.blockBreakBlacklistTileEntities.get();
    }

    public static boolean isBlacklistAsWhitelist() {
        return (Boolean)SoundAttractConfig.COMMON.blockBreakListAsWhitelist.get();
    }

    public static TagKey<Block> getBlockBlacklistTag() {
        return EMPTY_BLACKLIST;
    }

    public static double getTeleportToTargetChance(Level level) {
        return (Double)SoundAttractConfig.COMMON.teleportChance.get();
    }

    public static int getTeleportCooldownTicks() {
        return (Integer)SoundAttractConfig.COMMON.teleportCooldownTicks.get();
    }

    public static double getPickUpAndThrowChance(Level level) {
        return (Double)SoundAttractConfig.COMMON.pickUpChance.get();
    }

    public static int getPickUpMinDistanceToPickUp() {
        return (Integer)SoundAttractConfig.COMMON.pickUpMinDistanceToPickUp.get();
    }

    public static int getPickUpMaxDistanceToThrow() {
        return (Integer)SoundAttractConfig.COMMON.pickUpMaxDistanceToThrow.get();
    }

    public static double getPickUpSpeedModifier() {
        return (Double)SoundAttractConfig.COMMON.pickUpSpeedModifier.get();
    }

    public static int getPickUpCooldownTicks() {
        return (Integer)SoundAttractConfig.COMMON.pickUpCooldownTicks.get();
    }

    public static boolean isEnhancedAiLoaded() {
        return IS_ENHANCED_AI_LOADED;
    }

    public static double getXrayAttributeValue(Mob mob) {
        return 0.0;
    }
}

