/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractNetwork;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="soundattract", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundAttractClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientWorld == null || clientPlayer == null) {
            return;
        }
        SoundInstance soundInstance = event.getSound();
        if (soundInstance instanceof AbstractSoundInstance) {
            boolean isStepSound;
            AbstractSoundInstance soundInstance2 = (AbstractSoundInstance)soundInstance;
            ResourceLocation soundRL = soundInstance2.m_7904_();
            if (soundRL == null || soundRL.equals((Object)SoundMessage.VOICE_CHAT_SOUND_ID)) {
                return;
            }
            if (!SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(soundRL)) {
                return;
            }
            SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundRL);
            if (se == null) {
                return;
            }
            double x = soundInstance2.m_7772_();
            double y = soundInstance2.m_7780_();
            double z = soundInstance2.m_7778_();
            ResourceLocation dim = clientWorld.m_46472_().m_135782_();
            Optional<UUID> sourcePlayerUUID = Optional.empty();
            int calculatedRange = -1;
            double calculatedWeight = 1.0;
            boolean bl = isStepSound = se != null && se.m_11660_().m_135815_().contains("step") && clientPlayer.m_20182_().m_82531_(x, y, z) < 2.25;
            if (isStepSound) {
                sourcePlayerUUID = Optional.of(clientPlayer.m_20148_());
                Vec3 motion = clientPlayer.m_20184_();
                double horizontalSpeedSq = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
                boolean isOnGround = clientPlayer.m_20096_();
                boolean isSneaking = clientPlayer.m_6144_();
                boolean isSprinting = clientPlayer.m_20142_();
                PlayerAction currentAction = PlayerAction.IDLE;
                if (isSneaking) {
                    if (horizontalSpeedSq > 1.0E-6 && horizontalSpeedSq <= 9.0E-4) {
                        currentAction = PlayerAction.CRAWLING;
                    } else if (horizontalSpeedSq > 9.0E-4 && horizontalSpeedSq <= 0.004791600000000001) {
                        currentAction = PlayerAction.SNEAKING;
                    }
                } else if (isSprinting && !isOnGround) {
                    currentAction = PlayerAction.SPRINT_JUMPING;
                } else if (isSprinting && horizontalSpeedSq > 0.046655999999999996) {
                    currentAction = PlayerAction.SPRINTING;
                } else if (isOnGround && horizontalSpeedSq > 1.0E-6 && horizontalSpeedSq <= 0.046655999999999996) {
                    currentAction = PlayerAction.WALKING;
                }
                switch (currentAction) {
                    case CRAWLING: {
                        calculatedRange = 2;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case SNEAKING: {
                        calculatedRange = 3;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case WALKING: {
                        calculatedRange = 8;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case SPRINTING: {
                        calculatedRange = 12;
                        calculatedWeight = 1.0;
                        break;
                    }
                    case SPRINT_JUMPING: {
                        calculatedRange = 16;
                        calculatedWeight = 1.0;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            SoundMessage msg = new SoundMessage(soundRL, x, y, z, dim, sourcePlayerUUID, calculatedRange, calculatedWeight);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("Sending sound to server: {} at ({}, {}, {}) with range {} in dimension {}", new Object[]{soundRL, x, y, z, calculatedRange, dim});
            }
            SoundAttractNetwork.INSTANCE.sendToServer((Object)msg);
        }
    }

    public static void registerVoiceChatIntegration() {
    }

    private static int parseIntOr(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static double parseDoubleOr(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static enum PlayerAction {
        IDLE,
        CRAWLING,
        SNEAKING,
        WALKING,
        SPRINTING,
        SPRINT_JUMPING;

    }
}

