/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.enchantment.ModEnchantments;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="soundattract", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StealthDetectionEvents {
    private static final Map<Mob, Integer> mobOutOfRangeTicks = new HashMap<Mob, Integer>();
    private static final Map<Player, Vec3> lastPlayerPositions = new HashMap<Player, Vec3>();
    private static long lastStealthCheckTick = -1L;
    private static final Map<UUID, GunshotInfo> playerGunshotInfo = new HashMap<UUID, GunshotInfo>();
    private static final Map<UUID, Double> XRAY_RANGE_CACHE = new HashMap<UUID, Double>();

    private static int getStealthCheckInterval() {
        return (Integer)SoundAttractConfig.COMMON.stealthCheckInterval.get();
    }

    private static boolean hasConcealmentEnchant(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41793_() || ModEnchantments.CONCEAL == null) {
            return false;
        }
        Enchantment concealEnchant = (Enchantment)ModEnchantments.CONCEAL.get();
        if (concealEnchant == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && !stack.m_41619_() && stack.m_41793_()) {
                SoundAttractMod.LOGGER.warn("[HasConceal] Conceal enchantment not resolved from ModEnchantments for item: {}", (Object)stack.m_41611_().getString());
            }
            return false;
        }
        return EnchantmentHelper.m_44843_((Enchantment)concealEnchant, (ItemStack)stack) > 0;
    }

    public static void resetXrayCache() {
        XRAY_RANGE_CACHE.clear();
    }

    public static void recordPlayerGunshot(Player player, double detectionRange) {
        if (player == null || player.f_19853_.m_5776_()) {
            return;
        }
        long currentTime = player.f_19853_.m_46467_();
        playerGunshotInfo.put(player.m_20148_(), new GunshotInfo(currentTime, detectionRange));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[Gunshot] Recorded gunshot for {} with range {}. Effective until tick {}.", new Object[]{player.m_7755_().getString(), String.format("%.2f", detectionRange), currentTime + (long)((Integer)SoundAttractConfig.COMMON.gunshotDetectionDurationTicks.get()).intValue()});
        }
    }

    private static Optional<Double> getActiveGunshotRange(Player player) {
        long duration;
        GunshotInfo info = playerGunshotInfo.get(player.m_20148_());
        if (info == null) {
            return Optional.empty();
        }
        long currentTime = player.f_19853_.m_46467_();
        if (currentTime - info.timestamp < (duration = (long)((Integer)SoundAttractConfig.COMMON.gunshotDetectionDurationTicks.get()).intValue())) {
            return Optional.of(info.detectionRange);
        }
        playerGunshotInfo.remove(player.m_20148_());
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onMobAttemptTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return;
        }
        LivingEntity newTarget = event.getNewTarget();
        if (newTarget instanceof Player) {
            Player playerTarget = (Player)newTarget;
            if (playerTarget.m_7500_() || playerTarget.m_5833_() || !playerTarget.m_6084_()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Player {} is creative/spectator/dead. Allowing target by {}.", (Object)playerTarget.m_7755_().getString(), (Object)mob.m_7755_().getString());
                }
                return;
            }
            if (!StealthDetectionEvents.canMobDetectPlayer(mob, playerTarget)) {
                event.setCanceled(true);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} targeting of Player {} CANCELED due to stealth rules.", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                }
            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[LivingChangeTargetEvent] Mob {} targeting of Player {} ALLOWED (passes stealth check).", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
            }
        }
    }

    public static boolean canMobDetectPlayer(Mob mob, Player player) {
        if (mob == null || player == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[CanDetectPlayer] Called with null mob or player. Defaulting to detectable.");
            }
            return true;
        }
        if (player.m_7500_() || player.m_5833_() || !player.m_6084_()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CanDetectPlayer] Player {} is creative/spectator/dead. Bypassing stealth. Mob {}.", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
            }
            return true;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return true;
        }
        Level level = mob.f_19853_;
        double detectionRange = StealthDetectionEvents.getRealisticStealthDetectionRange(player, mob, level);
        double distSq = mob.m_20280_((Entity)player);
        if (distSq > detectionRange * detectionRange) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[StealthQuery] Player {} is OUT OF RANGE for mob {} (distSq: {}, rangeSq: {}).", new Object[]{player.m_7755_().getString(), mob.m_7755_().getString(), String.format("%.2f", distSq), String.format("%.2f", detectionRange * detectionRange)});
            }
            return false;
        }
        if (!FovEvents.isTargetInFov(mob, (Entity)player, true)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[StealthQuery] Player {} is IN RANGE for mob {} but OUTSIDE FOV. Denying detection.", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
            }
            return false;
        }
        double xrayRange = StealthDetectionEvents.getEffectiveXrayRange(mob);
        if (xrayRange > 0.0 && distSq <= xrayRange * xrayRange) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[StealthQuery] Player {} detected by mob {} via XRAY range {}.", new Object[]{player.m_7755_().getString(), mob.m_7755_().getString(), String.format("%.2f", xrayRange)});
            }
            return true;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[StealthQuery] Player {} IS DETECTABLE by mob {} (in range and in FOV).", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
        }
        return true;
    }

    private static double getEffectiveXrayRange(Mob mob) {
        if (mob == null) {
            return 0.0;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableXrayTargeting.get()).booleanValue()) {
            return 0.0;
        }
        try {
            String applyTagStr = (String)SoundAttractConfig.COMMON.xrayApplyTag.get();
            if (applyTagStr == null || applyTagStr.trim().isEmpty()) {
                return 0.0;
            }
            ResourceLocation applyRl = ResourceLocation.m_135820_((String)applyTagStr.trim());
            if (applyRl == null) {
                return 0.0;
            }
            TagKey applyTag = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)applyRl);
            if (!mob.m_6095_().m_204039_(applyTag)) {
                return 0.0;
            }
            if (((Boolean)SoundAttractConfig.COMMON.xrayRequireBetterNearby.get()).booleanValue()) {
                String betterTagStr = (String)SoundAttractConfig.COMMON.xrayBetterNearbyTag.get();
                if (betterTagStr == null || betterTagStr.trim().isEmpty()) {
                    return 0.0;
                }
                ResourceLocation betterRl = ResourceLocation.m_135820_((String)betterTagStr.trim());
                if (betterRl == null) {
                    return 0.0;
                }
                TagKey betterTag = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)betterRl);
                if (!mob.m_6095_().m_204039_(betterTag)) {
                    return 0.0;
                }
            }
        }
        catch (Exception e) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[XRAY] Tag check failed for mob {}: {}", (Object)mob.m_7755_().getString(), (Object)e.getMessage());
            }
            return 0.0;
        }
        if (EnhancedAICompat.isEnhancedAiLoaded()) {
            double v = EnhancedAICompat.getXrayAttributeValue(mob);
            return Math.max(0.0, v);
        }
        Double cached = XRAY_RANGE_CACHE.get(mob.m_20148_());
        if (cached != null) {
            return cached;
        }
        int max = (Integer)SoundAttractConfig.COMMON.xrayMaxRange.get();
        if (max <= 0) {
            XRAY_RANGE_CACHE.put(mob.m_20148_(), 0.0);
            return 0.0;
        }
        int min = (Integer)SoundAttractConfig.COMMON.xrayMinRange.get();
        min = Math.max(0, Math.min(min, max));
        double chance = (Double)SoundAttractConfig.COMMON.xrayChance.get();
        if (mob.m_217043_().m_188500_() >= chance) {
            XRAY_RANGE_CACHE.put(mob.m_20148_(), 0.0);
            return 0.0;
        }
        int spread = max - min;
        int chosen = spread <= 0 ? max : min + mob.m_217043_().m_188503_(spread + 1);
        double result = chosen;
        XRAY_RANGE_CACHE.put(mob.m_20148_(), result);
        return result;
    }

    public static boolean shouldSuppressTargeting(Mob mob) {
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return false;
        }
        LivingEntity target = mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        return !StealthDetectionEvents.canMobDetectPlayer(mob, player);
    }

    public static boolean shouldSuppressTargeting(Mob mob, Player player) {
        return !StealthDetectionEvents.canMobDetectPlayer(mob, player);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        int stealthCheckInterval;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return;
        }
        long gameTime = event.getServer().m_129783_().m_46467_();
        if (gameTime % (long)(stealthCheckInterval = StealthDetectionEvents.getStealthCheckInterval()) != 0L || gameTime == lastStealthCheckTick) {
            return;
        }
        lastStealthCheckTick = gameTime;
        for (ServerLevel level : event.getServer().m_129785_()) {
            int simDistBlocks = level.m_7654_().m_6846_().m_11312_() * 16;
            HashSet mobsToCheck = new HashSet();
            for (ServerPlayer serverPlayer : level.m_6907_()) {
                AABB scanArea = serverPlayer.m_20191_().m_82400_((double)simDistBlocks);
                mobsToCheck.addAll(level.m_6443_(Mob.class, scanArea, entity -> entity.m_6084_() && entity.m_5448_() instanceof Player));
            }
            for (Mob mob : mobsToCheck) {
                Player playerTarget = (Player)mob.m_5448_();
                if (playerTarget.m_7500_() || playerTarget.m_5833_()) {
                    mobOutOfRangeTicks.remove(mob);
                    continue;
                }
                boolean canCurrentlyDetect = StealthDetectionEvents.canMobDetectPlayer(mob, playerTarget);
                if (canCurrentlyDetect) {
                    if (mobOutOfRangeTicks.remove(mob) == null || !((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                    SoundAttractMod.LOGGER.info("[TickCheck] Mob {} regained direct detection of {}. Grace period reset.", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                    continue;
                }
                int ticks = mobOutOfRangeTicks.getOrDefault(mob, 0) + stealthCheckInterval;
                if (ticks >= (Integer)SoundAttractConfig.COMMON.stealthGracePeriodTicks.get()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[TickCheck] Mob {} lost target {} due to stealth grace period timeout.", (Object)mob.m_7755_().getString(), (Object)playerTarget.m_7755_().getString());
                    }
                    if (mob.m_6274_().m_21874_(MemoryModuleType.f_26334_)) {
                        mob.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                    }
                    mob.m_6710_(null);
                    mobOutOfRangeTicks.remove(mob);
                    continue;
                }
                mobOutOfRangeTicks.put(mob, ticks);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[TickCheck] Mob {} cannot detect {}. In grace period ({}/{}).", new Object[]{mob.m_7755_().getString(), playerTarget.m_7755_().getString(), ticks, SoundAttractConfig.COMMON.stealthGracePeriodTicks.get()});
            }
        }
    }

    public static boolean isPlayerMoving(Player player, double threshold) {
        if (player == null) {
            return false;
        }
        Vec3 currentPos = player.m_20182_();
        Vec3 lastPos = lastPlayerPositions.get(player);
        boolean moved = false;
        if (lastPos != null) {
            double distSq = currentPos.m_82557_(lastPos);
            moved = distSq > threshold * threshold;
        }
        lastPlayerPositions.put(player, currentPos);
        return moved;
    }

    private static PlayerStance determinePlayerStance(Player player) {
        Pose currentPose = player.m_20089_();
        boolean isVisuallyCrawling = player.m_20143_();
        boolean isCrouching = player.m_6047_();
        float playerHeight = player.m_6972_((Pose)currentPose).f_20378_;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[DetermineStanceDetails] Player: {}, Pose: {}, isVisuallyCrawling: {}, isCrouching: {}, Height: {}", new Object[]{player.m_7755_().getString(), currentPose, isVisuallyCrawling, isCrouching, String.format("%.2f", Float.valueOf(playerHeight))});
        }
        if (isVisuallyCrawling) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is CRAWLING (VisualCrawl: true, Pose: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.CRAWLING;
        }
        if (currentPose == Pose.SWIMMING || currentPose == Pose.SPIN_ATTACK || currentPose == Pose.FALL_FLYING) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is CRAWLING-EQUIVALENT (Pose: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.CRAWLING;
        }
        if (isCrouching) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is SNEAKING (Pose: {}, Crouching: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, isCrouching, String.format("%.2f", Float.valueOf(playerHeight))});
            }
            return PlayerStance.SNEAKING;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[DetermineStance] Player {} is STANDING (Pose: {}, Height: {})", new Object[]{player.m_7755_().getString(), currentPose, String.format("%.2f", Float.valueOf(playerHeight))});
        }
        return PlayerStance.STANDING;
    }

    public static double getRealisticStealthDetectionRange(Player player, Mob mob, Level level) {
        double finalCalculatedRange;
        int i;
        double baseRange;
        if (!((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            return (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get();
        }
        Optional<Double> gunshotRangeOpt = StealthDetectionEvents.getActiveGunshotRange(player);
        PlayerStance currentStance = StealthDetectionEvents.determinePlayerStance(player);
        if (gunshotRangeOpt.isPresent()) {
            baseRange = gunshotRangeOpt.get();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} has active gunshot flash. Initial range set to {}.", (Object)player.m_7755_().getString(), (Object)String.format("%.2f", baseRange));
            }
            double standingRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
            double poseReduction = Math.max(0.0, standingRange - (switch (currentStance) {
                case PlayerStance.CRAWLING -> (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                case PlayerStance.SNEAKING -> (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                default -> standingRange;
            }));
            baseRange -= poseReduction;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Gunshot range adjusted by pose {}. Reduction of {}. New range: {}.", new Object[]{currentStance, String.format("%.2f", poseReduction), String.format("%.2f", baseRange)});
            }
        } else {
            Optional override;
            MobProfile mobProfile = SoundAttractConfig.getMatchingProfile(mob);
            Optional<Object> optional = override = mobProfile != null ? mobProfile.getDetectionOverride(currentStance) : Optional.empty();
            if (override.isPresent()) {
                baseRange = (Double)override.get();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Mob {} using profile '{}' detection range for stance {}: {}", new Object[]{mob.m_7755_().getString(), mobProfile.getProfileName(), currentStance, baseRange});
                }
            } else {
                Optional playerOverride;
                PlayerProfile playerProfile = SoundAttractConfig.getMatchingPlayerProfile(player);
                Optional<Object> optional2 = playerOverride = playerProfile != null ? playerProfile.getDetectionOverride(currentStance) : Optional.empty();
                if (playerOverride.isPresent()) {
                    baseRange = (Double)playerOverride.get();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} matched player profile '{}' for stance {}: {}", new Object[]{player.m_7755_().getString(), playerProfile.getProfileName(), currentStance, baseRange});
                    }
                } else {
                    switch (currentStance) {
                        case CRAWLING: {
                            baseRange = (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                            break;
                        }
                        case SNEAKING: {
                            baseRange = (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                            break;
                        }
                        default: {
                            baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
                        }
                    }
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        if (mobProfile != null) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update] Mob {} profile '{}' has no override for stance {}. No matching player profile override. Using default: {}", new Object[]{mob.m_7755_().getString(), mobProfile.getProfileName(), currentStance, baseRange});
                        } else {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update] No mob profile override and no player profile override for Mob {}. Using default for stance {}: {}", new Object[]{mob.m_7755_().getString(), currentStance, baseRange});
                        }
                    }
                }
            }
        }
        if (player.m_21023_(MobEffects.f_19609_)) {
            double invisFactor = (Double)SoundAttractConfig.COMMON.invisibilityStealthFactor.get();
            baseRange *= invisFactor;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Player {} is invisible, reducing baseRange to {}", (Object)player.m_7755_().getString(), (Object)String.format("%.2f", baseRange));
            }
        }
        BlockPos basePos = player.m_20183_();
        long dayTime = level.m_46468_() % 24000L;
        boolean isDay = dayTime >= 0L && dayTime < 12000L;
        int effectiveLight = 0;
        BlockPos playerFeetPos = player.m_20183_();
        BlockPos playerEyesPos = playerFeetPos.m_7494_();
        if (level.m_46749_(playerFeetPos)) {
            effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.BLOCK, playerFeetPos));
            if (isDay && level.m_45527_(playerFeetPos)) {
                effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.SKY, playerFeetPos));
            }
        }
        if (level.m_46749_(playerEyesPos)) {
            effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.BLOCK, playerEyesPos));
            if (isDay && level.m_45527_(playerEyesPos)) {
                effectiveLight = Math.max(effectiveLight, level.m_45517_(LightLayer.SKY, playerEyesPos));
            }
        }
        for (ItemStack s : List.of(player.m_21205_(), player.m_21206_())) {
            Item item = s.m_41720_();
            if (!(item instanceof BlockItem)) continue;
            BlockItem bi = (BlockItem)item;
            BlockState def = bi.m_40614_().m_49966_();
            if (!level.m_46749_(basePos)) continue;
            int emit = def.getLightEmission((BlockGetter)level, basePos);
            effectiveLight = Math.max(effectiveLight, emit);
        }
        double neutral = ((Integer)SoundAttractConfig.COMMON.neutralLightLevel.get()).intValue();
        double sensitivity = (Double)SoundAttractConfig.COMMON.lightLevelSensitivity.get();
        double lightEffect = ((double)effectiveLight - neutral) * (sensitivity / 15.0);
        double lightFactor = 1.0 + lightEffect;
        lightFactor = Math.max((Double)SoundAttractConfig.COMMON.minLightFactor.get(), lightFactor);
        lightFactor = Math.min((Double)SoundAttractConfig.COMMON.maxLightFactor.get(), lightFactor);
        baseRange *= lightFactor;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_Update] Light - EffectiveLight: {}, LightFactor (clamped): {}, baseRange: {}", new Object[]{effectiveLight, String.format("%.2f", lightFactor), String.format("%.2f", baseRange)});
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableHeldItemPenalty.get()).booleanValue()) {
            int heldItemCount = 0;
            if (!player.m_21205_().m_41619_()) {
                ++heldItemCount;
            }
            if (!player.m_21206_().m_41619_()) {
                ++heldItemCount;
            }
            if (heldItemCount > 0) {
                double penaltyPerItem = (Double)SoundAttractConfig.COMMON.heldItemPenaltyFactor.get();
                for (i = 0; i < heldItemCount; ++i) {
                    baseRange *= penaltyPerItem;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Held Item Penalty: {} items, factor {:.2f} (applied {} times) -> {:.2f}", new Object[]{heldItemCount, penaltyPerItem, heldItemCount, baseRange});
                }
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableEnchantmentPenalty.get()).booleanValue()) {
            int visiblyEnchantedArmorPieces = 0;
            for (ItemStack armorStack : player.m_6168_()) {
                if (armorStack.m_41619_() || !armorStack.m_41793_() || StealthDetectionEvents.hasConcealmentEnchant(armorStack)) continue;
                ++visiblyEnchantedArmorPieces;
            }
            if (visiblyEnchantedArmorPieces > 0) {
                double armorPenaltyFactor = (Double)SoundAttractConfig.COMMON.armorEnchantmentPenaltyFactor.get();
                for (i = 0; i < visiblyEnchantedArmorPieces; ++i) {
                    baseRange *= armorPenaltyFactor;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Armor Enchant Penalty: {} pieces, factor {:.2f} (applied {} times) -> {:.2f}", new Object[]{visiblyEnchantedArmorPieces, armorPenaltyFactor, visiblyEnchantedArmorPieces, baseRange});
                }
            }
            int visiblyEnchantedHeldItems = 0;
            if (!player.m_21205_().m_41619_() && player.m_21205_().m_41793_() && !StealthDetectionEvents.hasConcealmentEnchant(player.m_21205_())) {
                ++visiblyEnchantedHeldItems;
            }
            if (!player.m_21206_().m_41619_() && player.m_21206_().m_41793_() && !StealthDetectionEvents.hasConcealmentEnchant(player.m_21206_())) {
                ++visiblyEnchantedHeldItems;
            }
            if (visiblyEnchantedHeldItems > 0) {
                double heldItemEnchantPenalty = (Double)SoundAttractConfig.COMMON.heldItemEnchantmentPenaltyFactor.get();
                for (int i2 = 0; i2 < visiblyEnchantedHeldItems; ++i2) {
                    baseRange *= heldItemEnchantPenalty;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Held Item Enchant Penalty: {} items, factor {:.2f} (applied {} times) -> {:.2f}", new Object[]{visiblyEnchantedHeldItems, heldItemEnchantPenalty, visiblyEnchantedHeldItems, baseRange});
                }
            }
        }
        ArrayList camouflageItems = new ArrayList((Collection)SoundAttractConfig.COMMON.camouflageArmorItems.get());
        if (((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalCamouflage.get()).booleanValue()) {
            Optional<Integer> armorColorOpt = StealthDetectionEvents.getEffectiveArmorColor(player);
            Optional<Integer> envColorOpt = StealthDetectionEvents.getAverageEnvironmentalColor(player, level);
            if (armorColorOpt.isPresent() && envColorOpt.isPresent()) {
                int matchBonusThreshold;
                int armorColor = armorColorOpt.get();
                int envColor = envColorOpt.get();
                int rArmor = armorColor >> 16 & 0xFF;
                int gArmor = armorColor >> 8 & 0xFF;
                int bArmor = armorColor & 0xFF;
                int rEnv = envColor >> 16 & 0xFF;
                int gEnv = envColor >> 8 & 0xFF;
                int bEnv = envColor & 0xFF;
                int diff = Math.abs(rArmor - rEnv) + Math.abs(gArmor - gEnv) + Math.abs(bArmor - bEnv);
                if (diff <= (matchBonusThreshold = ((Integer)SoundAttractConfig.COMMON.environmentalCamouflageColorMatchThreshold.get()).intValue())) {
                    double maxBonusEffect = (Double)SoundAttractConfig.COMMON.environmentalCamouflageMaxEffectiveness.get();
                    double effectivenessRatio = matchBonusThreshold > 0 ? 1.0 - (double)diff / (double)matchBonusThreshold : (diff == 0 ? 1.0 : 0.0);
                    double actualBonusEffectiveness = maxBonusEffect * effectivenessRatio;
                    baseRange *= 1.0 - actualBonusEffectiveness;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[EnvCamo] Player {} BONUS: armor=0x{}, env=0x{}, diff={}, matchThold={}, ratio={}, effect={}, newRange={}", new Object[]{player.m_7755_().getString(), String.format("%06X", armorColor), String.format("%06X", envColor), diff, matchBonusThreshold, String.format("%.2f", effectivenessRatio), String.format("%.2f", actualBonusEffectiveness), String.format("%.2f", baseRange)});
                    }
                } else if (((Boolean)SoundAttractConfig.COMMON.enableEnvironmentalMismatchPenalty.get()).booleanValue()) {
                    int mismatchPenaltyThreshold = (Integer)SoundAttractConfig.COMMON.environmentalMismatchThreshold.get();
                    if (diff > mismatchPenaltyThreshold) {
                        double penaltyFactor = (Double)SoundAttractConfig.COMMON.environmentalMismatchPenaltyFactor.get();
                        baseRange *= penaltyFactor;
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[EnvCamo] Player {} PENALTY: armor=0x{}, env=0x{}, diff={}, mismatchThold={}, penaltyFactor={}, newRange={}", new Object[]{player.m_7755_().getString(), String.format("%06X", armorColor), String.format("%06X", envColor), diff, mismatchPenaltyThreshold, String.format("%.2f", penaltyFactor), String.format("%.2f", baseRange)});
                        }
                    } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[EnvCamo] Player {} NEUTRAL: armor=0x{}, env=0x{}, diff={}, no bonus or penalty from env camo.", new Object[]{player.m_7755_().getString(), String.format("%06X", armorColor), String.format("%06X", envColor), diff});
                    }
                }
            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[EnvCamo] Player {} - Could not get armor or environment color. Skipping.", (Object)player.m_7755_().getString());
            }
        }
        if (level.m_46758_(player.m_20183_())) {
            baseRange *= ((Double)SoundAttractConfig.COMMON.rainStealthFactor.get()).doubleValue();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Raining. Factor applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
            }
        }
        if (level.m_46470_()) {
            baseRange *= ((Double)SoundAttractConfig.COMMON.thunderStealthFactor.get()).doubleValue();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_Update] Thundering. Factor applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
            }
        }
        if (currentStance != PlayerStance.SNEAKING && currentStance != PlayerStance.CRAWLING) {
            if (StealthDetectionEvents.isPlayerMoving(player, (Double)SoundAttractConfig.COMMON.movementThreshold.get())) {
                baseRange *= ((Double)SoundAttractConfig.COMMON.movementStealthPenalty.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Player moving (not sneak/crawl). Penalty applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
                }
            } else {
                baseRange *= ((Double)SoundAttractConfig.COMMON.stationaryStealthBonusFactor.get()).doubleValue();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_Update] Player stationary (not sneak/crawl). Bonus applied. baseRange: {}", (Object)String.format("%.2f", baseRange));
                }
            }
        } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_Update] Player sneaking/crawling. Movement penalty/bonus not applied here (handled by stance base range). baseRange: {}", (Object)String.format("%.2f", baseRange));
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableCamouflage.get()).booleanValue()) {
            if (!camouflageItems.isEmpty()) {
                boolean isActuallyWearingFullSetOfListedItems;
                double effectToApply = 0.0;
                int totalActualArmorPieces = 0;
                long wornListedCamouflagePieces = 0L;
                for (ItemStack armorStack : player.m_6168_()) {
                    if (armorStack.m_41619_()) continue;
                    ++totalActualArmorPieces;
                    ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)armorStack.m_41720_());
                    if (itemId == null || !camouflageItems.contains(itemId.toString())) continue;
                    ++wornListedCamouflagePieces;
                }
                boolean bl = isActuallyWearingFullSetOfListedItems = totalActualArmorPieces == 4 && wornListedCamouflagePieces == (long)totalActualArmorPieces && totalActualArmorPieces > 0;
                if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                    if (isActuallyWearingFullSetOfListedItems) {
                        effectToApply = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} wearing full set of listed items (requireFullSet=true). Applying fullArmorStealthBonus: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                        }
                    } else {
                        double totalEffectiveness = 0.0;
                        ArrayList armorItemsList = new ArrayList();
                        player.m_6168_().forEach(armorItemsList::add);
                        block26: for (i = 0; i < armorItemsList.size(); ++i) {
                            Item item;
                            ResourceLocation itemId;
                            ItemStack stack = (ItemStack)armorItemsList.get(i);
                            if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)(item = stack.m_41720_()))) == null || !camouflageItems.contains(itemId.toString())) continue;
                            switch (i) {
                                case 0: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                                    continue block26;
                                }
                                case 1: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                                    continue block26;
                                }
                                case 2: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                                    continue block26;
                                }
                                case 3: {
                                    totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                                }
                            }
                        }
                        effectToApply = totalEffectiveness;
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} wearing partial listed camo (requireFullSet=true). Applying summed per-piece effectiveness: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                        }
                    }
                } else if (isActuallyWearingFullSetOfListedItems && (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get() > 0.0) {
                    effectToApply = (Double)SoundAttractConfig.COMMON.fullArmorStealthBonus.get();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} wearing full set of listed items (requireFullSet=false, using full bonus). Applying fullArmorStealthBonus: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                    }
                } else {
                    double totalEffectiveness = 0.0;
                    ArrayList armorItemsList = new ArrayList();
                    player.m_6168_().forEach(armorItemsList::add);
                    block27: for (i = 0; i < armorItemsList.size(); ++i) {
                        Item item;
                        ResourceLocation itemId;
                        ItemStack stack = (ItemStack)armorItemsList.get(i);
                        if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)(item = stack.m_41720_()))) == null || !camouflageItems.contains(itemId.toString())) continue;
                        switch (i) {
                            case 0: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                                continue block27;
                            }
                            case 1: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                                continue block27;
                            }
                            case 2: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                                continue block27;
                            }
                            case 3: {
                                totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                            }
                        }
                    }
                    effectToApply = totalEffectiveness;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} (requireFullSet=false). Applying summed per-piece effectiveness: {}", (Object)player.m_7755_().getString(), (Object)effectToApply);
                    }
                }
                if (effectToApply > 0.0) {
                    double itemCamoMultiplier = 1.0 - Math.min(effectToApply, 0.99);
                    baseRange *= itemCamoMultiplier;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[GRSDR_Update ItemCamo] Player {} range after general item camouflage: {}. Applied multiplier: {} (Effect: {})", new Object[]{player.m_7755_().getString(), String.format("%.2f", baseRange), String.format("%.2f", itemCamoMultiplier), String.format("%.2f", effectToApply)});
                    }
                }
                double finalCalculatedRange2 = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[GRSDR_End] Mob: {}, Player: {}, Final Calculated Range (camo items processed): {}", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", finalCalculatedRange2)});
                }
                return finalCalculatedRange2;
            }
            finalCalculatedRange = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GRSDR_End] Mob: {}, Player: {}, Item Camo enabled but no items configured. Final Range: {}", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", finalCalculatedRange)});
            }
            return finalCalculatedRange;
        }
        finalCalculatedRange = Math.max((Double)SoundAttractConfig.COMMON.minStealthDetectionRange.get(), Math.min(baseRange, (Double)SoundAttractConfig.COMMON.maxStealthDetectionRange.get()));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GRSDR_End] Mob: {}, Player: {}, Item Camo system disabled. Final Range: {}", new Object[]{mob.m_7755_().getString(), player.m_7755_().getString(), String.format("%.2f", finalCalculatedRange)});
        }
        return finalCalculatedRange;
    }

    private static Optional<Integer> getEffectiveArmorColor(Player player) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        boolean onlyDyedLeather = (Boolean)SoundAttractConfig.COMMON.environmentalCamouflageOnlyDyedLeather.get();
        for (ItemStack itemStack : player.m_6168_()) {
            ResourceLocation itemIdRL;
            DyeableLeatherItem dyeableItem;
            ArmorItem armorItem;
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            boolean colorAdded = false;
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.LEATHER && item instanceof DyeableLeatherItem && (dyeableItem = (DyeableLeatherItem)item).m_41113_(itemStack)) {
                colors.add(dyeableItem.m_41121_(itemStack));
                colorAdded = true;
            }
            if (onlyDyedLeather && !colorAdded || colorAdded || (itemIdRL = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            Integer mappedColorValue = SoundAttractConfig.customArmorColors.get(itemIdRL);
            if (mappedColorValue != null) {
                colors.add(mappedColorValue);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[GetArmorColor] Using MAPPED color for {}: 0x{}", (Object)itemIdRL, (Object)String.format("%06X", mappedColorValue));
                continue;
            }
            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
            SoundAttractMod.LOGGER.info("[GetArmorColor] Item {} not found in custom_armor_color_map.", (Object)itemIdRL);
        }
        if (colors.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GetArmorColor] No determinable armor colors found.");
            }
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int numColors = colors.size();
        if (numColors == 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[GetArmorColor] numColors is 0 after processing, this should not happen if colors list was not empty.");
            }
            return Optional.empty();
        }
        int avgR = (int)(totalR / (long)numColors);
        int avgG = (int)(totalG / (long)numColors);
        int avgB = (int)(totalB / (long)numColors);
        int finalAvgColor = avgR << 16 | avgG << 8 | avgB;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GetArmorColor] Average armor color: 0x{} from {} pieces.", (Object)String.format("%06X", finalAvgColor), (Object)numColors);
        }
        return Optional.of(finalAvgColor);
    }

    private static Optional<Integer> getAverageEnvironmentalColor(Player player, Level level) {
        ArrayList<Integer> blockColors = new ArrayList<Integer>();
        BlockPos playerPos = player.m_20183_();
        for (int yOffset = 0; yOffset >= -1; --yOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    int mapColor;
                    BlockState blockState;
                    BlockPos currentPos = playerPos.m_7918_(xOffset, yOffset, zOffset);
                    if (!level.m_46749_(currentPos) || (blockState = level.m_8055_(currentPos)).m_60795_() || (mapColor = blockState.m_60780_((BlockGetter)level, (BlockPos)currentPos).f_76396_) == 0) continue;
                    blockColors.add(mapColor);
                }
            }
        }
        if (blockColors.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[GetEnvColor] No block map colors found in sampling area.");
            }
            return Optional.empty();
        }
        long totalR = 0L;
        long totalG = 0L;
        long totalB = 0L;
        Iterator iterator = blockColors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            totalR += (long)(color >> 16 & 0xFF);
            totalG += (long)(color >> 8 & 0xFF);
            totalB += (long)(color & 0xFF);
        }
        int numColors = blockColors.size();
        if (numColors == 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.warn("[GetEnvColor] numColors is 0 after processing, this should not happen if blockColors list was not empty.");
            }
            return Optional.empty();
        }
        int avgR = (int)(totalR / (long)numColors);
        int avgG = (int)(totalG / (long)numColors);
        int avgB = (int)(totalB / (long)numColors);
        int finalAvgColor = avgR << 16 | avgG << 8 | avgB;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[GetEnvColor] Average environment color: 0x{} from {} blocks.", (Object)String.format("%06X", finalAvgColor), (Object)numColors);
        }
        return Optional.of(finalAvgColor);
    }

    public static class GunshotInfo {
        public final long timestamp;
        public final double detectionRange;

        public GunshotInfo(long timestamp, double detectionRange) {
            this.timestamp = timestamp;
            this.detectionRange = detectionRange;
        }
    }
}

