/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Random;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class FollowLeaderGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private Mob leader;
    private AttractionGoal leaderAttractionGoal = null;
    private static final double MAX_DISTANCE = 12.0;
    private Vec3 lastPos = null;
    private int stuckTicks = 0;
    private int stuckThreshold;
    private int dynamicTickCounter;
    private Vec3 lastRandomDest;
    private boolean hasPickedDest;

    public FollowLeaderGoal(Mob mob, double moveSpeed) {
        this.stuckThreshold = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        this.dynamicTickCounter = 0;
        this.lastRandomDest = null;
        this.hasPickedDest = false;
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private double getGroupDistance() {
        return (Double)SoundAttractConfig.COMMON.groupDistance.get();
    }

    public boolean m_8036_() {
        this.leader = MobGroupManager.getLeader(this.mob);
        if (this.leader == null || this.leader == this.mob) {
            return false;
        }
        if (this.mob.m_20280_((Entity)this.leader) > this.getGroupDistance() * this.getGroupDistance()) {
            return false;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (smartEdge && MobGroupManager.isEdgeMob(this.mob)) {
            return false;
        }
        if (!this.leader.m_6084_()) {
            return false;
        }
        this.leaderAttractionGoal = null;
        this.leader.f_21345_.m_25386_().forEach(goal -> {
            Goal patt1843$temp = goal.m_26015_();
            if (patt1843$temp instanceof AttractionGoal) {
                AttractionGoal ag;
                this.leaderAttractionGoal = ag = (AttractionGoal)patt1843$temp;
            }
        });
        return this.leaderAttractionGoal != null && this.leaderAttractionGoal.isPursuingSound();
    }

    public boolean m_8045_() {
        if (this.leader == null || !this.leader.m_6084_()) {
            return false;
        }
        if (this.mob.m_20280_((Entity)this.leader) > this.getGroupDistance() * this.getGroupDistance()) {
            return false;
        }
        this.leaderAttractionGoal = StreamSupport.stream(this.leader.f_21345_.m_25386_().spliterator(), false).map(WrappedGoal::m_26015_).filter(g -> g instanceof AttractionGoal).map(g -> (AttractionGoal)((Object)g)).findFirst().orElse(null);
        if (this.leaderAttractionGoal == null || !this.leaderAttractionGoal.isPursuingSound()) {
            return false;
        }
        return !this.leader.m_21573_().m_26571_();
    }

    public void m_8037_() {
        if (this.leader == null) {
            return;
        }
        if (this.leaderAttractionGoal == null || !this.leaderAttractionGoal.isPursuingSound()) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[FollowLeaderGoal] Mob {} following leader {} (leader is pursuing sound)", (Object)this.mob.m_7755_().getString(), (Object)this.leader.m_7755_().getString());
        }
        int scanCooldown = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        int updateInterval = Math.max(1, scanCooldown / 2);
        this.dynamicTickCounter = (this.dynamicTickCounter + 1) % updateInterval;
        if (this.dynamicTickCounter != 0) {
            return;
        }
        BlockPos soundPos = null;
        try {
            Field f = ((Object)((Object)this.leaderAttractionGoal)).getClass().getDeclaredField("targetSoundPos");
            f.setAccessible(true);
            soundPos = (BlockPos)f.get((Object)this.leaderAttractionGoal);
        }
        catch (Exception f) {
            // empty catch block
        }
        if (soundPos == null) {
            return;
        }
        double arrivalDistance = (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
        if (!this.hasPickedDest) {
            Random rand = new Random(this.mob.m_20148_().hashCode() ^ soundPos.hashCode());
            double angle = rand.nextDouble() * 2.0 * Math.PI;
            double radius = arrivalDistance * Math.sqrt(rand.nextDouble());
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            int destX = soundPos.m_123341_() + (int)Math.floor(offsetX);
            int destZ = soundPos.m_123343_() + (int)Math.floor(offsetZ);
            int groundY = this.mob.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destX, destZ);
            double finalX = (double)destX + 0.5;
            double finalY = groundY;
            double finalZ = (double)destZ + 0.5;
            this.lastRandomDest = new Vec3(finalX, finalY, finalZ);
            this.hasPickedDest = true;
        }
        if (this.lastRandomDest != null) {
            Vec3 curPos = this.mob.m_20182_();
            if (curPos.m_82557_(this.lastRandomDest) > 2.25) {
                this.mob.m_21573_().m_26519_(this.lastRandomDest.f_82479_, this.lastRandomDest.f_82480_, this.lastRandomDest.f_82481_, this.moveSpeed);
            }
            if (this.lastPos != null && curPos.m_82557_(this.lastPos) < 0.04) {
                ++this.stuckTicks;
                if (this.stuckTicks > this.stuckThreshold) {
                    this.hasPickedDest = false;
                    this.stuckTicks = 0;
                }
            } else {
                this.stuckTicks = 0;
            }
            this.lastPos = curPos;
        }
        if (this.leader.m_21573_().m_26571_()) {
            this.hasPickedDest = false;
            this.lastRandomDest = null;
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        this.leader = null;
        this.hasPickedDest = false;
        this.lastRandomDest = null;
    }
}

