/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class TeleportToSoundGoal
extends Goal {
    private final Mob mob;
    private final TargetingConditions targetingConditions;
    private Mob toTeleport;
    private int unreachableTime;
    private int cooldown;
    private int teleportTick;
    private SoundTracker.SoundRecord targetSound;

    public TeleportToSoundGoal(Mob mob) {
        this.mob = mob;
        this.targetingConditions = TargetingConditions.m_148353_().m_26883_(this.getFollowDistance());
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!((Boolean)SoundAttractConfig.COMMON.enableTeleportToSound.get()).booleanValue()) {
            return false;
        }
        if (--this.cooldown > 0) {
            return false;
        }
        if (this.mob.m_6162_()) {
            return false;
        }
        String teleporterTagStr = (String)SoundAttractConfig.COMMON.teleportCanTeleportTag.get();
        if (teleporterTagStr == null || teleporterTagStr.isEmpty()) {
            return false;
        }
        ResourceLocation teleporterRl = ResourceLocation.m_135820_((String)teleporterTagStr);
        if (teleporterRl == null) {
            return false;
        }
        TagKey teleporterTag = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)teleporterRl);
        if (!this.mob.m_6095_().m_204039_(teleporterTag)) {
            return false;
        }
        double chance = EnhancedAICompat.getTeleportToTargetChance(this.mob.f_19853_);
        if (this.mob.m_217043_().m_188500_() >= chance) {
            return false;
        }
        this.targetSound = SoundTracker.findNearestSound(this.mob, this.mob.f_19853_, this.mob.m_20183_(), this.mob.m_146892_(), null);
        if (this.targetSound == null) {
            return false;
        }
        String targetTagStr = (String)SoundAttractConfig.COMMON.teleportCanBeTeleportedTag.get();
        if (targetTagStr == null || targetTagStr.isEmpty()) {
            return false;
        }
        ResourceLocation targetRl = ResourceLocation.m_135820_((String)targetTagStr);
        if (targetRl == null) {
            return false;
        }
        TagKey targetTag = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)targetRl);
        this.targetingConditions.m_26883_(this.getFollowDistance());
        this.toTeleport = (Mob)this.mob.f_19853_.m_45982_(this.mob.f_19853_.m_6443_(Mob.class, this.mob.m_20191_().m_82400_(this.getFollowDistance()), other -> other != this.mob && other.m_6084_() && other.m_6095_().m_204039_(targetTag)), this.targetingConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        return this.toTeleport != null;
    }

    public boolean m_8045_() {
        return this.toTeleport != null && this.toTeleport.m_6084_() && this.targetSound != null && this.targetSound.ticksRemaining > 0;
    }

    public void m_8056_() {
        this.mob.m_21563_().m_148051_((Entity)this.toTeleport);
        this.mob.m_21573_().m_26573_();
        this.mob.m_21573_().m_5624_((Entity)this.toTeleport, 1.5);
        this.toTeleport.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.toTeleport = null;
        this.unreachableTime = 0;
        this.targetSound = null;
        this.teleportTick = 0;
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }

    public void m_8037_() {
        if (this.targetSound == null) {
            this.m_8041_();
            return;
        }
        BlockPos soundPos = this.targetSound.pos;
        if (this.teleportTick <= 0) {
            this.mob.m_21563_().m_148051_((Entity)this.toTeleport);
            this.toTeleport.m_21573_().m_26573_();
            if (this.mob.m_21573_().m_26571_()) {
                this.mob.m_21573_().m_5624_((Entity)this.toTeleport, 1.5);
            }
            if (this.mob.m_20280_((Entity)this.toTeleport) <= 4.0) {
                this.hide((LivingEntity)this.mob);
                this.hide((LivingEntity)this.toTeleport);
                this.teleportTick = this.m_183277_(30);
            }
        } else if (--this.teleportTick <= 0) {
            this.show((LivingEntity)this.mob);
            this.teleportSafely((LivingEntity)this.toTeleport, (double)soundPos.m_123341_() + 0.5, soundPos.m_123342_(), (double)soundPos.m_123343_() + 0.5);
            this.show((LivingEntity)this.toTeleport);
            this.cooldown = this.m_183277_(EnhancedAICompat.getTeleportCooldownTicks());
            this.m_8041_();
            return;
        }
        if (++this.unreachableTime > this.m_183277_(120)) {
            this.cooldown = this.m_183277_(EnhancedAICompat.getTeleportCooldownTicks());
            this.m_8041_();
        }
    }

    private void hide(LivingEntity entity) {
        this.applySpeedFreeze(entity);
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 200, 0.5, 0.5, 0.5, 0.5);
        }
        entity.m_5496_(SoundEvents.f_11852_, 4.0f, 0.5f);
        entity.m_20242_(true);
        entity.m_6842_(true);
    }

    private void show(LivingEntity entity) {
        this.removeSpeedFreeze(entity);
        entity.m_20242_(false);
        entity.m_6842_(false);
        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 2.0f);
    }

    private void applySpeedFreeze(LivingEntity entity) {
        if (!entity.m_21023_(MobEffects.f_19597_) || entity.m_21124_(MobEffects.f_19597_).m_19564_() < 10) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.m_183277_(60), 10, false, false, false));
        }
    }

    private void removeSpeedFreeze(LivingEntity entity) {
        entity.m_21195_(MobEffects.f_19597_);
    }

    private void teleportSafely(LivingEntity entity, double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pX, pY, pZ);
        BlockState state = entity.f_19853_.m_8055_((BlockPos)mutable);
        Material mat = state.m_60767_();
        boolean blocksMotion = mat != null && mat.m_76334_();
        boolean isWater = state.m_60819_().m_205070_(FluidTags.f_13131_);
        if (blocksMotion && !isWater) {
            do {
                Vec3 oldPos = entity.m_20182_();
                entity.m_6021_(pX, pY += 1.0, pZ);
                entity.f_19853_.m_214171_(GameEvent.f_238175_, oldPos, GameEvent.Context.m_223717_((Entity)entity));
            } while (entity.m_20186_() < (double)entity.f_19853_.m_151558_() && !entity.f_19853_.m_45786_((Entity)entity));
        } else {
            Vec3 oldPos = entity.m_20182_();
            entity.m_6021_(pX, pY, pZ);
            entity.f_19853_.m_214171_(GameEvent.f_238175_, oldPos, GameEvent.Context.m_223717_((Entity)entity));
        }
    }
}

