/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractNetwork;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaIntegrationEvents {
    private static boolean wasSprinting = false;
    private static boolean wasSneaking = false;
    private static boolean wasCrawling = false;
    private static boolean wasOnGround = true;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean isJumping;
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.f_46443_) {
            return;
        }
        int cooldown = DynamicScanCooldownManager.currentScanCooldownTicks;
        if (++tickCounter % cooldown != 0) {
            return;
        }
        Player player = event.player;
        ResourceLocation dim = player.f_19853_.m_46472_().m_135782_();
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        Optional<UUID> uuid = Optional.of(player.m_20148_());
        if (player.m_20142_() && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaSprint", "minecraft:entity.player.sprint", x, y, z, dim, uuid, 10, 1.2, 1.0, 1.0);
        }
        wasSprinting = player.m_20142_();
        if (!player.m_20142_() && !player.m_6047_() && player.m_20184_().m_165925_() > 0.01 && player.m_20096_() && !player.m_20089_().name().equalsIgnoreCase("SWIMMING") && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaWalk", "minecraft:entity.player.walk", x, y, z, dim, uuid, 6, 0.6, 0.8, 1.0);
        }
        boolean bl = isJumping = player.f_19789_ == 0.0f && player.m_20184_().f_82480_ > 0.1 && !wasOnGround;
        if (isJumping && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaJump", "minecraft:entity.player.jump", x, y, z, dim, uuid, 7, 0.7, 0.8, 1.0);
        }
        wasOnGround = player.m_20096_();
        if (player.m_6047_() && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaSneak", "minecraft:entity.player.sneak", x, y, z, dim, uuid, 3, 0.2, 0.4, 1.0);
        }
        wasSneaking = player.m_6047_();
        boolean isCrawling = player.m_20089_().name().equalsIgnoreCase("SWIMMING");
        if (isCrawling && player instanceof ServerPlayer) {
            VanillaIntegrationEvents.sendVanillaSound("VanillaCrawl", "minecraft:block.wool.step", x, y, z, dim, uuid, 2, 0.1, 0.2, 1.0);
        }
        wasCrawling = isCrawling;
    }

    private static int parseIntOr(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static double parseDoubleOr(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static void sendVanillaSound(String animatorClass, String soundId, double x, double y, double z, ResourceLocation dim, Optional<UUID> uuid, int range, double weight, double volume, double pitch) {
        SoundMessage msg = new SoundMessage(ResourceLocation.parse((String)soundId), x, y, z, dim, uuid, range, weight, animatorClass);
        boolean isServer = true;
        try {
            Class.forName("net.minecraft.server.level.ServerPlayer");
        }
        catch (Throwable t) {
            isServer = false;
        }
        if (isServer) {
            String soundIdStr;
            String string = soundIdStr = soundId != null ? soundId : null;
            if (!(SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() || soundIdStr != null && SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(soundIdStr))) {
                return;
            }
            BlockPos pos = new BlockPos(x, y, z);
            String dimString = dim.toString();
            int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
            if (ResourceLocation.parse((String)soundId).equals((Object)SoundMessage.VOICE_CHAT_SOUND_ID)) {
                if (range > 0) {
                    SoundTracker.addSound(null, pos, dimString, range, weight, lifetime);
                }
            } else {
                String id;
                SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)soundId));
                double _range = range;
                double _weight = weight;
                String string2 = id = soundId != null ? soundId : "";
                if (se != null) {
                    SoundAttractMod.LOGGER.info("[SoundMessage] addSound: soundId={} | range={} | weight={} | pos=({}, {}, {}) | dim={}", new Object[]{soundId, _range, _weight, x, y, z, dim});
                    SoundTracker.addSound(se, pos, dimString, _range, _weight, lifetime);
                } else if (animatorClass != null && !animatorClass.isEmpty()) {
                    SoundTracker.addVirtualSound(pos, dimString, _range, _weight, lifetime, uuid.orElse(null), animatorClass);
                }
            }
            return;
        }
        SoundAttractNetwork.INSTANCE.sendToServer((Object)msg);
    }
}

