/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.ConfigReloadListener;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundMessagePayload;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.MobCellAssignmentHooks;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.SoundAttractConfigData;
import com.example.soundattract.enchantment.ModEnchantments;
import com.example.soundattract.integration.PlasmoIntegration;
import com.example.soundattract.integration.PointBlankIntegrationHandler;
import com.example.soundattract.integration.VanillaIntegrationEvents;
import com.example.soundattract.logic.SoundMessageHandler;
import com.example.soundattract.loot.ModLootTables;
import com.example.soundattract.network.SimpleNbtSyncPayload;
import com.example.soundattract.util.WorkerScheduler;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1308;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4140;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.api.server.PlasmoVoiceServer;

public class SoundAttractMod
implements ModInitializer {
    public static final String MOD_ID = "soundattract";
    public static final class_4140<class_2338> SOUND_ATTRACTION_MEMORY = (class_4140)class_2378.method_10230((class_2378)class_7923.field_41129, (class_2960)class_2960.method_60655((String)"soundattract", (String)"sound_attraction_memory"), (Object)new class_4140(Optional.of(class_2338.field_25064)));
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"soundattract");
    public static SoundAttractConfigData CONFIG;
    private final double tpsSmoothingFactor = 0.05;
    private long lastTickTimeNanos = 0L;
    private double averageTickTimeNanos = 5.0E7;
    private PlasmoIntegration plasmo;

    public void onInitialize() {
        ConfigReloadListener.reloadConfig();
        if (CONFIG == null) {
            LOGGER.error("Failed to load SoundAttractMod configuration! Using default or limited functionality.");
            CONFIG = new SoundAttractConfigData();
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            LOGGER.info("[SoundAttract] Initializing. Environment: {}, Thread: {}", (Object)FabricLoader.getInstance().getEnvironmentType(), (Object)Thread.currentThread().getName());
            LOGGER.info("[SoundAttract] Debug logging is ENABLED.");
        }
        ModEnchantments.register();
        ModLootTables.register();
        MobCellAssignmentHooks.register();
        ConfigReloadListener.registerCommand();
        VanillaIntegrationEvents.register();
        StealthDetectionEvents.register();
        this.registerNetworkHandlers();
        this.PointBlankIntegrationHandler();
        if (FabricLoader.getInstance().isModLoaded("plasmovoice")) {
            LOGGER.info("[SoundAttract] Plasmo Voice mod found. Preparing integration.");
            this.plasmo = new PlasmoIntegration();
        }
        this.registerServerLifecycleEvents();
        this.registerTickEvents();
        this.registerEntityEvents();
        if (SoundAttractMod.CONFIG.debugLogging) {
            LOGGER.info("[SoundAttract] Initialization complete.");
            LOGGER.info("[DEBUG] Registered Packet Payloads (Server Perspective):");
            LOGGER.info("[DEBUG]   SoundMessagePayload ID: {}", (Object)SoundMessagePayload.ID.comp_2242());
            LOGGER.info("[DEBUG]   SimpleNbtSyncPayload ID: {}", (Object)SimpleNbtSyncPayload.ID.comp_2242());
        }
    }

    private void registerNetworkHandlers() {
        PayloadTypeRegistry.playC2S().register(SoundMessagePayload.ID, SoundMessagePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SoundMessagePayload.ID, (payload, context) -> context.server().execute(() -> SoundMessageHandler.handle(payload, context.player())));
        PayloadTypeRegistry.playC2S().register(SimpleNbtSyncPayload.ID, SimpleNbtSyncPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SimpleNbtSyncPayload.ID, (payload, context) -> {
            class_2487 nbt = payload.nbt();
            class_3222 player = context.player();
            context.server().execute(() -> {
                if (CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    LOGGER.info("[FabricSimpleNbtSync] Server received NBT from {}: {}", (Object)player.method_5477().getString(), (Object)nbt);
                }
            });
        });
    }

    private void PointBlankIntegrationHandler() {
        if (FabricLoader.getInstance().isModLoaded("pointblank")) {
            if (SoundAttractMod.CONFIG.enablePointBlankIntegration) {
                LOGGER.info("[SoundAttract] Point Blank mod found and integration is enabled. Registering server-side event listeners.");
                try {
                    PointBlankIntegrationHandler.register();
                }
                catch (Throwable e) {
                    LOGGER.error("Failed to register Point Blank integration events. This may be a mixin conflict or an API change.", e);
                }
            } else {
                LOGGER.info("[SoundAttract] Point Blank integration is disabled in the config.");
            }
        } else {
            LOGGER.info("[SoundAttract] Point Blank mod not found, skipping integration.");
        }
    }

    private void registerServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (SoundAttractMod.CONFIG.debugLogging) {
                LOGGER.info("[SoundAttract] Server started. Registering other handlers.");
            }
            if (this.plasmo != null) {
                try {
                    LOGGER.info("[SoundAttract] Loading Plasmo Voice addon...");
                    PlasmoVoiceServer.getAddonsLoader().load((Object)this.plasmo);
                    LOGGER.info("[SoundAttract] Plasmo Voice addon loaded.");
                }
                catch (Throwable t) {
                    LOGGER.error("[SoundAttract] Failed to load Plasmo Voice addon", t);
                }
            }
        });
    }

    private void registerTickEvents() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.lastTickTimeNanos == 0L) {
                this.lastTickTimeNanos = System.nanoTime();
            } else {
                long currentTimeNanos = System.nanoTime();
                long elapsedNanos = currentTimeNanos - this.lastTickTimeNanos;
                this.lastTickTimeNanos = currentTimeNanos;
                this.averageTickTimeNanos = this.averageTickTimeNanos * 0.95 + (double)elapsedNanos * 0.05;
                double tps = Math.min(20.0, 1.0E9 / this.averageTickTimeNanos);
                if (CONFIG != null) {
                    SoundAttractMod.CONFIG.lastKnownTps = tps;
                }
            }
            SoundAttractionEvents.onServerTick(server);
            BlockBreakerManager.processPendingActions();
            long applyBudgetMs = 2L;
            WorkerScheduler.drainGroupResults(MobGroupManager::applyGroupResult, applyBudgetMs);
            WorkerScheduler.drainSoundResults(result -> SoundTracker.applySoundScoreResult(server, result), applyBudgetMs);
        });
    }

    private void registerEntityEvents() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                SoundAttractionEvents.onEntityJoinWorld(mob);
            }
        });
    }
}

