/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessagePayload;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.SoundOverride;
import com.example.soundattract.util.WorkerScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SoundTracker {
    private static final Map<class_2960, List<SoundRecord>> RECENT_SOUNDS_BY_DIM = new ConcurrentHashMap<class_2960, List<SoundRecord>>();
    private static final Map<class_2960, Map<Long, List<SoundRecord>>> SPATIAL_SOUNDS_BY_DIM = new ConcurrentHashMap<class_2960, Map<Long, List<SoundRecord>>>();
    private static final Map<class_2960, WeakHashMap<RaycastCacheKey, double[]>> RAYCAST_CACHE_BY_DIM = new ConcurrentHashMap<class_2960, WeakHashMap<RaycastCacheKey, double[]>>();
    private static final int PREFILTER_LIMIT = 24;
    private static final double WEIGHT_EPSILON = 1.0E-4;

    private static int getGridRadiusForRange(double range, int partitionSize) {
        if (range < 8.0) {
            return 1;
        }
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        for (int i = 1; i <= 20; ++i) {
            if (!(range < 8.0 + (double)partitionSize * (double)i)) continue;
            return i + 1;
        }
        return 21;
    }

    public static Set<Long> getCoveredCells(class_2338 pos, double range, int partitionSize) {
        HashSet<Long> cells = new HashSet<Long>();
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        int gridRadius = SoundTracker.getGridRadiusForRange(range, partitionSize);
        int baseX = pos.method_10263() / partitionSize;
        int baseZ = pos.method_10260() / partitionSize;
        for (int dx = -gridRadius; dx <= gridRadius; ++dx) {
            for (int dz = -gridRadius; dz <= gridRadius; ++dz) {
                int cellX = baseX + dx;
                int cellZ = baseZ + dz;
                long key = (long)cellX << 32 | (long)cellZ & 0xFFFFFFFFL;
                cells.add(key);
            }
        }
        return cells;
    }

    private static synchronized List<SoundRecord> getRecentSoundsList(class_1937 world) {
        return RECENT_SOUNDS_BY_DIM.computeIfAbsent(world.method_27983().method_29177(), k -> Collections.synchronizedList(new ArrayList()));
    }

    private static synchronized Map<Long, List<SoundRecord>> getSpatialSoundMap(class_1937 world) {
        return SPATIAL_SOUNDS_BY_DIM.computeIfAbsent(world.method_27983().method_29177(), k -> new ConcurrentHashMap());
    }

    private static synchronized WeakHashMap<RaycastCacheKey, double[]> getRaycastCache(class_1937 world) {
        return RAYCAST_CACHE_BY_DIM.computeIfAbsent(world.method_27983().method_29177(), k -> new WeakHashMap());
    }

    public static synchronized List<SoundRecord> getRecentSounds(class_1937 world) {
        return new ArrayList<SoundRecord>(SoundTracker.getRecentSoundsList(world));
    }

    private static synchronized void updateSpatialSounds(class_1937 world) {
        Map<Long, List<SoundRecord>> spatialMap = SoundTracker.getSpatialSoundMap(world);
        spatialMap.clear();
        if (SoundAttractMod.CONFIG == null) {
            return;
        }
        int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
        if (partitionSize <= 0) {
            partitionSize = 16;
        }
        List<SoundRecord> currentSounds = SoundTracker.getRecentSoundsList(world);
        for (SoundRecord r : currentSounds) {
            r.coveredCells.clear();
            Set<Long> cells = SoundTracker.getCoveredCells(r.pos, r.range, partitionSize);
            r.coveredCells.addAll(cells);
            for (Long key : cells) {
                spatialMap.computeIfAbsent(key, k -> Collections.synchronizedList(new ArrayList())).add(r);
            }
        }
    }

    public static synchronized void addSound(class_1937 world, class_3414 se, class_2338 pos, double range, double weight, String explicitSoundId) {
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot add sound.");
            return;
        }
        String dimensionKey = world.method_27983().method_29177().toString();
        Object soundIdToUse = explicitSoundId;
        if (soundIdToUse == null && se != null && se.method_14833() != null) {
            soundIdToUse = se.method_14833().toString();
        }
        if (soundIdToUse == null) {
            soundIdToUse = "unknown_sound_id_at_" + pos.method_23854();
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.warn("[SoundTracker] SoundEvent or explicitSoundId resulted in null soundId. Using placeholder: {}", soundIdToUse);
            }
        }
        String finalSoundId = soundIdToUse;
        if (!(SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || SoundAttractMod.CONFIG.soundIdWhitelist.contains(finalSoundId) || finalSoundId.equals(SoundMessagePayload.VOICE_CHAT_SOUND_ID.toString()))) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Skipped non-whitelist sound: {} at {} (dim: {}), range={}, weight={}", new Object[]{finalSoundId, pos, dimensionKey, range, weight});
            }
            return;
        }
        if (range < 0.0) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.warn("[SoundTracker] Attempted to register sound {} at {} (dim: {}) with negative range={}, skipping.", new Object[]{finalSoundId, pos, dimensionKey, range});
            }
            return;
        }
        List<SoundRecord> recentSounds = SoundTracker.getRecentSoundsList(world);
        boolean removed = recentSounds.removeIf(r -> r.pos.equals((Object)pos) && Objects.equals(r.soundId, finalSoundId) && Objects.equals(r.dimensionKey, dimensionKey));
        if (removed && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Refreshed sound (removed old instance): {} at {} (dim: {})", new Object[]{finalSoundId, pos, dimensionKey});
        }
        recentSounds.add(new SoundRecord(se, finalSoundId, pos, dimensionKey, range, weight));
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Registered sound {} at {} (dim: {}), range={}, weight={}, lifetime={}", new Object[]{finalSoundId, pos, dimensionKey, String.format("%.2f", range), String.format("%.2f", weight), SoundAttractMod.CONFIG.soundLifetimeTicks});
        }
        SoundTracker.updateSpatialSounds(world);
    }

    public static synchronized void addSound(class_1937 world, class_3414 se, class_2338 pos, double range, double weight) {
        SoundTracker.addSound(world, se, pos, range, weight, null);
    }

    public static synchronized void addSound(class_1937 world, class_3414 se, class_2338 pos) {
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded for default lifetime sound.");
            return;
        }
        SoundTracker.addSound(world, se, pos, 16.0, 1.0);
    }

    public static synchronized void addVirtualSound(class_1937 world, class_2338 pos, double range, double weight, UUID sourcePlayer, String animationClass) {
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot add virtual sound.");
            return;
        }
        String dimensionKey = world.method_27983().method_29177().toString();
        String constructedVirtualSoundId = "virtual_sound:" + (animationClass != null ? animationClass : "player_action");
        if (sourcePlayer != null) {
            String playerPart = sourcePlayer.toString();
            constructedVirtualSoundId = constructedVirtualSoundId + ":" + (playerPart.length() > 8 ? playerPart.substring(0, 8) : playerPart);
        }
        String finalVirtualSoundId = constructedVirtualSoundId;
        List<SoundRecord> recentSounds = SoundTracker.getRecentSoundsList(world);
        boolean removed = recentSounds.removeIf(r -> r.pos.equals((Object)pos) && Objects.equals(r.soundId, finalVirtualSoundId) && Objects.equals(r.dimensionKey, dimensionKey));
        if (removed && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Refreshed virtual sound (removed old instance): {} at {} (dim: {})", new Object[]{finalVirtualSoundId, pos, dimensionKey});
        }
        recentSounds.add(new VirtualSoundRecord(pos, dimensionKey, range, weight, sourcePlayer, animationClass));
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[SoundTracker] Registered virtual sound (intended ID for refresh check: {}) at {} (dim: {}), range={}, weight={}, lifetime={}", new Object[]{finalVirtualSoundId, pos, dimensionKey, String.format("%.2f", range), String.format("%.2f", weight), SoundAttractMod.CONFIG.soundLifetimeTicks});
        }
        SoundTracker.updateSpatialSounds(world);
    }

    public static synchronized void tick(class_1937 world) {
        List<SoundRecord> recentSounds = SoundTracker.getRecentSoundsList(world);
        if (recentSounds.isEmpty()) {
            return;
        }
        boolean soundsChanged = false;
        Iterator<SoundRecord> iter = recentSounds.iterator();
        while (iter.hasNext()) {
            SoundRecord r = iter.next();
            --r.ticksRemaining;
            if (r.ticksRemaining > 0) continue;
            iter.remove();
            soundsChanged = true;
        }
        if (soundsChanged) {
            SoundTracker.updateSpatialSounds(world);
        }
    }

    public static void applySoundScoreResult(MinecraftServer server, WorkerScheduler.SoundScoreResult result) {
        if (result == null) {
            return;
        }
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)result.getDimensionKey()));
        class_3218 world = server.method_3847(worldKey);
        if (world == null) {
            return;
        }
        class_1297 entity = world.method_14190(result.getMobUuid());
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            if (result.getBest() != null && result.getBest().isValid()) {
                mob.method_18868().method_18878(SoundAttractMod.SOUND_ATTRACTION_MEMORY, (Object)result.getBest().getPosition());
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("{} is now attracted to {}", (Object)mob.method_5477().getString(), (Object)result.getBest().getPosition());
                }
            }
        }
    }

    public static synchronized void removeSoundAt(class_1937 world, class_2338 pos) {
        String dimensionKey;
        List<SoundRecord> recentSounds = SoundTracker.getRecentSoundsList(world);
        boolean removed = recentSounds.removeIf(arg_0 -> SoundTracker.lambda$removeSoundAt$6(pos, dimensionKey = world.method_27983().method_29177().toString(), arg_0));
        if (removed) {
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Removed sound(s) at pos {} in dim {}", (Object)pos, (Object)dimensionKey);
            }
            SoundTracker.updateSpatialSounds(world);
        }
    }

    public static double[] applyBlockMuffling(class_1937 level, class_2338 src, class_2338 dst, double origRange, double origWeight, String soundId) {
        RaycastCacheKey key;
        WeakHashMap<RaycastCacheKey, double[]> raycastCache;
        double[] cached;
        String currentSoundId;
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot apply muffling.");
            return new double[]{origRange, origWeight};
        }
        String string = currentSoundId = soundId != null ? soundId : "unknown_muffling_sound";
        if (SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || SoundAttractMod.CONFIG.soundIdWhitelist.contains(currentSoundId) || currentSoundId.startsWith("virtual_sound:") || !currentSoundId.equals(SoundMessagePayload.VOICE_CHAT_SOUND_ID.toString())) {
            // empty if block
        }
        if ((cached = (raycastCache = SoundTracker.getRaycastCache(level)).get(key = new RaycastCacheKey(dst, src, currentSoundId))) != null) {
            return cached;
        }
        double range = origRange;
        double weight = origWeight;
        int x0 = src.method_10263();
        int y0 = src.method_10264();
        int z0 = src.method_10260();
        int x1 = dst.method_10263();
        int y1 = dst.method_10264();
        int z1 = dst.method_10260();
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int sx = Integer.compare(x1, x0);
        int sy = Integer.compare(y1, y0);
        int sz = Integer.compare(z1, z0);
        int nMaxSteps = dx + dy + dz + 1;
        int x = x0;
        int y = y0;
        int z = z0;
        int err_xy = dx - dy;
        int err_xz = dx - dz;
        int blocksMuffled = 0;
        int areaRadius = SoundAttractMod.CONFIG.mufflingAreaRadius;
        class_243 startVec = class_243.method_24953((class_2382)src);
        class_243 endVec = class_243.method_24953((class_2382)dst);
        class_243 direction = endVec.method_1020(startVec).method_1029();
        double totalDistance = startVec.method_1022(endVec);
        double step = 0.5;
        for (double d = 0.0; d <= totalDistance && range > 0.0 && weight > 0.0; d += step) {
            class_243 currentPoint = startVec.method_1019(direction.method_1021(d));
            class_2338 currentBlockPos = class_2338.method_49638((class_2374)currentPoint);
            boolean muffledThisStep = false;
            for (int dxr = -areaRadius; dxr <= areaRadius && !muffledThisStep; ++dxr) {
                for (int dyr = -areaRadius; dyr <= areaRadius && !muffledThisStep; ++dyr) {
                    for (int dzr = -areaRadius; dzr <= areaRadius && !muffledThisStep; ++dzr) {
                        class_2680 state;
                        class_2248 block;
                        class_2338 posToCheck = currentBlockPos.method_10069(dxr, dyr, dzr);
                        if (d > step && posToCheck.equals((Object)src) || d < totalDistance - step && posToCheck.equals((Object)dst) || !level.method_22340(posToCheck) || (block = (state = level.method_8320(posToCheck)).method_26204()) == class_2246.field_10124 || state.method_26215()) continue;
                        if (SoundTracker.isCustomWool(state, block) && SoundAttractMod.CONFIG.woolMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.woolBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.woolBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if (SoundTracker.isCustomThin(state, block) && SoundAttractMod.CONFIG.thinMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.thinBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.thinBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if (SoundTracker.isCustomNonSolid(state, block) && SoundAttractMod.CONFIG.nonSolidMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.nonSolidBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.nonSolidBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if (SoundTracker.isCustomSolid(state, block) && SoundAttractMod.CONFIG.solidMufflingEnabled) {
                            range -= (double)SoundAttractMod.CONFIG.solidBlockRangeReduction;
                            weight -= SoundAttractMod.CONFIG.solidBlockWeightReduction;
                            ++blocksMuffled;
                            muffledThisStep = true;
                            continue;
                        }
                        if ((state.method_26227() == null || state.method_26227().method_15769()) && !SoundTracker.isCustomLiquid(block) || !SoundAttractMod.CONFIG.liquidMufflingEnabled) continue;
                        range -= (double)SoundAttractMod.CONFIG.liquidBlockRangeReduction;
                        weight -= SoundAttractMod.CONFIG.liquidBlockWeightReduction;
                        ++blocksMuffled;
                        muffledThisStep = true;
                    }
                }
            }
        }
        if (range < 0.0) {
            range = 0.0;
        }
        if (weight < 0.0) {
            weight = 0.0;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[BlockMuffling] soundId={}, src={}, dst={}, origRange={}, origWeight={}, muffledRange={}, muffledWeight={}, blocksMuffled={}", new Object[]{currentSoundId, src, dst, String.format("%.2f", origRange), String.format("%.2f", origWeight), String.format("%.2f", range), String.format("%.2f", weight), blocksMuffled});
        }
        double[] result = new double[]{range, weight};
        if (blocksMuffled > 0 || origRange == 0.0) {
            raycastCache.put(key, result);
        }
        return result;
    }

    public static synchronized void pruneIrrelevantSounds(class_1937 level) {
        List<SoundRecord> recentSounds = SoundTracker.getRecentSoundsList(level);
        if (recentSounds.isEmpty() || SoundAttractMod.CONFIG == null) {
            return;
        }
        int pruneIndex = 0;
        boolean SOUNDS_PRUNED_PER_TICK = true;
        int total = recentSounds.size();
        if (pruneIndex >= total) {
            pruneIndex = 0;
        }
        int prunedThisTick = 0;
        int checkedThisTick = 0;
        ArrayList<SoundRecord> soundsToPrune = new ArrayList<SoundRecord>();
        for (int i = 0; i < total && checkedThisTick < total && prunedThisTick < 1; ++i) {
            int currentIndex = (pruneIndex + i) % total;
            if (currentIndex >= recentSounds.size()) continue;
            SoundRecord sound = recentSounds.get(currentIndex);
            ++checkedThisTick;
            if (!Objects.equals(sound.dimensionKey, level.method_27983().method_29177().toString()) || sound.ticksRemaining > SoundAttractMod.CONFIG.scanCooldownTicks) continue;
            boolean isRelevantToAnyMob = false;
            for (Long cellKey : sound.coveredCells) {
                int cellX = (int)(cellKey >> 32);
                int cellZ = (int)(cellKey & 0xFFFFFFFFL);
                int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
                if (partitionSize <= 0) {
                    partitionSize = 16;
                }
                class_238 checkBox = new class_238((double)(cellX * partitionSize), (double)level.method_31607(), (double)(cellZ * partitionSize), (double)((cellX + 1) * partitionSize), (double)level.method_31600(), (double)((cellZ + 1) * partitionSize));
                List mobsInCell = level.method_8390(class_1308.class, checkBox, m -> m.method_5805());
                for (class_1308 mob : mobsInCell) {
                    Optional<SoundOverride> ov;
                    class_2960 rl;
                    if (!SoundAttractMod.CONFIG.attractedEntities.contains(class_7923.field_41177.method_10221((Object)mob.method_5864()).toString())) continue;
                    MobProfile profile = SoundAttractMod.CONFIG.getMatchingProfile(mob);
                    double effectiveRange = sound.range;
                    double effectiveWeight = sound.weight;
                    if (profile != null && sound.soundId != null && (rl = class_2960.method_12829((String)sound.soundId)) != null && (ov = profile.getSoundOverride(rl)).isPresent()) {
                        effectiveRange = ov.get().getRange();
                        effectiveWeight = ov.get().getWeight();
                    }
                    double[] muffled = SoundTracker.applyBlockMuffling(level, sound.pos, mob.method_24515(), effectiveRange, effectiveWeight, sound.soundId);
                    double finalRange = muffled[0];
                    if (!(mob.method_24515().method_10262((class_2382)sound.pos) <= finalRange * finalRange)) continue;
                    isRelevantToAnyMob = true;
                    break;
                }
                if (!isRelevantToAnyMob) continue;
                break;
            }
            if (isRelevantToAnyMob) continue;
            soundsToPrune.add(sound);
            ++prunedThisTick;
        }
        if (!soundsToPrune.isEmpty()) {
            recentSounds.removeAll(soundsToPrune);
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Pruned {} irrelevant sounds from {}.", (Object)soundsToPrune.size(), (Object)level.method_27983().method_29177());
            }
            SoundTracker.updateSpatialSounds(level);
        }
    }

    public static synchronized SoundRecord findNearestSound(class_1937 level, class_1308 mob, class_2338 mobPos, class_243 mobEyePos) {
        if (SoundAttractMod.CONFIG == null) {
            System.err.println("[SoundTracker] Config not loaded, cannot find nearest sound.");
            return null;
        }
        List<SoundRecord> currentSoundsSnapshot = SoundTracker.getRecentSounds(level);
        if (currentSoundsSnapshot.isEmpty()) {
            return null;
        }
        String dimensionKey = level.method_27983().method_29177().toString();
        MobProfile profile = SoundAttractMod.CONFIG.getMatchingProfile(mob);
        double noveltyBonusValue = SoundAttractMod.CONFIG.soundNoveltyBonusWeight;
        int noveltyTicks = SoundAttractMod.CONFIG.soundNoveltyTimeTicks;
        int maxLifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
        HashMap<String, ApproxCandidate> approxBySound = new HashMap<String, ApproxCandidate>();
        for (SoundRecord r : currentSoundsSnapshot) {
            ApproxCandidate existing;
            double novelty;
            double approxWeight;
            double distSqr;
            Optional<SoundOverride> ov;
            String soundId;
            if (r == null || r.pos == null || !Objects.equals(r.dimensionKey, dimensionKey)) continue;
            String string = soundId = r.soundId != null ? r.soundId : "unknown_sound_in_recent_list";
            if (!SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() && !SoundAttractMod.CONFIG.soundIdWhitelist.contains(soundId) && !soundId.startsWith("virtual_sound:") && !soundId.equals(SoundMessagePayload.VOICE_CHAT_SOUND_ID.toString())) continue;
            double effRange = r.range;
            double effWeight = r.weight;
            class_2960 rl = class_2960.method_12829((String)soundId);
            if (profile != null && rl != null && (ov = profile.getSoundOverride(rl)).isPresent()) {
                effRange = ov.get().getRange();
                effWeight = ov.get().getWeight();
            }
            if ((distSqr = mobPos.method_10262((class_2382)r.pos)) > effRange * effRange || (approxWeight = effWeight + (novelty = noveltyBonusValue > 0.0 && r.ticksRemaining > maxLifetime - noveltyTicks ? noveltyBonusValue : 0.0)) <= 0.0 || (existing = (ApproxCandidate)approxBySound.get(soundId)) != null && !(approxWeight > existing.approxWeight) && (!(Math.abs(approxWeight - existing.approxWeight) < 0.001) || !(distSqr < existing.distSqr))) continue;
            approxBySound.put(soundId, new ApproxCandidate(r, effRange, effWeight, novelty, approxWeight, distSqr, soundId, rl));
        }
        if (approxBySound.isEmpty()) {
            return null;
        }
        ArrayList<Object> shortlist = new ArrayList(approxBySound.values());
        shortlist.sort((a, b) -> {
            int cmp = Double.compare(b.approxWeight, a.approxWeight);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.distSqr, b.distSqr);
        });
        if (shortlist.size() > 24) {
            shortlist = new ArrayList(shortlist.subList(0, 24));
        }
        ApproxCandidate bestCandidate = null;
        double bestFinalWeight = -1.0;
        double bestFinalDist = Double.MAX_VALUE;
        for (ApproxCandidate candidate : shortlist) {
            double finalWeight;
            if (bestCandidate != null && candidate.approxWeight < bestFinalWeight - 1.0E-4) continue;
            double[] muffled = SoundTracker.applyBlockMuffling(level, candidate.rec.pos, mobPos, candidate.effRange, candidate.effWeight, candidate.soundKey);
            candidate.muffledRange = muffled[0];
            candidate.muffledWeight = muffled[1];
            if (candidate.muffledWeight <= 0.0 || candidate.muffledRange <= 0.0 || candidate.distSqr > candidate.muffledRange * candidate.muffledRange || !((finalWeight = candidate.finalWeight()) > bestFinalWeight) && (!(Math.abs(finalWeight - bestFinalWeight) < 0.001) || !(candidate.distSqr < bestFinalDist))) continue;
            bestCandidate = candidate;
            bestFinalWeight = finalWeight;
            bestFinalDist = candidate.distSqr;
        }
        if (bestCandidate == null) {
            return null;
        }
        SoundRecord src = bestCandidate.rec;
        SoundRecord result = new SoundRecord(src.sound, src.soundId, src.pos, src.dimensionKey, bestCandidate.muffledRange, bestCandidate.muffledWeight);
        result.ticksRemaining = src.ticksRemaining;
        return result;
    }

    public static List<class_1308> getMobsForSound(List<class_1308> mobsToFilter, SoundRecord sound, Predicate<class_1308> filter) {
        ArrayList<class_1308> eligibleMobs = new ArrayList<class_1308>();
        if (sound == null || mobsToFilter == null) {
            return eligibleMobs;
        }
        for (class_1308 mob : mobsToFilter) {
            boolean inRange;
            if (mob == null || !mob.method_5805() || !(inRange = mob.method_24515().method_10262((class_2382)sound.pos) <= sound.range * sound.range) || !filter.test(mob)) continue;
            eligibleMobs.add(mob);
        }
        return eligibleMobs;
    }

    private static boolean isBlockInConfigList(class_2680 state, class_2248 block, List<String> configList) {
        if (configList == null || configList.isEmpty()) {
            return false;
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        if (id != null && configList.contains(id.toString())) {
            return true;
        }
        for (String entry : configList) {
            String tagName;
            class_6862 tag;
            if (!entry.startsWith("#") || !state.method_26164(tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)(tagName = entry.substring(1)))))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomWool(class_2680 state, class_2248 block) {
        if (SoundAttractMod.CONFIG == null) {
            return state.method_26164(class_3481.field_15481);
        }
        return SoundTracker.isBlockInConfigList(state, block, SoundAttractMod.CONFIG.customWoolBlocks) || state.method_26164(class_3481.field_15481);
    }

    private static boolean isCustomSolid(class_2680 state, class_2248 block) {
        if (SoundAttractMod.CONFIG == null) {
            return state.method_51367();
        }
        return SoundTracker.isBlockInConfigList(state, block, SoundAttractMod.CONFIG.customSolidBlocks) || state.method_51367();
    }

    private static boolean isCustomNonSolid(class_2680 state, class_2248 block) {
        if (SoundAttractMod.CONFIG == null) {
            return !state.method_51367();
        }
        return SoundTracker.isBlockInConfigList(state, block, SoundAttractMod.CONFIG.customNonSolidBlocks) || !state.method_51367();
    }

    private static boolean isCustomThin(class_2680 state, class_2248 block) {
        if (SoundAttractMod.CONFIG == null) {
            return false;
        }
        if (SoundTracker.isBlockInConfigList(state, block, SoundAttractMod.CONFIG.customThinBlocks)) {
            return true;
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        if (id == null) {
            return false;
        }
        String path = id.method_12832();
        return path.contains("pane") || path.contains("iron_bars") || path.contains("painting") || path.contains("fence") || path.contains("trapdoor") || path.contains("door") || path.contains("ladder") || path.contains("scaffolding") || path.contains("rail") || path.contains("chain");
    }

    private static boolean isCustomLiquid(class_2248 block) {
        if (SoundAttractMod.CONFIG == null) {
            return false;
        }
        String blockId = class_7923.field_41175.method_10221((Object)block).toString();
        return SoundAttractMod.CONFIG.customLiquidBlocks.contains(blockId);
    }

    private static /* synthetic */ boolean lambda$removeSoundAt$6(class_2338 pos, String dimensionKey, SoundRecord r) {
        return r.pos.equals((Object)pos) && Objects.equals(r.dimensionKey, dimensionKey);
    }

    public static class SoundRecord {
        public final class_3414 sound;
        public final String soundId;
        public final class_2338 pos;
        public int ticksRemaining;
        public final String dimensionKey;
        public final double range;
        public final double weight;
        public final Set<Long> coveredCells = new HashSet<Long>();

        public SoundRecord(class_3414 sound, String soundId, class_2338 pos, String dimensionKey, double range, double weight) {
            this.sound = sound;
            this.soundId = soundId;
            this.pos = pos;
            this.ticksRemaining = SoundAttractMod.CONFIG.soundLifetimeTicks;
            this.dimensionKey = dimensionKey;
            this.range = range;
            this.weight = weight;
        }

        public SoundRecord(class_3414 sound, class_2338 pos, String dimensionKey, double range, double weight) {
            this(sound, sound != null && sound.method_14833() != null ? sound.method_14833().toString() : "unknown_sound_event_id", pos, dimensionKey, range, weight);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SoundRecord)) {
                return false;
            }
            SoundRecord other = (SoundRecord)obj;
            return Objects.equals(this.soundId, other.soundId) && Objects.equals(this.pos, other.pos) && Objects.equals(this.dimensionKey, other.dimensionKey) && Double.compare(this.weight, other.weight) == 0 && Double.compare(this.range, other.range) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.soundId, this.pos, this.dimensionKey, this.range, this.weight);
        }

        public boolean isValid() {
            return this.pos != null && this.weight > 0.0;
        }

        public class_2338 getPosition() {
            return this.pos;
        }
    }

    public static class VirtualSoundRecord
    extends SoundRecord {
        public final UUID sourcePlayer;
        public final String animationClass;

        public VirtualSoundRecord(class_2338 pos, String dimensionKey, double range, double weight, UUID sourcePlayer, String animationClass) {
            super(null, "virtual_sound:" + (animationClass != null ? animationClass : "unknown"), pos, dimensionKey, range, weight);
            this.sourcePlayer = sourcePlayer;
            this.animationClass = animationClass;
        }
    }

    private static class RaycastCacheKey {
        public final class_2338 mobPos;
        public final class_2338 soundPos;
        public final String soundId;

        public RaycastCacheKey(class_2338 mobPos, class_2338 soundPos, String soundId) {
            this.mobPos = mobPos;
            this.soundPos = soundPos;
            this.soundId = Objects.requireNonNull(soundId, "soundId cannot be null for RaycastCacheKey");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RaycastCacheKey)) {
                return false;
            }
            RaycastCacheKey other = (RaycastCacheKey)o;
            return this.mobPos.equals((Object)other.mobPos) && this.soundPos.equals((Object)other.soundPos) && this.soundId.equals(other.soundId);
        }

        public int hashCode() {
            return Objects.hash(this.mobPos, this.soundPos, this.soundId);
        }
    }

    private static class ApproxCandidate {
        final SoundRecord rec;
        final double effRange;
        final double effWeight;
        final double novelty;
        final double approxWeight;
        double distSqr;
        final String soundKey;
        final class_2960 soundId;
        double muffledRange;
        double muffledWeight;

        public ApproxCandidate(SoundRecord rec, double effRange, double effWeight, double novelty, double approxWeight, double distSqr, String soundKey, class_2960 soundId) {
            this.rec = rec;
            this.effRange = effRange;
            this.effWeight = effWeight;
            this.novelty = novelty;
            this.approxWeight = approxWeight;
            this.distSqr = distSqr;
            this.soundKey = soundKey;
            this.soundId = soundId;
            this.muffledRange = effRange;
            this.muffledWeight = effWeight;
        }

        double finalWeight() {
            return this.muffledWeight + this.novelty;
        }
    }
}

