/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Consumer;

public class AdaptiveScanScheduler {
    private final PriorityQueue<CellScanTask> queue = new PriorityQueue();
    private final Map<Long, CellScanTask> scheduled = new HashMap<Long, CellScanTask>();
    private final int baseCooldown;
    private final int[] tierShifts;

    public AdaptiveScanScheduler(int baseCooldown, int[] tierShifts) {
        this.baseCooldown = baseCooldown;
        this.tierShifts = tierShifts;
    }

    public void scheduleCell(long cellKey, int tier, long currentTick) {
        int shift = tier >= 0 && tier < this.tierShifts.length ? this.tierShifts[tier] : 0;
        long nextTick = currentTick + (long)(this.baseCooldown << shift);
        CellScanTask existing = this.scheduled.get(cellKey);
        if (existing == null || nextTick < existing.nextScanTick) {
            CellScanTask task = new CellScanTask(cellKey, nextTick, tier);
            this.queue.add(task);
            this.scheduled.put(cellKey, task);
        }
    }

    public void tick(long currentTick, Consumer<CellScanTask> onScan) {
        while (!this.queue.isEmpty() && this.queue.peek().nextScanTick <= currentTick) {
            CellScanTask task = this.queue.poll();
            this.scheduled.remove(task.cellKey);
            onScan.accept(task);
            this.scheduleCell(task.cellKey, task.tier, currentTick);
        }
    }

    public static class CellScanTask
    implements Comparable<CellScanTask> {
        public final long cellKey;
        public long nextScanTick;
        public final int tier;

        public CellScanTask(long cellKey, long nextScanTick, int tier) {
            this.cellKey = cellKey;
            this.nextScanTick = nextScanTick;
            this.tier = tier;
        }

        @Override
        public int compareTo(CellScanTask other) {
            return Long.compare(this.nextScanTick, other.nextScanTick);
        }
    }
}

