/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.SpatialPartitionModule;
import com.example.soundattract.ai.SpatialPartitioner;
import com.example.soundattract.util.WorkerScheduler;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class MobGroupManager {
    private static List<Long> cellsToProcess = new ArrayList<Long>();
    private static int nextCellIndex = 0;
    private static final Map<Long, Deque<class_1308>> cellEdgeMobs = new HashMap<Long, Deque<class_1308>>();
    private static final Map<UUID, class_1308> uuidToLeader = Collections.synchronizedMap(new HashMap());
    private static final List<WeakReference<class_1308>> leaders = Collections.synchronizedList(new ArrayList());
    private static final Map<class_1308, List<SoundRelay>> mobToRelayedSounds = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<class_1308, Long> mobLastRelayTime = Collections.synchronizedMap(new WeakHashMap());
    private static final Set<UUID> deserterUuids = Collections.synchronizedSet(new HashSet());
    private static long lastGroupUpdateTime = -1L;
    private static long lastCleanupTime = -1L;
    private static final Object cleanupLock = new Object();
    private static Map<class_1308, Set<class_1308>> lastEdgeMobEntityMap = new HashMap<class_1308, Set<class_1308>>();

    private static boolean isAttractedType(class_1308 mob) {
        String id = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        return SoundAttractMod.CONFIG.attractedEntities.contains(id);
    }

    public static boolean isEdgeMobEntity(class_1308 mob) {
        boolean isEdge;
        class_1308 leader;
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[isEdgeMobEntity] Checking mob {} (pos: {}, {})", new Object[]{mob.method_5477().getString(), mob.method_23317(), mob.method_23321()});
        }
        if ((leader = MobGroupManager.getLeader(mob)) == mob) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[isEdgeMobEntity] MobEntity {} is its own leader (not edge)", (Object)mob.method_5477().getString());
            }
            return false;
        }
        Set<class_1308> edgeSet = lastEdgeMobEntityMap.get(leader);
        boolean bl = isEdge = edgeSet != null && edgeSet.contains(mob);
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[isEdgeMobEntity] MobEntity {} edge result: {} (from cache)", (Object)mob.method_5477().getString(), (Object)isEdge);
        }
        return isEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupStaleEntries(class_3218 level) {
        Object object = cleanupLock;
        synchronized (object) {
            Object object2 = leaders;
            synchronized (object2) {
                leaders.removeIf(ref -> {
                    class_1308 mob = (class_1308)ref.get();
                    return mob == null || mob.method_31481();
                });
            }
            object2 = uuidToLeader;
            synchronized (object2) {
                uuidToLeader.keySet().removeIf(uuid -> {
                    class_1308 mob = uuidToLeader.get(uuid);
                    return mob == null || mob.method_31481();
                });
            }
            object2 = mobToRelayedSounds;
            synchronized (object2) {
                mobToRelayedSounds.keySet().removeIf(mob -> mob == null || mob.method_31481());
            }
            object2 = mobLastRelayTime;
            synchronized (object2) {
                mobLastRelayTime.keySet().removeIf(mob -> mob == null || mob.method_31481());
            }
            object2 = deserterUuids;
            synchronized (object2) {
                deserterUuids.removeIf(uuid -> {
                    class_1308 mob = uuidToLeader.get(uuid);
                    return mob == null || mob.method_31481();
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGroups(class_3218 level) {
        List group;
        class_2960 id;
        int cellsProcessed;
        double tps = 20.0;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.serverTpsSupplier != null) {
            tps = SoundAttractMod.CONFIG.serverTpsSupplier.get();
        } else if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.lastKnownTps > 0.0) {
            tps = SoundAttractMod.CONFIG.lastKnownTps;
        }
        double clampedTps = Math.max(10.0, Math.min(20.0, tps));
        double tpsFrac = (clampedTps - 10.0) / 10.0;
        int cellsPerTick = (int)Math.round((double)SoundAttractMod.CONFIG.minCellsPerTick + (double)(SoundAttractMod.CONFIG.maxCellsPerTick - SoundAttractMod.CONFIG.minCellsPerTick) * tpsFrac);
        int mobsPerCellPerTick = (int)Math.round((double)SoundAttractMod.CONFIG.minMobsPerCellPerTick + (double)(SoundAttractMod.CONFIG.maxMobsPerCellPerTick - SoundAttractMod.CONFIG.minMobsPerCellPerTick) * tpsFrac);
        if (SoundAttractMod.CONFIG.minCellsPerTick == SoundAttractMod.CONFIG.maxCellsPerTick) {
            cellsPerTick = SoundAttractMod.CONFIG.minCellsPerTick;
        }
        if (SoundAttractMod.CONFIG.minMobsPerCellPerTick == SoundAttractMod.CONFIG.maxMobsPerCellPerTick) {
            mobsPerCellPerTick = SoundAttractMod.CONFIG.minMobsPerCellPerTick;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] TPS: {} | cellsPerTick: {} | mobsPerCellPerTick: {}", new Object[]{tps, cellsPerTick, mobsPerCellPerTick});
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] updateGroups called at game time {}", (Object)level.method_8510());
        }
        long time = level.method_8510();
        int scanCooldown = DynamicScanCooldownManager.currentScanCooldownTicks;
        int groupAssignInterval = DynamicScanCooldownManager.getGroupAssignmentInterval();
        if (lastGroupUpdateTime >= 0L && time - lastGroupUpdateTime < (long)groupAssignInterval) {
            return;
        }
        lastGroupUpdateTime = time;
        if (scanCooldown > 0 && (lastCleanupTime == -1L || time - lastCleanupTime > 10L * (long)scanCooldown)) {
            MobGroupManager.cleanupStaleEntries(level);
            lastCleanupTime = time;
        }
        List<String> attracted = SoundAttractMod.CONFIG.attractedEntities.stream().map(Object::toString).toList();
        HashMap<class_1308, class_2960> mobIdMap = new HashMap<class_1308, class_2960>();
        if (cellsToProcess.isEmpty()) {
            cellsToProcess.addAll((Collection<Long>)SpatialPartitionModule.cellToMobUuids.keySet());
            nextCellIndex = 0;
        }
        ArrayList<class_1308> mobs = new ArrayList<class_1308>();
        block3: for (cellsProcessed = 0; nextCellIndex < cellsToProcess.size() && cellsProcessed < cellsPerTick; ++nextCellIndex, ++cellsProcessed) {
            Long cellKey = cellsToProcess.get(nextCellIndex);
            LongOpenHashSet uuidSet = (LongOpenHashSet)SpatialPartitionModule.cellToMobUuids.get((Object)cellKey);
            if (uuidSet == null) continue;
            int mobsProcessed = 0;
            LongIterator longIterator = uuidSet.iterator();
            block4: while (longIterator.hasNext()) {
                long uuidLsb = (Long)longIterator.next();
                if (mobsProcessed >= mobsPerCellPerTick) continue block3;
                for (Object uuid : SpatialPartitionModule.uuidToMobCache.keySet()) {
                    if (((UUID)uuid).getLeastSignificantBits() != uuidLsb) continue;
                    class_1308 mob = SpatialPartitionModule.getMobFromCache((UUID)uuid);
                    if (mob != null && mob.method_5805()) {
                        if (!MobGroupManager.isAttractedType(mob)) continue;
                        class_2960 id2 = class_7923.field_41177.method_10221((Object)mob.method_5864());
                        mobIdMap.put(mob, id2);
                        if (attracted.contains(id2.toString())) {
                            mobs.add(mob);
                        }
                    }
                    ++mobsProcessed;
                    continue block4;
                }
            }
        }
        if (nextCellIndex >= cellsToProcess.size()) {
            cellsToProcess.clear();
            nextCellIndex = 0;
        }
        if (cellsProcessed == 0) {
            return;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            StringBuilder allMobEntityTypesLog = new StringBuilder();
            for (class_1308 mob : mobs) {
                id = (class_2960)mobIdMap.get(mob);
                allMobEntityTypesLog.append(String.format("%s at (%.1f, %.1f, %.1f); ", id.toString(), mob.method_23317(), mob.method_23318(), mob.method_23321()));
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] All mobs present ({}): {}", (Object)mobs.size(), (Object)allMobEntityTypesLog.toString());
        }
        ArrayList<class_1308> attractedMobEntities = new ArrayList<class_1308>();
        for (class_1308 mob : mobs) {
            id = (class_2960)mobIdMap.get(mob);
            if (!attracted.contains(id.toString())) continue;
            attractedMobEntities.add(mob);
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            StringBuilder mobPosLog = new StringBuilder();
            for (class_1308 mob : attractedMobEntities) {
                mobPosLog.append(String.format("%s at (%.1f, %.1f, %.1f); ", mob.method_5477().getString(), mob.method_23317(), mob.method_23318(), mob.method_23321()));
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] Attracted mobs ({}): {}", (Object)attractedMobEntities.size(), (Object)mobPosLog.toString());
        }
        uuidToLeader.clear();
        leaders.clear();
        for (class_1308 m2 : attractedMobEntities) {
            if (SoundAttractMod.CONFIG.getMatchingProfile(m2) == null) continue;
            leaders.add(new WeakReference<class_1308>(m2));
            uuidToLeader.put(m2.method_5667(), m2);
            if (!SoundAttractMod.CONFIG.debugLogging) continue;
            SoundAttractMod.LOGGER.info("[MobGroupManager] Profiled mob {} forced to leader", (Object)class_7923.field_41177.method_10221((Object)m2.method_5864()));
        }
        if (attractedMobEntities.isEmpty()) {
            return;
        }
        double groupRadius = SoundAttractMod.CONFIG.groupDistance;
        int maxGroupSize = SoundAttractMod.CONFIG.maxGroupSize;
        double cellSize = groupRadius;
        HashMap<Long, List> cellToMobs = new HashMap<Long, List>();
        for (class_1308 mob : attractedMobEntities) {
            long cellKey = SpatialPartitioner.getKey(new class_2338((int)mob.method_23317(), 0, (int)mob.method_23321()), SoundAttractMod.CONFIG.spatialPartitionSize);
            cellToMobs.computeIfAbsent(cellKey, k -> new ArrayList()).add(mob);
        }
        int leaderCount = 0;
        int totalGroupSize = 0;
        HashMap<class_1308, List> leaderToGroup = new HashMap<class_1308, List>();
        ArrayList<class_1308> assignedLeaders = new ArrayList<class_1308>();
        for (Map.Entry entry : cellToMobs.entrySet()) {
            group = (List)entry.getValue();
            if (group.isEmpty()) continue;
            for (class_1308 mob : group) {
                class_1308 currentLeader = uuidToLeader.get(mob.method_5667());
                class_1308 nearestLeader = currentLeader != null && currentLeader.method_5805() ? currentLeader : null;
                double nearestDistSq = Double.MAX_VALUE;
                if (nearestLeader == null) {
                    for (class_1308 class_13082 : assignedLeaders) {
                        double distSq = mob.method_5858((class_1297)class_13082);
                        if (!(distSq <= groupRadius * groupRadius) || !(distSq < nearestDistSq)) continue;
                        nearestLeader = class_13082;
                        nearestDistSq = distSq;
                    }
                    if (nearestLeader == null) {
                        assignedLeaders.add(mob);
                        leaders.add(new WeakReference<class_1308>(mob));
                        ++leaderCount;
                        nearestLeader = mob;
                    }
                }
                uuidToLeader.put(mob.method_5667(), nearestLeader);
                leaderToGroup.computeIfAbsent(nearestLeader, k -> new ArrayList()).add(mob);
                ++totalGroupSize;
            }
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            double avgGroupSize = leaderCount > 0 ? (double)totalGroupSize / (double)leaderCount : 0.0;
            SoundAttractMod.LOGGER.info("[MobGroupManager] Grouped {} mobs into {} groups (avg group size: {:.2f})", new Object[]{attractedMobEntities.size(), leaderCount, avgGroupSize});
        }
        for (class_1308 class_13083 : attractedMobEntities) {
            if (!uuidToLeader.containsKey(class_13083.method_5667())) {
                deserterUuids.add(class_13083.method_5667());
                if (!SoundAttractMod.CONFIG.debugLogging) continue;
                SoundAttractMod.LOGGER.info("[MobGroupManager] MobEntity {} marked as DESERTER (not in any group)", (Object)class_13083.method_5477().getString());
                continue;
            }
            deserterUuids.remove(class_13083.method_5667());
        }
        lastEdgeMobEntityMap.clear();
        for (class_1308 class_13084 : leaderToGroup.keySet()) {
            Object m322;
            group = (List)leaderToGroup.get(class_13084);
            if (group == null) continue;
            int sectors = SoundAttractMod.CONFIG.numEdgeSectors;
            int edgePerSector = SoundAttractMod.CONFIG.edgeMobsPerSector;
            HashMap<Integer, List> sectorToFarthestList = new HashMap<Integer, List>();
            double leaderX = class_13084.method_23317();
            double leaderZ = class_13084.method_23321();
            for (Object m322 : group) {
                if (m322 == class_13084) continue;
                double dx2 = m322.method_23317() - leaderX;
                double dz2 = m322.method_23321() - leaderZ;
                double angle = Math.atan2(dz2, dx2);
                int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                sectorToFarthestList.computeIfAbsent(sector, k -> new ArrayList()).add(m322);
            }
            HashSet<class_1308> hashSet = new HashSet<class_1308>();
            m322 = sectorToFarthestList.entrySet().iterator();
            while (m322.hasNext()) {
                Map.Entry entry = (Map.Entry)m322.next();
                int sector = (Integer)entry.getKey();
                List mobsInSector = (List)entry.getValue();
                mobsInSector.sort((a, b) -> Double.compare(b.method_5739((class_1297)leader), a.method_5739((class_1297)leader)));
                int edgeCount = Math.min(edgePerSector, mobsInSector.size());
                if (edgeCount == 0 && !mobsInSector.isEmpty()) {
                    edgeCount = 1;
                }
                for (int i = 0; i < edgeCount; ++i) {
                    hashSet.add((class_1308)mobsInSector.get(i));
                }
            }
            if (hashSet.isEmpty() && group.size() > 1) {
                class_1308 farthest = null;
                double maxDist = -1.0;
                for (class_1308 m4 : group) {
                    double dist;
                    if (m4 == class_13084 || !((dist = (double)m4.method_5739((class_1297)class_13084)) > maxDist)) continue;
                    maxDist = dist;
                    farthest = m4;
                }
                if (farthest != null) {
                    hashSet.add(farthest);
                }
            }
            lastEdgeMobEntityMap.put(class_13084, hashSet);
            if (!SoundAttractMod.CONFIG.debugLogging) continue;
            StringBuilder sb = new StringBuilder();
            for (class_1308 edge : hashSet) {
                sb.append(edge.method_5477().getString()).append(", ");
            }
            SoundAttractMod.LOGGER.info("[MobGroupManager] Edge mobs for leader {}: {}", (Object)class_13084.method_5477().getString(), (Object)sb.toString());
        }
        mobToRelayedSounds.entrySet().removeIf(e -> ((class_1308)e.getKey()).method_31481());
        for (List list : mobToRelayedSounds.values()) {
            list.removeIf(r -> time - r.timestamp > (long)SoundAttractMod.CONFIG.soundEventTTL);
        }
        mobLastRelayTime.entrySet().removeIf(e -> ((class_1308)e.getKey()).method_31481());
        ArrayList<class_1308> allAttractedMobEntities = new ArrayList<class_1308>();
        class_238 class_2383 = new class_238(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (class_1308 mob : level.method_8390(class_1308.class, class_2383, m -> true)) {
            if (!MobGroupManager.isAttractedType(mob)) continue;
            allAttractedMobEntities.add(mob);
        }
        Set<UUID> set = deserterUuids;
        synchronized (set) {
            for (class_1308 mob : allAttractedMobEntities) {
                boolean isGrouped;
                class_1308 leader = uuidToLeader.get(mob.method_5667());
                boolean bl = isGrouped = leader != null && leader != mob;
                if (!isGrouped) {
                    deserterUuids.add(mob.method_5667());
                    if (!SoundAttractMod.CONFIG.debugLogging) continue;
                    SoundAttractMod.LOGGER.info("[MobGroupManager] MobEntity {} marked as DESERTER", (Object)mob.method_5477().getString());
                    continue;
                }
                deserterUuids.remove(mob.method_5667());
            }
        }
    }

    private static long offsetCellKey(long baseKey, int dx, int dz, double cellSize) {
        long cellX = baseKey >> 32;
        long cellZ = baseKey & 0xFFFFFFFFL;
        return cellX + (long)dx << 32 | cellZ + (long)dz & 0xFFFFFFFFL;
    }

    public static void relaySoundToLeader(class_1308 mob, double x, double y, double z, double range, double weight, long timestamp) {
        class_1308 leader = MobGroupManager.getLeader(mob);
        if (leader == mob) {
            return;
        }
        Long lastRelay = mobLastRelayTime.get(mob);
        if (lastRelay != null && timestamp - lastRelay < (long)SoundAttractMod.CONFIG.asyncMobGroupCooldownTicks) {
            return;
        }
        mobLastRelayTime.put(mob, timestamp);
        SoundRelay relay = new SoundRelay(x, y, z, range, weight, timestamp);
        List relays = mobToRelayedSounds.computeIfAbsent(leader, k -> new ArrayList());
        if (!relays.contains(relay)) {
            relays.add(relay);
        }
    }

    public static List<SoundRelay> peekRelayedSounds(class_1308 leader) {
        List<SoundRelay> relays = mobToRelayedSounds.get(leader);
        if (relays == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SoundRelay>(relays);
    }

    public static List<SoundRelay> consumeRelayedSounds(class_1308 leader) {
        List<SoundRelay> relays = mobToRelayedSounds.remove(leader);
        if (relays == null) {
            return Collections.emptyList();
        }
        long now = leader.method_37908().method_8510();
        HashSet<SoundRelay> deduped = new HashSet<SoundRelay>();
        for (SoundRelay r : relays) {
            if (now - r.timestamp > (long)SoundAttractMod.CONFIG.soundEventTTL) continue;
            deduped.add(r);
        }
        return new ArrayList<SoundRelay>(deduped);
    }

    public static class_1308 getLeader(class_1308 mob) {
        return uuidToLeader.get(mob.method_5667());
    }

    public static void promoteToDeserter(class_1308 mob) {
        deserterUuids.add(mob.method_5667());
    }

    public static boolean isDeserter(class_1308 mob) {
        return deserterUuids.contains(mob.method_5667());
    }

    public static void scheduleCellsForSound(class_2338 soundPos, double range, class_3218 level, long currentTick) {
        int partitionSize = SoundAttractMod.CONFIG.spatialPartitionSize;
        int gridRadius = (int)Math.ceil(range / (double)partitionSize);
        int baseX = soundPos.method_10263() / partitionSize;
        int baseZ = soundPos.method_10260() / partitionSize;
        for (int layer = 0; layer <= gridRadius; ++layer) {
            int tickDelay = layer;
            for (int dx = -layer; dx <= layer; ++dx) {
                for (int dz = -layer; dz <= layer; ++dz) {
                    if (Math.abs(dx) != layer && Math.abs(dz) != layer) continue;
                    int cellX = baseX + dx;
                    int cellZ = baseZ + dz;
                    long cellKey = (long)cellX << 32 | (long)cellZ & 0xFFFFFFFFL;
                    long scheduledTick = currentTick + (long)tickDelay;
                    DynamicScanCooldownManager.scheduler.scheduleCell(cellKey, 0, scheduledTick);
                }
            }
        }
    }

    public static void applyGroupResult(WorkerScheduler.GroupComputeResult result) {
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[MobGroupManager] Received group result, but handler is not yet implemented.");
        }
    }

    public static void scheduleNearbyCellsForPlayers(class_3218 level, long currentTick) {
        int[] tierRadii = new int[]{3, 5, 8, 12};
        for (class_3222 player : level.method_18456()) {
            class_2338 pos = player.method_24515();
            for (int tier = 0; tier < tierRadii.length; ++tier) {
                int radius = tierRadii[tier];
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        long cellKey = SpatialPartitionModule.cellKey(pos.method_10069(dx * SpatialPartitionModule.cellSize, 0, dz * SpatialPartitionModule.cellSize));
                        DynamicScanCooldownManager.scheduler.scheduleCell(cellKey, tier, currentTick);
                    }
                }
            }
        }
    }

    public static class SoundRelay {
        public final double x;
        public final double y;
        public final double z;
        public final double range;
        public final double weight;
        public final long timestamp;
        public final int hash;

        public SoundRelay(double x, double y, double z, double range, double weight, long timestamp) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.range = range;
            this.weight = weight;
            this.timestamp = timestamp;
            this.hash = Objects.hash((int)x, (int)y, (int)z, (int)range, (int)(weight * 100.0));
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoundRelay)) {
                return false;
            }
            SoundRelay other = (SoundRelay)o;
            return this.hash == other.hash && Math.abs(this.timestamp - other.timestamp) < (long)SoundAttractMod.CONFIG.soundEventTTL;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

