/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class TeleportToSoundGoal
extends class_1352 {
    private static final class_2960 SPEED_FREEZE_ID = class_2960.method_60655((String)"soundattract", (String)"teleport_to_sound_freeze");
    private final class_1308 mob;
    private class_1308 toTeleport;
    private int unreachableTime;
    private int cooldown;
    private int teleportTick;
    private SoundTracker.SoundRecord targetSound;

    public TeleportToSoundGoal(class_1308 mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (SoundAttractMod.CONFIG == null) {
            return false;
        }
        if (!SoundAttractMod.CONFIG.enableTeleportToSound) {
            return false;
        }
        if (--this.cooldown > 0) {
            return false;
        }
        if (this.mob.method_6109()) {
            return false;
        }
        String teleporterTagStr = SoundAttractMod.CONFIG.teleportCanTeleportTag;
        if (teleporterTagStr == null || teleporterTagStr.isBlank()) {
            return false;
        }
        class_6862 teleporterTag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)teleporterTagStr));
        if (!this.mob.method_5864().method_20210(teleporterTag)) {
            return false;
        }
        double chance = SoundAttractMod.CONFIG.teleportChance;
        if (this.mob.method_59922().method_43058() >= chance) {
            return false;
        }
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            return false;
        }
        this.targetSound = SoundTracker.findNearestSound(world, this.mob, this.mob.method_24515(), this.mob.method_33571());
        if (this.targetSound == null) {
            return false;
        }
        String targetTagStr = SoundAttractMod.CONFIG.teleportCanBeTeleportedTag;
        if (targetTagStr == null || targetTagStr.isBlank()) {
            return false;
        }
        class_6862 targetTag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)targetTagStr));
        double followRange = this.mob.method_45325(class_5134.field_23717);
        double range = followRange > 0.0 ? followRange : 16.0;
        List candidates = world.method_8390(class_1308.class, this.mob.method_5829().method_1014(range), other -> other != this.mob && other.method_5805() && other.method_5864().method_20210(targetTag));
        double closestDistSq = Double.MAX_VALUE;
        class_1308 closest = null;
        for (class_1308 candidate : candidates) {
            double d = this.mob.method_5858((class_1297)candidate);
            if (!(d < closestDistSq)) continue;
            closestDistSq = d;
            closest = candidate;
        }
        this.toTeleport = closest;
        return this.toTeleport != null;
    }

    public boolean method_6266() {
        return this.toTeleport != null && this.toTeleport.method_5805() && this.targetSound != null && this.targetSound.ticksRemaining > 0;
    }

    public void method_6269() {
        this.mob.method_5988().method_35111((class_1297)this.toTeleport);
        this.mob.method_5942().method_6340();
        this.mob.method_5942().method_6335((class_1297)this.toTeleport, 1.5);
        this.toTeleport.method_5942().method_6340();
    }

    public void method_6270() {
        this.toTeleport = null;
        this.unreachableTime = 0;
        this.targetSound = null;
        this.teleportTick = 0;
    }

    public void method_6268() {
        if (this.targetSound == null || this.toTeleport == null) {
            this.method_6270();
            return;
        }
        class_2338 soundPos = this.targetSound.pos;
        if (this.teleportTick <= 0) {
            this.mob.method_5988().method_35111((class_1297)this.toTeleport);
            this.toTeleport.method_5942().method_6340();
            if (this.mob.method_5942().method_6357()) {
                this.mob.method_5942().method_6335((class_1297)this.toTeleport, 1.5);
            }
            if (this.mob.method_5858((class_1297)this.toTeleport) <= 4.0) {
                this.hide((class_1309)this.mob);
                this.hide((class_1309)this.toTeleport);
                this.teleportTick = 30;
            }
        } else if (--this.teleportTick <= 0) {
            this.show((class_1309)this.mob);
            this.teleportSafely((class_1309)this.toTeleport, (double)soundPos.method_10263() + 0.5, soundPos.method_10264(), (double)soundPos.method_10260() + 0.5);
            this.show((class_1309)this.toTeleport);
            this.cooldown = SoundAttractMod.CONFIG.teleportCooldownTicks;
            this.method_6270();
            return;
        }
        if (++this.unreachableTime > 120) {
            this.cooldown = SoundAttractMod.CONFIG.teleportCooldownTicks;
            this.method_6270();
        }
    }

    private void hide(class_1309 entity) {
        this.applySpeedFreeze(entity);
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_11214, entity.method_23317(), entity.method_23320(), entity.method_23321(), 200, 0.5, 0.5, 0.5, 0.5);
        }
        entity.method_5783(class_3417.field_14879, 4.0f, 0.5f);
        entity.method_5875(true);
        entity.method_5648(true);
    }

    private void show(class_1309 entity) {
        this.removeSpeedFreeze(entity);
        entity.method_5875(false);
        entity.method_5648(false);
        entity.method_5783(class_3417.field_14879, 1.0f, 2.0f);
    }

    private void applySpeedFreeze(class_1309 entity) {
        class_1324 inst = entity.method_5996(class_5134.field_23719);
        if (inst != null && inst.method_6199(SPEED_FREEZE_ID) == null) {
            inst.method_26835(new class_1322(SPEED_FREEZE_ID, -1.0, class_1322.class_1323.field_6331));
        }
    }

    private void removeSpeedFreeze(class_1309 entity) {
        class_1324 inst = entity.method_5996(class_5134.field_23719);
        if (inst != null) {
            inst.method_6200(SPEED_FREEZE_ID);
        }
    }

    private void teleportSafely(class_1309 entity, double x, double y, double z) {
        class_1937 world = entity.method_37908();
        class_243 oldPos = entity.method_19538();
        entity.method_5859(x, y, z);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_32888((class_6880)class_5712.field_39446, oldPos, class_5712.class_7397.method_43285((class_1297)entity));
        }
    }
}

