/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessagePayload;
import com.example.soundattract.SoundTracker;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class VanillaIntegrationEvents {
    private static boolean wasSprinting = false;
    private static boolean wasSneaking = false;
    private static boolean wasCrawling = false;
    private static boolean wasOnGround = true;
    private static int tickCounter = 0;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                VanillaIntegrationEvents.onPlayerTick(player);
            }
        });
    }

    public static void onPlayerTick(class_3222 player) {
        boolean isJumping;
        int cooldown = DynamicScanCooldownManager.currentScanCooldownTicks;
        if (++tickCounter % cooldown != 0) {
            return;
        }
        class_1937 world = player.method_37908();
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        Optional<UUID> uuid = Optional.of(player.method_5667());
        if (player.method_5624()) {
            VanillaIntegrationEvents.sendVanillaSound(world, "VanillaSprint", "minecraft:entity.player.sprint", x, y, z, uuid, 10, 1.2, 1.0, 1.0);
        }
        wasSprinting = player.method_5624();
        if (!player.method_5624() && !player.method_5715() && player.method_18798().method_37268() > 0.01 && player.method_24828() && !player.method_18376().name().equalsIgnoreCase("SWIMMING")) {
            VanillaIntegrationEvents.sendVanillaSound(world, "VanillaWalk", "minecraft:entity.player.walk", x, y, z, uuid, 6, 0.6, 0.8, 1.0);
        }
        boolean bl = isJumping = player.field_6017 == 0.0f && player.method_18798().field_1351 > 0.1 && !wasOnGround;
        if (isJumping) {
            VanillaIntegrationEvents.sendVanillaSound(world, "VanillaJump", "minecraft:entity.player.jump", x, y, z, uuid, 7, 0.7, 0.8, 1.0);
        }
        wasOnGround = player.method_24828();
        if (player.method_5715()) {
            VanillaIntegrationEvents.sendVanillaSound(world, "VanillaSneak", "minecraft:entity.player.sneak", x, y, z, uuid, 3, 0.2, 0.4, 1.0);
        }
        wasSneaking = player.method_5715();
        boolean isCrawling = player.method_18376().name().equalsIgnoreCase("SWIMMING");
        if (isCrawling) {
            VanillaIntegrationEvents.sendVanillaSound(world, "VanillaCrawl", "minecraft:block.wool.step", x, y, z, uuid, 2, 0.1, 0.2, 1.0);
        }
        wasCrawling = isCrawling;
    }

    private static void sendVanillaSound(class_1937 world, String animatorClass, String soundIdStr, double x, double y, double z, Optional<UUID> uuid, int range, double weight, double volume, double pitch) {
        if (!(SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || soundIdStr != null && SoundAttractMod.CONFIG.soundIdWhitelist.contains(soundIdStr))) {
            return;
        }
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        int lifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
        class_2960 soundId = class_2960.method_60654((String)soundIdStr);
        if (soundId.equals((Object)SoundMessagePayload.VOICE_CHAT_SOUND_ID)) {
            if (range > 0) {
                SoundTracker.addSound(world, null, pos, range, weight, soundIdStr);
            }
        } else {
            class_3414 se = (class_3414)class_7923.field_41172.method_10223(soundId);
            if (se != null) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[SoundMessage] addSound: soundId={} | range={} | weight={} | pos=({}, {}, {}) | dim={}", new Object[]{soundIdStr, range, weight, x, y, z, world.method_27983().method_29177()});
                }
                SoundTracker.addSound(world, se, pos, range, weight, soundIdStr);
            } else if (animatorClass != null && !animatorClass.isEmpty()) {
                SoundTracker.addVirtualSound(world, pos, range, weight, uuid.orElse(null), animatorClass);
            }
        }
    }
}

