/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.logic;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessagePayload;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfigData;
import com.example.soundattract.integration.PointBlankIntegration;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class SoundMessageHandler {
    public static void handle(SoundMessagePayload payload, class_3222 sender) {
        try {
            String soundIdStr;
            if (sender == null) {
                SoundAttractMod.LOGGER.warn("[SoundMessage] sender is null for sound message with soundId: {}", (Object)payload.soundId());
                return;
            }
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundMessage] Received: id={}, range={}, weight={}, dim={}, pos=({}, {}, {})", new Object[]{payload.soundId(), payload.range(), payload.weight(), payload.dimension(), String.format("%.2f", payload.x()), String.format("%.2f", payload.y()), String.format("%.2f", payload.z())});
            }
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)payload.dimension());
            class_3218 serverWorld = sender.method_5682().method_3847(worldKey);
            if (serverWorld == null) {
                SoundAttractMod.LOGGER.warn("[SoundMessage] serverWorld is null for dimension: {}", (Object)payload.dimension());
                return;
            }
            if (payload.soundId().equals((Object)PointBlankIntegration.PB_GUN_SOUND_ID) && SoundAttractMod.CONFIG.enablePointBlankIntegration) {
                String[] parts;
                double finalRange = payload.range();
                double finalWeight = payload.weight();
                int lifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
                class_2338 pos = class_2338.method_49637((double)payload.x(), (double)payload.y(), (double)payload.z());
                String gunId = "unknown";
                String action = "unknown";
                if (payload.gunData() != null && !payload.gunData().isEmpty() && (parts = payload.gunData().split(";")).length >= 2) {
                    action = parts[0];
                    gunId = parts[1];
                }
                SoundTracker.addSound((class_1937)serverWorld, null, pos, finalRange, finalWeight, payload.soundId().toString());
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[SoundMessage] Handled PointBlank sound: action={}, gunId={}, finalRange={}, finalWeight={}", new Object[]{action, gunId, String.format("%.2f", finalRange), String.format("%.2f", finalWeight)});
                }
                return;
            }
            String string = soundIdStr = payload.soundId() != null ? payload.soundId().toString() : null;
            if (!(SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || soundIdStr != null && SoundAttractMod.CONFIG.soundIdWhitelist.contains(soundIdStr) || payload.soundId() != null && payload.soundId().equals((Object)SoundMessagePayload.VOICE_CHAT_SOUND_ID))) {
                return;
            }
            class_2338 pos = class_2338.method_49637((double)payload.x(), (double)payload.y(), (double)payload.z());
            if (pos.method_10263() == 0 && pos.method_10264() == 0 && pos.method_10260() == 0) {
                pos = sender.method_24515();
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[SoundMessage] Fallback to sender position {} for sound {}", (Object)pos, (Object)payload.soundId());
                }
            }
            int lifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
            if (payload.soundId().equals((Object)SoundMessagePayload.VOICE_CHAT_SOUND_ID)) {
                int effectiveRange = payload.range();
                if (effectiveRange <= 0) {
                    effectiveRange = SoundAttractMod.CONFIG.voiceChatNormalRange;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[SoundMessage] VOICE_CHAT range fallback to config: {}", (Object)effectiveRange);
                    }
                }
                if (effectiveRange > 0) {
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[SoundMessage] VOICE_CHAT handled at {} in {} with range={} weight={}", new Object[]{pos, serverWorld.method_27983().method_29177(), effectiveRange, payload.weight()});
                    }
                    SoundTracker.addSound((class_1937)serverWorld, null, pos, effectiveRange, payload.weight(), SoundMessagePayload.VOICE_CHAT_SOUND_ID.toString());
                }
            } else {
                SoundAttractConfigData.SoundConfig config;
                double range = payload.range();
                double weight = payload.weight();
                if (range <= 0.0 && payload.soundId() != null && (config = SoundAttractMod.CONFIG.getSoundConfigForId(payload.soundId().toString())) != null) {
                    range = config.range;
                    weight = config.weight;
                }
                SoundTracker.addSound((class_1937)serverWorld, null, pos, range, weight, payload.soundId().toString());
            }
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("[SoundMessage] Exception in handle for soundId={}", (Object)payload.soundId(), (Object)e);
        }
    }
}

