/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class AttractionGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private BlockPos targetSoundPos;
    private double currentTargetWeight = -1.0;
    private int scanCooldown = 0;
    private BlockPos lastPos = null;
    private Vec3 lastLeaderPos = null;
    private int stuckTicks = 0;
    private static final int STUCK_THRESHOLD = 10;
    private static final int RECALC_THRESHOLD = 30;
    private int lastSoundTicksRemaining = -1;
    private int scanTickCounter = 0;
    private int scanCooldownCounter = 0;
    private boolean isPursuingSound = false;
    private int pursuingSoundTicksRemaining = 0;
    private EdgeMobState edgeMobState = null;
    private boolean foundPlayerOrHit = false;
    private boolean relayedToLeader = false;
    private int edgeArrivalTicks = 0;
    private static final int EDGE_WAIT_TICKS = 15;
    private SoundTracker.SoundRecord cachedSound;
    private SoundTracker.SoundRecord cachedNearestSoundForTick;
    private long lastSoundCheckTick = -1L;
    private static final Map<Mob, DelayedRelay> pendingDelayedRelays = new HashMap<Mob, DelayedRelay>();
    private Vec3 chosenDest = null;
    private boolean hasPicked = false;

    public AttractionGoal(Mob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private int scanCooldownTicks() {
        return DynamicScanCooldownManager.currentScanCooldownTicks;
    }

    private boolean isMobEligible() {
        Set<EntityType<?>> attractedTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        return attractedTypes.contains(this.mob.getType());
    }

    private double getArrivalDistance() {
        return (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
    }

    private int getWaitTicks() {
        return (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
    }

    private PlayerStance determinePlayerStance(LivingEntity player) {
        if ((player.getPose() == Pose.SWIMMING || player.getPose() == Pose.FALL_FLYING || player.getPose() == Pose.SPIN_ATTACK) && player.getBbHeight() < 1.0f) {
            return PlayerStance.CRAWLING;
        }
        if (player.isCrouching()) {
            return PlayerStance.SNEAKING;
        }
        return PlayerStance.STANDING;
    }

    private double getDetectionRangeForPlayer(LivingEntity player) {
        double baseRange;
        MobProfile mobProfile = SoundAttractConfig.getMatchingProfile(this.mob);
        PlayerStance currentStance = this.determinePlayerStance(player);
        Optional<Object> override = Optional.empty();
        if (mobProfile != null) {
            override = mobProfile.getDetectionOverride(currentStance);
        }
        if (override.isPresent()) {
            baseRange = (Double)override.get();
        } else {
            switch (currentStance) {
                case CRAWLING: {
                    baseRange = (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                    break;
                }
                case SNEAKING: {
                    baseRange = (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                    break;
                }
                default: {
                    baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
                }
            }
        }
        boolean hasCamouflage = false;
        int wornCamouflagePieces = 0;
        if (((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            for (ItemStack armorItem : player.getArmorSlots()) {
                if (armorItem.isEmpty()) continue;
                String itemId = BuiltInRegistries.ITEM.getKey((Object)armorItem.getItem()).toString();
                if (!((List)SoundAttractConfig.COMMON.camouflageArmorItems.get()).contains(itemId)) continue;
                ++wornCamouflagePieces;
            }
            if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                hasCamouflage = wornCamouflagePieces == 4;
            } else {
                boolean bl = hasCamouflage = wornCamouflagePieces > 0;
            }
        }
        if (hasCamouflage) {
            double totalEffectiveness = 0.0;
            ArrayList armorItems = new ArrayList();
            player.getArmorSlots().forEach(armorItems::add);
            block11: for (int i = 0; i < armorItems.size(); ++i) {
                Item item;
                ResourceLocation itemId;
                ItemStack stack = (ItemStack)armorItems.get(i);
                if (stack.isEmpty() || (itemId = BuiltInRegistries.ITEM.getKey((Object)(item = stack.getItem()))) == null || !((List)SoundAttractConfig.COMMON.camouflageArmorItems.get()).contains(itemId.toString())) continue;
                switch (i) {
                    case 3: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 2: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 1: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 0: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                    }
                }
            }
            baseRange *= Math.max(0.0, 1.0 - totalEffectiveness);
        }
        return Math.max(0.0, baseRange);
    }

    private boolean shouldSuppressTargeting() {
        return (Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get() != false && StealthDetectionEvents.shouldSuppressTargeting(this.mob);
    }

    public boolean canUse() {
        if (!this.isMobEligible() || this.mob.isVehicle() || this.mob.isSleeping() || this.shouldSuppressTargeting()) {
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
            Mob leader = MobGroupManager.getLeader(this.mob);
            boolean isDeserter = MobGroupManager.isDeserter(this.mob);
            if (leader == this.mob && !isDeserter) {
                return false;
            }
            if (leader != this.mob) {
                return false;
            }
        }
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
            return false;
        }
        this.scanCooldownCounter = this.scanCooldownTicks();
        SoundTracker.SoundRecord newSound = this.getCachedNearestSound();
        if (newSound == null) {
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} canUse sound: id={}, pos={}, range={}, weight={}", new Object[]{this.mob.getName().getString(), newSound.soundId, newSound.pos, String.format("%.2f", newSound.range), String.format("%.2f", newSound.weight)});
        }
        this.targetSoundPos = newSound.pos;
        this.currentTargetWeight = newSound.weight;
        this.cachedSound = newSound;
        return true;
    }

    public boolean canContinueToUse() {
        Mob leader;
        if (!this.isMobEligible() || this.mob.isVehicle() || this.mob.isSleeping() || this.shouldSuppressTargeting()) {
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
            leader = MobGroupManager.getLeader(this.mob);
            boolean isDeserter = MobGroupManager.isDeserter(this.mob);
            if (leader == this.mob && !isDeserter) {
                return false;
            }
            if (leader != this.mob) {
                return false;
            }
        }
        if (this.targetSoundPos == null || this.mob.getNavigation().isDone()) {
            return false;
        }
        leader = MobGroupManager.getLeader(this.mob);
        if (leader != this.mob && ((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue() && this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
            return false;
        }
        SoundTracker.SoundRecord bestSoundNow = this.getCachedNearestSound();
        if (bestSoundNow == null) {
            return false;
        }
        if (bestSoundNow.pos.equals((Object)this.targetSoundPos)) {
            this.cachedSound = bestSoundNow;
            return true;
        }
        double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
        if (bestSoundNow.weight > this.currentTargetWeight * switchRatio) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} switching from target (w:{}) to new sound (w:{})", new Object[]{this.mob.getName().getString(), String.format("%.2f", this.currentTargetWeight), String.format("%.2f", bestSoundNow.weight)});
            }
            return false;
        }
        return true;
    }

    public void start() {
        if (this.targetSoundPos != null) {
            this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.targetSoundPos = null;
        this.currentTargetWeight = -1.0;
        this.cachedSound = null;
        this.isPursuingSound = false;
        this.pursuingSoundTicksRemaining = 0;
        this.edgeMobState = null;
        this.foundPlayerOrHit = false;
        this.relayedToLeader = false;
        this.edgeArrivalTicks = 0;
        this.chosenDest = null;
        this.hasPicked = false;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[AttractionGoal] stop: {}", (Object)this.mob.getName().getString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        block42: {
            block41: {
                block38: {
                    block39: {
                        Mob leader;
                        block40: {
                            SoundTracker.SoundRecord currentPursuedSound;
                            if (this.scanCooldownCounter > 0) {
                                --this.scanCooldownCounter;
                            }
                            SoundTracker.SoundRecord freshSound = this.getCachedNearestSound();
                            boolean shouldSwitch = false;
                            if (freshSound != null) {
                                if (this.cachedSound == null) {
                                    shouldSwitch = true;
                                } else {
                                    double freshWeight = freshSound.weight;
                                    double currentWeight = this.cachedSound.weight;
                                    double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
                                    if (freshWeight > currentWeight * switchRatio) {
                                        shouldSwitch = true;
                                    }
                                }
                            }
                            if (shouldSwitch) {
                                this.cachedSound = freshSound;
                                this.targetSoundPos = freshSound.pos;
                                this.currentTargetWeight = freshSound.weight;
                                this.hasPicked = false;
                                this.chosenDest = null;
                                this.edgeMobState = null;
                                this.foundPlayerOrHit = false;
                                this.relayedToLeader = false;
                                this.mob.getNavigation().stop();
                            } else if (freshSound == null) {
                                this.cachedSound = null;
                                this.targetSoundPos = null;
                            }
                            if (this.targetSoundPos == null) {
                                return;
                            }
                            boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
                            leader = MobGroupManager.getLeader(this.mob);
                            if (this.lastPos != null && this.lastPos.equals((Object)this.mob.blockPosition())) {
                                ++this.stuckTicks;
                                if (this.stuckTicks >= 30 && !this.mob.getNavigation().isStuck()) {
                                    this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
                                    this.stuckTicks = 0;
                                }
                            } else {
                                this.stuckTicks = 0;
                                this.lastPos = this.mob.blockPosition();
                            }
                            if (((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue() && this.targetSoundPos != null && (this.stuckTicks >= 10 || this.mob.getNavigation().isStuck())) {
                                BlockPos blocking = BlockBreakerPosGoal.findFirstBlockingBlock(this.mob.level(), this.mob, this.targetSoundPos);
                                boolean hasBreaker = this.mob.goalSelector.getAvailableGoals().stream().anyMatch(w -> w.getGoal() instanceof BlockBreakerPosGoal);
                                if (blocking != null && !hasBreaker) {
                                    double mult = (Double)SoundAttractConfig.COMMON.blockBreakTimeMultiplier.get();
                                    boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakToolOnly.get();
                                    boolean properOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolOnly.get();
                                    boolean properReq = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolRequired.get();
                                    BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, this.targetSoundPos, mult, toolOnly, properOnly, properReq);
                                    BlockBreakerManager.scheduleAdd(this.mob, breaker, 2);
                                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                        SoundAttractMod.LOGGER.info("[AttractionGoal] {} stuck: scheduled BlockBreakerPosGoal toward {}.", (Object)this.mob.getName().getString(), (Object)this.targetSoundPos);
                                    }
                                }
                            }
                            if ((currentPursuedSound = this.cachedSound) == null || !currentPursuedSound.pos.equals((Object)this.targetSoundPos)) {
                                currentPursuedSound = null;
                            }
                            if (currentPursuedSound == null || currentPursuedSound.ticksRemaining <= 0) {
                                this.targetSoundPos = null;
                                return;
                            }
                            if (leader == this.mob) {
                                if (!this.hasPicked) {
                                    double arrivalDist = this.getArrivalDistance();
                                    RandomSource rand = this.mob.getRandom();
                                    double angle = rand.nextDouble() * (Math.PI * 2);
                                    double radius = arrivalDist * Math.sqrt(rand.nextDouble());
                                    double offsetX = Math.cos(angle) * radius;
                                    double offsetZ = Math.sin(angle) * radius;
                                    int blockX = this.targetSoundPos.getX() + (int)Math.floor(offsetX);
                                    int blockZ = this.targetSoundPos.getZ() + (int)Math.floor(offsetZ);
                                    int groundY = this.mob.level().getHeight(Heightmap.Types.MOTION_BLOCKING, blockX, blockZ);
                                    double finalX = (double)blockX + 0.5;
                                    double finalY = groundY;
                                    double finalZ = (double)blockZ + 0.5;
                                    this.chosenDest = new Vec3(finalX, finalY, finalZ);
                                    this.hasPicked = true;
                                }
                                if (this.chosenDest != null) {
                                    Vec3 cur = this.mob.position();
                                    if (cur.distanceToSqr(this.chosenDest) > 2.25) {
                                        this.mob.getNavigation().moveTo(this.chosenDest.x, this.chosenDest.y, this.chosenDest.z, this.moveSpeed);
                                    }
                                    if (this.mob.getNavigation().isDone()) {
                                        this.hasPicked = false;
                                        this.chosenDest = null;
                                    }
                                }
                                return;
                            }
                            List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
                            if (relays != null && !relays.isEmpty()) {
                                for (MobGroupManager.SoundRelay relay : relays) {
                                    Optional relayEventOpt = BuiltInRegistries.SOUND_EVENT.getOptional(ResourceLocation.parse((String)relay.soundId));
                                    SoundTracker.SoundRecord relayedSoundRecord = new SoundTracker.SoundRecord(relayEventOpt.orElse(null), relay.soundId, BlockPos.containing((double)relay.x, (double)relay.y, (double)relay.z), 20, this.mob.level().dimension().location().toString(), relay.range, relay.weight);
                                    if (this.cachedSound != null && !(relayedSoundRecord.weight > this.cachedSound.weight * (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get()) && (!(Math.abs(relayedSoundRecord.weight - this.cachedSound.weight) < 0.001) || !(relayedSoundRecord.pos.distSqr((Vec3i)this.mob.blockPosition()) < this.cachedSound.pos.distSqr((Vec3i)this.mob.blockPosition())))) continue;
                                    this.cachedSound = relayedSoundRecord;
                                    this.targetSoundPos = this.cachedSound.pos;
                                    this.currentTargetWeight = this.cachedSound.weight;
                                    this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
                                    this.pursuingSoundTicksRemaining = relayedSoundRecord.ticksRemaining > 0 ? relayedSoundRecord.ticksRemaining : DynamicScanCooldownManager.currentScanCooldownTicks;
                                }
                            }
                            if (leader == null || !smartEdge || this.hasFollowerEdgeRelayGoal()) break block39;
                            if (this.edgeMobState == null) {
                                this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
                                this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
                            }
                            if (this.edgeMobState != EdgeMobState.GOING_TO_SOUND) break block40;
                            this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
                            if (this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
                                ++this.edgeArrivalTicks;
                                if (this.edgeArrivalTicks >= 15 || this.foundPlayerOrHit) {
                                    SoundTracker.SoundRecord soundToRelay;
                                    if (!this.relayedToLeader && this.foundPlayerOrHit && (soundToRelay = this.cachedSound) != null && soundToRelay.pos.equals((Object)this.targetSoundPos) && soundToRelay.ticksRemaining > 0 && soundToRelay.soundId != null) {
                                        MobGroupManager.relaySoundToLeader(this.mob, soundToRelay.soundId, soundToRelay.pos.getX(), soundToRelay.pos.getY(), soundToRelay.pos.getZ(), soundToRelay.range, soundToRelay.weight, this.mob.level().getGameTime());
                                        this.relayedToLeader = true;
                                    }
                                    this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                                    this.edgeArrivalTicks = 0;
                                }
                                break block38;
                            } else {
                                LivingEntity targetPlayer = this.mob.getTarget();
                                if (targetPlayer instanceof Player && targetPlayer.distanceToSqr((Entity)this.mob) < Math.pow(StealthDetectionEvents.getRealisticStealthDetectionRange((Player)targetPlayer, this.mob, this.mob.level()), 2.0)) {
                                    this.foundPlayerOrHit = true;
                                }
                            }
                            break block38;
                        }
                        if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
                            if (leader != null && !leader.isRemoved() && leader.isAlive()) {
                                this.mob.getNavigation().moveTo(leader.getX(), leader.getY(), leader.getZ(), this.moveSpeed * 0.8);
                                if (this.mob.distanceToSqr((Entity)leader) < (this.getArrivalDistance() + 2.0) * (this.getArrivalDistance() + 2.0)) {
                                    this.targetSoundPos = null;
                                    this.edgeMobState = null;
                                    return;
                                }
                                break block38;
                            } else {
                                this.targetSoundPos = null;
                                this.edgeMobState = null;
                                return;
                            }
                        }
                        break block38;
                    }
                    this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
                }
                if (!this.isPursuingSound || this.cachedSound == null) break block41;
                if (this.pursuingSoundTicksRemaining > 0) {
                    --this.pursuingSoundTicksRemaining;
                    if (this.pursuingSoundTicksRemaining <= 0) {
                        this.isPursuingSound = false;
                    }
                }
                break block42;
            }
            if (!this.isPursuingSound) {
                this.pursuingSoundTicksRemaining = 0;
            }
        }
        if (this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
            this.scanCooldownCounter = this.scanCooldownTicks();
        }
    }

    private SoundTracker.SoundRecord findInterestingSoundRecord() {
        SoundTracker.SoundRecord currentTargetSound;
        Level level = this.mob.level();
        if (level.isClientSide()) {
            return null;
        }
        BlockPos mobPos = this.mob.blockPosition();
        Vec3 mobEyePos = this.mob.getEyePosition(1.0f);
        Mob leader = MobGroupManager.getLeader(this.mob);
        SoundTracker.SoundRecord bestSoundOverall = null;
        if (leader == this.mob) {
            List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
            if (relays != null) {
                for (MobGroupManager.SoundRelay relay : relays) {
                    SoundTracker.SoundRecord relayedSound = new SoundTracker.SoundRecord(null, relay.soundId, new BlockPos((int)relay.x, (int)relay.y, (int)relay.z), 200, level.dimension().location().toString(), relay.range, relay.weight);
                    if (bestSoundOverall != null && !(relayedSound.weight > bestSoundOverall.weight) && (!(Math.abs(relayedSound.weight - bestSoundOverall.weight) < 0.001) || !(relayedSound.range > bestSoundOverall.range))) continue;
                    bestSoundOverall = relayedSound;
                }
            }
        } else {
            bestSoundOverall = SoundTracker.findNearestSound(this.mob, level, mobPos, mobEyePos);
        }
        if ((currentTargetSound = this.cachedSound) != null && bestSoundOverall != null && !this.areSoundsEffectivelySame(currentTargetSound, bestSoundOverall)) {
            boolean canSwitch;
            double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
            boolean bl = canSwitch = bestSoundOverall.weight > currentTargetSound.weight * switchRatio || Math.abs(bestSoundOverall.weight - currentTargetSound.weight) < 0.001 && bestSoundOverall.pos.distSqr((Vec3i)mobPos) < currentTargetSound.pos.distSqr((Vec3i)mobPos);
            if (!canSwitch) {
                return currentTargetSound;
            }
        }
        if (bestSoundOverall != null) {
            this.isPursuingSound = true;
            this.pursuingSoundTicksRemaining = DynamicScanCooldownManager.currentScanCooldownTicks;
        } else if (leader == this.mob) {
            this.isPursuingSound = false;
            this.pursuingSoundTicksRemaining = 0;
        } else if (leader != this.mob && !this.isPursuingSound) {
            this.isPursuingSound = false;
            this.pursuingSoundTicksRemaining = 0;
        }
        this.cachedSound = bestSoundOverall;
        return bestSoundOverall;
    }

    private boolean areSoundsEffectivelySame(SoundTracker.SoundRecord s1, SoundTracker.SoundRecord s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.pos.equals((Object)s2.pos) && s1.soundId != null && s1.soundId.equals(s2.soundId) && Math.abs(s1.range - s2.range) < 0.1 && Math.abs(s1.weight - s2.weight) < 0.01;
    }

    private boolean isPlayerMovementSound(double weight) {
        return weight == 1.2 || weight == 0.6 || weight == 0.2 || weight == 0.1;
    }

    public boolean isPursuingSound() {
        return this.isPursuingSound;
    }

    private SoundTracker.SoundRecord getCachedNearestSound() {
        long currentTick = this.mob.level().getGameTime();
        if (this.lastSoundCheckTick != currentTick) {
            this.lastSoundCheckTick = currentTick;
            this.cachedNearestSoundForTick = this.findInterestingSoundRecord();
        }
        return this.cachedNearestSoundForTick;
    }

    private boolean hasFollowerEdgeRelayGoal() {
        return this.mob.goalSelector.getAvailableGoals().stream().anyMatch(w -> w.getGoal() instanceof FollowerEdgeRelayGoal);
    }

    private static enum EdgeMobState {
        GOING_TO_SOUND,
        RETURNING_TO_LEADER;

    }

    private static class DelayedRelay {
        public final Mob leader;
        public final BlockPos soundPos;
        public final long triggerTime;
        public boolean cancelled = false;

        public DelayedRelay(Mob leader, BlockPos soundPos, long triggerTime) {
            this.leader = leader;
            this.soundPos = soundPos;
            this.triggerTime = triggerTime;
        }
    }
}

