/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockBreakerPosGoal
extends Goal {
    private final Mob miner;
    private final BlockPos destinationPos;
    private final double reachDistance = 4.9;
    private final double timeToBreakMultiplier;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private final boolean properToolRequired;
    private BlockPos targetPos = null;
    private BlockState targetState = null;
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private int prevBreakProgress = 0;

    public BlockBreakerPosGoal(Mob miner, BlockPos destination, double timeToBreakMultiplier, boolean toolOnly, boolean properToolOnly, boolean properToolRequired) {
        this.miner = miner;
        this.destinationPos = destination;
        this.timeToBreakMultiplier = timeToBreakMultiplier <= 0.0 ? 1.0 : timeToBreakMultiplier;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.properToolRequired = properToolRequired;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            return false;
        }
        if (this.destinationPos == null) {
            return false;
        }
        if (this.toolOnly && !this.isHoldingTool()) {
            return false;
        }
        this.targetPos = BlockBreakerPosGoal.findFirstBlockingBlock(this.miner.level(), this.miner, this.destinationPos);
        if (this.targetPos == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: No blocking block found toward {}.", (Object)this.miner.getName().getString(), (Object)this.destinationPos);
            }
            return false;
        }
        this.targetState = this.miner.level().getBlockState(this.targetPos);
        if (!this.passesRules(this.targetState, this.targetPos)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: Target {} rejected by rules.", (Object)this.miner.getName().getString(), (Object)this.targetPos);
            }
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: Starting to break {} to reach {}.", new Object[]{this.miner.getName().getString(), this.targetPos, this.destinationPos});
        }
        return true;
    }

    public boolean canContinueToUse() {
        if (this.targetPos == null) {
            return false;
        }
        if (this.destinationPos == null) {
            return false;
        }
        Level world = this.miner.level();
        if (world.isEmptyBlock(this.targetPos)) {
            return false;
        }
        if (this.properToolOnly && this.targetState != null && !this.canBreakBlock(this.targetState)) {
            return false;
        }
        BlockPos ahead = BlockBreakerPosGoal.findFirstBlockingBlock(world, this.miner, this.destinationPos);
        return ahead != null;
    }

    public void start() {
        if (this.targetPos != null) {
            this.initBlockBreak();
            this.miner.setAggressive(true);
            double distSq = this.miner.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos));
            if (distSq > 24.010000000000005) {
                this.miner.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 1.0);
            }
        }
    }

    public void stop() {
        Level level;
        if (this.targetPos != null && (level = this.miner.level()) instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)level;
            sw.destroyBlockProgress(this.miner.getId(), this.targetPos, -1);
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: Stopping block breaking.", (Object)this.miner.getName().getString());
        }
        this.targetPos = null;
        this.targetState = null;
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.prevBreakProgress = 0;
        this.miner.setAggressive(false);
        BlockBreakerManager.scheduleRemove(this.miner, this);
    }

    public void tick() {
        ServerLevel sw;
        if (this.targetPos == null || this.targetState == null) {
            return;
        }
        Level world = this.miner.level();
        if (world.isEmptyBlock(this.targetPos)) {
            return;
        }
        if (this.properToolOnly && !this.canBreakBlock(this.targetState)) {
            return;
        }
        double distSqToTarget = this.miner.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos));
        if (distSqToTarget > 24.010000000000005) {
            if (this.miner.getNavigation().isDone()) {
                this.miner.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 1.0);
            }
            if (world instanceof ServerLevel) {
                ServerLevel sw2 = (ServerLevel)world;
                sw2.destroyBlockProgress(this.miner.getId(), this.targetPos, -1);
            }
            return;
        }
        ++this.breakingTick;
        this.miner.getLookControl().setLookAt((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5);
        int progress = (int)((float)this.breakingTick / (float)Math.max(1, this.tickToBreak) * 10.0f);
        if (progress != this.prevBreakProgress) {
            this.prevBreakProgress = progress;
            if (world instanceof ServerLevel) {
                sw = (ServerLevel)world;
                sw.destroyBlockProgress(this.miner.getId(), this.targetPos, progress);
            }
        }
        if (this.breakingTick % 6 == 0) {
            this.miner.swing(InteractionHand.MAIN_HAND);
        }
        if (this.breakingTick >= this.tickToBreak && world instanceof ServerLevel) {
            sw = (ServerLevel)world;
            sw.destroyBlockProgress(this.miner.getId(), this.targetPos, -1);
            sw.destroyBlock(this.targetPos, true, (Entity)this.miner);
            this.targetPos = BlockBreakerPosGoal.findFirstBlockingBlock(world, this.miner, this.destinationPos);
            if (this.targetPos != null) {
                this.targetState = world.getBlockState(this.targetPos);
                if (this.passesRules(this.targetState, this.targetPos)) {
                    this.initBlockBreak();
                } else {
                    this.targetPos = null;
                    this.targetState = null;
                }
            }
        }
    }

    private void initBlockBreak() {
        this.targetState = this.miner.level().getBlockState(this.targetPos);
        this.tickToBreak = this.computeTicksToBreak(this.targetState);
        this.breakingTick = 0;
        this.prevBreakProgress = 0;
    }

    private int computeTicksToBreak(BlockState state) {
        float hardness = state.getDestroySpeed((BlockGetter)this.miner.level(), this.targetPos);
        if (hardness == 0.0f) {
            return 1;
        }
        double base = 20.0 * (double)hardness * this.timeToBreakMultiplier;
        if (state.requiresCorrectToolForDrops() && !this.isSuitableFor(state)) {
            base *= 4.0;
        }
        return Math.max(1, (int)Math.ceil(base));
    }

    private boolean canBreakBlock(BlockState state) {
        if (!state.requiresCorrectToolForDrops() || !this.properToolRequired) {
            return true;
        }
        return this.isSuitableFor(state);
    }

    private boolean isSuitableFor(BlockState state) {
        ItemStack main = this.miner.getMainHandItem();
        ItemStack off = this.miner.getOffhandItem();
        return !main.isEmpty() && main.isCorrectToolForDrops(state) || !off.isEmpty() && off.isCorrectToolForDrops(state);
    }

    private boolean isHoldingTool() {
        return !this.miner.getMainHandItem().isEmpty() || !this.miner.getOffhandItem().isEmpty();
    }

    private boolean passesRules(BlockState state, BlockPos pos) {
        if (pos.getY() > (Integer)SoundAttractConfig.COMMON.blockBreakMaxY.get()) {
            return false;
        }
        if (state.hasBlockEntity() && ((Boolean)SoundAttractConfig.COMMON.blockBreakBlacklistTileEntities.get()).booleanValue()) {
            return false;
        }
        List list = (List)SoundAttractConfig.COMMON.blockBreakBlockList.get();
        boolean whitelist = (Boolean)SoundAttractConfig.COMMON.blockBreakListAsWhitelist.get();
        if (list != null && !list.isEmpty()) {
            String idStr = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
            boolean listed = list.stream().map(String::trim).anyMatch(s -> !s.isEmpty() && s.equals(idStr));
            if (!whitelist && listed) {
                return false;
            }
            if (whitelist && !listed) {
                return false;
            }
        }
        return true;
    }

    public static BlockPos findFirstBlockingBlock(Level world, Mob mob, BlockPos dest) {
        Vec3 end;
        if (world == null || mob == null || dest == null) {
            return null;
        }
        Vec3 start = mob.getEyePosition();
        ClipContext ctx = new ClipContext(start, end = Vec3.atCenterOf((Vec3i)dest), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob);
        BlockHitResult hit = world.clip(ctx);
        if (hit != null && hit.getType() != HitResult.Type.MISS) {
            return hit.getBlockPos();
        }
        Vec3 mobPos = mob.position();
        Vec3 destCenter = Vec3.atCenterOf((Vec3i)dest);
        Vec3 dir = destCenter.subtract(mobPos);
        double length = dir.length();
        if (length < 0.001) {
            return null;
        }
        Vec3 step = dir.normalize().scale(0.5);
        int maxSteps = (int)Math.ceil(length / 0.5);
        Vec3 probeFeet = new Vec3(mobPos.x, mob.getY(), mobPos.z);
        Vec3 probeEye = new Vec3(mobPos.x, mob.getEyeY(), mobPos.z);
        for (int i = 0; i < maxSteps; ++i) {
            probeFeet = probeFeet.add(step);
            probeEye = probeEye.add(step);
            BlockPos feetPos = BlockPos.containing((Position)probeFeet);
            BlockPos eyePos = BlockPos.containing((Position)probeEye);
            if (BlockBreakerPosGoal.isObstacle(world, feetPos)) {
                return feetPos;
            }
            if (!BlockBreakerPosGoal.isObstacle(world, eyePos)) continue;
            return eyePos;
        }
        return null;
    }

    private static boolean isObstacle(Level world, BlockPos pos) {
        BlockState st = world.getBlockState(pos);
        if (st.isAir()) {
            return false;
        }
        if (!st.getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return true;
        }
        FluidState fs = world.getFluidState(pos);
        return !fs.isEmpty();
    }
}

