/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.PlayerStance;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class MobProfile {
    private final String profileName;
    private final String mobIdString;
    @Nullable
    private final ResourceLocation mobId;
    @Nullable
    private final CompoundTag nbtMatcher;
    private final List<SoundOverride> soundOverrides;
    private final Map<PlayerStance, Double> detectionOverrides;
    private final boolean isValid;

    public MobProfile(String profileName, String mobIdString, @Nullable String nbtMatcherString, List<SoundOverride> soundOverrides, Map<PlayerStance, Double> detectionOverrides) {
        this.profileName = Objects.requireNonNull(profileName, "profileName cannot be null");
        this.mobIdString = Objects.requireNonNull(mobIdString, "mobIdString cannot be null");
        boolean profileIsValid = true;
        if ("*".equals(mobIdString)) {
            this.mobId = null;
        } else {
            this.mobId = ResourceLocation.tryParse((String)mobIdString);
            if (this.mobId == null) {
                SoundAttractMod.LOGGER.warn("Invalid mobIdString for profile '{}': {}. This profile will be disabled.", (Object)profileName, (Object)mobIdString);
                profileIsValid = false;
            }
        }
        this.isValid = profileIsValid;
        CompoundTag parsedNbt = null;
        if (nbtMatcherString != null && !nbtMatcherString.trim().isEmpty()) {
            try {
                parsedNbt = TagParser.parseTag((String)nbtMatcherString);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Failed to parse NBT matcher for profile '{}': {}. Error: {}", new Object[]{profileName, nbtMatcherString, e.getMessage()});
            }
        }
        this.nbtMatcher = parsedNbt;
        this.soundOverrides = Collections.unmodifiableList(Objects.requireNonNull(soundOverrides, "soundOverrides cannot be null"));
        this.detectionOverrides = Collections.unmodifiableMap(Objects.requireNonNull(detectionOverrides, "detectionOverrides cannot be null"));
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getMobIdString() {
        return this.mobIdString;
    }

    @Nullable
    public ResourceLocation getMobId() {
        return this.mobId;
    }

    @Nullable
    public CompoundTag getNbtMatcher() {
        return this.nbtMatcher;
    }

    public List<SoundOverride> getSoundOverrides() {
        return this.soundOverrides;
    }

    public Map<PlayerStance, Double> getDetectionOverrides() {
        return this.detectionOverrides;
    }

    public Optional<Double> getDetectionOverride(PlayerStance stance) {
        return Optional.ofNullable(this.detectionOverrides.get((Object)stance));
    }

    public Optional<SoundOverride> getSoundOverride(ResourceLocation soundId) {
        return this.soundOverrides.stream().filter(override -> override.soundId().equals((Object)soundId)).findFirst();
    }

    public static MobProfile fromString(String raw) {
        if (raw == null || raw.trim().isEmpty()) {
            return null;
        }
        String[] parts = raw.split(";", 5);
        if (parts.length < 2) {
            SoundAttractMod.LOGGER.warn("Invalid mob profile string: '{}'. Must have at least profileName and mobId.", (Object)raw);
            return null;
        }
        String profileName = parts[0].trim();
        String mobIdString = parts[1].trim();
        String nbtMatcherString = parts.length > 2 ? parts[2].trim() : "";
        String soundOverridesString = parts.length > 3 ? parts[3].trim() : "";
        String detectionOverridesString = parts.length > 4 ? parts[4].trim() : "";
        List<SoundOverride> soundOverrides = MobProfile.parseSoundOverrides(soundOverridesString, profileName);
        Map<PlayerStance, Double> detectionOverrides = MobProfile.parseDetectionOverrides(detectionOverridesString, profileName);
        return new MobProfile(profileName, mobIdString, nbtMatcherString, soundOverrides, detectionOverrides);
    }

    private static List<SoundOverride> parseSoundOverrides(String soundOverridesString, String profileName) {
        if (soundOverridesString == null || soundOverridesString.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(soundOverridesString.split(",")).map(s -> SoundOverride.fromString(s.trim(), profileName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Map<PlayerStance, Double> parseDetectionOverrides(String detectionOverridesString, String profileName) {
        if (detectionOverridesString.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<PlayerStance, Double> overrides = new HashMap<PlayerStance, Double>();
        for (String part : detectionOverridesString.split(",")) {
            String[] pair = part.trim().split(":");
            if (pair.length != 2) continue;
            String stanceStr = pair[0].trim().toUpperCase();
            String valueStr = pair[1].trim();
            PlayerStance stance = null;
            for (PlayerStance s : PlayerStance.values()) {
                if (!s.name().equals(stanceStr)) continue;
                stance = s;
                break;
            }
            if (stance == null) {
                SoundAttractMod.LOGGER.warn("Invalid player stance '{}' in profile '{}'", (Object)pair[0], (Object)profileName);
                continue;
            }
            try {
                double value = Double.parseDouble(valueStr);
                overrides.put(stance, value);
            }
            catch (NumberFormatException e) {
                SoundAttractMod.LOGGER.warn("Invalid detection override value '{}' for stance '{}' in profile '{}'", new Object[]{valueStr, stanceStr, profileName});
            }
        }
        return overrides;
    }

    public boolean matches(Mob mob) {
        CompoundTag mobNbt;
        if (!this.isValid) {
            return false;
        }
        if (this.mobId == null) {
            if (this.nbtMatcher != null && !this.nbtMatcher.isEmpty()) {
                CompoundTag mobNbt2 = mob.saveWithoutId(new CompoundTag());
                return this.checkNbt(mobNbt2, this.nbtMatcher);
            }
            return true;
        }
        ResourceLocation actualMobId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        if (!this.mobId.equals((Object)actualMobId)) {
            return false;
        }
        return this.nbtMatcher == null || this.nbtMatcher.isEmpty() || this.checkNbt(mobNbt = mob.saveWithoutId(new CompoundTag()), this.nbtMatcher);
    }

    private boolean checkNbt(CompoundTag mobNbt, CompoundTag matcherNbt) {
        for (String key : matcherNbt.getAllKeys()) {
            if (!mobNbt.contains(key, (int)matcherNbt.getTagType(key))) {
                return false;
            }
            if (matcherNbt.getTagType(key) == 10) {
                if (this.checkNbt(mobNbt.getCompound(key), matcherNbt.getCompound(key))) continue;
                return false;
            }
            if (matcherNbt.getTagType(key) == 9) {
                if (mobNbt.getList(key, (int)matcherNbt.getList(key, 0).getElementType()).equals((Object)matcherNbt.getList(key, 0))) continue;
                SoundAttractMod.LOGGER.trace("NBT list matching for key '{}' is currently basic. Profile: {}", (Object)key, (Object)this.profileName);
                continue;
            }
            if (mobNbt.get(key).equals((Object)matcherNbt.get(key))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MobProfile{profileName='" + this.profileName + "', mobIdString='" + this.mobIdString + "'" + (String)(this.mobId != null ? ", mobId=" + String.valueOf(this.mobId) : "") + (String)(this.nbtMatcher != null ? ", nbtMatcher=" + this.nbtMatcher.getAsString() : "") + ", soundOverrides=" + String.valueOf(this.soundOverrides) + ", detectionOverrides=" + String.valueOf(this.detectionOverrides) + "}";
    }

    public record SoundOverride(ResourceLocation soundId, double range, double weight) {
        public static SoundOverride fromString(String raw, String profileName) {
            if (raw == null || raw.trim().isEmpty()) {
                return null;
            }
            String[] parts = raw.split(":");
            if (parts.length != 3) {
                SoundAttractMod.LOGGER.warn("Invalid sound override format in profile '{}': '{}'. Expected 'soundId:range:weight'", (Object)profileName, (Object)raw);
                return null;
            }
            ResourceLocation soundId = ResourceLocation.tryParse((String)parts[0].trim());
            if (soundId == null) {
                SoundAttractMod.LOGGER.warn("Invalid sound ID in profile '{}': '{}'", (Object)profileName, (Object)parts[0].trim());
                return null;
            }
            try {
                double range = Double.parseDouble(parts[1].trim());
                double weight = Double.parseDouble(parts[2].trim());
                return new SoundOverride(soundId, range, weight);
            }
            catch (NumberFormatException e) {
                SoundAttractMod.LOGGER.warn("Invalid range or weight in profile '{}': '{}'", new Object[]{profileName, raw, e});
                return null;
            }
        }
    }
}

